/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.credentialstorage.implementation.macosx;

import com.microsoft.credentialstorage.SecretStore;
import com.microsoft.credentialstorage.implementation.macosx.KeychainSecurityCliStore;
import com.microsoft.credentialstorage.model.StoredCredential;
import java.util.Map;

public final class KeychainSecurityBackedCredentialStore
extends KeychainSecurityCliStore
implements SecretStore<StoredCredential> {
    @Override
    public StoredCredential get(String key) {
        StoredCredential result;
        Map<String, Object> metaData = KeychainSecurityBackedCredentialStore.read(KeychainSecurityCliStore.SecretKind.Credential, key);
        if (!metaData.isEmpty()) {
            String userName = (String)metaData.get("acct");
            String password = (String)metaData.get("password");
            result = new StoredCredential(userName, password.toCharArray());
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public boolean add(String key, StoredCredential credentials) {
        Map<String, Object> metaData = KeychainSecurityBackedCredentialStore.read(KeychainSecurityCliStore.SecretKind.Credential, key);
        if (!metaData.isEmpty() && !credentials.getUsername().equals(metaData.get("acct"))) {
            this.deleteByKind(key, KeychainSecurityCliStore.SecretKind.Credential);
        }
        KeychainSecurityBackedCredentialStore.write(KeychainSecurityCliStore.SecretKind.Credential, key, credentials.getUsername(), credentials.getPassword());
        return true;
    }

    @Override
    public boolean delete(String key) {
        return this.deleteByKind(key, KeychainSecurityCliStore.SecretKind.Credential);
    }

    @Override
    public boolean isSecure() {
        return true;
    }
}

