/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.credentialstorage.implementation.macosx;

import com.microsoft.credentialstorage.SecretStore;
import com.microsoft.credentialstorage.implementation.macosx.KeychainSecurityCliStore;
import com.microsoft.credentialstorage.model.StoredToken;
import com.microsoft.credentialstorage.model.StoredTokenType;
import java.util.Map;

public final class KeychainSecurityBackedTokenStore
extends KeychainSecurityCliStore
implements SecretStore<StoredToken> {
    @Override
    public StoredToken get(String key) {
        StoredToken result;
        Map<String, Object> metaData = KeychainSecurityBackedTokenStore.read(KeychainSecurityCliStore.SecretKind.Token, key);
        if (metaData.size() > 0) {
            String typeName = (String)metaData.get("acct");
            String secret = (String)metaData.get("password");
            result = new StoredToken(secret.toCharArray(), StoredTokenType.fromDescription(typeName));
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public boolean add(String key, StoredToken token) {
        this.writeTokenKind(key, KeychainSecurityCliStore.SecretKind.Token, token);
        return true;
    }

    @Override
    public boolean delete(String targetName) {
        return this.deleteByKind(targetName, KeychainSecurityCliStore.SecretKind.Token);
    }

    @Override
    public boolean isSecure() {
        return true;
    }
}

