/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.credentialstorage.implementation.posix.libsecret;

import com.microsoft.credentialstorage.implementation.posix.internal.GLibLibrary;
import com.microsoft.credentialstorage.implementation.posix.libsecret.LibSecretBackedSecureStore;
import com.microsoft.credentialstorage.model.StoredToken;
import com.microsoft.credentialstorage.model.StoredTokenPair;
import com.microsoft.credentialstorage.model.StoredTokenType;
import com.sun.jna.ptr.PointerByReference;
import java.util.Objects;

public final class LibSecretBackedTokenPairStore
extends LibSecretBackedSecureStore<StoredTokenPair> {
    private static final String ACCESS_TOKEN = "/accessToken";
    private static final String REFRESH_TOKEN = "/refreshToken";

    @Override
    public StoredTokenPair get(String key) {
        Objects.requireNonNull(key, "key cannot be null");
        logger.info("Getting {} for {}", (Object)this.getType(), (Object)key);
        StoredToken accessToken = this.readSecret(key + ACCESS_TOKEN, (userName, password) -> new StoredToken((char[])password, StoredTokenType.ACCESS));
        StoredToken refreshToken = this.readSecret(key + REFRESH_TOKEN, (userName, password) -> new StoredToken((char[])password, StoredTokenType.REFRESH));
        if (accessToken == null && refreshToken == null) {
            return null;
        }
        return new StoredTokenPair(accessToken, refreshToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(String key, StoredTokenPair secret) {
        Objects.requireNonNull(key, "key cannot be null");
        Objects.requireNonNull(secret, "secret cannot be null");
        logger.info("Adding a {} for {}", (Object)this.getType(), (Object)key);
        PointerByReference error = new PointerByReference();
        try {
            boolean result = this.writeSecret(key + ACCESS_TOKEN, secret.getAccessToken().getType().getDescription(), secret.getAccessToken().getValue(), error);
            if (!result || !LibSecretBackedTokenPairStore.checkResult(error, "Could not save access token to the storage.")) {
                boolean bl = false;
                return bl;
            }
            result = this.writeSecret(key + REFRESH_TOKEN, secret.getRefreshToken().getType().getDescription(), secret.getRefreshToken().getValue(), error);
            boolean bl = result && LibSecretBackedTokenPairStore.checkResult(error, "Could not save refresh token to the storage.");
            return bl;
        }
        finally {
            if (error.getValue() != null) {
                GLibLibrary.INSTANCE.g_error_free(error.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(String key) {
        boolean bl;
        Objects.requireNonNull(key, "key cannot be null");
        logger.info("Deleting {} for {}", (Object)this.getType(), (Object)key);
        PointerByReference accessError = new PointerByReference();
        try {
            boolean accessResult = this.deleteSecret(key + ACCESS_TOKEN, accessError);
            boolean result = accessResult && LibSecretBackedTokenPairStore.checkResult(accessError, "Could not delete access token from storage");
        }
        finally {
            if (accessError.getValue() != null) {
                GLibLibrary.INSTANCE.g_error_free(accessError.getValue());
            }
        }
        PointerByReference refreshError = new PointerByReference();
        try {
            boolean refreshResult = this.deleteSecret(key + REFRESH_TOKEN, accessError);
            bl = refreshResult && LibSecretBackedTokenPairStore.checkResult(refreshError, "Could not delete refresh token from storage");
        }
        finally {
            if (accessError.getValue() != null) {
                GLibLibrary.INSTANCE.g_error_free(accessError.getValue());
            }
        }
        return result &= bl;
    }

    @Override
    protected StoredTokenPair create(String username, char[] secret) {
        return null;
    }

    @Override
    protected String getType() {
        return "OAuth2Token";
    }
}

