/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore;

import com.jnbridge.jnbcore.CallbackException;
import com.jnbridge.jnbcore.CallbackFactory;
import com.jnbridge.jnbcore.ClassRegistry;
import com.jnbridge.jnbcore.DebugConstants;
import com.jnbridge.jnbcore.InternalException;
import com.jnbridge.jnbcore.JNBArrayWrapper;
import com.jnbridge.jnbcore.JNBCallback;
import com.jnbridge.jnbcore.JNBObjID;
import com.jnbridge.jnbcore.JNBValueObject;
import com.jnbridge.jnbcore.MessageKeys;
import com.jnbridge.jnbcore.Messages;
import com.jnbridge.jnbcore.ObjectRegistry;
import java.lang.reflect.Array;

public final class ArgConverter
implements DebugConstants,
MessageKeys {
    public static Object[] convertArgs(Object[] objectArray, Object[] objectArray2) throws InternalException, CallbackException {
        if (objectArray.length != objectArray2.length) {
            throw new InternalException(Messages.getString("ARGCONVERTER_CONVERTARGS"));
        }
        Object[] objectArray3 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray3[i] = ArgConverter.convertOneArg((String)objectArray[i], objectArray2[i]);
        }
        return objectArray3;
    }

    public static Object convertOneArg(String string, Object object) throws InternalException, CallbackException {
        if (object != null && object instanceof JNBArrayWrapper) {
            object = ((JNBArrayWrapper)object).getArray();
        }
        try {
            switch (string.charAt(0)) {
                case 'I': {
                    if (object instanceof Integer) {
                        return object;
                    }
                    return new Integer((String)object);
                }
                case 'Z': {
                    if (object instanceof Boolean) {
                        return object;
                    }
                    return new Boolean((String)object);
                }
                case 'B': {
                    if (object instanceof Byte) {
                        return object;
                    }
                    return new Byte((String)object);
                }
                case 'C': {
                    if (object instanceof Character) {
                        return object;
                    }
                    if (object instanceof Integer) {
                        char c = (char)((Integer)object).intValue();
                        return new Character(c);
                    }
                    Integer n = new Integer((String)object);
                    char c = (char)n.intValue();
                    return new Character(c);
                }
                case 'S': {
                    if (object instanceof Short) {
                        return object;
                    }
                    return new Short((String)object);
                }
                case 'J': {
                    if (object instanceof Long) {
                        return object;
                    }
                    return new Long((String)object);
                }
                case 'F': {
                    if (object instanceof Float) {
                        return object;
                    }
                    return new Float((String)object);
                }
                case 'D': {
                    if (object instanceof Double) {
                        return object;
                    }
                    return new Double((String)object);
                }
                case '[': {
                    return ArgConverter.convertArray(string, object);
                }
                case 'L': {
                    if (object == null) {
                        return null;
                    }
                    if (string.substring(1).equals("java.lang.String;")) {
                        return (String)object;
                    }
                    if (object instanceof String) {
                        return object;
                    }
                    if (object.getClass().isArray()) {
                        return ArgConverter.convertArray(string, object);
                    }
                    if (object instanceof JNBCallback) {
                        return CallbackFactory.createProxy((JNBCallback)object);
                    }
                    if (object instanceof JNBValueObject) {
                        return ((JNBValueObject)object).getObject();
                    }
                    if (object instanceof JNBObjID) {
                        return ObjectRegistry.getObjectFromID((JNBObjID)object);
                    }
                    return object;
                }
            }
            throw new InternalException(Messages.getString("ARGCONVERTER_CONVERTONEARG") + " " + string);
        }
        catch (InternalException internalException) {
            throw internalException;
        }
        catch (CallbackException callbackException) {
            throw callbackException;
        }
        catch (Exception exception) {
            throw new InternalException(exception.toString());
        }
    }

    private static Object convertArray(String string, Object object) throws InternalException, CallbackException {
        if (object == null) {
            return object;
        }
        switch (string.charAt(1)) {
            case 'I': {
                return object;
            }
            case 'Z': {
                return object;
            }
            case 'B': {
                return object;
            }
            case 'C': {
                Class<?> clazz = object.getClass().getComponentType();
                if (clazz == Integer.TYPE) {
                    return ArgConverter.convertIntArrayToCharArray((int[])object);
                }
                return object;
            }
            case 'S': {
                return object;
            }
            case 'J': {
                return object;
            }
            case 'F': {
                return object;
            }
            case 'D': {
                return object;
            }
            case '[': {
                Object object2;
                int n = Array.getLength(object);
                String string2 = string.substring(1);
                try {
                    string2 = ArgConverter.filterObjID(string2);
                    object2 = Array.newInstance(ClassRegistry.getClass(string2, Thread.currentThread().getContextClassLoader()), n);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new InternalException(Messages.getString("ARGCONVERTER_CONVERTARRAY_1") + " " + classNotFoundException.getMessage());
                }
                for (int i = 0; i < n; ++i) {
                    Array.set(object2, i, ArgConverter.convertArray(string.substring(1), Array.get(object, i)));
                }
                return object2;
            }
            case 'L': {
                Object object3;
                int n = Array.getLength(object);
                String string3 = string.substring(1);
                if (string3.equals("Ljava.lang.String;")) {
                    return ArgConverter.convertStringArray(object);
                }
                try {
                    string3 = string3.substring(1, string3.length() - 1);
                    string3 = ArgConverter.filterObjID(string3);
                    object3 = Array.newInstance(ClassRegistry.getClass(string3, Thread.currentThread().getContextClassLoader()), n);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new InternalException(Messages.getString("ARGCONVERTER_CONVERTARRAY_2") + " " + classNotFoundException.getMessage());
                }
                for (int i = 0; i < n; ++i) {
                    Object object4 = ArgConverter.convertOneArg(string.substring(1), Array.get(object, i));
                    Array.set(object3, i, object4);
                }
                return object3;
            }
        }
        return ArgConverter.convertArray(object.getClass().getName(), object);
    }

    private static char[] convertIntArrayToCharArray(int[] nArray) {
        int n = nArray.length;
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)nArray[i];
        }
        return cArray;
    }

    private static String filterObjID(String string) {
        int n = string.indexOf("com.jnbridge.jnbcore.JNBObjID");
        if (n == -1) {
            return string;
        }
        String string2 = string.substring(0, n) + "java.lang.Object" + string.substring(n + 29);
        return string2;
    }

    private static int[] convertIntArray(Object object) {
        int n = Array.getLength(object);
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            String string = (String)Array.get(object, i);
            nArray[i] = Integer.parseInt(string);
        }
        return nArray;
    }

    private static boolean[] convertBoolArray(Object object) {
        int n = Array.getLength(object);
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            String string = (String)Array.get(object, i);
            blArray[i] = string.equalsIgnoreCase("true");
        }
        return blArray;
    }

    private static byte[] convertByteArray(Object object) {
        int n = Array.getLength(object);
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            String string = (String)Array.get(object, i);
            byArray[i] = Byte.parseByte(string);
        }
        return byArray;
    }

    private static char[] convertCharArray(Object object) {
        int n = Array.getLength(object);
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            char c;
            String string = (String)Array.get(object, i);
            Integer n2 = new Integer(string);
            cArray[i] = c = (char)n2.intValue();
        }
        return cArray;
    }

    private static short[] convertShortArray(Object object) {
        int n = Array.getLength(object);
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            String string = (String)Array.get(object, i);
            sArray[i] = Short.parseShort(string);
        }
        return sArray;
    }

    private static long[] convertLongArray(Object object) {
        int n = Array.getLength(object);
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            String string = (String)Array.get(object, i);
            lArray[i] = Long.parseLong(string);
        }
        return lArray;
    }

    private static float[] convertFloatArray(Object object) {
        int n = Array.getLength(object);
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            String string = (String)Array.get(object, i);
            fArray[i] = Float.parseFloat(string);
        }
        return fArray;
    }

    private static double[] convertDoubleArray(Object object) {
        int n = Array.getLength(object);
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            String string = (String)Array.get(object, i);
            dArray[i] = Double.parseDouble(string);
        }
        return dArray;
    }

    private static String[] convertStringArray(Object object) {
        int n = Array.getLength(object);
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)Array.get(object, i);
        }
        return stringArray;
    }
}

