/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore;

import com.jnbridge.jnbcore.ClassHelper;
import com.jnbridge.jnbcore.DotNetSideException;
import com.jnbridge.jnbcore.MessageKeys;
import com.jnbridge.jnbcore.Messages;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Hashtable;

public abstract class BoxedValueFactory
implements MessageKeys {
    private static Hashtable classMap = new Hashtable();
    private static Hashtable boxedClassMap = new Hashtable();
    private static HashSet specialBoxedClassMap = new HashSet();
    private static final int BYTE = 1;
    private static final int SHORT = 2;
    private static final int INT = 3;
    private static final int LONG = 4;
    private static final int FLOAT = 5;
    private static final int DOUBLE = 6;
    private static final int CHAR = 7;
    private static final int BOOL = 8;
    private static Class[] intParam = new Class[]{Integer.TYPE};
    private static Class[] shortParam = new Class[]{Short.TYPE};
    private static Class[] longParam = new Class[]{Long.TYPE};
    private static Class[] floatParam = new Class[]{Float.TYPE};
    private static Class[] doubleParam = new Class[]{Double.TYPE};
    private static Class[] byteParam = new Class[]{Byte.TYPE};
    private static Class[] charParam = new Class[]{Character.TYPE};
    private static Class[] boolParam = new Class[]{Boolean.TYPE};
    private static boolean boxedValueInitialized = false;
    private static boolean boxedValueInitialized2 = false;
    private static Class boxedValue = null;
    private static Method unboxToJava = null;
    private static Class[] unboxParams = new Class[0];
    private static Object[] emptyArgs = new Object[0];
    private static boolean netToJavaProject = false;
    private static Constructor boxedSByteConstr = null;
    private static Constructor boxedShortConstr = null;
    private static Constructor boxedIntConstr = null;
    private static Constructor boxedLongConstr = null;
    private static Constructor boxedFloatConstr = null;
    private static Constructor boxedDoubleConstr = null;
    private static Constructor boxedCharConstr = null;
    private static Constructor boxedBoolConstr = null;

    private static Constructor getWrappedValueConstructor(String string, Class[] classArray) {
        try {
            Class clazz = ClassHelper.forName(string);
            return clazz.getConstructor(classArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static void initializeBoxedValue2() {
        if (!boxedValueInitialized2) {
            boxedSByteConstr = BoxedValueFactory.getWrappedValueConstructor("System.BoxedSByte", byteParam);
            boxedShortConstr = BoxedValueFactory.getWrappedValueConstructor("System.BoxedShort", shortParam);
            boxedIntConstr = BoxedValueFactory.getWrappedValueConstructor("System.BoxedInt", intParam);
            boxedLongConstr = BoxedValueFactory.getWrappedValueConstructor("System.BoxedLong", longParam);
            boxedFloatConstr = BoxedValueFactory.getWrappedValueConstructor("System.BoxedFloat", floatParam);
            boxedDoubleConstr = BoxedValueFactory.getWrappedValueConstructor("System.BoxedDouble", doubleParam);
            boxedCharConstr = BoxedValueFactory.getWrappedValueConstructor("System.BoxedChar", charParam);
            boxedBoolConstr = BoxedValueFactory.getWrappedValueConstructor("System.BoxedBoolean", boolParam);
            boxedValueInitialized2 = true;
        }
    }

    public static void initializeBoxedValue() {
        if (!boxedValueInitialized) {
            try {
                boxedValue = ClassHelper.forName("System.BoxedValue");
                unboxToJava = boxedValue.getMethod("unboxToJava", unboxParams);
                boxedValueInitialized = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                netToJavaProject = true;
                boxedValueInitialized = true;
                boxedValueInitialized2 = true;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                netToJavaProject = true;
                boxedValueInitialized = true;
                boxedValueInitialized2 = true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new DotNetSideException(Messages.getString("BOXEDVALUEFACTORY_STATIC"));
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                Throwable throwable = exceptionInInitializerError.getCause();
                if (throwable != null && throwable instanceof DotNetSideException) {
                    netToJavaProject = true;
                }
                throw exceptionInInitializerError;
            }
        }
    }

    public static boolean isBoxable(Object object) {
        BoxedValueFactory.initializeBoxedValue();
        if (netToJavaProject) {
            return false;
        }
        if (object == null) {
            return false;
        }
        return classMap.containsKey(object.getClass());
    }

    public static boolean isBoxedValue(Object object) {
        BoxedValueFactory.initializeBoxedValue();
        if (netToJavaProject) {
            return false;
        }
        if (object == null) {
            return false;
        }
        return boxedClassMap.containsKey(object.getClass().getName());
    }

    public static boolean isSpecialBoxedValue(Object object) {
        BoxedValueFactory.initializeBoxedValue();
        if (netToJavaProject) {
            return false;
        }
        if (object == null) {
            return false;
        }
        return specialBoxedClassMap.contains(object.getClass().getName());
    }

    public static Object unbox(Object object) {
        BoxedValueFactory.initializeBoxedValue();
        if (object == null) {
            return null;
        }
        try {
            return unboxToJava.invoke(object, emptyArgs);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new DotNetSideException(Messages.getString("OXEDVALUEFACTORY_UNBOX_1"), invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new DotNetSideException(Messages.getString("BOXEDVALUEFACTORY_UNBOX_2"), illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                Class clazz = ClassHelper.forName("System.BoxedValue");
                Method method = clazz.getMethod("unboxToJava", unboxParams);
                return method.invoke(object, emptyArgs);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new DotNetSideException(Messages.getString("BOXEDVALUEFACTORY_STATIC"));
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new DotNetSideException(Messages.getString("OXEDVALUEFACTORY_UNBOX_1"), illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new DotNetSideException(Messages.getString("BOXEDVALUEFACTORY_UNBOX_2"), illegalArgumentException);
            }
        }
    }

    public static Object box(Object object) {
        BoxedValueFactory.initializeBoxedValue();
        BoxedValueFactory.initializeBoxedValue2();
        if (object == null) {
            return null;
        }
        Integer n = (Integer)classMap.get(object.getClass());
        if (n == null) {
            throw new DotNetSideException(Messages.getString("BOXEDVALUEFACTORY_BOX_1") + object.getClass());
        }
        try {
            switch (n) {
                case 1: {
                    Object t = boxedSByteConstr.newInstance(object);
                    return t;
                }
                case 2: {
                    Object t = boxedShortConstr.newInstance(object);
                    return t;
                }
                case 3: {
                    Object t = boxedIntConstr.newInstance(object);
                    return t;
                }
                case 4: {
                    Object t = boxedLongConstr.newInstance(object);
                    return t;
                }
                case 5: {
                    Object t = boxedFloatConstr.newInstance(object);
                    return t;
                }
                case 6: {
                    Object t = boxedDoubleConstr.newInstance(object);
                    return t;
                }
                case 7: {
                    Object t = boxedCharConstr.newInstance(object);
                    return t;
                }
                case 8: {
                    Object t = boxedBoolConstr.newInstance(object);
                    return t;
                }
            }
            throw new DotNetSideException(Messages.getString("BOXEDVALUEFACTORY_BOX_2") + n);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new DotNetSideException(Messages.getString("BOXEDVALUEFACTORY_BOX_5"), invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new DotNetSideException(Messages.getString("BOXEDVALUEFACTORY_BOX_6"), illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new DotNetSideException(Messages.getString("BOXEDVALUEFACTORY_BOX_7"), instantiationException);
        }
    }

    static {
        classMap.put(Byte.class, new Integer(1));
        classMap.put(Short.class, new Integer(2));
        classMap.put(Integer.class, new Integer(3));
        classMap.put(Long.class, new Integer(4));
        classMap.put(Float.class, new Integer(5));
        classMap.put(Double.class, new Integer(6));
        classMap.put(Character.class, new Integer(7));
        classMap.put(Boolean.class, new Integer(8));
        boxedClassMap.put("System.BoxedBoolean", new Integer(8));
        boxedClassMap.put("System.BoxedChar", new Integer(7));
        boxedClassMap.put("System.BoxedDouble", new Integer(6));
        boxedClassMap.put("System.BoxedFloat", new Integer(5));
        boxedClassMap.put("System.BoxedInt", new Integer(3));
        boxedClassMap.put("System.BoxedLong", new Integer(4));
        boxedClassMap.put("System.BoxedSByte", new Integer(1));
        boxedClassMap.put("System.BoxedShort", new Integer(2));
        boxedClassMap.put("System.BoxedUInt", new Integer(4));
        boxedClassMap.put("System.BoxedUShort", new Integer(3));
        boxedClassMap.put("System.BoxedULong", new Integer(5));
        boxedClassMap.put("System.BoxedByte", new Integer(2));
        specialBoxedClassMap.add("System.BoxedUInt");
        specialBoxedClassMap.add("System.BoxedUShort");
        specialBoxedClassMap.add("System.BoxedULong");
        specialBoxedClassMap.add("System.BoxedByte");
    }
}

