/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore;

import com.jnbridge.jnbcore.AsyncCallbackInvocationHandler;
import com.jnbridge.jnbcore.CallbackException;
import com.jnbridge.jnbcore.CallbackInvocationHandler;
import com.jnbridge.jnbcore.JNBCallback;
import com.jnbridge.jnbcore.MessageKeys;
import com.jnbridge.jnbcore.Messages;
import com.jnbridge.jnbcore.SyncCallbackInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Hashtable;

public class CallbackFactory
implements MessageKeys {
    private static Hashtable callbackRegistry = new Hashtable();

    private CallbackFactory() {
    }

    public static Object getRegisteredProxy(long l) {
        Long l2 = new Long(l);
        return callbackRegistry.get(l2);
    }

    public static void removeProxy(long l) {
        Long l2 = new Long(l);
        callbackRegistry.remove(l2);
    }

    public static Object createProxy(JNBCallback jNBCallback) throws CallbackException {
        Long l = new Long(jNBCallback.getCallbackID());
        Object object = callbackRegistry.get(l);
        if (object != null) {
            return object;
        }
        String[] stringArray = jNBCallback.getInterfaces();
        int n = stringArray.length;
        CallbackInvocationHandler callbackInvocationHandler = null;
        callbackInvocationHandler = jNBCallback.isSync() ? new SyncCallbackInvocationHandler() : new AsyncCallbackInvocationHandler();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        HashSet hashSet = new HashSet();
        for (int i = 0; i < n; ++i) {
            try {
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(stringArray[i], false, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classLoader = CallbackFactory.class.getClassLoader();
                    clazz = Class.forName(stringArray[i], false, classLoader);
                }
                if (hashSet.contains(clazz)) continue;
                if (!clazz.isInterface()) {
                    throw new CallbackException(Messages.getString("CALLBACKFACTORY_CREATEPROXY_1") + " " + clazz.getName());
                }
                hashSet.add(clazz);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new CallbackException(Messages.getString("CALLBACKFACTORY_CREATEPROXY_2") + " " + classNotFoundException.getMessage());
            }
        }
        Object[] objectArray = hashSet.toArray();
        int n2 = objectArray.length;
        Class[] classArray = new Class[n2];
        for (int i = 0; i < n2; ++i) {
            classArray[i] = (Class)objectArray[i];
        }
        object = Proxy.newProxyInstance(classLoader, classArray, (InvocationHandler)callbackInvocationHandler);
        callbackRegistry.put(l, object);
        return object;
    }
}

