/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore;

import com.jnbridge.jnbcore.ClassNameConstants;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;

public final class DotNetArgTypeConverter
implements ClassNameConstants {
    private static Boolean TRUE = new Boolean(true);
    private static Boolean FALSE = new Boolean(false);
    private static Hashtable wrapperTable = new Hashtable();
    private static Hashtable primitiveTypeMap = new Hashtable();
    private static Hashtable reverseConversionTable = new Hashtable();
    private static HashSet bracketExceptions;

    private DotNetArgTypeConverter() {
    }

    private static String replaceAll(String string, String string2, String string3) {
        int n = string2.length();
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = string.indexOf(string2, 0);
        int n4 = 0;
        while (n3 != -1) {
            stringBuffer.append(string.substring(n4, n3));
            stringBuffer.append(string3);
            n4 = n3 + n;
            if (n4 >= n2) break;
            n3 = string.indexOf(string2, n4);
        }
        if (n4 < n2) {
            stringBuffer.append(string.substring(n4));
        }
        return stringBuffer.toString();
    }

    public static String convertNested(String string) {
        if (string == null) {
            return string;
        }
        String string2 = DotNetArgTypeConverter.replaceAll(string, "`", "__");
        return string2.replace('+', '$');
    }

    public static String[] convertNested(String[] stringArray) {
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = DotNetArgTypeConverter.convertNested(stringArray[i]);
        }
        return stringArray2;
    }

    public static String[] convertNested(String[] stringArray, String string) {
        int n = stringArray.length;
        String[] stringArray2 = new String[n + 1];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = stringArray[i];
        }
        stringArray2[n] = string;
        return DotNetArgTypeConverter.convertNested(stringArray2);
    }

    public static String[] convertNested(String[] stringArray, boolean[] blArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = DotNetArgTypeConverter.convertNested(stringArray[i]);
            arrayList.add(string);
            if (!blArray[i]) continue;
            arrayList.add(string + "Helper");
        }
        String[] stringArray2 = new String[arrayList.size()];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = (String)arrayList.get(i);
        }
        return stringArray2;
    }

    public static boolean[] convertNestedInterfaces(boolean[] blArray) {
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
        for (int i = 0; i < blArray.length; ++i) {
            if (blArray[i]) {
                arrayList.add(TRUE);
                arrayList.add(FALSE);
                continue;
            }
            arrayList.add(FALSE);
        }
        boolean[] blArray2 = new boolean[arrayList.size()];
        for (int i = 0; i < blArray2.length; ++i) {
            blArray2[i] = arrayList.get(i) == TRUE;
        }
        return blArray2;
    }

    public static String convertToJavaType(String string) {
        return DotNetArgTypeConverter.convertToJavaType(string, false);
    }

    public static String convertToJavaType(String string, boolean bl) {
        String string2;
        if ((string = DotNetArgTypeConverter.convertNested(string)).endsWith("[]") || string.endsWith(",]")) {
            return "[" + DotNetArgTypeConverter.convertToJavaType(DotNetArgTypeConverter.stripArray(string), true);
        }
        int n = string.indexOf("[");
        int n2 = string.lastIndexOf("]");
        if (n != -1 && n2 != -1 && n2 > n + 1) {
            string = string.substring(0, n) + string.substring(n2 + 1);
        }
        if ((string2 = (String)primitiveTypeMap.get(string)) != null) {
            return string2;
        }
        string2 = string.equals("System.String") ? "java.lang.String" : string;
        if (bl) {
            string2 = "L" + string2 + ";";
        }
        return string2;
    }

    public static String[] convertToJavaType(String[] stringArray) {
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = DotNetArgTypeConverter.convertToJavaType(stringArray[i]);
        }
        return stringArray2;
    }

    private static String stripArray(String string) {
        int n = string.length();
        if (string.endsWith("[]")) {
            return string.substring(0, n - 2);
        }
        if (string.endsWith(",]")) {
            return string.substring(0, n - 2) + "]";
        }
        return string;
    }

    public static String convertToDotNetEquivType(String string) {
        int n = string.lastIndexOf("[");
        String string2 = null;
        if (n == -1) {
            string2 = string;
        } else {
            String string3 = string.substring(0, n + 1);
            String string4 = string.substring(n + 1);
            String string5 = (String)reverseConversionTable.get(string4);
            if (string5 == null) {
                string5 = string4;
            }
            string2 = string3 + string5;
        }
        return string2;
    }

    public static String getJavaWrapperType(String string) {
        return (String)wrapperTable.get(string);
    }

    public static String convertToDotNet(String string) {
        String string2 = string.replace('$', '+');
        string2 = DotNetArgTypeConverter.replaceAll(string2, "__", "`");
        string2 = DotNetArgTypeConverter.replaceAll(string2, ".`", ".__");
        string2 = DotNetArgTypeConverter.replaceAll(string2, "+`", "+__");
        return string2;
    }

    public static String removeBrackets(String string) {
        if (bracketExceptions.contains(string)) {
            return string;
        }
        int n = string.indexOf(60);
        String string2 = string;
        while (n != -1) {
            int n2 = string.indexOf(62, n);
            string2 = n2 == -1 ? string2.substring(0, n) : string2.substring(0, n) + string2.substring(n2 + 1);
            n = string2.indexOf(60);
        }
        return string2;
    }

    static {
        primitiveTypeMap.put("System.Boolean", "Z");
        primitiveTypeMap.put("System.SByte", "B");
        primitiveTypeMap.put("System.Int32", "I");
        primitiveTypeMap.put("System.Int16", "S");
        primitiveTypeMap.put("System.Int64", "J");
        primitiveTypeMap.put("System.Single", "F");
        primitiveTypeMap.put("System.Double", "D");
        primitiveTypeMap.put("System.Char", "C");
        primitiveTypeMap.put("System.Byte", "S");
        primitiveTypeMap.put("System.UInt16", "I");
        primitiveTypeMap.put("System.UInt32", "J");
        primitiveTypeMap.put("System.UInt64", "F");
        wrapperTable.put("System.Boolean", "java.lang.Boolean");
        wrapperTable.put("System.SByte", "java.lang.Byte");
        wrapperTable.put("System.Int32", "java.lang.Integer");
        wrapperTable.put("System.Int16", "java.lang.Short");
        wrapperTable.put("System.Int64", "java.lang.Long");
        wrapperTable.put("System.Single", "java.lang.Float");
        wrapperTable.put("System.Double", "java.lang.Double");
        wrapperTable.put("System.Char", "java.lang.Character");
        wrapperTable.put("System.Byte", "java.lang.Short");
        wrapperTable.put("System.UInt16", "java.lang.Integer");
        wrapperTable.put("System.UInt32", "java.lang.Long");
        wrapperTable.put("System.UInt64", "java.lang.Float");
        reverseConversionTable.put("Z", "System.Boolean");
        reverseConversionTable.put("B", "System.SByte");
        reverseConversionTable.put("I", "System.Int32");
        reverseConversionTable.put("S", "System.Int16");
        reverseConversionTable.put("J", "System.Int64");
        reverseConversionTable.put("F", "System.Single");
        reverseConversionTable.put("D", "System.Double");
        reverseConversionTable.put("C", "System.Char");
        reverseConversionTable.put("Ljava.lang.String;", "System.String");
        reverseConversionTable.put("Ljava.lang.Enum;", "System.Enum");
        bracketExceptions = new HashSet();
        bracketExceptions.add("<init>");
        bracketExceptions.add("<clinit>");
    }
}

