/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore;

import com.jnbridge.jnbcore.ClassNameConstants;
import com.jnbridge.org.apache.bcel.generic.ArrayType;
import com.jnbridge.org.apache.bcel.generic.ObjectType;
import com.jnbridge.org.apache.bcel.generic.Type;
import java.util.Hashtable;

class DotNetArgTypeConverterJ2N
implements ClassNameConstants {
    private static Hashtable bcelConversionTable = new Hashtable();
    private static Hashtable mappedCollectionTable = new Hashtable();

    DotNetArgTypeConverterJ2N() {
    }

    public static Type convertMappedCollection(String string) {
        return (Type)mappedCollectionTable.get(string);
    }

    public static Type getBcelConversionType(String string) {
        return (Type)bcelConversionTable.get(string);
    }

    public static boolean isPrimitive(String string) {
        return bcelConversionTable.containsKey(string) && !"System.String".equals(string);
    }

    public static Type convertOneArgType(String string) {
        Type type = (Type)bcelConversionTable.get(string);
        if (type != null) {
            return type;
        }
        if (DotNetArgTypeConverterJ2N.isArray(string)) {
            int n = DotNetArgTypeConverterJ2N.getDimension(string);
            Type type2 = DotNetArgTypeConverterJ2N.getElementType(string);
            return new ArrayType(type2, n);
        }
        return new ObjectType(string);
    }

    private static Type getElementType(String string) {
        int n = string.indexOf(91);
        String string2 = string.substring(0, n);
        return DotNetArgTypeConverterJ2N.convertOneArgType(string2);
    }

    public static boolean isPrimitiveOrString(String string) {
        if (DotNetArgTypeConverterJ2N.isPrimitive(string)) {
            return true;
        }
        return "System.String".equals(string);
    }

    private static boolean isArray(String string) {
        return string.indexOf(91) != -1;
    }

    private static int getDimension(String string) {
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c != '[' && c != ',') continue;
            ++n;
        }
        return n;
    }

    static {
        bcelConversionTable.put("System.Boolean", Type.BOOLEAN);
        bcelConversionTable.put("System.SByte", Type.BYTE);
        bcelConversionTable.put("System.Int32", Type.INT);
        bcelConversionTable.put("System.Int16", Type.SHORT);
        bcelConversionTable.put("System.Int64", Type.LONG);
        bcelConversionTable.put("System.Single", Type.FLOAT);
        bcelConversionTable.put("System.Double", Type.DOUBLE);
        bcelConversionTable.put("System.Char", Type.CHAR);
        bcelConversionTable.put("System.Byte", Type.SHORT);
        bcelConversionTable.put("System.UInt16", Type.INT);
        bcelConversionTable.put("System.UInt32", Type.LONG);
        bcelConversionTable.put("System.UInt64", Type.FLOAT);
        bcelConversionTable.put("System.String", Type.STRING);
        bcelConversionTable.put("System.Void", Type.VOID);
        mappedCollectionTable.put("System.Collections.Hashtable", new ObjectType("java.util.Hashtable"));
        mappedCollectionTable.put("System.Collections.ArrayList", new ObjectType("java.util.ArrayList"));
        mappedCollectionTable.put("System.DateTime", new ObjectType("java.util.Date"));
        mappedCollectionTable.put("System.Decimal", new ObjectType("java.math.BigDecimal"));
    }
}

