/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore;

import com.jnbridge.jnbcore.AbstractDotNetCallbackListener;
import com.jnbridge.jnbcore.BoxedValueFactory;
import com.jnbridge.jnbcore.DotNetArgTypeConverter;
import com.jnbridge.jnbcore.DotNetCallbackDispatcher;
import com.jnbridge.jnbcore.DotNetCallbackInfo;
import com.jnbridge.jnbcore.DotNetClassRegistry;
import com.jnbridge.jnbcore.DotNetWrapper;
import com.jnbridge.jnbcore.DotNetWrapperFactory;
import com.jnbridge.jnbcore.JNBInternalException;
import com.jnbridge.jnbcore.java50.EnumInfo;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Hashtable;

public class DotNetCallbackListener
extends AbstractDotNetCallbackListener {
    private long callbackID;
    private Object theCallback;
    private boolean m_terminate = false;
    private static HashSet wrappableClasses = new HashSet();
    private static Hashtable primitiveTypeNameMap;
    private static Hashtable primitiveTypeMap;
    private static Hashtable signatureMap;
    private static Hashtable extendedSignatureMap;
    private static Hashtable typeMap;

    public DotNetCallbackListener(long l, Object object) {
        this.callbackID = l;
        this.theCallback = object;
    }

    public void terminate() {
        this.m_terminate = true;
    }

    public void run() {
        DotNetCallbackDispatcher dotNetCallbackDispatcher = null;
        try {
            dotNetCallbackDispatcher = new DotNetCallbackDispatcher(this.callbackID);
            while (true) {
                Serializable serializable;
                if (this.m_terminate) {
                    dotNetCallbackDispatcher.killCallback();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    dotNetCallbackDispatcher.dotNetDispose();
                    dotNetCallbackDispatcher = null;
                    return;
                }
                DotNetCallbackInfo dotNetCallbackInfo = dotNetCallbackDispatcher.waitForCallback();
                if (dotNetCallbackInfo == null) continue;
                Object object = null;
                try {
                    object = this.invoke(dotNetCallbackInfo);
                }
                catch (InvocationTargetException invocationTargetException) {
                    serializable = invocationTargetException.getTargetException();
                    dotNetCallbackDispatcher.endCallbackException(dotNetCallbackInfo.getResultContext(), serializable);
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    dotNetCallbackDispatcher.endCallbackException(dotNetCallbackInfo.getResultContext(), illegalAccessException);
                    continue;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    dotNetCallbackDispatcher.endCallbackException(dotNetCallbackInfo.getResultContext(), noSuchMethodException);
                    continue;
                }
                if (object != null) {
                    String string = object.getClass().getName();
                    if (string.equals("System.BoxedInt")) {
                        serializable = (Integer)BoxedValueFactory.unbox(object);
                        dotNetCallbackDispatcher.endCallback(dotNetCallbackInfo.getResultContext(), (Integer)serializable);
                    } else if (string.equals("System.BoxedShort")) {
                        serializable = (Short)BoxedValueFactory.unbox(object);
                        dotNetCallbackDispatcher.endCallback(dotNetCallbackInfo.getResultContext(), (Short)serializable);
                    } else if (string.equals("System.BoxedLong")) {
                        serializable = (Long)BoxedValueFactory.unbox(object);
                        dotNetCallbackDispatcher.endCallback(dotNetCallbackInfo.getResultContext(), (Long)serializable);
                    } else if (string.equals("System.BoxedFloat")) {
                        serializable = (Float)BoxedValueFactory.unbox(object);
                        dotNetCallbackDispatcher.endCallback(dotNetCallbackInfo.getResultContext(), ((Float)serializable).floatValue());
                    } else if (string.equals("System.BoxedDouble")) {
                        serializable = (Double)BoxedValueFactory.unbox(object);
                        dotNetCallbackDispatcher.endCallback(dotNetCallbackInfo.getResultContext(), (Double)serializable);
                    } else if (string.equals("System.BoxedChar")) {
                        serializable = (Character)BoxedValueFactory.unbox(object);
                        dotNetCallbackDispatcher.endCallback(dotNetCallbackInfo.getResultContext(), ((Character)serializable).charValue());
                    } else if (string.equals("System.BoxedSByte")) {
                        serializable = (Byte)BoxedValueFactory.unbox(object);
                        dotNetCallbackDispatcher.endCallback(dotNetCallbackInfo.getResultContext(), (Byte)serializable);
                    } else if (string.equals("System.BoxedBoolean")) {
                        serializable = (Boolean)BoxedValueFactory.unbox(object);
                        dotNetCallbackDispatcher.endCallback(dotNetCallbackInfo.getResultContext(), (Boolean)serializable);
                    } else if (string.equals("java.lang.String")) {
                        dotNetCallbackDispatcher.endCallback(dotNetCallbackInfo.getResultContext(), (String)object);
                    } else {
                        dotNetCallbackDispatcher.endCallback(dotNetCallbackInfo.getResultContext(), object);
                    }
                } else {
                    dotNetCallbackDispatcher.endCallback(dotNetCallbackInfo.getResultContext(), object);
                }
                dotNetCallbackInfo = null;
            }
        }
        catch (DotNetCallbackDispatcher.CallbackDisposedException callbackDisposedException) {
        }
        catch (JNBInternalException jNBInternalException) {
            dotNetCallbackDispatcher.killCallback();
        }
        catch (ThreadDeath threadDeath) {
            dotNetCallbackDispatcher.killCallback();
            throw threadDeath;
        }
    }

    private Object invoke(DotNetCallbackInfo dotNetCallbackInfo) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Object object;
        Method method;
        Class[] classArray;
        Object[] objectArray;
        block8: {
            String string = dotNetCallbackInfo.getMethodName();
            String[] stringArray = dotNetCallbackInfo.getSignature();
            objectArray = dotNetCallbackInfo.getArguments();
            classArray = this.convertSignature(stringArray);
            Class<?> clazz = this.theCallback.getClass();
            method = null;
            try {
                method = clazz.getMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                object = clazz.getMethods();
                for (int i = 0; i < ((Method[])object).length; ++i) {
                    if (!object[i].getName().equals("Invoke")) continue;
                    method = object[i];
                    classArray = method.getParameterTypes();
                    break;
                }
                if (method != null) break block8;
                throw noSuchMethodException;
            }
        }
        objectArray = this.unwrapPrimitives(objectArray, classArray);
        DotNetCallbackListener.wrapStringsAndArrays(objectArray, classArray);
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            Object object2 = method.invoke(this.theCallback, objectArray);
            object = method.getReturnType();
            object2 = this.unwrapStringsAndArrays(object2, (Class)object);
            return object2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            int n;
            object = illegalArgumentException.getMessage() + "\n";
            object = (String)object + "expected parameters: ";
            Class<?>[] classArray2 = method.getParameterTypes();
            for (n = 0; n < classArray2.length; ++n) {
                object = (String)object + " " + classArray2[n];
            }
            object = (String)object + "\n received arguments: ";
            for (n = 0; n < objectArray.length; ++n) {
                object = objectArray[n] == null ? (String)object + " null" : (String)object + " " + objectArray[n].getClass();
            }
            throw new IllegalArgumentException((String)object);
        }
    }

    private static void wrapStringsAndArrays(Object[] objectArray, Class[] classArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null || !wrappableClasses.contains(classArray[i].getName())) continue;
            if (objectArray[i].getClass() == String.class) {
                objectArray[i] = DotNetWrapperFactory.makeDotNetString((String)objectArray[i]);
                continue;
            }
            if (objectArray[i].getClass().isArray()) {
                objectArray[i] = DotNetWrapperFactory.makeDotNetArray(objectArray[i]);
                continue;
            }
            if (EnumInfo.isEnum(objectArray[i].getClass())) {
                objectArray[i] = DotNetWrapperFactory.makeDotNetEnum(objectArray[i]);
                continue;
            }
            if (!BoxedValueFactory.isBoxable(objectArray[i])) continue;
            objectArray[i] = BoxedValueFactory.box(objectArray[i]);
        }
    }

    Object unwrapStringsAndArrays(Object object, Class clazz) {
        if (clazz.getName().equals("System.Object") && object instanceof DotNetWrapper) {
            return ((DotNetWrapper)object).getWrappedValue();
        }
        return object;
    }

    private Object[] unwrapPrimitives(Object[] objectArray, Class[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (objectArray == null) {
            return new Object[0];
        }
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            objectArray2[i] = this.unwrapOneArgument(objectArray[i], classArray[i]);
        }
        return objectArray2;
    }

    private Object unwrapOneArgument(Object object, Class clazz) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object object2 = null;
        if (object == null) {
            return null;
        }
        if (clazz.isPrimitive()) {
            String string = clazz.getName();
            Method method = null;
            Class clazz2 = (Class)primitiveTypeMap.get(string);
            if (clazz2 != null) {
                if (clazz2 == Character.TYPE) {
                    if (object instanceof Character) {
                        object2 = object;
                    } else {
                        Short s = (Short)object;
                        char c = (char)s.shortValue();
                        object2 = new Character(c);
                    }
                } else {
                    object2 = BoxedValueFactory.isBoxedValue(object) ? BoxedValueFactory.unbox(object) : object;
                }
            } else if (object instanceof DotNetWrapper) {
                object2 = ((DotNetWrapper)object).getWrappedValue();
            } else {
                String string2 = (String)primitiveTypeNameMap.get(string);
                clazz2 = DotNetClassRegistry.getClass(string2);
                method = clazz2.getMethod("unboxToJava", new Class[0]);
                try {
                    object2 = method.invoke(object, new Object[0]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    String string3 = illegalArgumentException.getMessage() + "\n";
                    string3 = string3 + "expected parameters: ";
                    Class<?>[] classArray = method.getParameterTypes();
                    for (int i = 0; i < classArray.length; ++i) {
                        string3 = string3 + " " + classArray[i];
                    }
                    string3 = string3 + "\n received arguments: <empty>";
                    throw new IllegalArgumentException(string3);
                }
            }
        } else {
            object2 = object instanceof DotNetWrapper ? ((DotNetWrapper)object).getWrappedValue() : object;
        }
        return object2;
    }

    private Class[] convertSignature(String[] stringArray) {
        int n = stringArray.length;
        Class[] classArray = new Class[n];
        for (int i = 0; i < n; ++i) {
            Class clazz = (Class)typeMap.get(stringArray[i]);
            classArray[i] = clazz != null ? clazz : DotNetClassRegistry.getClass(this.convertOneSignature(stringArray[i]));
        }
        return classArray;
    }

    private String convertOneSignature(String string) {
        return this.convertOneSignature(string, signatureMap);
    }

    private String convertOneSignature(String string, Hashtable hashtable) {
        String string2 = (String)hashtable.get(string);
        if (string2 != null) {
            return string2;
        }
        if (string.endsWith("[]")) {
            return "[" + this.convertOneSignature(DotNetArgTypeConverter.convertNested(string.substring(0, string.length() - 2)), extendedSignatureMap);
        }
        if (string.endsWith(",]")) {
            return "[" + this.convertOneSignature(DotNetArgTypeConverter.convertNested(string.substring(0, string.length() - 2) + "]"), extendedSignatureMap);
        }
        if (hashtable == extendedSignatureMap) {
            return "L" + string + ";";
        }
        return string;
    }

    static {
        wrappableClasses.add("System.Object");
        wrappableClasses.add("System.ICloneable");
        wrappableClasses.add("System.Collections.IList");
        wrappableClasses.add("System.Collections.Generic.IList__1");
        wrappableClasses.add("System.Collections.ICollection");
        wrappableClasses.add("System.Collections.Generic.ICollection__1");
        wrappableClasses.add("System.Collections.IEnumerable");
        wrappableClasses.add("System.Collections.Generic.IEnumerable__1");
        wrappableClasses.add("System.IComparable");
        wrappableClasses.add("System.IComparable__1");
        wrappableClasses.add("System.IEquatable__1");
        wrappableClasses.add("System.IFormattable");
        wrappableClasses.add("System.IConvertible");
        primitiveTypeNameMap = new Hashtable();
        primitiveTypeMap = new Hashtable();
        primitiveTypeNameMap.put("java.lang.Short", "System.BoxedShort");
        primitiveTypeNameMap.put("java.lang.Integer", "System.BoxedInt");
        primitiveTypeNameMap.put("java.lang.Long", "System.BoxedLong");
        primitiveTypeNameMap.put("java.lang.Float", "System.BoxedFloat");
        primitiveTypeNameMap.put("java.lang.Double", "System.BoxedDouble");
        primitiveTypeNameMap.put("java.lang.Byte", "System.BoxedSByte");
        primitiveTypeNameMap.put("java.lang.Character", "System.BoxedChar");
        primitiveTypeNameMap.put("java.lang.Boolean", "System.BoxedBoolean");
        primitiveTypeMap.put("short", Short.TYPE);
        primitiveTypeMap.put("int", Integer.TYPE);
        primitiveTypeMap.put("long", Long.TYPE);
        primitiveTypeMap.put("float", Float.TYPE);
        primitiveTypeMap.put("double", Double.TYPE);
        primitiveTypeMap.put("byte", Byte.TYPE);
        primitiveTypeMap.put("char", Character.TYPE);
        primitiveTypeMap.put("boolean", Boolean.TYPE);
        signatureMap = new Hashtable();
        extendedSignatureMap = new Hashtable();
        typeMap = new Hashtable();
        signatureMap.put("System.Int32", "java.lang.Integer");
        signatureMap.put("System.Int64", "java.lang.Long");
        signatureMap.put("System.Int16", "java.lang.Short");
        signatureMap.put("System.Single", "java.lang.Float");
        signatureMap.put("System.Double", "java.lang.Double");
        signatureMap.put("System.SByte", "java.lang.Byte");
        signatureMap.put("System.Char", "java.lang.Character");
        signatureMap.put("System.Boolean", "java.lang.Boolean");
        signatureMap.put("System.String", "java.lang.String");
        extendedSignatureMap.put("System.Int32", "I");
        extendedSignatureMap.put("System.Int64", "J");
        extendedSignatureMap.put("System.Int16", "S");
        extendedSignatureMap.put("System.Single", "F");
        extendedSignatureMap.put("System.Double", "D");
        extendedSignatureMap.put("System.SByte", "B");
        extendedSignatureMap.put("System.Char", "C");
        extendedSignatureMap.put("System.Boolean", "Z");
        extendedSignatureMap.put("System.String", "Ljava.lang.String;");
        typeMap.put("System.Int32", Integer.TYPE);
        typeMap.put("System.Int64", Long.TYPE);
        typeMap.put("System.Int16", Short.TYPE);
        typeMap.put("System.Single", Float.TYPE);
        typeMap.put("System.Double", Double.TYPE);
        typeMap.put("System.SByte", Byte.TYPE);
        typeMap.put("System.Char", Character.TYPE);
        typeMap.put("System.Boolean", Boolean.TYPE);
        typeMap.put("System.String", String.class);
    }
}

