/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore;

import com.jnbridge.jnbcore.ByValueConstants;
import com.jnbridge.jnbcore.DotNetArgTypeConverter;
import com.jnbridge.jnbcore.DotNetSideException;
import com.jnbridge.jnbcore.JavaProxyClass;
import com.jnbridge.jnbcore.JavaProxyClassLoader;
import com.jnbridge.jnbcore.MessageKeys;
import com.jnbridge.jnbcore.Messages;
import com.jnbridge.jnbproxy.DotNetClassInfo;
import com.jnbridge.jnbproxy.DotNetConstructorInfo;
import com.jnbridge.jnbproxy.DotNetFieldInfo;
import com.jnbridge.jnbproxy.DotNetMemberParseException;
import com.jnbridge.jnbproxy.DotNetMethodInfo;
import com.jnbridge.jnbproxy.DotNetPropertyInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;

public abstract class DotNetClassRegistry
implements ByValueConstants,
MessageKeys {
    private static ClassCache classCache = new ClassCache();
    private static HashSet presentClasses = new HashSet();
    private static HashSet alwaysPresent = new HashSet();
    public static boolean isRunningTiger;
    private static Class java9VersionClass;
    private static Method java9VersionParseMethod;
    private static Method java9VersionMajorMethod;
    private static Hashtable superclassChains;
    private static Hashtable substituteProxy;
    private static HashSet byValuePubFieldClasses;
    private static HashSet byValueJavaBeanClasses;
    private static HashSet byValueMappedCollection;

    private static boolean tigerTest() {
        int n;
        int n2;
        String string = System.getProperty("java.version");
        try {
            java9VersionClass = Class.forName("java.lang.Runtime$Version");
        }
        catch (ClassNotFoundException classNotFoundException) {
            java9VersionClass = null;
        }
        if (java9VersionClass != null) {
            try {
                java9VersionParseMethod = java9VersionClass.getMethod("parse", String.class);
                java9VersionMajorMethod = java9VersionClass.getMethod("major", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                java9VersionParseMethod = null;
                java9VersionMajorMethod = null;
            }
        }
        if (java9VersionParseMethod != null && java9VersionMajorMethod != null) {
            try {
                Object object = java9VersionParseMethod.invoke(null, string);
                Integer n3 = (Integer)java9VersionMajorMethod.invoke(object, new Object[0]);
                int n4 = n3;
                return n4 > 9;
            }
            catch (IllegalAccessException illegalAccessException) {
                return false;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            catch (InvocationTargetException invocationTargetException) {
                return false;
            }
        }
        if (string == null) {
            throw new TigerTestException(Messages.getString("DOTNETCLASSREGISTRY_TIGERTEST_1"));
        }
        int n5 = string.indexOf(46);
        if (n5 == -1) {
            throw new TigerTestException(Messages.getString("DOTNETCLASSREGISTRY_TIGERTEST_2"));
        }
        int n6 = string.indexOf(46, n5 + 1);
        if (n6 == -1) {
            throw new TigerTestException(Messages.getString("DOTNETCLASSREGISTRY_TIGERTEST_3"));
        }
        String string2 = string.substring(0, n5);
        if (string2 == null) {
            throw new TigerTestException(Messages.getString("DOTNETCLASSREGISTRY_TIGERTEST_4"));
        }
        String string3 = string.substring(n5 + 1, n6);
        if (string3 == null) {
            throw new TigerTestException(Messages.getString("DOTNETCLASSREGISTRY_TIGERTEST_5"));
        }
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TigerTestException(Messages.getString("DOTNETCLASSREGISTRY_TIGERTEST_6"));
        }
        try {
            n = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TigerTestException(Messages.getString("DOTNETCLASSREGISTRY_TIGERTEST_7"));
        }
        if (n2 > 1) {
            return true;
        }
        return n2 == 1 && n >= 5;
    }

    public static boolean isPresent(String string) {
        if (alwaysPresent.contains(string)) {
            return true;
        }
        return DotNetClassRegistry.getClass(string, false) != null || presentClasses.contains(string);
    }

    public static void setPresent(String string) {
        presentClasses.add(string);
    }

    public static synchronized Class getClass(String string) {
        return DotNetClassRegistry.getClass(string, true);
    }

    public static synchronized Class getClass(String string, boolean bl) {
        Class clazz;
        block10: {
            clazz = classCache.get(string = DotNetArgTypeConverter.convertNested(string));
            if (clazz == null) {
                try {
                    try {
                        clazz = Class.forName(string, false, Thread.currentThread().getContextClassLoader());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        clazz = Class.forName(string, false, DotNetClassRegistry.class.getClassLoader());
                    }
                    classCache.put(string, clazz);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    try {
                        clazz = Class.forName(string, false, JavaProxyClassLoader.instance());
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        if (bl) {
                            try {
                                clazz = DotNetClassRegistry.createClass(string);
                                classCache.put(string, clazz);
                            }
                            catch (ClassNotFoundException classNotFoundException3) {
                                clazz = null;
                            }
                            break block10;
                        }
                        clazz = null;
                    }
                }
            }
        }
        return clazz;
    }

    private static Class createClass(String string) throws ClassNotFoundException {
        DotNetFieldInfo[] dotNetFieldInfoArray;
        Object object;
        DotNetClassInfo dotNetClassInfo;
        try {
            dotNetClassInfo = new DotNetClassInfo(DotNetArgTypeConverter.convertToDotNet(string));
        }
        catch (DotNetMemberParseException dotNetMemberParseException) {
            throw new ClassNotFoundException(string);
        }
        String string2 = dotNetClassInfo.superclassName;
        if (string2 != null && !classCache.containsKey(DotNetArgTypeConverter.convertNested(string2))) {
            object = DotNetClassRegistry.createClass(string2);
            classCache.put(DotNetArgTypeConverter.convertNested(string2), object);
        }
        object = DotNetClassRegistry.filterClasses(dotNetClassInfo.interfaces);
        for (int i = 0; i < ((String[])object).length; ++i) {
            if (classCache.containsKey(DotNetArgTypeConverter.convertNested(object[i]))) continue;
            dotNetFieldInfoArray = DotNetClassRegistry.createClass(object[i]);
            classCache.put(DotNetArgTypeConverter.convertNested(object[i]), dotNetFieldInfoArray);
        }
        try {
            int n;
            JavaProxyClass javaProxyClass = dotNetClassInfo.isInterface ? new JavaProxyClass(DotNetArgTypeConverter.convertNested(dotNetClassInfo.className), DotNetArgTypeConverter.convertNested(dotNetClassInfo.interfaces), DotNetArgTypeConverter.convertNested(dotNetClassInfo.nestedClasses), DotNetArgTypeConverter.convertNestedInterfaces(dotNetClassInfo.nestedInterfaceFlags), isRunningTiger, false, true) : new JavaProxyClass(DotNetArgTypeConverter.convertNested(dotNetClassInfo.className), DotNetArgTypeConverter.convertNested(dotNetClassInfo.superclassName), DotNetArgTypeConverter.convertNested(dotNetClassInfo.interfaces), DotNetArgTypeConverter.convertNested(dotNetClassInfo.nestedClasses), DotNetArgTypeConverter.convertNestedInterfaces(dotNetClassInfo.nestedInterfaceFlags), dotNetClassInfo.isAbstract, false, isRunningTiger, false, dotNetClassInfo.isEnum, dotNetClassInfo.enumNames, true);
            dotNetFieldInfoArray = dotNetClassInfo.fields;
            for (int i = 0; i < dotNetFieldInfoArray.length; ++i) {
                if (!dotNetFieldInfoArray[i].isGeneratable()) continue;
                javaProxyClass.addField(dotNetFieldInfoArray[i].fieldName, dotNetFieldInfoArray[i].className, dotNetFieldInfoArray[i].modifiers, dotNetFieldInfoArray[i].fieldValue, 0);
            }
            DotNetMethodInfo[] dotNetMethodInfoArray = dotNetClassInfo.methods;
            for (int i = 0; i < dotNetMethodInfoArray.length; ++i) {
                if (!dotNetMethodInfoArray[i].isGeneratable()) continue;
                javaProxyClass.addMethod(dotNetMethodInfoArray[i].modifiers, dotNetMethodInfoArray[i].methodName, dotNetMethodInfoArray[i].paramClasses, dotNetMethodInfoArray[i].paramNames, dotNetMethodInfoArray[i].returnClass, false, dotNetMethodInfoArray[i].isPublic, dotNetMethodInfoArray[i].hasRefOrOutParams, dotNetMethodInfoArray[i].refOrOutParams);
                String[] stringArray = dotNetMethodInfoArray[i].bridgeTargets;
                if (stringArray == null) continue;
                for (n = 0; n < stringArray.length; ++n) {
                    if (dotNetMethodInfoArray[i].returnClass == stringArray[n]) continue;
                    javaProxyClass.addBridgeMethod(dotNetMethodInfoArray[i].methodName, dotNetMethodInfoArray[i].paramClasses, dotNetMethodInfoArray[i].paramNames, dotNetMethodInfoArray[i].returnClass, stringArray[n], false, dotNetMethodInfoArray[i].hasRefOrOutParams, dotNetMethodInfoArray[i].refOrOutParams);
                }
            }
            DotNetConstructorInfo[] dotNetConstructorInfoArray = dotNetClassInfo.constructors;
            for (int i = 0; i < dotNetConstructorInfoArray.length; ++i) {
                if (!dotNetConstructorInfoArray[i].isGeneratable()) continue;
                n = 0;
                for (int j = 0; j < dotNetConstructorInfoArray[i].paramClasses.length; ++j) {
                    if (classCache.containsKey(DotNetArgTypeConverter.convertNested(dotNetConstructorInfoArray[i].paramClasses[j]))) continue;
                    n = 1;
                }
                if (n != 0) continue;
                javaProxyClass.addConstructor(dotNetConstructorInfoArray[i].paramClasses, dotNetConstructorInfoArray[i].paramNames, false, dotNetConstructorInfoArray[i].isPublic);
            }
            DotNetPropertyInfo[] dotNetPropertyInfoArray = dotNetClassInfo.properties;
            for (n = 0; n < dotNetPropertyInfoArray.length; ++n) {
                if (!dotNetPropertyInfoArray[n].isGeneratable()) continue;
                javaProxyClass.addProperty(dotNetPropertyInfoArray[n].modifiers, dotNetPropertyInfoArray[n].propertyName, dotNetPropertyInfoArray[n].propertyType, dotNetPropertyInfoArray[n].hasGetMethod, dotNetPropertyInfoArray[n].hasSetMethod, dotNetPropertyInfoArray[n].indexerClasses, dotNetPropertyInfoArray[n].indexerNames, 0, false);
                String[] stringArray = dotNetPropertyInfoArray[n].bridgeTargets;
                if (stringArray == null) continue;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (dotNetPropertyInfoArray[n].propertyType == stringArray[i]) continue;
                    javaProxyClass.addBridgeMethod("get_" + dotNetPropertyInfoArray[n].propertyName, dotNetPropertyInfoArray[n].indexerClasses, dotNetPropertyInfoArray[n].indexerNames, dotNetPropertyInfoArray[n].propertyType, stringArray[i], false, false, null);
                }
            }
            ByteArrayOutputStream byteArrayOutputStream = javaProxyClass.bake();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            JavaProxyClassLoader javaProxyClassLoader = JavaProxyClassLoader.instance();
            Class clazz = javaProxyClassLoader.generateClass(DotNetArgTypeConverter.convertNested(string), byArray, 0, byArray.length);
            return clazz;
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException(string);
        }
    }

    static String[] filterClasses(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("com.jnbridge.jnbcore.DelegateMarker")) {
                if (arrayList.contains(stringArray[i])) continue;
                arrayList.add(stringArray[i]);
                continue;
            }
            if (stringArray[i].equals("com.jnbridge.jnbcore.EnumProxyMarker")) {
                if (arrayList.contains(stringArray[i])) continue;
                arrayList.add(stringArray[i]);
                continue;
            }
            if (stringArray[i].equals("com.jnbridge.jnbcore.ByValuePubFieldsMarker")) {
                if (arrayList.contains(stringArray[i])) continue;
                arrayList.add(stringArray[i]);
                continue;
            }
            if (stringArray[i].equals("com.jnbridge.jnbcore.ByValueJavaBeansMarker")) {
                if (arrayList.contains(stringArray[i])) continue;
                arrayList.add(stringArray[i]);
                continue;
            }
            if (stringArray[i].equals("com.jnbridge.jnbcore.ByValueMappedCollectionMarker")) {
                if (arrayList.contains(stringArray[i])) continue;
                arrayList.add(stringArray[i]);
                continue;
            }
            if (stringArray[i].equals("com.jnbridge.jnbcore.DotNetWrapper")) {
                if (arrayList.contains(stringArray[i])) continue;
                arrayList.add(stringArray[i]);
                continue;
            }
            if (!DotNetClassRegistry.isPresent(stringArray[i]) || arrayList.contains(stringArray[i])) continue;
            arrayList.add(stringArray[i]);
        }
        String[] stringArray2 = new String[arrayList.size()];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = (String)arrayList.get(i);
        }
        return stringArray2;
    }

    public static void setSuperclassChain(String string, String[] stringArray) {
        superclassChains.put(string, stringArray);
    }

    public static String getSubstituteProxy(String string, String string2) {
        if (DotNetClassRegistry.isPresent(string)) {
            return string;
        }
        String string3 = (String)substituteProxy.get(string);
        if (string3 != null) {
            return string3;
        }
        String[] stringArray = (String[])superclassChains.get(string2);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!DotNetClassRegistry.isPresent(stringArray[i])) continue;
            substituteProxy.put(string, stringArray[i]);
            return stringArray[i];
        }
        return "java.lang.Object";
    }

    public static void setByValueCode(String string, int n) {
        switch (n) {
            case 0: {
                return;
            }
            case 1: {
                byValuePubFieldClasses.add(string);
                return;
            }
            case 2: {
                byValueJavaBeanClasses.add(string);
                return;
            }
            case 3: {
                byValueMappedCollection.add(string);
                return;
            }
        }
        throw new DotNetSideException(Messages.getString("DOTNETCLASSREGISTRY_SETBYVALUECODE") + " " + n);
    }

    public static int getByValueCode(String string) {
        if (byValuePubFieldClasses.contains(string)) {
            return 1;
        }
        if (byValueJavaBeanClasses.contains(string)) {
            return 2;
        }
        if (byValueMappedCollection.contains(string)) {
            return 3;
        }
        return 0;
    }

    static {
        alwaysPresent.add("System.Object");
        alwaysPresent.add("System.DotNetString");
        alwaysPresent.add("System.DotNetArray");
        alwaysPresent.add("System.DotNetEnum");
        alwaysPresent.add("System.BoxedValue");
        alwaysPresent.add("System.BoxedInt");
        alwaysPresent.add("System.BoxedShort");
        alwaysPresent.add("System.BoxedLong");
        alwaysPresent.add("System.BoxedFloat");
        alwaysPresent.add("System.BoxedDouble");
        alwaysPresent.add("System.BoxedBoolean");
        alwaysPresent.add("System.BoxedSByte");
        alwaysPresent.add("System.BoxedChar");
        alwaysPresent.add("com.jnbridge.jnbcore.DotNetObjectBase");
        alwaysPresent.add("com.jnbridge.jnbcore.DotNetWrapper");
        isRunningTiger = DotNetClassRegistry.tigerTest();
        java9VersionClass = null;
        java9VersionParseMethod = null;
        java9VersionMajorMethod = null;
        superclassChains = new Hashtable();
        substituteProxy = new Hashtable();
        byValuePubFieldClasses = new HashSet();
        byValueJavaBeanClasses = new HashSet();
        byValueMappedCollection = new HashSet();
    }

    public static class TigerTestException
    extends RuntimeException {
        public TigerTestException(String string) {
            super(string);
        }
    }

    private static class ClassCache {
        private Hashtable classCache = new Hashtable();

        private ClassCache() {
        }

        private synchronized Hashtable getSubcache() {
            Hashtable hashtable;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            if ((hashtable = (Hashtable)this.classCache.get(classLoader)) == null) {
                hashtable = new Hashtable();
                try {
                    Class<?> clazz = Class.forName("System.Object", false, classLoader);
                    hashtable.put("System.Object", clazz);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                this.classCache.put(classLoader, hashtable);
            }
            return hashtable;
        }

        public final synchronized Class get(Object object) {
            Hashtable hashtable = this.getSubcache();
            Class<?> clazz = (Class<?>)hashtable.get(object);
            if (clazz != null) {
                return clazz;
            }
            try {
                clazz = Class.forName((String)object, false, Thread.currentThread().getContextClassLoader());
                hashtable.put(object, clazz);
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }

        public final synchronized void put(Object object, Object object2) {
            Hashtable hashtable = this.getSubcache();
            hashtable.put(object, object2);
        }

        public final synchronized boolean containsKey(Object object) {
            Hashtable hashtable = this.getSubcache();
            boolean bl = hashtable.containsKey(object);
            if (bl) {
                return true;
            }
            try {
                Class<?> clazz = Class.forName((String)object, false, Thread.currentThread().getContextClassLoader());
                hashtable.put(object, clazz);
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return false;
            }
        }
    }
}

