/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore;

import com.jnbridge.jnbcore.AsyncCallback;
import com.jnbridge.jnbcore.BoxedValueFactory;
import com.jnbridge.jnbcore.ByValueMarker;
import com.jnbridge.jnbcore.ClassHelper;
import com.jnbridge.jnbcore.DebugConstants;
import com.jnbridge.jnbcore.DelegateMarker;
import com.jnbridge.jnbcore.DotNetArgTypeConverter;
import com.jnbridge.jnbcore.DotNetCallbackRegistry;
import com.jnbridge.jnbcore.DotNetClassRegistry;
import com.jnbridge.jnbcore.DotNetObjectDisposedException;
import com.jnbridge.jnbcore.DotNetSide;
import com.jnbridge.jnbcore.DotNetSideException;
import com.jnbridge.jnbcore.DotNetWrapper;
import com.jnbridge.jnbcore.DotNetWrapperFactory;
import com.jnbridge.jnbcore.EnumProxyMarker;
import com.jnbridge.jnbcore.ExceptionFactory;
import com.jnbridge.jnbcore.IDotNetSideProxy;
import com.jnbridge.jnbcore.InternalConstructorMarker;
import com.jnbridge.jnbcore.JNBArrayWrapper;
import com.jnbridge.jnbcore.JNBDotNetCallback;
import com.jnbridge.jnbcore.JNBDotNetObjID;
import com.jnbridge.jnbcore.JNBDotNetValueObject;
import com.jnbridge.jnbcore.JNBException;
import com.jnbridge.jnbcore.JavaSideProperties;
import com.jnbridge.jnbcore.JavaSidePropertiesException;
import com.jnbridge.jnbcore.MessageKeys;
import com.jnbridge.jnbcore.Messages;
import com.jnbridge.jnbcore.NotImplementedException;
import com.jnbridge.jnbcore.NullValue;
import com.jnbridge.jnbcore.ObjectFactoryException;
import com.jnbridge.jnbcore.ThreadTrueMarker;
import com.jnbridge.jnbcore.java50.EnumInfo;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Hashtable;

public abstract class DotNetObjectBase
extends RuntimeException
implements MessageKeys,
DebugConstants {
    protected static IDotNetSideProxy dotNetSideProxy;
    protected IDotNetSideProxy myDotNetSideProxy;
    protected static Hashtable objMap;
    private static boolean determinedEvalLicense;
    static long cleanupDelay;
    private static CleanupThread cleanup;
    protected static final InternalConstructorMarker marker;
    protected long theObjID = -1L;
    protected Long wrappedObjID;
    protected String theClassName;
    public String dotNetExceptionStackTrace = null;
    private boolean disposed = false;
    private static HashSet dotNetArrayInterfaces;
    private static HashSet dotNetStringInterfaces;
    private static HashSet dotNetEnumInterfaces;
    private static Class boxedValueClass;
    private static Method unboxToJava;
    private static HashSet unsignedTypes;
    private static Hashtable unwrapConversionTable;
    private static Hashtable passThroughTable;
    private static Class[] paramClassArray;

    protected static synchronized WeakReference objMap_get(Long l) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Hashtable hashtable = (Hashtable)objMap.get(classLoader);
        if (hashtable == null) {
            return null;
        }
        return (WeakReference)hashtable.get(l);
    }

    protected static synchronized void objMap_put(long l, Object object) {
        DotNetObjectBase.objMap_put(new Long(l), object);
    }

    protected static synchronized void objMap_put(Long l, Object object) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Hashtable<Long, WeakReference<Object>> hashtable = (Hashtable<Long, WeakReference<Object>>)objMap.get(classLoader);
        if (hashtable == null) {
            hashtable = new Hashtable<Long, WeakReference<Object>>();
            objMap.put(classLoader, hashtable);
        }
        hashtable.put(l, new WeakReference<Object>(object));
    }

    protected static synchronized void objMap_remove(Long l) {
        Hashtable hashtable;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = DotNetObjectBase.class.getClassLoader();
        }
        if ((hashtable = (Hashtable)objMap.get(classLoader)) != null) {
            hashtable.remove(l);
        }
    }

    private static synchronized void objMap_cleanup() {
        Object[] objectArray = objMap.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            Hashtable hashtable = (Hashtable)objMap.get(objectArray[i]);
            Object[] objectArray2 = hashtable.keySet().toArray();
            for (int j = 0; j < objectArray2.length; ++j) {
                WeakReference weakReference = (WeakReference)hashtable.get(objectArray2[j]);
                if (weakReference == null) {
                    hashtable.remove(objectArray2[j]);
                    continue;
                }
                DotNetObjectBase dotNetObjectBase = (DotNetObjectBase)weakReference.get();
                if (dotNetObjectBase != null) continue;
                hashtable.remove(objectArray2[j]);
            }
        }
    }

    static synchronized void disposeAll() {
        Object[] objectArray = objMap.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            Hashtable hashtable = (Hashtable)objMap.get(objectArray[i]);
            Object[] objectArray2 = hashtable.keySet().toArray();
            for (int j = 0; j < objectArray2.length; ++j) {
                DotNetObjectBase dotNetObjectBase;
                WeakReference weakReference = (WeakReference)hashtable.get(objectArray2[j]);
                if (weakReference == null || (dotNetObjectBase = (DotNetObjectBase)weakReference.get()) == null) continue;
                dotNetObjectBase.dotNetDispose();
            }
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof DotNetObjectBase)) {
            return false;
        }
        String[] stringArray = new String[]{"System.Object"};
        Object[] objectArray = DotNetObjectBase.convertArgsFromJava(stringArray, new Object[]{object});
        try {
            boolean bl = this.myDotNetSideProxy.booleanVirtualCall(this.theObjID, "Equals", stringArray, objectArray);
            return bl;
        }
        catch (Throwable throwable) {
            if (!(throwable instanceof JNBException)) {
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw (RuntimeException)throwable;
            }
            JNBException jNBException = (JNBException)throwable;
            ExceptionFactory.throwException(jNBException, objMap);
            return false;
        }
    }

    public int hashCode() {
        String[] stringArray = new String[]{};
        Object[] objectArray = new Object[]{};
        try {
            int n = this.myDotNetSideProxy.intVirtualCall(this.theObjID, "GetHashCode", stringArray, objectArray);
            return n;
        }
        catch (Throwable throwable) {
            if (!(throwable instanceof JNBException)) {
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw (RuntimeException)throwable;
            }
            JNBException jNBException = (JNBException)throwable;
            ExceptionFactory.throwException(jNBException, objMap);
            return 0;
        }
    }

    protected void checkReference() {
        if (this.theObjID == -1L) {
            throw new NotImplementedException();
        }
    }

    protected DotNetObjectBase(InternalConstructorMarker internalConstructorMarker, String string) {
        this.setCurrentDotNetSideProxy();
        this.checkEvalLicense();
    }

    protected DotNetObjectBase(InternalConstructorMarker internalConstructorMarker, String string, long l) {
        this.register(string, l);
        this.setCurrentDotNetSideProxy();
        this.checkEvalLicense();
    }

    private void checkEvalLicense() {
        if (!determinedEvalLicense) {
            try {
                Class.forName("com.jnbridge.jnbcore.EvalLicenseIndicator");
                System.out.println("NOTE:  This copy of JNBridgePro is for evaluation purposes only.   JNBridgePro proxy components targeted for licensed runtime environments must be generated using a permanent JNBridgePro Developer license.   For more information on licensing, please see: http://www.jnbridge.com/licensing.htm");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            determinedEvalLicense = true;
        }
    }

    private void setCurrentDotNetSideProxy() {
        this.myDotNetSideProxy = DotNetSide.getCurrentDotNetSideProxy();
    }

    protected static IDotNetSideProxy getCurrentDotNetSideProxy() {
        return DotNetSide.getCurrentDotNetSideProxy();
    }

    public IDotNetSideProxy getMyDotNetSideProxy() {
        return this.myDotNetSideProxy;
    }

    protected static void setMyDotNetSideProxy(Object object, IDotNetSideProxy iDotNetSideProxy) {
        if (object != null && object instanceof DotNetObjectBase) {
            DotNetObjectBase dotNetObjectBase = (DotNetObjectBase)object;
            dotNetObjectBase.myDotNetSideProxy = iDotNetSideProxy;
        }
    }

    protected void register(String string, long l) {
        this.theObjID = l;
        this.wrappedObjID = new Long(this.theObjID);
        DotNetObjectBase.objMap_put(l, (Object)this);
        this.theClassName = string;
    }

    protected void register(JNBDotNetObjID jNBDotNetObjID) {
        this.register(jNBDotNetObjID.getClassName(), jNBDotNetObjID.getObjID());
    }

    protected final void checkDisposed() {
        if (this.disposed) {
            throw new DotNetObjectDisposedException();
        }
    }

    protected boolean isDisposed() {
        return this.disposed;
    }

    public void dotNetDispose() {
        if (!this.disposed) {
            if (this.theObjID == -1L) {
                return;
            }
            try {
                this.myDotNetSideProxy.release(this.theObjID);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            DotNetObjectBase.objMap_remove(this.wrappedObjID);
            this.disposed = true;
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.disposed) {
                this.dotNetDispose();
            }
        }
        finally {
            super.finalize();
        }
    }

    public static Object convertObjToJava(Object object, String string) {
        return DotNetObjectBase.convertObjToJava(object, string, null);
    }

    public static Object convertObjToJava(Object object, String string, IDotNetSideProxy iDotNetSideProxy) {
        Class clazz = DotNetClassRegistry.getClass(DotNetArgTypeConverter.convertNested(string));
        Object object2 = DotNetObjectBase.convertObjToJava(object, clazz, iDotNetSideProxy);
        return object2;
    }

    public static Object convertObjToJava(Object object, Class clazz) {
        return DotNetObjectBase.convertObjToJava(object, clazz, null);
    }

    public static Object convertObjToJava(Object object, Class clazz, IDotNetSideProxy iDotNetSideProxy) {
        if (object == null) {
            return object;
        }
        if (object instanceof JNBDotNetObjID) {
            JNBDotNetObjID jNBDotNetObjID = (JNBDotNetObjID)object;
            long l = jNBDotNetObjID.getObjID();
            String string = jNBDotNetObjID.getClassName();
            Class clazz2 = DotNetClassRegistry.getClass(DotNetArgTypeConverter.convertNested(string));
            if (ByValueMarker.class.isAssignableFrom(clazz) || EnumProxyMarker.class.isAssignableFrom(clazz) || clazz2 != null && ByValueMarker.class.isAssignableFrom(clazz2) || clazz2 != null && EnumProxyMarker.class.isAssignableFrom(clazz2)) {
                try {
                    IDotNetSideProxy iDotNetSideProxy2 = iDotNetSideProxy != null ? iDotNetSideProxy : DotNetObjectBase.getCurrentDotNetSideProxy();
                    return DotNetObjectBase.convertObjToJava(iDotNetSideProxy2.getValue(jNBDotNetObjID.getObjID(), false), clazz, iDotNetSideProxy);
                }
                catch (Throwable throwable) {
                    throw new DotNetSideException(Messages.getString("DOTNETOBJECTBASE_CONVERTOBJTOJAVA"), throwable);
                }
            }
            WeakReference weakReference = DotNetObjectBase.objMap_get(new Long(l));
            DotNetObjectBase dotNetObjectBase = null;
            if (weakReference == null) {
                dotNetObjectBase = DotNetObjectBase.createInstance(DotNetArgTypeConverter.convertNested(string), l);
                if (iDotNetSideProxy != null) {
                    DotNetObjectBase.setMyDotNetSideProxy(dotNetObjectBase, iDotNetSideProxy);
                }
            } else {
                dotNetObjectBase = (DotNetObjectBase)weakReference.get();
                if (dotNetObjectBase == null) {
                    dotNetObjectBase = DotNetObjectBase.createInstance(DotNetArgTypeConverter.convertNested(string), l);
                    if (iDotNetSideProxy != null) {
                        DotNetObjectBase.setMyDotNetSideProxy(dotNetObjectBase, iDotNetSideProxy);
                    }
                }
            }
            return dotNetObjectBase;
        }
        if (object instanceof JNBDotNetValueObject) {
            return ((JNBDotNetValueObject)object).getObject();
        }
        if (clazz.isPrimitive() || clazz == String.class) {
            return object;
        }
        if (object instanceof String && (DotNetObjectBase.class.isAssignableFrom(clazz) || dotNetStringInterfaces.contains(clazz.getName()))) {
            return DotNetWrapperFactory.makeDotNetString((String)object);
        }
        if (EnumInfo.isEnum(object.getClass()) && (DotNetObjectBase.class.isAssignableFrom(clazz) || dotNetEnumInterfaces.contains(clazz.getName()))) {
            return DotNetWrapperFactory.makeDotNetEnum(object);
        }
        if (clazz.isArray() || object.getClass().isArray() || object instanceof JNBArrayWrapper) {
            Class<?> clazz3;
            Class<?> clazz4 = clazz.getComponentType();
            if (object instanceof JNBArrayWrapper) {
                JNBArrayWrapper jNBArrayWrapper = (JNBArrayWrapper)object;
                object = jNBArrayWrapper.getArray();
                clazz3 = jNBArrayWrapper.getArrayTypeStr();
                Class clazz5 = DotNetClassRegistry.getClass((String)((Object)(clazz3 = DotNetArgTypeConverter.convertToJavaType((String)((Object)clazz3)))));
                if (!DotNetObjectBase.usesMappedType(clazz5)) {
                    clazz4 = clazz5.getComponentType();
                }
            }
            int n = Array.getLength(object);
            if (clazz4 != null && clazz4.isPrimitive()) {
                clazz3 = object.getClass().getComponentType();
                if ((clazz3 == Byte.class || clazz3 == Byte.TYPE) && clazz4 == Short.TYPE) {
                    return DotNetObjectBase.convertByteArrayToShortArray((byte[])object);
                }
                if (clazz4 == Character.TYPE && clazz3 == Integer.TYPE) {
                    return DotNetObjectBase.convertIntArrayToCharArray((int[])object);
                }
                return object;
            }
            if (clazz4 == null) {
                clazz4 = object.getClass().getComponentType();
                clazz3 = clazz4.getName();
                int n2 = ((String)((Object)clazz3)).indexOf("java.lang.Object");
                int n3 = ((String)((Object)clazz3)).indexOf("com.jnbridge.jnbcore.JNBDotNetObjID");
                int n4 = ((String)((Object)clazz3)).indexOf("com.jnbridge.jnbcore.JNBDotNetValueObject");
                if (n2 == 0 || n3 == 0 || n4 == 0) {
                    clazz3 = "System.Object";
                } else if (n2 > 0) {
                    clazz3 = ((String)((Object)clazz3)).substring(0, n2) + "System.Object;";
                } else if (n3 > 0) {
                    clazz3 = ((String)((Object)clazz3)).substring(0, n2) + "System.Object;";
                } else if (n4 > 0) {
                    clazz3 = ((String)((Object)clazz3)).substring(0, n2) + "System.Object;";
                }
                if (n2 != -1 || n3 != -1 || n4 != -1) {
                    try {
                        clazz4 = ClassHelper.forName((String)((Object)clazz3));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        clazz4 = object.getClass().getComponentType();
                    }
                }
            }
            if (clazz4.getName().equals("System.Object")) {
                clazz3 = null;
                for (int i = 0; i < n; ++i) {
                    Class clazz6;
                    Object object2;
                    Object object3 = Array.get(object, i);
                    if (object3 == null) continue;
                    if (object3 instanceof JNBDotNetObjID) {
                        object2 = (JNBDotNetObjID)object3;
                        clazz6 = DotNetClassRegistry.getClass(DotNetArgTypeConverter.convertNested(((JNBDotNetObjID)object2).getClassName()));
                    } else if (object3 instanceof JNBDotNetValueObject) {
                        object2 = (JNBDotNetValueObject)object3;
                        clazz6 = DotNetClassRegistry.getClass(DotNetArgTypeConverter.convertNested(((JNBDotNetValueObject)object2).getObject().getClass().getName()));
                    } else {
                        clazz6 = DotNetClassRegistry.getClass("System.Object");
                    }
                    clazz3 = clazz3 == null ? clazz6 : DotNetObjectBase.getLeastUpperBound(clazz3, clazz6);
                }
                if (clazz3 != null) {
                    clazz4 = clazz3;
                }
            }
            clazz3 = Array.newInstance(clazz4, n);
            for (int i = 0; i < n; ++i) {
                Object object4 = Array.get(object, i);
                Object object5 = DotNetObjectBase.convertObjToJava(object4, clazz4, iDotNetSideProxy);
                if (object5 != null && !clazz4.isPrimitive() && !clazz4.isInstance(object5)) {
                    object5 = BoxedValueFactory.box(object5);
                }
                Array.set(clazz3, i, object5);
            }
            if (DotNetObjectBase.class.isAssignableFrom(clazz) || dotNetArrayInterfaces.contains(clazz.getName())) {
                return DotNetWrapperFactory.makeDotNetArray(clazz3);
            }
            return clazz3;
        }
        if (DotNetObjectBase.isWrappedPrimitive(object) && !clazz.isInstance(object)) {
            return BoxedValueFactory.box(object);
        }
        return object;
    }

    private static boolean usesMappedType(Class clazz) {
        if (clazz == null) {
            return false;
        }
        if (clazz == String.class || EnumInfo.isEnum(clazz)) {
            return true;
        }
        return DotNetObjectBase.usesMappedType(clazz.getComponentType());
    }

    private static Class getLeastUpperBound(Class clazz, Class clazz2) {
        for (Class clazz3 = clazz; clazz3 != null; clazz3 = clazz3.getSuperclass()) {
            if (!clazz3.isAssignableFrom(clazz2)) continue;
            return clazz3;
        }
        return DotNetClassRegistry.getClass("System.Object");
    }

    private static short[] convertByteArrayToShortArray(byte[] byArray) {
        int n = byArray.length;
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = (short)(byArray[i] & 0xFF);
        }
        return sArray;
    }

    private static char[] convertIntArrayToCharArray(int[] nArray) {
        int n = nArray.length;
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)nArray[i];
        }
        return cArray;
    }

    protected static Object[] convertArgsFromJava(String[] stringArray, Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray2[i] = DotNetObjectBase.convertArgFromJava(stringArray[i], objectArray[i]);
        }
        return objectArray2;
    }

    private static String removeRef(String string) {
        if (!string.endsWith("&")) {
            return string;
        }
        return string.substring(0, string.length() - 1);
    }

    public static Object convertArgFromJava(String string, Object object) {
        if (object == null) {
            return object;
        }
        if (object instanceof NullValue) {
            throw new IllegalArgumentException("Improper use of NullValue object.  Please use null instead");
        }
        if (DotNetObjectBase.isWrappedPrimitiveOrString(object)) {
            return object;
        }
        if (object instanceof DotNetWrapper) {
            Object object2 = ((DotNetWrapper)object).getWrappedValue();
            if (object2.getClass().isArray()) {
                return DotNetObjectBase.convertArgFromJava(DotNetObjectBase.removeRef(string), object2);
            }
            throw new DotNetSideException(Messages.getString("DOTNETOBJECTBASE_CONVERTARGFROMJAVA"));
        }
        if (object instanceof EnumProxyMarker) {
            return object;
        }
        if (object instanceof DelegateMarker) {
            long l = DotNetCallbackRegistry.getInstance().registerCallback(object);
            boolean bl = !(object instanceof AsyncCallback);
            return new JNBDotNetCallback(bl, l, object);
        }
        if (object.getClass().isArray()) {
            Class<Object> clazz = object.getClass().getComponentType();
            if (clazz.isPrimitive() || clazz == String.class) {
                return object;
            }
            if (boxedValueClass.isAssignableFrom(clazz)) {
                return DotNetObjectBase.unwrapArray(object);
            }
            int n = Array.getLength(object);
            clazz = Object.class;
            string = DotNetObjectBase.removeRef(string);
            String string2 = DotNetObjectBase.getElementSignature(string);
            Object object3 = Array.newInstance(clazz, n);
            for (int i = 0; i < n; ++i) {
                Object object4 = DotNetObjectBase.convertArgFromJava(string2, Array.get(object, i));
                Array.set(object3, i, object4);
            }
            JNBArrayWrapper jNBArrayWrapper = null;
            jNBArrayWrapper = DotNetObjectBase.isUnsignedArray(string) ? new JNBArrayWrapper(string, object3) : new JNBArrayWrapper(object.getClass(), object3);
            return jNBArrayWrapper;
        }
        if (DotNetObjectBase.isByValue(object)) {
            return new JNBDotNetValueObject(object);
        }
        if (BoxedValueFactory.isBoxedValue(object)) {
            if (BoxedValueFactory.isSpecialBoxedValue(object)) {
                return object;
            }
            return BoxedValueFactory.unbox(object);
        }
        DotNetObjectBase dotNetObjectBase = (DotNetObjectBase)object;
        return new JNBDotNetObjID(dotNetObjectBase.theObjID, dotNetObjectBase.theClassName);
    }

    private static boolean isUnsignedArray(String string) {
        int n = string.indexOf("[");
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(0, n);
        if (string2.startsWith("L") && string2.endsWith(";")) {
            string2 = string2.substring(1, string2.length() - 1);
        }
        return unsignedTypes.contains(string2);
    }

    private static String getElementSignature(String string) {
        if (string.endsWith("[]")) {
            return string.substring(0, string.length() - 2);
        }
        return "System.Object";
    }

    private static boolean isByValue(Object object) {
        return object instanceof ByValueMarker;
    }

    public static boolean isByValueClass(Class clazz) {
        return ByValueMarker.class.isAssignableFrom(clazz);
    }

    public static boolean isThreadTrue(String string) {
        Class clazz = DotNetClassRegistry.getClass(string);
        return ThreadTrueMarker.class.isAssignableFrom(clazz);
    }

    public static boolean isThreadTrue(Long l) {
        WeakReference weakReference = DotNetObjectBase.objMap_get(l);
        if (weakReference == null) {
            return false;
        }
        Object t = weakReference.get();
        if (t == null) {
            return false;
        }
        return t instanceof ThreadTrueMarker;
    }

    public static String classNameForID(Long l) {
        WeakReference weakReference = DotNetObjectBase.objMap_get(l);
        if (weakReference == null) {
            return "";
        }
        Object t = weakReference.get();
        if (t == null) {
            return "";
        }
        return t.getClass().getName();
    }

    private static Object unwrapArray(Object object) {
        try {
            Class<?> clazz = object.getClass().getComponentType();
            String string = clazz.getName();
            Class clazz2 = (Class)unwrapConversionTable.get(string);
            int n = Array.getLength(object);
            Object object2 = Array.newInstance(clazz2, n);
            for (int i = 0; i < n; ++i) {
                Object object3 = Array.get(object, i);
                Object object4 = object3 == null ? null : unboxToJava.invoke(object3, new Object[0]);
                Array.set(object2, i, object4);
            }
            return object2;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    private static Class convertElementType(Class clazz) {
        Class<?> clazz2 = clazz;
        int n = 0;
        while (clazz2.isArray()) {
            ++n;
            clazz2 = clazz2.getComponentType();
        }
        if (clazz2.isPrimitive() || clazz2 == String.class) {
            return clazz;
        }
        if (n == 0) {
            return Object.class;
        }
        String string = "Ljava.lang.Object;";
        for (int i = 0; i < n; ++i) {
            string = "[" + string;
        }
        try {
            return ClassHelper.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DotNetSideException(Messages.getString("DOTNETOBJECTBASE_CONVERTELEMENTTYPE"), classNotFoundException);
        }
    }

    private static boolean isWrappedPrimitiveOrString(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof DotNetWrapper) {
            Object object2 = ((DotNetWrapper)object).getWrappedValue();
            return object2 instanceof String || EnumInfo.isEnum(object2.getClass());
        }
        return passThroughTable.get(object.getClass()) != null;
    }

    private static boolean isWrappedPrimitive(Object object) {
        if (object == null) {
            return false;
        }
        if (passThroughTable.get(object.getClass()) == null) {
            return false;
        }
        return !String.class.isInstance(object);
    }

    static DotNetObjectBase createInstance(String string, long l) {
        try {
            string = DotNetArgTypeConverter.convertNested(string);
            Class clazz = DotNetClassRegistry.getClass(string);
            if (clazz.isInterface()) {
                return null;
            }
            Constructor constructor = clazz.getDeclaredConstructor(paramClassArray);
            constructor.setAccessible(true);
            DotNetObjectBase dotNetObjectBase = (DotNetObjectBase)constructor.newInstance(marker, string, new Long(l));
            return dotNetObjectBase;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ObjectFactoryException("java.lang.NoSuchMethodException", noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ObjectFactoryException("java.lang.reflect.InvocationTargetException", invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ObjectFactoryException("java.lang.IllegalAccessException", illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new ObjectFactoryException("java.lang.InstantiationException " + string, instantiationException);
        }
    }

    static {
        objMap = new Hashtable();
        determinedEvalLicense = false;
        try {
            if (JavaSideProperties.isPropsFileSet()) {
                JavaSideProperties javaSideProperties = JavaSideProperties.getInstance();
                String string = javaSideProperties.getProperty("javaSide.cleanupDelay");
                if (string == null) {
                    string = System.getProperty("javaSide.cleanupDelay", "0");
                }
                try {
                    cleanupDelay = Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {
                    cleanupDelay = 0L;
                }
            } else {
                String string = System.getProperty("javaSide.cleanupDelay", "0");
                try {
                    cleanupDelay = Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {
                    cleanupDelay = 0L;
                }
            }
        }
        catch (JavaSidePropertiesException javaSidePropertiesException) {
            String string = System.getProperty("javaSide.cleanupDelay", "0");
            try {
                cleanupDelay = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                cleanupDelay = 0L;
            }
        }
        cleanup = new CleanupThread(cleanupDelay);
        if (cleanupDelay != 0L) {
            cleanup.start();
        }
        marker = InternalConstructorMarker.getInstance();
        dotNetSideProxy = DotNetSide.getProxy("default");
        DotNetSide.addDefaultServer(dotNetSideProxy);
        dotNetArrayInterfaces = new HashSet();
        dotNetStringInterfaces = new HashSet();
        dotNetEnumInterfaces = new HashSet();
        dotNetStringInterfaces.add("System.IComparable");
        dotNetStringInterfaces.add("System.IComparable__1");
        dotNetStringInterfaces.add("System.ICloneable");
        dotNetStringInterfaces.add("System.IConvertible");
        dotNetStringInterfaces.add("System.Collections.IEnumerable");
        dotNetStringInterfaces.add("System.Collections.Generic.IEnumerable__1");
        dotNetStringInterfaces.add("System.IEquatable__1");
        dotNetEnumInterfaces.add("System.IComparable");
        dotNetEnumInterfaces.add("System.IFormattable");
        dotNetEnumInterfaces.add("System.IConvertible");
        dotNetArrayInterfaces.add("System.Collections.Generic.IList__1");
        dotNetArrayInterfaces.add("System.Collections.IList");
        dotNetArrayInterfaces.add("System.Collections.Generic.ICollection__1");
        dotNetArrayInterfaces.add("System.Collections.ICollection");
        dotNetArrayInterfaces.add("System.Collections.Generic.IEnumerable__1");
        dotNetArrayInterfaces.add("System.Collections.IEnumerable");
        dotNetArrayInterfaces.add("System.ICloneable");
        try {
            boxedValueClass = ClassHelper.forName("System.BoxedValue");
            unboxToJava = boxedValueClass.getMethod("unboxToJava", new Class[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            boxedValueClass = null;
            unboxToJava = null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            unboxToJava = null;
        }
        unsignedTypes = new HashSet();
        unsignedTypes.add("System.Byte");
        unsignedTypes.add("System.UInt8");
        unsignedTypes.add("System.UInt16");
        unsignedTypes.add("System.UInt32");
        unsignedTypes.add("System.UInt64");
        unwrapConversionTable = new Hashtable();
        unwrapConversionTable.put("System.BoxedBoolean", Boolean.TYPE);
        unwrapConversionTable.put("System.BoxedChar", Character.TYPE);
        unwrapConversionTable.put("System.BoxedDouble", Double.TYPE);
        unwrapConversionTable.put("System.BoxedFloat", Float.TYPE);
        unwrapConversionTable.put("System.BoxedInt", Integer.TYPE);
        unwrapConversionTable.put("System.BoxedLong", Long.TYPE);
        unwrapConversionTable.put("System.BoxedSByte", Byte.TYPE);
        unwrapConversionTable.put("System.BoxedShort", Short.TYPE);
        unwrapConversionTable.put("System.BoxedUInt", Long.TYPE);
        unwrapConversionTable.put("System.BoxedUShort", Integer.TYPE);
        unwrapConversionTable.put("System.BoxedULong", Float.TYPE);
        unwrapConversionTable.put("System.BoxedByte", Short.TYPE);
        passThroughTable = new Hashtable();
        passThroughTable.put(Integer.class, new Boolean(true));
        passThroughTable.put(Short.class, new Boolean(true));
        passThroughTable.put(Long.class, new Boolean(true));
        passThroughTable.put(Float.class, new Boolean(true));
        passThroughTable.put(Double.class, new Boolean(true));
        passThroughTable.put(Byte.class, new Boolean(true));
        passThroughTable.put(Character.class, new Boolean(true));
        passThroughTable.put(Boolean.class, new Boolean(true));
        passThroughTable.put(String.class, new Boolean(true));
        paramClassArray = new Class[]{InternalConstructorMarker.class, String.class, Long.TYPE};
    }

    private static class CleanupThread
    extends Thread {
        private long delay;

        public CleanupThread(long l) {
            super("cleanup");
            this.delay = l;
            this.setDaemon(true);
            this.setPriority(10);
        }

        public void run() {
            try {
                while (true) {
                    CleanupThread.sleep(this.delay);
                    DotNetObjectBase.objMap_cleanup();
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }
}

