/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore;

import com.jnbridge.jnbcore.DotNetObjectBase;
import com.jnbridge.jnbcore.DotNetSideException;
import com.jnbridge.jnbcore.DotNetSideProxy;
import com.jnbridge.jnbcore.IDotNetSideProxy;
import com.jnbridge.jnbcore.JavaSideProperties;
import com.jnbridge.jnbcore.JavaSidePropertiesException;
import com.jnbridge.jnbcore.MessageKeys;
import com.jnbridge.jnbcore.Messages;
import com.jnbridge.jnbcore.PropertiesConstants;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;

public class DotNetSide
implements PropertiesConstants,
MessageKeys {
    private static String m_host;
    private static int m_port;
    private static String m_serverType;
    private static IDotNetSideProxy dotNetSideProxy;
    private static IDotNetSideProxy currentGlobalDotNetSideProxy;
    private static Hashtable threadProxyMap;
    private static boolean checkThreadProxyMap;
    private static boolean initWasCalled;
    private static Hashtable serverTable;
    private static boolean serverIsSet;
    private static Object threadProxyMapLock;

    private DotNetSide() {
    }

    public static void init(String string) throws DotNetSideException {
        try {
            JavaSideProperties.setPropsFile(string);
            initWasCalled = true;
            DotNetSide.init_common();
        }
        catch (JavaSidePropertiesException javaSidePropertiesException) {
            throw new DotNetSideException(Messages.getString("DOTNETSIDE_INIT") + " " + javaSidePropertiesException.getMessage());
        }
    }

    public static void init(Properties properties) throws DotNetSideException {
        try {
            JavaSideProperties.setPropsObject(properties);
            initWasCalled = true;
            DotNetSide.init_common();
        }
        catch (JavaSidePropertiesException javaSidePropertiesException) {
            throw new DotNetSideException(Messages.getString("DOTNETSIDE_INIT") + " " + javaSidePropertiesException.getMessage());
        }
    }

    private static void init_common() throws JavaSidePropertiesException {
        JavaSideProperties javaSideProperties = JavaSideProperties.getInstance();
        m_host = javaSideProperties.getProperty("dotNetSide.host");
        m_serverType = javaSideProperties.getProperty("dotNetSide.serverType");
        if (m_serverType != null && !m_serverType.toLowerCase().equals("sharedmem")) {
            try {
                m_port = Integer.parseInt(javaSideProperties.getProperty("dotNetSide.port"));
            }
            catch (NumberFormatException numberFormatException) {
                throw new JavaSidePropertiesException(Messages.getString("DOTNETSIDE_INIT_COMMON_1"));
            }
            DotNetSide.addDefaultServer(DotNetSide.getProxy("default"));
        } else if (m_serverType == null) {
            throw new JavaSidePropertiesException(Messages.getString("DOTNETSIDE_INIT_COMMON_2"));
        }
    }

    public static void disposeAll() {
        DotNetObjectBase.disposeAll();
    }

    static IDotNetSideProxy getProxy(String string) throws DotNetSideException {
        if (!initWasCalled) {
            throw new DotNetSideException(Messages.getString("DOTNETSIDE_GETPROXY_1"));
        }
        return new DotNetSideProxy(m_serverType, m_host, m_port, string);
    }

    static IDotNetSideProxy getProxy(String string, String string2, String string3, String string4) {
        int n = Integer.parseInt(string3);
        return new DotNetSideProxy(string, string2, n, string4);
    }

    static void addDefaultServer(IDotNetSideProxy iDotNetSideProxy) {
        serverTable.put("default", iDotNetSideProxy);
        if (!serverIsSet) {
            currentGlobalDotNetSideProxy = iDotNetSideProxy;
            serverIsSet = true;
        }
    }

    private static Properties getProperties(String string) {
        try {
            Properties properties = new Properties();
            File file = null;
            if (string == null) {
                throw new DotNetSideException(Messages.getString("DOTNETSIDE_GETPROPERTIES_1"));
            }
            file = new File(string);
            file = file.getCanonicalFile();
            if (!file.exists()) {
                throw new DotNetSideException(Messages.getString("DOTNETSIDE_GETPROPERTIES_2") + " " + string);
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            properties.load(bufferedInputStream);
            ((InputStream)bufferedInputStream).close();
            return properties;
        }
        catch (IOException iOException) {
            throw new DotNetSideException(Messages.getString("DOTNETSIDE_GETPROPERTIES_3") + " " + string, iOException);
        }
    }

    public static void addServer(String string, String string2) {
        Properties properties = DotNetSide.getProperties(string2);
        DotNetSide.addServer(string, properties);
    }

    public static void addServer(String string, Properties properties) {
        if (serverTable.containsKey(string)) {
            throw new DotNetSideException(Messages.getString("DOTNETSIDE_ADDSERVER_1") + " " + string);
        }
        if ("default".equals(string)) {
            throw new DotNetSideException(Messages.getString("DOTNETSIDE_ADDSERVER_2"));
        }
        IDotNetSideProxy iDotNetSideProxy = DotNetSide.getProxy(properties.getProperty("dotNetSide.serverType"), properties.getProperty("dotNetSide.host"), properties.getProperty("dotNetSide.port"), string);
        serverTable.put(string, iDotNetSideProxy);
    }

    public static void setServer(String string) {
        DotNetSide.setServer(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setServer(String string, boolean bl) {
        IDotNetSideProxy iDotNetSideProxy = (IDotNetSideProxy)serverTable.get(string);
        if (iDotNetSideProxy == null) {
            throw new DotNetSideException(Messages.getString("DOTNETSIDE_SETSERVER") + " " + string);
        }
        if (bl) {
            Object object = threadProxyMapLock;
            synchronized (object) {
                checkThreadProxyMap = false;
                threadProxyMap.clear();
            }
            currentGlobalDotNetSideProxy = iDotNetSideProxy;
        } else {
            Object object = threadProxyMapLock;
            synchronized (object) {
                threadProxyMap.put(Thread.currentThread(), iDotNetSideProxy);
                checkThreadProxyMap = true;
            }
        }
        serverIsSet = true;
    }

    public static void resetDefaultServer() {
        DotNetSide.resetDefaultServer(true);
    }

    public static void resetDefaultServer(boolean bl) {
        DotNetSide.setServer("default", bl);
    }

    public static String currentServer() {
        return DotNetSide.getCurrentDotNetSideProxy().getName();
    }

    public static String boundServer(Object object) {
        if (object != null && object instanceof DotNetObjectBase) {
            DotNetObjectBase dotNetObjectBase = (DotNetObjectBase)object;
            return dotNetObjectBase.myDotNetSideProxy.getName();
        }
        throw new DotNetSideException(Messages.getString("DOTNETSIDE_BOUNDSERVER"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IDotNetSideProxy getCurrentDotNetSideProxy() {
        IDotNetSideProxy iDotNetSideProxy;
        Object object = threadProxyMapLock;
        synchronized (object) {
            if (checkThreadProxyMap) {
                iDotNetSideProxy = (IDotNetSideProxy)threadProxyMap.get(Thread.currentThread());
                if (iDotNetSideProxy == null) {
                    iDotNetSideProxy = currentGlobalDotNetSideProxy;
                }
            } else {
                iDotNetSideProxy = currentGlobalDotNetSideProxy;
            }
        }
        return iDotNetSideProxy;
    }

    public static boolean isAlive() {
        return DotNetSide.isAlive("default");
    }

    public static boolean isAlive(String string) {
        IDotNetSideProxy iDotNetSideProxy = (IDotNetSideProxy)serverTable.get(string);
        if (iDotNetSideProxy == null) {
            throw new DotNetSideException(Messages.getString("DOTNETSIDE_ISALIVE") + " " + string);
        }
        try {
            iDotNetSideProxy.poll();
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    static {
        threadProxyMap = new Hashtable();
        checkThreadProxyMap = false;
        initWasCalled = false;
        serverTable = new Hashtable();
        serverIsSet = false;
        threadProxyMapLock = new Object();
    }
}

