/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore;

import com.jnbridge.jnbcore.DotNetSideException;
import com.jnbridge.jnbcore.IDotNetSideProxy;
import com.jnbridge.jnbcore.JNBDispatchMap;
import com.jnbridge.jnbcore.JNBDotNetObjID;
import com.jnbridge.jnbcore.MessageKeys;
import com.jnbridge.jnbcore.Messages;
import com.jnbridge.jnbcore.TargetReporter;
import com.jnbridge.jnbcore.clientTransports.AbstractClientTransport;
import com.jnbridge.jnbcore.clientTransports.ClientTransportException;
import com.jnbridge.jnbcore.clientTransports.HttpClientTransport;
import com.jnbridge.jnbcore.clientTransports.SharedMemClientTransport;
import com.jnbridge.jnbcore.clientTransports.TcpClientTransport;
import com.jnbridge.jnbcore.formatters.Formatter;
import com.jnbridge.jnbcore.formatters.binary.BinaryFormatter;
import com.jnbridge.jnbcore.formatters.soap.SOAPFormatter;
import com.jnbridge.jnbcore.server.sharedmem.SharedMemRequestHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.Hashtable;

public class DotNetSideProxy
implements IDotNetSideProxy,
MessageKeys {
    private Formatter formatter = null;
    private boolean isBinaryServer = false;
    private boolean isHttpServer = false;
    private boolean isSharedMem = false;
    String host = null;
    int port = 0;
    String name = null;
    private boolean calledIs11 = false;
    private boolean is11;

    public String getName() {
        return this.name;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public DotNetSideProxy(String string, String string2, int n, String string3) throws DotNetSideException {
        this.host = string2;
        this.port = n;
        this.name = string3;
        try {
            if (SharedMemRequestHandler.dotNetIsMaster && SharedMemRequestHandler.javaEntry != null) {
                this.formatter = new BinaryFormatter();
                this.isSharedMem = true;
                return;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        if (string == null) {
            throw new DotNetSideException(Messages.getString("DOTNETSIDEPROXY_CONSTRUCTOR_2"));
        }
        if (string.equals("http")) {
            this.formatter = new SOAPFormatter();
            this.isHttpServer = true;
        } else if (string.equals("tcp")) {
            this.formatter = new BinaryFormatter();
            this.isBinaryServer = true;
        } else if (string.toLowerCase().equals("sharedmem")) {
            this.formatter = new BinaryFormatter();
            this.isSharedMem = true;
        } else {
            throw new DotNetSideException(Messages.getString("DOTNETSIDEPROXY_CONSTRUCTOR"));
        }
    }

    public void poll() throws Throwable {
        CallInfo callInfo = new CallInfo("poll");
        this.call(callInfo);
    }

    public void close() {
    }

    public void synchronizedCall(long l, String string, String[] stringArray, Object[] objectArray) {
    }

    public JNBDotNetObjID construct(String string, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("construct", string, stringArray, (Object)objectArray);
        return (JNBDotNetObjID)this.call(callInfo);
    }

    public void release(long l) throws Throwable {
        CallInfo callInfo = new CallInfo("release", l);
        this.call(callInfo);
    }

    public Object getValue(long l, boolean bl) throws Throwable {
        CallInfo callInfo = new CallInfo("getValue", l, bl);
        return this.call(callInfo);
    }

    public Object[] getValueArray(long[] lArray, boolean bl) throws Throwable {
        CallInfo callInfo = new CallInfo("getValueArray", lArray, bl);
        return (Object[])this.call(callInfo);
    }

    public void voidStaticCall(String string, String string2, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("voidStaticCall", string, string2, stringArray, (Object)objectArray);
        this.call(callInfo);
    }

    public int intStaticCall(String string, String string2, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("intStaticCall", string, string2, stringArray, (Object)objectArray);
        Integer n = this.intCall(callInfo);
        return n;
    }

    public short shortStaticCall(String string, String string2, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("shortStaticCall", string, string2, stringArray, (Object)objectArray);
        Short s = this.shortCall(callInfo);
        return s;
    }

    public long longStaticCall(String string, String string2, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("longStaticCall", string, string2, stringArray, (Object)objectArray);
        Long l = this.longCall(callInfo);
        return l;
    }

    public float floatStaticCall(String string, String string2, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("floatStaticCall", string, string2, stringArray, (Object)objectArray);
        Float f = this.floatCall(callInfo);
        return f.floatValue();
    }

    public double doubleStaticCall(String string, String string2, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("doubleStaticCall", string, string2, stringArray, (Object)objectArray);
        Double d = this.doubleCall(callInfo);
        return d;
    }

    public char charStaticCall(String string, String string2, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("charStaticCall", string, string2, stringArray, (Object)objectArray);
        Character c = this.charCall(callInfo);
        return c.charValue();
    }

    public byte byteStaticCall(String string, String string2, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("byteStaticCall", string, string2, stringArray, (Object)objectArray);
        Byte by = this.byteCall(callInfo);
        return by;
    }

    public boolean booleanStaticCall(String string, String string2, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("booleanStaticCall", string, string2, stringArray, (Object)objectArray);
        Boolean bl = this.boolCall(callInfo);
        return bl;
    }

    public Object objectStaticCall(String string, String string2, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("objectStaticCall", string, string2, stringArray, (Object)objectArray);
        return this.call(callInfo);
    }

    public Hashtable refOutStaticCall(String string, String string2, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("refOutStaticCall", string, string2, stringArray, (Object)objectArray);
        return (Hashtable)this.call(callInfo);
    }

    public void voidVirtualCall(long l, String string, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("voidVirtualCall", l, string, stringArray, (Object)objectArray);
        this.call(callInfo);
    }

    public int intVirtualCall(long l, String string, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("intVirtualCall", l, string, stringArray, (Object)objectArray);
        Integer n = this.intCall(callInfo);
        return n;
    }

    public short shortVirtualCall(long l, String string, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("shortVirtualCall", l, string, stringArray, (Object)objectArray);
        Short s = this.shortCall(callInfo);
        return s;
    }

    public long longVirtualCall(long l, String string, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("longVirtualCall", l, string, stringArray, (Object)objectArray);
        Long l2 = this.longCall(callInfo);
        return l2;
    }

    public float floatVirtualCall(long l, String string, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("floatVirtualCall", l, string, stringArray, (Object)objectArray);
        Float f = this.floatCall(callInfo);
        return f.floatValue();
    }

    public double doubleVirtualCall(long l, String string, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("doubleVirtualCall", l, string, stringArray, (Object)objectArray);
        Double d = this.doubleCall(callInfo);
        return d;
    }

    public char charVirtualCall(long l, String string, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("charVirtualCall", l, string, stringArray, (Object)objectArray);
        Character c = this.charCall(callInfo);
        return c.charValue();
    }

    public byte byteVirtualCall(long l, String string, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("byteVirtualCall", l, string, stringArray, (Object)objectArray);
        Byte by = this.byteCall(callInfo);
        return by;
    }

    public boolean booleanVirtualCall(long l, String string, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("booleanVirtualCall", l, string, stringArray, (Object)objectArray);
        Boolean bl = this.boolCall(callInfo);
        return bl;
    }

    public Object objectVirtualCall(long l, String string, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("objectVirtualCall", l, string, stringArray, (Object)objectArray);
        return this.call(callInfo);
    }

    public Hashtable refOutVirtualCall(long l, String string, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("refOutVirtualCall", l, string, stringArray, (Object)objectArray);
        return (Hashtable)this.call(callInfo);
    }

    public int getIntInstanceField(long l, String string) throws Throwable {
        CallInfo callInfo = new CallInfo("getIntInstanceField", l, string);
        Integer n = this.intCall(callInfo);
        return n;
    }

    public short getShortInstanceField(long l, String string) throws Throwable {
        CallInfo callInfo = new CallInfo("getShortInstanceField", l, string);
        Short s = this.shortCall(callInfo);
        return s;
    }

    public long getLongInstanceField(long l, String string) throws Throwable {
        CallInfo callInfo = new CallInfo("getLongInstanceField", l, string);
        Long l2 = this.longCall(callInfo);
        return l2;
    }

    public float getFloatInstanceField(long l, String string) throws Throwable {
        CallInfo callInfo = new CallInfo("getFloatInstanceField", l, string);
        Float f = this.floatCall(callInfo);
        return f.floatValue();
    }

    public double getDoubleInstanceField(long l, String string) throws Throwable {
        CallInfo callInfo = new CallInfo("getDoubleInstanceField", l, string);
        Double d = this.doubleCall(callInfo);
        return d;
    }

    public char getCharInstanceField(long l, String string) throws Throwable {
        CallInfo callInfo = new CallInfo("getCharInstanceField", l, string);
        Character c = this.charCall(callInfo);
        return c.charValue();
    }

    public byte getByteInstanceField(long l, String string) throws Throwable {
        CallInfo callInfo = new CallInfo("getByteInstanceField", l, string);
        Byte by = this.byteCall(callInfo);
        return by;
    }

    public boolean getBooleanInstanceField(long l, String string) throws Throwable {
        CallInfo callInfo = new CallInfo("getBooleanInstanceField", l, string);
        Boolean bl = this.boolCall(callInfo);
        return bl;
    }

    public Object getObjectInstanceField(long l, String string, String string2) throws Throwable {
        CallInfo callInfo = new CallInfo("getObjectInstanceField", l, string, string2);
        return this.call(callInfo);
    }

    public void setIntInstanceField(long l, String string, String string2, int n) throws Throwable {
        CallInfo callInfo = new CallInfo("setIntInstanceField", l, string, string2, (Object)new Integer(n));
        this.call(callInfo);
    }

    public void setShortInstanceField(long l, String string, String string2, short s) throws Throwable {
        CallInfo callInfo = new CallInfo("setShortInstanceField", l, string, string2, (Object)new Short(s));
        this.call(callInfo);
    }

    public void setLongInstanceField(long l, String string, String string2, long l2) throws Throwable {
        CallInfo callInfo = new CallInfo("setLongInstanceField", l, string, string2, (Object)new Long(l2));
        this.call(callInfo);
    }

    public void setFloatInstanceField(long l, String string, String string2, float f) throws Throwable {
        CallInfo callInfo = new CallInfo("setFloatInstanceField", l, string, string2, (Object)new Float(f));
        this.call(callInfo);
    }

    public void setDoubleInstanceField(long l, String string, String string2, double d) throws Throwable {
        CallInfo callInfo = new CallInfo("setDoubleInstanceField", l, string, string2, (Object)new Double(d));
        this.call(callInfo);
    }

    public void setCharInstanceField(long l, String string, String string2, char c) throws Throwable {
        CallInfo callInfo = new CallInfo("setCharInstanceField", l, string, string2, (Object)new Character(c));
        this.call(callInfo);
    }

    public void setByteInstanceField(long l, String string, String string2, byte by) throws Throwable {
        CallInfo callInfo = new CallInfo("setByteInstanceField", l, string, string2, (Object)new Byte(by));
        this.call(callInfo);
    }

    public void setBooleanInstanceField(long l, String string, String string2, boolean bl) throws Throwable {
        CallInfo callInfo = new CallInfo("setBooleanInstanceField", l, string, string2, (Object)new Boolean(bl));
        this.call(callInfo);
    }

    public void setObjectInstanceField(long l, String string, String string2, Object object) throws Throwable {
        CallInfo callInfo = new CallInfo("setObjectInstanceField", l, string, string2, object);
        this.call(callInfo);
    }

    public int getIntStaticField(String string, String string2, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("getIntStaticField", string, string2, objectArray);
        Integer n = this.intCall(callInfo);
        return n;
    }

    public short getShortStaticField(String string, String string2, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("getShortStaticField", string, string2, objectArray);
        Short s = this.shortCall(callInfo);
        return s;
    }

    public long getLongStaticField(String string, String string2, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("getLongStaticField", string, string2, objectArray);
        Long l = this.longCall(callInfo);
        return l;
    }

    public float getFloatStaticField(String string, String string2, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("getFloatStaticField", string, string2, objectArray);
        Float f = this.floatCall(callInfo);
        return f.floatValue();
    }

    public double getDoubleStaticField(String string, String string2, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("getDoubleStaticField", string, string2, objectArray);
        Double d = this.doubleCall(callInfo);
        return d;
    }

    public char getCharStaticField(String string, String string2, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("getCharStaticField", string, string2, objectArray);
        Character c = this.charCall(callInfo);
        return c.charValue();
    }

    public byte getByteStaticField(String string, String string2, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("getByteStaticField", string, string2, objectArray);
        Byte by = this.byteCall(callInfo);
        return by;
    }

    public boolean getBooleanStaticField(String string, String string2, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("getBooleanStaticField", string, string2, objectArray);
        Boolean bl = this.boolCall(callInfo);
        return bl;
    }

    public Object getObjectStaticField(String string, String string2, Object[] objectArray, String string3) throws Throwable {
        CallInfo callInfo = new CallInfo("getObjectStaticField", string, string2, objectArray, string3);
        return this.call(callInfo);
    }

    public void setIntStaticField(String string, String string2, String string3, int n, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("setIntStaticField", string, string2, string3, new Integer(n), objectArray);
        this.call(callInfo);
    }

    public void setShortStaticField(String string, String string2, String string3, short s, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("setShortStaticField", string, string2, string3, new Short(s), objectArray);
        this.call(callInfo);
    }

    public void setLongStaticField(String string, String string2, String string3, long l, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("setLongStaticField", string, string2, string3, new Long(l), objectArray);
        this.call(callInfo);
    }

    public void setFloatStaticField(String string, String string2, String string3, float f, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("setFloatStaticField", string, string2, string3, new Float(f), objectArray);
        this.call(callInfo);
    }

    public void setDoubleStaticField(String string, String string2, String string3, double d, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("setDoubleStaticField", string, string2, string3, new Double(d), objectArray);
        this.call(callInfo);
    }

    public void setCharStaticField(String string, String string2, String string3, char c, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("setCharStaticField", string, string2, string3, new Character(c), objectArray);
        this.call(callInfo);
    }

    public void setByteStaticField(String string, String string2, String string3, byte by, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("setByteStaticField", string, string2, string3, new Byte(by), objectArray);
        this.call(callInfo);
    }

    public void setBooleanStaticField(String string, String string2, String string3, boolean bl, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("setBooleanStaticField", string, string2, string3, new Boolean(bl), objectArray);
        this.call(callInfo);
    }

    public void setObjectStaticField(String string, String string2, String string3, Object object, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("setObjectStaticField", string, string2, string3, object, objectArray);
        this.call(callInfo);
    }

    public int getIntInstanceProperty(long l, String string, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("getIntInstanceProperty", true, l, string, stringArray, objectArray);
        Integer n = this.intCall(callInfo);
        return n;
    }

    public short getShortInstanceProperty(long l, String string, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("getShortInstanceProperty", true, l, string, stringArray, objectArray);
        Short s = this.shortCall(callInfo);
        return s;
    }

    public long getLongInstanceProperty(long l, String string, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("getLongInstanceProperty", true, l, string, stringArray, objectArray);
        Long l2 = this.longCall(callInfo);
        return l2;
    }

    public float getFloatInstanceProperty(long l, String string, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("getFloatInstanceProperty", true, l, string, stringArray, objectArray);
        Float f = this.floatCall(callInfo);
        return f.floatValue();
    }

    public double getDoubleInstanceProperty(long l, String string, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("getDoubleInstanceProperty", true, l, string, stringArray, objectArray);
        Double d = this.doubleCall(callInfo);
        return d;
    }

    public char getCharInstanceProperty(long l, String string, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("getCharInstanceProperty", true, l, string, stringArray, objectArray);
        Character c = this.charCall(callInfo);
        return c.charValue();
    }

    public byte getByteInstanceProperty(long l, String string, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("getByteInstanceProperty", true, l, string, stringArray, objectArray);
        Byte by = this.byteCall(callInfo);
        return by;
    }

    public boolean getBooleanInstanceProperty(long l, String string, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("getBooleanInstanceProperty", true, l, string, stringArray, objectArray);
        Boolean bl = this.boolCall(callInfo);
        return bl;
    }

    public Object getObjectInstanceProperty(long l, String string, String string2, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("getObjectInstanceProperty", true, l, string, string2, stringArray, objectArray);
        return this.call(callInfo);
    }

    public void setIntInstanceProperty(long l, String string, String string2, int n, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("setIntInstanceProperty", l, string, string2, (Object)new Integer(n), stringArray, objectArray);
        this.call(callInfo);
    }

    public void setShortInstanceProperty(long l, String string, String string2, short s, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("setShortInstanceProperty", l, string, string2, (Object)new Short(s), stringArray, objectArray);
        this.call(callInfo);
    }

    public void setLongInstanceProperty(long l, String string, String string2, long l2, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("setLongInstanceProperty", l, string, string2, (Object)new Long(l2), stringArray, objectArray);
        this.call(callInfo);
    }

    public void setFloatInstanceProperty(long l, String string, String string2, float f, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("setFloatInstanceProperty", l, string, string2, (Object)new Float(f), stringArray, objectArray);
        this.call(callInfo);
    }

    public void setDoubleInstanceProperty(long l, String string, String string2, double d, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("setDoubleInstanceProperty", l, string, string2, (Object)new Double(d), stringArray, objectArray);
        this.call(callInfo);
    }

    public void setCharInstanceProperty(long l, String string, String string2, char c, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("setCharInstanceProperty", l, string, string2, (Object)new Character(c), stringArray, objectArray);
        this.call(callInfo);
    }

    public void setByteInstanceProperty(long l, String string, String string2, byte by, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("setByteInstanceProperty", l, string, string2, (Object)new Byte(by), stringArray, objectArray);
        this.call(callInfo);
    }

    public void setBooleanInstanceProperty(long l, String string, String string2, boolean bl, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("setBooleanInstanceProperty", l, string, string2, (Object)new Boolean(bl), stringArray, objectArray);
        this.call(callInfo);
    }

    public void setObjectInstanceProperty(long l, String string, String string2, Object object, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("setObjectInstanceProperty", l, string, string2, object, stringArray, objectArray);
        this.call(callInfo);
    }

    public int getIntStaticProperty(String string, String string2, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("getIntStaticProperty", true, string, string2, stringArray, objectArray);
        Integer n = this.intCall(callInfo);
        return n;
    }

    public short getShortStaticProperty(String string, String string2, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("getShortStaticProperty", true, string, string2, stringArray, objectArray);
        Short s = this.shortCall(callInfo);
        return s;
    }

    public long getLongStaticProperty(String string, String string2, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("getLongStaticProperty", true, string, string2, stringArray, objectArray);
        Long l = this.longCall(callInfo);
        return l;
    }

    public float getFloatStaticProperty(String string, String string2, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("getFloatStaticProperty", true, string, string2, stringArray, objectArray);
        Float f = this.floatCall(callInfo);
        return f.floatValue();
    }

    public double getDoubleStaticProperty(String string, String string2, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("getDoubleStaticProperty", true, string, string2, stringArray, objectArray);
        Double d = this.doubleCall(callInfo);
        return d;
    }

    public char getCharStaticProperty(String string, String string2, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("getCharStaticProperty", true, string, string2, stringArray, objectArray);
        Character c = this.charCall(callInfo);
        return c.charValue();
    }

    public byte getByteStaticProperty(String string, String string2, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("getByteStaticProperty", true, string, string2, stringArray, objectArray);
        Byte by = this.byteCall(callInfo);
        return by;
    }

    public boolean getBooleanStaticProperty(String string, String string2, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("getBooleanStaticProperty", true, string, string2, stringArray, objectArray);
        Boolean bl = this.boolCall(callInfo);
        return bl;
    }

    public Object getObjectStaticProperty(String string, String string2, String string3, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("getObjectStaticProperty", string, string2, string3, stringArray, objectArray);
        return this.call(callInfo);
    }

    public void setIntStaticProperty(String string, String string2, String string3, int n, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("setIntStaticProperty", string, string2, string3, (Object)new Integer(n), stringArray, objectArray);
        this.call(callInfo);
    }

    public void setShortStaticProperty(String string, String string2, String string3, short s, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("setShortStaticProperty", string, string2, string3, (Object)new Short(s), stringArray, objectArray);
        this.call(callInfo);
    }

    public void setLongStaticProperty(String string, String string2, String string3, long l, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("setLongStaticProperty", string, string2, string3, (Object)new Long(l), stringArray, objectArray);
        this.call(callInfo);
    }

    public void setFloatStaticProperty(String string, String string2, String string3, float f, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("setFloatStaticProperty", string, string2, string3, (Object)new Float(f), stringArray, objectArray);
        this.call(callInfo);
    }

    public void setDoubleStaticProperty(String string, String string2, String string3, double d, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("setDoubleStaticProperty", string, string2, string3, (Object)new Double(d), stringArray, objectArray);
        this.call(callInfo);
    }

    public void setCharStaticProperty(String string, String string2, String string3, char c, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("setCharStaticProperty", string, string2, string3, (Object)new Character(c), stringArray, objectArray);
        this.call(callInfo);
    }

    public void setByteStaticProperty(String string, String string2, String string3, byte by, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("setByteStaticProperty", string, string2, string3, (Object)new Byte(by), stringArray, objectArray);
        this.call(callInfo);
    }

    public void setBooleanStaticProperty(String string, String string2, String string3, boolean bl, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("setBooleanStaticProperty", string, string2, string3, (Object)new Boolean(bl), stringArray, objectArray);
        this.call(callInfo);
    }

    public void setObjectStaticProperty(String string, String string2, String string3, Object object, String[] stringArray, Object[] objectArray) throws Throwable {
        CallInfo callInfo = new CallInfo("setObjectStaticProperty", string, string2, string3, object, stringArray, objectArray);
        this.call(callInfo);
    }

    public void addStaticEvent(String string, String string2, String string3, Object object) throws Throwable {
        CallInfo callInfo = new CallInfo("addStaticEvent", string, string2, string3, object);
        this.call(callInfo);
    }

    public void addInstanceEvent(long l, String string, String string2, Object object) throws Throwable {
        CallInfo callInfo = new CallInfo("addInstanceEvent", l, string, string2, object);
        this.call(callInfo);
    }

    public void removeStaticEvent(String string, String string2, String string3, Object object) throws Throwable {
        CallInfo callInfo = new CallInfo("removeStaticEvent", string, string2, string3, object);
        this.call(callInfo);
    }

    public void removeInstanceEvent(long l, String string, String string2, Object object) throws Throwable {
        CallInfo callInfo = new CallInfo("removeInstanceEvent", l, string, string2, object);
        this.call(callInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object call(CallInfo callInfo) throws Throwable {
        AbstractClientTransport abstractClientTransport;
        if (this.isHttpServer) {
            abstractClientTransport = new HttpClientTransport();
        } else if (this.isBinaryServer) {
            abstractClientTransport = new TcpClientTransport();
            if (!this.calledIs11) {
                this.calledIs11 = true;
                this.is11 = TargetReporter.is1_1();
            }
            if (this.is11) {
                abstractClientTransport.dontCompress();
            }
        } else if (this.isSharedMem) {
            abstractClientTransport = new SharedMemClientTransport();
        } else {
            throw new DotNetSideException(Messages.getString("DOTNETSIDEPROXY_CALL_1"));
        }
        try {
            if (!this.isSharedMem) {
                abstractClientTransport.open(this.host, this.port);
            }
        }
        catch (ClientTransportException clientTransportException) {
            throw new DotNetSideException(Messages.getString("DOTNETSIDEPROXY_CALL_2"), clientTransportException);
        }
        try {
            ByteArrayInputStream byteArrayInputStream;
            Object object;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.formatter.serializeCall(byteArrayOutputStream, callInfo);
            abstractClientTransport.sendRequest(byteArrayOutputStream, callInfo.getMethodName());
            if (abstractClientTransport.isSocketBased()) {
                Thread.currentThread();
                Thread.yield();
            }
            if ((object = this.formatter.deserializeResponse(byteArrayInputStream = abstractClientTransport.getResponse())) instanceof Throwable) {
                throw (Throwable)object;
            }
            Object object2 = object;
            return object2;
        }
        finally {
            if (!this.isSharedMem) {
                abstractClientTransport.close();
            }
        }
    }

    private Integer intCall(CallInfo callInfo) throws Throwable {
        Object object = this.call(callInfo);
        Integer n = object instanceof String ? new Integer((String)object) : (Integer)object;
        return n;
    }

    private Short shortCall(CallInfo callInfo) throws Throwable {
        Object object = this.call(callInfo);
        Short s = object instanceof String ? new Short((String)object) : (Short)object;
        return s;
    }

    private Long longCall(CallInfo callInfo) throws Throwable {
        Object object = this.call(callInfo);
        Long l = object instanceof String ? new Long((String)object) : (Long)object;
        return l;
    }

    private Float floatCall(CallInfo callInfo) throws Throwable {
        Object object = this.call(callInfo);
        Float f = object instanceof String ? new Float((String)object) : (Float)object;
        return f;
    }

    private Double doubleCall(CallInfo callInfo) throws Throwable {
        Object object = this.call(callInfo);
        Double d = object instanceof String ? new Double((String)object) : (Double)object;
        return d;
    }

    private Character charCall(CallInfo callInfo) throws Throwable {
        Character c;
        Object object = this.call(callInfo);
        if (object instanceof String) {
            try {
                int n = Integer.parseInt((String)object);
                char c2 = (char)n;
                c = new Character(c2);
            }
            catch (NumberFormatException numberFormatException) {
                c = new Character(((String)object).charAt(0));
            }
        } else if (object instanceof Short) {
            short s = (Short)object;
            c = new Character((char)s);
        } else if (object instanceof Integer) {
            int n = (Integer)object;
            c = new Character((char)n);
        } else {
            c = (Character)object;
        }
        return c;
    }

    private Byte byteCall(CallInfo callInfo) throws Throwable {
        Object object = this.call(callInfo);
        Byte by = object instanceof String ? new Byte((String)object) : (Byte)object;
        return by;
    }

    private Boolean boolCall(CallInfo callInfo) throws Throwable {
        Object object = this.call(callInfo);
        Boolean bl = object instanceof String ? new Boolean((String)object) : (Boolean)object;
        return bl;
    }

    private static class CallInfo
    extends HashMap {
        private String methodName = null;

        public String toString() {
            String string = "";
            Object[] objectArray = this.keySet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                string = string + "callInfo[" + objectArray[i] + "] = " + this.get(objectArray[i]) + "\n";
            }
            return string;
        }

        public String getMethodName() {
            return this.methodName;
        }

        private CallInfo(String string) {
            this.methodName = string;
            this.put("targetMethodName", string);
            this.put("targetMethodID", JNBDispatchMap.getMethodIDasInteger(string));
            this.put("targetObjectID", JNBDispatchMap.getTargetID("/JNBDotNetDispatcher"));
            this.put("isThreadTrue", new Boolean(false));
        }

        public CallInfo(String string, String string2, String[] stringArray, Object object) {
            this(string);
            this.put("className", string2);
            this.put("signature", stringArray);
            this.put("args", object);
        }

        public CallInfo(String string, long l) {
            this(string);
            this.put("objID", new Long(l));
        }

        public CallInfo(String string, long l, boolean bl) {
            this(string);
            this.put("objID", new Long(l));
            this.put("isJavaBean", new Boolean(bl));
        }

        public CallInfo(String string, long[] lArray, boolean bl) {
            this(string);
            this.put("objIDs", lArray);
            this.put("isJavaBean", new Boolean(bl));
        }

        public CallInfo(String string, String string2, String string3, String[] stringArray, Object object) {
            this(string);
            this.put("className", string2);
            this.put("methodName", string3);
            this.put("signature", stringArray);
            this.put("args", object);
        }

        public CallInfo(String string, long l, String string2, String[] stringArray, Object object) {
            this(string);
            this.put("objID", new Long(l));
            this.put("methodName", string2);
            this.put("signature", stringArray);
            this.put("args", object);
        }

        public CallInfo(String string, long l, String string2) {
            this(string);
            this.put("objID", new Long(l));
            this.put("fieldName", string2);
        }

        public CallInfo(String string, long l, String string2, String string3) {
            this(string);
            this.put("objID", new Long(l));
            this.put("fieldName", string2);
            this.put("signature", string3);
        }

        public CallInfo(String string, long l, String string2, String string3, Object object) {
            this(string);
            this.put("objID", new Long(l));
            this.put("fieldName", string2);
            this.put("signature", string3);
            this.put("val", object);
        }

        public CallInfo(String string, String string2, String string3, Object[] objectArray) {
            this(string);
            this.put("className", string2);
            this.put("fieldName", string3);
            this.put("genericParams", objectArray);
        }

        public CallInfo(String string, String string2, String string3, Object[] objectArray, String string4) {
            this(string);
            this.put("className", string2);
            this.put("fieldName", string3);
            this.put("signature", string4);
            this.put("genericParams", objectArray);
        }

        public CallInfo(String string, String string2, String string3, String string4, Object object) {
            this(string);
            this.put("className", string2);
            this.put("fieldName", string3);
            this.put("signature", string4);
            this.put("val", object);
        }

        public CallInfo(String string, String string2, String string3, String string4, Object object, Object[] objectArray) {
            this(string);
            this.put("className", string2);
            this.put("fieldName", string3);
            this.put("signature", string4);
            this.put("val", object);
            this.put("genericParams", objectArray);
        }

        public CallInfo(String string, boolean bl, long l, String string2, String[] stringArray, Object[] objectArray) {
            this(string);
            this.put("objID", new Long(l));
            this.put("propertyName", string2);
            this.put("signature", stringArray);
            this.put("indexes", objectArray);
        }

        public CallInfo(String string, boolean bl, long l, String string2, String string3, String[] stringArray, Object[] objectArray) {
            this(string);
            this.put("objID", new Long(l));
            this.put("propertyName", string2);
            this.put("signature", string3);
            this.put("indexSignature", stringArray);
            this.put("indexes", objectArray);
        }

        public CallInfo(String string, long l, String string2, String string3, Object object, String[] stringArray, Object[] objectArray) {
            this(string);
            this.put("objID", new Long(l));
            this.put("propertyName", string2);
            this.put("signature", string3);
            this.put("val", object);
            this.put("indexSignature", stringArray);
            this.put("indexes", objectArray);
        }

        public CallInfo(String string, boolean bl, String string2, String string3, String[] stringArray, Object[] objectArray) {
            this(string);
            this.put("className", string2);
            this.put("propertyName", string3);
            this.put("signature", stringArray);
            this.put("indexes", objectArray);
        }

        public CallInfo(String string, String string2, String string3, String string4, String[] stringArray, Object[] objectArray) {
            this(string);
            this.put("className", string2);
            this.put("propertyName", string3);
            this.put("signature", string4);
            this.put("indexSignature", stringArray);
            this.put("indexes", objectArray);
        }

        public CallInfo(String string, String string2, String string3, String string4, Object object, String[] stringArray, Object[] objectArray) {
            this(string);
            this.put("className", string2);
            this.put("propertyName", string3);
            this.put("signature", string4);
            this.put("val", object);
            this.put("indexSignature", stringArray);
            this.put("indexes", objectArray);
        }
    }
}

