/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore;

import com.jnbridge.jnbcore.ClassHelper;
import com.jnbridge.jnbcore.DotNetSideException;
import com.jnbridge.jnbcore.MessageKeys;
import com.jnbridge.jnbcore.Messages;
import com.jnbridge.jnbcore.java50.EnumInfo;
import java.lang.reflect.Constructor;

public abstract class DotNetWrapperFactory
implements MessageKeys {
    private static Class[] stringParam = new Class[]{String.class};
    private static Class[] objectParam = new Class[]{Object.class};
    private static Class[] enumParam = new Class[]{EnumInfo.getEnumClass()};

    public static Object makeDotNetString(String string) {
        try {
            Class clazz = ClassHelper.forName("System.DotNetString");
            Constructor constructor = clazz.getConstructor(stringParam);
            Object t = constructor.newInstance(string);
            return t;
        }
        catch (Exception exception) {
            throw new DotNetSideException(Messages.getString("DOTNETWRAPPERFACTORY_MAKEDOTNETSTRING"), exception);
        }
    }

    public static Object makeDotNetArray(Object object) {
        try {
            Class clazz = ClassHelper.forName("System.DotNetArray");
            Constructor constructor = clazz.getConstructor(objectParam);
            Object t = constructor.newInstance(object);
            return t;
        }
        catch (Exception exception) {
            throw new DotNetSideException(Messages.getString("DOTNETWRAPPERFACTORY_MAKEDOTNETARRAY"), exception);
        }
    }

    public static Object makeDotNetEnum(Object object) {
        try {
            Class clazz = ClassHelper.forName("System.DotNetEnum");
            Constructor constructor = clazz.getConstructor(enumParam);
            Object t = constructor.newInstance(object);
            return t;
        }
        catch (Exception exception) {
            throw new DotNetSideException(Messages.getString("DOTNETWRAPPERFACTORY_MAKEDOTNETENUM"), exception);
        }
    }
}

