/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore;

import com.jnbridge.jnbcore.CallArgs;
import com.jnbridge.jnbcore.ClassRegistry;
import com.jnbridge.jnbcore.DebugConstants;
import com.jnbridge.jnbcore.InternalException;
import com.jnbridge.jnbcore.JNBDispatcherConstants;
import com.jnbridge.jnbcore.JNBValueObject;
import com.jnbridge.jnbcore.JNBVoidResult;
import com.jnbridge.jnbcore.Logging;
import com.jnbridge.jnbcore.MessageKeys;
import com.jnbridge.jnbcore.Messages;
import com.jnbridge.jnbcore.ObjectRegistry;
import com.jnbridge.jnbcore.ThreadTrueInvoker;
import com.jnbridge.jnbcore.formatters.binary.BinaryArgConverter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class JNBDispatcher
implements JNBDispatcherConstants,
DebugConstants,
MessageKeys {
    private static JNBDispatcher instance = new JNBDispatcher();
    private static boolean isLoggingOn = Logging.isLoggingOn();
    private ThreadTrueInvoker threadTrueInvoker = ThreadTrueInvoker.instance();
    private static Method m_isDefault = null;
    private static final Object[] emptyParams = new Object[0];

    public static JNBDispatcher getInstance() {
        return instance;
    }

    private JNBDispatcher() {
    }

    private static boolean runningJava8() {
        return m_isDefault != null;
    }

    private static boolean isDefault(Method method) {
        try {
            if (m_isDefault == null) {
                return false;
            }
            Boolean bl = (Boolean)m_isDefault.invoke((Object)method, emptyParams);
            return bl;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
    }

    public Object call(int n, CallArgs callArgs, boolean bl, byte[] byArray, boolean bl2) throws Exception {
        int n2 = 0;
        short s = 0;
        long l = 0L;
        float f = 0.0f;
        double d = 0.0;
        char c = ' ';
        byte by = 0;
        boolean bl3 = true;
        Object object = null;
        switch (n) {
            case 0: {
                object = this.construct((String)callArgs.getArg("className"), callArgs.getArg("signature"), callArgs.getArg("args"), bl, byArray);
                return ObjectRegistry.registerObject(object, bl2);
            }
            case 1: {
                Long l2 = (Long)callArgs.getArg("objID");
                this.release(l2);
                return new JNBVoidResult();
            }
            case 103: {
                Long l3 = (Long)callArgs.getArg("objID");
                this.addReference(l3);
                return new JNBVoidResult();
            }
            case 60: {
                this.synchronizedCall((Long)callArgs.getArg("objID"), (String)callArgs.getArg("methodName"), callArgs.getArg("signature"), callArgs.getArg("args"));
                return new JNBVoidResult();
            }
            case 61: {
                object = this.getValue((Long)callArgs.getArg("objID"), (Boolean)callArgs.getArg("isJavaBean"));
                return object;
            }
            case 62: {
                object = this.getValueArray((Long[])callArgs.getArg("objIDs"), (Boolean)callArgs.getArg("isJavaBean"));
                return object;
            }
            case 2: {
                this.voidStaticCall((String)callArgs.getArg("className"), (String)callArgs.getArg("methodName"), callArgs.getArg("signature"), callArgs.getArg("args"), bl, byArray);
                return new JNBVoidResult();
            }
            case 3: {
                n2 = this.intStaticCall((String)callArgs.getArg("className"), (String)callArgs.getArg("methodName"), callArgs.getArg("signature"), callArgs.getArg("args"), bl, byArray);
                return new Integer(n2);
            }
            case 4: {
                s = this.shortStaticCall((String)callArgs.getArg("className"), (String)callArgs.getArg("methodName"), callArgs.getArg("signature"), callArgs.getArg("args"), bl, byArray);
                return new Short(s);
            }
            case 5: {
                l = this.longStaticCall((String)callArgs.getArg("className"), (String)callArgs.getArg("methodName"), callArgs.getArg("signature"), callArgs.getArg("args"), bl, byArray);
                return new Long(l);
            }
            case 6: {
                f = this.floatStaticCall((String)callArgs.getArg("className"), (String)callArgs.getArg("methodName"), callArgs.getArg("signature"), callArgs.getArg("args"), bl, byArray);
                return new Float(f);
            }
            case 7: {
                d = this.doubleStaticCall((String)callArgs.getArg("className"), (String)callArgs.getArg("methodName"), callArgs.getArg("signature"), callArgs.getArg("args"), bl, byArray);
                return new Double(d);
            }
            case 8: {
                c = this.charStaticCall((String)callArgs.getArg("className"), (String)callArgs.getArg("methodName"), callArgs.getArg("signature"), callArgs.getArg("args"), bl, byArray);
                return new Character(c);
            }
            case 9: {
                by = this.byteStaticCall((String)callArgs.getArg("className"), (String)callArgs.getArg("methodName"), callArgs.getArg("signature"), callArgs.getArg("args"), bl, byArray);
                return new Byte(by);
            }
            case 10: {
                bl3 = this.booleanStaticCall((String)callArgs.getArg("className"), (String)callArgs.getArg("methodName"), callArgs.getArg("signature"), callArgs.getArg("args"), bl, byArray);
                return new Boolean(bl3);
            }
            case 11: {
                object = this.objectStaticCall((String)callArgs.getArg("className"), (String)callArgs.getArg("methodName"), callArgs.getArg("signature"), callArgs.getArg("args"), bl, byArray);
                return ObjectRegistry.registerObject(object, bl2);
            }
            case 12: {
                this.voidVirtualCall((Long)callArgs.getArg("objID"), (String)callArgs.getArg("methodName"), callArgs.getArg("signature"), callArgs.getArg("args"), bl, byArray);
                return new JNBVoidResult();
            }
            case 13: {
                n2 = this.intVirtualCall((Long)callArgs.getArg("objID"), (String)callArgs.getArg("methodName"), callArgs.getArg("signature"), callArgs.getArg("args"), bl, byArray);
                return new Integer(n2);
            }
            case 14: {
                s = this.shortVirtualCall((Long)callArgs.getArg("objID"), (String)callArgs.getArg("methodName"), callArgs.getArg("signature"), callArgs.getArg("args"), bl, byArray);
                return new Short(s);
            }
            case 15: {
                l = this.longVirtualCall((Long)callArgs.getArg("objID"), (String)callArgs.getArg("methodName"), callArgs.getArg("signature"), callArgs.getArg("args"), bl, byArray);
                return new Long(l);
            }
            case 16: {
                f = this.floatVirtualCall((Long)callArgs.getArg("objID"), (String)callArgs.getArg("methodName"), callArgs.getArg("signature"), callArgs.getArg("args"), bl, byArray);
                return new Float(f);
            }
            case 17: {
                d = this.doubleVirtualCall((Long)callArgs.getArg("objID"), (String)callArgs.getArg("methodName"), callArgs.getArg("signature"), callArgs.getArg("args"), bl, byArray);
                return new Double(d);
            }
            case 18: {
                c = this.charVirtualCall((Long)callArgs.getArg("objID"), (String)callArgs.getArg("methodName"), callArgs.getArg("signature"), callArgs.getArg("args"), bl, byArray);
                return new Character(c);
            }
            case 19: {
                by = this.byteVirtualCall((Long)callArgs.getArg("objID"), (String)callArgs.getArg("methodName"), callArgs.getArg("signature"), callArgs.getArg("args"), bl, byArray);
                return new Byte(by);
            }
            case 20: {
                bl3 = this.booleanVirtualCall((Long)callArgs.getArg("objID"), (String)callArgs.getArg("methodName"), callArgs.getArg("signature"), callArgs.getArg("args"), bl, byArray);
                return new Boolean(bl3);
            }
            case 21: {
                object = this.objectVirtualCall((Long)callArgs.getArg("objID"), (String)callArgs.getArg("methodName"), callArgs.getArg("signature"), callArgs.getArg("args"), bl, byArray);
                return ObjectRegistry.registerObject(object, bl2);
            }
            case 22: {
                n2 = this.getIntInstanceField((Long)callArgs.getArg("objID"), (String)callArgs.getArg("fieldName"), bl, byArray);
                return new Integer(n2);
            }
            case 23: {
                s = this.getShortInstanceField((Long)callArgs.getArg("objID"), (String)callArgs.getArg("fieldName"), bl, byArray);
                return new Short(s);
            }
            case 24: {
                l = this.getLongInstanceField((Long)callArgs.getArg("objID"), (String)callArgs.getArg("fieldName"), bl, byArray);
                return new Long(l);
            }
            case 25: {
                f = this.getFloatInstanceField((Long)callArgs.getArg("objID"), (String)callArgs.getArg("fieldName"), bl, byArray);
                return new Float(f);
            }
            case 26: {
                d = this.getDoubleInstanceField((Long)callArgs.getArg("objID"), (String)callArgs.getArg("fieldName"), bl, byArray);
                return new Double(d);
            }
            case 27: {
                c = this.getCharInstanceField((Long)callArgs.getArg("objID"), (String)callArgs.getArg("fieldName"), bl, byArray);
                return new Character(c);
            }
            case 28: {
                by = this.getByteInstanceField((Long)callArgs.getArg("objID"), (String)callArgs.getArg("fieldName"), bl, byArray);
                return new Byte(by);
            }
            case 29: {
                bl3 = this.getBooleanInstanceField((Long)callArgs.getArg("objID"), (String)callArgs.getArg("fieldName"), bl, byArray);
                return new Boolean(bl3);
            }
            case 30: {
                object = this.getObjectInstanceField((Long)callArgs.getArg("objID"), (String)callArgs.getArg("fieldName"), (String)callArgs.getArg("signature"), bl, byArray);
                return ObjectRegistry.registerObject(object, bl2);
            }
            case 31: {
                this.setIntInstanceField((Long)callArgs.getArg("objID"), (String)callArgs.getArg("fieldName"), (Integer)callArgs.getArg("val"), bl, byArray);
                return new JNBVoidResult();
            }
            case 32: {
                this.setShortInstanceField((Long)callArgs.getArg("objID"), (String)callArgs.getArg("fieldName"), (Short)callArgs.getArg("val"), bl, byArray);
                return new JNBVoidResult();
            }
            case 33: {
                this.setLongInstanceField((Long)callArgs.getArg("objID"), (String)callArgs.getArg("fieldName"), (Long)callArgs.getArg("val"), bl, byArray);
                return new JNBVoidResult();
            }
            case 34: {
                this.setFloatInstanceField((Long)callArgs.getArg("objID"), (String)callArgs.getArg("fieldName"), (Float)callArgs.getArg("val"), bl, byArray);
                return new JNBVoidResult();
            }
            case 35: {
                this.setDoubleInstanceField((Long)callArgs.getArg("objID"), (String)callArgs.getArg("fieldName"), (Double)callArgs.getArg("val"), bl, byArray);
                return new JNBVoidResult();
            }
            case 36: {
                this.setCharInstanceField((Long)callArgs.getArg("objID"), (String)callArgs.getArg("fieldName"), (Character)callArgs.getArg("val"), bl, byArray);
                return new JNBVoidResult();
            }
            case 37: {
                this.setByteInstanceField((Long)callArgs.getArg("objID"), (String)callArgs.getArg("fieldName"), (Byte)callArgs.getArg("val"), bl, byArray);
                return new JNBVoidResult();
            }
            case 38: {
                this.setBooleanInstanceField((Long)callArgs.getArg("objID"), (String)callArgs.getArg("fieldName"), (Boolean)callArgs.getArg("val"), bl, byArray);
                return new JNBVoidResult();
            }
            case 39: {
                this.setObjectInstanceField((Long)callArgs.getArg("objID"), (String)callArgs.getArg("fieldName"), callArgs.getArg("val"), bl, byArray);
                return new JNBVoidResult();
            }
            case 40: {
                n2 = this.getIntStaticField((String)callArgs.getArg("className"), (String)callArgs.getArg("fieldName"), bl, byArray);
                return new Integer(n2);
            }
            case 41: {
                s = this.getShortStaticField((String)callArgs.getArg("className"), (String)callArgs.getArg("fieldName"), bl, byArray);
                return new Short(s);
            }
            case 42: {
                l = this.getLongStaticField((String)callArgs.getArg("className"), (String)callArgs.getArg("fieldName"), bl, byArray);
                return new Long(l);
            }
            case 43: {
                f = this.getFloatStaticField((String)callArgs.getArg("className"), (String)callArgs.getArg("fieldName"), bl, byArray);
                return new Float(f);
            }
            case 44: {
                d = this.getDoubleStaticField((String)callArgs.getArg("className"), (String)callArgs.getArg("fieldName"), bl, byArray);
                return new Double(d);
            }
            case 45: {
                c = this.getCharStaticField((String)callArgs.getArg("className"), (String)callArgs.getArg("fieldName"), bl, byArray);
                return new Character(c);
            }
            case 46: {
                by = this.getByteStaticField((String)callArgs.getArg("className"), (String)callArgs.getArg("fieldName"), bl, byArray);
                return new Byte(by);
            }
            case 47: {
                bl3 = this.getBooleanStaticField((String)callArgs.getArg("className"), (String)callArgs.getArg("fieldName"), bl, byArray);
                return new Boolean(bl3);
            }
            case 48: {
                object = this.getObjectStaticField((String)callArgs.getArg("className"), (String)callArgs.getArg("fieldName"), (String)callArgs.getArg("signature"), bl, byArray);
                return ObjectRegistry.registerObject(object, bl2);
            }
            case 49: {
                this.setIntStaticField((String)callArgs.getArg("className"), (String)callArgs.getArg("fieldName"), (Integer)callArgs.getArg("val"), bl, byArray);
                return new JNBVoidResult();
            }
            case 50: {
                this.setShortStaticField((String)callArgs.getArg("className"), (String)callArgs.getArg("fieldName"), (Short)callArgs.getArg("val"), bl, byArray);
                return new JNBVoidResult();
            }
            case 51: {
                this.setLongStaticField((String)callArgs.getArg("className"), (String)callArgs.getArg("fieldName"), (Long)callArgs.getArg("val"), bl, byArray);
                return new JNBVoidResult();
            }
            case 52: {
                this.setFloatStaticField((String)callArgs.getArg("className"), (String)callArgs.getArg("fieldName"), (Float)callArgs.getArg("val"), bl, byArray);
                return new JNBVoidResult();
            }
            case 53: {
                this.setDoubleStaticField((String)callArgs.getArg("className"), (String)callArgs.getArg("fieldName"), (Double)callArgs.getArg("val"), bl, byArray);
                return new JNBVoidResult();
            }
            case 54: {
                this.setCharStaticField((String)callArgs.getArg("className"), (String)callArgs.getArg("fieldName"), (Character)callArgs.getArg("val"), bl, byArray);
                return new JNBVoidResult();
            }
            case 55: {
                this.setByteStaticField((String)callArgs.getArg("className"), (String)callArgs.getArg("fieldName"), (Byte)callArgs.getArg("val"), bl, byArray);
                return new JNBVoidResult();
            }
            case 56: {
                this.setBooleanStaticField((String)callArgs.getArg("className"), (String)callArgs.getArg("fieldName"), (Boolean)callArgs.getArg("val"), bl, byArray);
                return new JNBVoidResult();
            }
            case 57: {
                this.setObjectStaticField((String)callArgs.getArg("className"), (String)callArgs.getArg("fieldName"), callArgs.getArg("val"), bl, byArray);
                return new JNBVoidResult();
            }
        }
        throw new InternalException(Messages.getString("JNBDISPATCHER_CALL") + " " + n);
    }

    private Class getType(String string) throws InternalException {
        try {
            switch (string.charAt(0)) {
                case 'I': {
                    return Integer.TYPE;
                }
                case 'Z': {
                    return Boolean.TYPE;
                }
                case 'B': {
                    return Byte.TYPE;
                }
                case 'C': {
                    return Character.TYPE;
                }
                case 'S': {
                    return Short.TYPE;
                }
                case 'J': {
                    return Long.TYPE;
                }
                case 'F': {
                    return Float.TYPE;
                }
                case 'D': {
                    return Double.TYPE;
                }
                case '[': {
                    Class clazz = ClassRegistry.getClass(string, this.getClass().getClassLoader());
                    return clazz;
                }
                case 'L': {
                    return ClassRegistry.getClass(string.substring(1, string.length() - 1), this.getClass().getClassLoader());
                }
            }
            throw new InternalException(Messages.getString("JNBDISPATCHER_GETTYPE"));
        }
        catch (InternalException internalException) {
            throw internalException;
        }
        catch (Exception exception) {
            throw new InternalException(exception.toString());
        }
    }

    public Object construct(String string, Object object, Object object2, boolean bl, byte[] byArray) throws Exception {
        try {
            Object[] objectArray = BinaryArgConverter.unwrapArrays(object);
            Object[] objectArray2 = BinaryArgConverter.unwrapArrays(object2);
            Class clazz = ClassRegistry.getClass(string, this.getClass().getClassLoader());
            Class[] classArray = new Class[objectArray2.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                classArray[i] = this.getType((String)objectArray[i]);
            }
            Constructor constructor = clazz.getDeclaredConstructor(classArray);
            if (isLoggingOn) {
                JNBDispatcher.logCall("construct", clazz, "<init>", objectArray, objectArray2);
            }
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            if (bl) {
                return this.threadTrueInvoker.newInstance(constructor, objectArray2, byArray);
            }
            return constructor.newInstance(objectArray2);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException;
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronizedCall(Long l, String string, Object object, Object object2) throws Exception {
        try {
            Object object3 = ObjectRegistry.getObjectFromID(l);
            Object[] objectArray = BinaryArgConverter.unwrapArrays(object);
            Object[] objectArray2 = BinaryArgConverter.unwrapArrays(object2);
            Class<?> clazz = object3.getClass();
            Class[] classArray = new Class[objectArray2.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                classArray[i] = this.getType((String)objectArray[i]);
            }
            Method method = this.getMethod(clazz, string, classArray);
            if (isLoggingOn) {
                JNBDispatcher.logCall("synchronizedCall", clazz, string, objectArray, objectArray2);
            }
            Object object4 = object3;
            synchronized (object4) {
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                method.invoke(object3, objectArray2);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException;
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public void voidStaticCall(String string, String string2, Object object, Object object2, boolean bl, byte[] byArray) throws Exception {
        try {
            Object[] objectArray = BinaryArgConverter.unwrapArrays(object);
            Object[] objectArray2 = BinaryArgConverter.unwrapArrays(object2);
            Class clazz = ClassRegistry.getClass(string, this.getClass().getClassLoader());
            Class[] classArray = new Class[objectArray2.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                classArray[i] = this.getType((String)objectArray[i]);
            }
            Method method = this.getMethod(clazz, string2, classArray);
            if (isLoggingOn) {
                JNBDispatcher.logCall("voidStaticCall", clazz, string2, objectArray, objectArray2);
            }
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            if (bl) {
                this.threadTrueInvoker.invoke(method, null, objectArray2, byArray);
            } else {
                method.invoke(null, objectArray2);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException;
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public int intStaticCall(String string, String string2, Object object, Object object2, boolean bl, byte[] byArray) throws Exception {
        try {
            Object[] objectArray = BinaryArgConverter.unwrapArrays(object);
            Object[] objectArray2 = BinaryArgConverter.unwrapArrays(object2);
            Class clazz = ClassRegistry.getClass(string, this.getClass().getClassLoader());
            Class[] classArray = new Class[objectArray2.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                classArray[i] = this.getType((String)objectArray[i]);
            }
            Method method = this.getMethod(clazz, string2, classArray);
            if (isLoggingOn) {
                JNBDispatcher.logCall("intStaticCall", clazz, string2, objectArray, objectArray2);
            }
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            Integer n = bl ? (Integer)this.threadTrueInvoker.invoke(method, null, objectArray2, byArray) : (Integer)method.invoke(null, objectArray2);
            return n;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException;
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public short shortStaticCall(String string, String string2, Object object, Object object2, boolean bl, byte[] byArray) throws Exception {
        try {
            Object[] objectArray = BinaryArgConverter.unwrapArrays(object);
            Object[] objectArray2 = BinaryArgConverter.unwrapArrays(object2);
            Class clazz = ClassRegistry.getClass(string, this.getClass().getClassLoader());
            Class[] classArray = new Class[objectArray2.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                classArray[i] = this.getType((String)objectArray[i]);
            }
            Method method = this.getMethod(clazz, string2, classArray);
            if (isLoggingOn) {
                JNBDispatcher.logCall("shortStaticCall", clazz, string2, objectArray, objectArray2);
            }
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            Short s = bl ? (Short)this.threadTrueInvoker.invoke(method, null, objectArray2, byArray) : (Short)method.invoke(null, objectArray2);
            return s;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException;
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public long longStaticCall(String string, String string2, Object object, Object object2, boolean bl, byte[] byArray) throws Exception {
        try {
            Object[] objectArray = BinaryArgConverter.unwrapArrays(object);
            Object[] objectArray2 = BinaryArgConverter.unwrapArrays(object2);
            Class clazz = ClassRegistry.getClass(string, this.getClass().getClassLoader());
            Class[] classArray = new Class[objectArray2.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                classArray[i] = this.getType((String)objectArray[i]);
            }
            Method method = this.getMethod(clazz, string2, classArray);
            if (isLoggingOn) {
                JNBDispatcher.logCall("longStaticCall", clazz, string2, objectArray, objectArray2);
            }
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            Long l = bl ? (Long)this.threadTrueInvoker.invoke(method, null, objectArray2, byArray) : (Long)method.invoke(null, objectArray2);
            return l;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException;
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public float floatStaticCall(String string, String string2, Object object, Object object2, boolean bl, byte[] byArray) throws Exception {
        try {
            Object[] objectArray = BinaryArgConverter.unwrapArrays(object);
            Object[] objectArray2 = BinaryArgConverter.unwrapArrays(object2);
            Class clazz = ClassRegistry.getClass(string, this.getClass().getClassLoader());
            Class[] classArray = new Class[objectArray2.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                classArray[i] = this.getType((String)objectArray[i]);
            }
            Method method = this.getMethod(clazz, string2, classArray);
            if (isLoggingOn) {
                JNBDispatcher.logCall("floatStaticCall", clazz, string2, objectArray, objectArray2);
            }
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            Float f = bl ? (Float)this.threadTrueInvoker.invoke(method, null, objectArray2, byArray) : (Float)method.invoke(null, objectArray2);
            return f.floatValue();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException;
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public double doubleStaticCall(String string, String string2, Object object, Object object2, boolean bl, byte[] byArray) throws Exception {
        try {
            Object[] objectArray = BinaryArgConverter.unwrapArrays(object);
            Object[] objectArray2 = BinaryArgConverter.unwrapArrays(object2);
            Class clazz = ClassRegistry.getClass(string, this.getClass().getClassLoader());
            Class[] classArray = new Class[objectArray2.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                classArray[i] = this.getType((String)objectArray[i]);
            }
            Method method = this.getMethod(clazz, string2, classArray);
            if (isLoggingOn) {
                JNBDispatcher.logCall("doubleStaticCall", clazz, string2, objectArray, objectArray2);
            }
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            Double d = bl ? (Double)this.threadTrueInvoker.invoke(method, null, objectArray2, byArray) : (Double)method.invoke(null, objectArray2);
            return d;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException;
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public char charStaticCall(String string, String string2, Object object, Object object2, boolean bl, byte[] byArray) throws Exception {
        try {
            Object[] objectArray = BinaryArgConverter.unwrapArrays(object);
            Object[] objectArray2 = BinaryArgConverter.unwrapArrays(object2);
            Class clazz = ClassRegistry.getClass(string, this.getClass().getClassLoader());
            Class[] classArray = new Class[objectArray2.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                classArray[i] = this.getType((String)objectArray[i]);
            }
            Method method = this.getMethod(clazz, string2, classArray);
            if (isLoggingOn) {
                JNBDispatcher.logCall("charStaticCall", clazz, string2, objectArray, objectArray2);
            }
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            Character c = bl ? (Character)this.threadTrueInvoker.invoke(method, null, objectArray2, byArray) : (Character)method.invoke(null, objectArray2);
            return c.charValue();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException;
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public byte byteStaticCall(String string, String string2, Object object, Object object2, boolean bl, byte[] byArray) throws Exception {
        try {
            Object[] objectArray = BinaryArgConverter.unwrapArrays(object);
            Object[] objectArray2 = BinaryArgConverter.unwrapArrays(object2);
            Class clazz = ClassRegistry.getClass(string, this.getClass().getClassLoader());
            Class[] classArray = new Class[objectArray2.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                classArray[i] = this.getType((String)objectArray[i]);
            }
            Method method = this.getMethod(clazz, string2, classArray);
            if (isLoggingOn) {
                JNBDispatcher.logCall("byteStaticCall", clazz, string2, objectArray, objectArray2);
            }
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            Byte by = bl ? (Byte)this.threadTrueInvoker.invoke(method, null, objectArray2, byArray) : (Byte)method.invoke(null, objectArray2);
            return by;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException;
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public boolean booleanStaticCall(String string, String string2, Object object, Object object2, boolean bl, byte[] byArray) throws Exception {
        try {
            Object[] objectArray = BinaryArgConverter.unwrapArrays(object);
            Object[] objectArray2 = BinaryArgConverter.unwrapArrays(object2);
            Class clazz = ClassRegistry.getClass(string, this.getClass().getClassLoader());
            Class[] classArray = new Class[objectArray2.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                classArray[i] = this.getType((String)objectArray[i]);
            }
            Method method = this.getMethod(clazz, string2, classArray);
            if (isLoggingOn) {
                JNBDispatcher.logCall("booleanStaticCall", clazz, string2, objectArray, objectArray2);
            }
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            Boolean bl2 = bl ? (Boolean)this.threadTrueInvoker.invoke(method, null, objectArray2, byArray) : (Boolean)method.invoke(null, objectArray2);
            return bl2;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException;
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public Object objectStaticCall(String string, String string2, Object object, Object object2, boolean bl, byte[] byArray) throws Exception {
        try {
            Object[] objectArray = BinaryArgConverter.unwrapArrays(object);
            Object[] objectArray2 = BinaryArgConverter.unwrapArrays(object2);
            Class clazz = ClassRegistry.getClass(string, this.getClass().getClassLoader());
            Class[] classArray = new Class[objectArray2.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                classArray[i] = this.getType((String)objectArray[i]);
            }
            Method method = this.getMethod(clazz, string2, classArray);
            if (isLoggingOn) {
                JNBDispatcher.logCall("objectStaticCall", clazz, string2, objectArray, objectArray2);
            }
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            if (bl) {
                return this.threadTrueInvoker.invoke(method, null, objectArray2, byArray);
            }
            return method.invoke(null, objectArray2);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException;
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public void voidVirtualCall(Long l, String string, Object object, Object object2, boolean bl, byte[] byArray) throws Exception {
        try {
            Object object3 = ObjectRegistry.getObjectFromID(l);
            Object[] objectArray = BinaryArgConverter.unwrapArrays(object);
            Object[] objectArray2 = BinaryArgConverter.unwrapArrays(object2);
            Class<?> clazz = object3.getClass();
            Class[] classArray = new Class[objectArray2.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                classArray[i] = this.getType((String)objectArray[i]);
            }
            Method method = this.getMethod(clazz, string, classArray);
            if (isLoggingOn) {
                JNBDispatcher.logCall("voidVirtualCall", clazz, string, objectArray, objectArray2);
            }
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            if (bl) {
                this.threadTrueInvoker.invoke(method, object3, objectArray2, byArray);
            } else {
                method.invoke(object3, objectArray2);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException;
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public int intVirtualCall(Long l, String string, Object object, Object object2, boolean bl, byte[] byArray) throws Exception {
        try {
            Object object3 = ObjectRegistry.getObjectFromID(l);
            Object[] objectArray = BinaryArgConverter.unwrapArrays(object);
            Object[] objectArray2 = BinaryArgConverter.unwrapArrays(object2);
            Class<?> clazz = object3.getClass();
            Class[] classArray = new Class[objectArray2.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                classArray[i] = this.getType((String)objectArray[i]);
            }
            Method method = this.getMethod(clazz, string, classArray);
            if (isLoggingOn) {
                JNBDispatcher.logCall("intVirtualCall", clazz, string, objectArray, objectArray2);
            }
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            Integer n = bl ? (Integer)this.threadTrueInvoker.invoke(method, object3, objectArray2, byArray) : (Integer)method.invoke(object3, objectArray2);
            return n;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException;
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public short shortVirtualCall(Long l, String string, Object object, Object object2, boolean bl, byte[] byArray) throws Exception {
        try {
            Object object3 = ObjectRegistry.getObjectFromID(l);
            Object[] objectArray = BinaryArgConverter.unwrapArrays(object);
            Object[] objectArray2 = BinaryArgConverter.unwrapArrays(object2);
            Class<?> clazz = object3.getClass();
            Class[] classArray = new Class[objectArray2.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                classArray[i] = this.getType((String)objectArray[i]);
            }
            Method method = this.getMethod(clazz, string, classArray);
            if (isLoggingOn) {
                JNBDispatcher.logCall("shortVirtualCall", clazz, string, objectArray, objectArray2);
            }
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            Short s = bl ? (Short)this.threadTrueInvoker.invoke(method, object3, objectArray2, byArray) : (Short)method.invoke(object3, objectArray2);
            return s;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException;
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public long longVirtualCall(Long l, String string, Object object, Object object2, boolean bl, byte[] byArray) throws Exception {
        try {
            Object object3 = ObjectRegistry.getObjectFromID(l);
            Object[] objectArray = BinaryArgConverter.unwrapArrays(object);
            Object[] objectArray2 = BinaryArgConverter.unwrapArrays(object2);
            Class<?> clazz = object3.getClass();
            Class[] classArray = new Class[objectArray2.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                classArray[i] = this.getType((String)objectArray[i]);
            }
            Method method = this.getMethod(clazz, string, classArray);
            if (isLoggingOn) {
                JNBDispatcher.logCall("longVirtualCall", clazz, string, objectArray, objectArray2);
            }
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            Long l2 = bl ? (Long)this.threadTrueInvoker.invoke(method, object3, objectArray2, byArray) : (Long)method.invoke(object3, objectArray2);
            return l2;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException;
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public float floatVirtualCall(Long l, String string, Object object, Object object2, boolean bl, byte[] byArray) throws Exception {
        try {
            Object object3 = ObjectRegistry.getObjectFromID(l);
            Object[] objectArray = BinaryArgConverter.unwrapArrays(object);
            Object[] objectArray2 = BinaryArgConverter.unwrapArrays(object2);
            Class<?> clazz = object3.getClass();
            Class[] classArray = new Class[objectArray2.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                classArray[i] = this.getType((String)objectArray[i]);
            }
            Method method = this.getMethod(clazz, string, classArray);
            if (isLoggingOn) {
                JNBDispatcher.logCall("floatVirtualCall", clazz, string, objectArray, objectArray2);
            }
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            Float f = bl ? (Float)this.threadTrueInvoker.invoke(method, object3, objectArray2, byArray) : (Float)method.invoke(object3, objectArray2);
            return f.floatValue();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException;
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public double doubleVirtualCall(Long l, String string, Object object, Object object2, boolean bl, byte[] byArray) throws Exception {
        try {
            Object object3 = ObjectRegistry.getObjectFromID(l);
            Object[] objectArray = BinaryArgConverter.unwrapArrays(object);
            Object[] objectArray2 = BinaryArgConverter.unwrapArrays(object2);
            Class<?> clazz = object3.getClass();
            Class[] classArray = new Class[objectArray2.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                classArray[i] = this.getType((String)objectArray[i]);
            }
            Method method = this.getMethod(clazz, string, classArray);
            if (isLoggingOn) {
                JNBDispatcher.logCall("doubleVirtualCall", clazz, string, objectArray, objectArray2);
            }
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            Double d = bl ? (Double)this.threadTrueInvoker.invoke(method, object3, objectArray2, byArray) : (Double)method.invoke(object3, objectArray2);
            return d;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException;
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public char charVirtualCall(Long l, String string, Object object, Object object2, boolean bl, byte[] byArray) throws Exception {
        try {
            Object object3 = ObjectRegistry.getObjectFromID(l);
            Object[] objectArray = BinaryArgConverter.unwrapArrays(object);
            Object[] objectArray2 = BinaryArgConverter.unwrapArrays(object2);
            Class<?> clazz = object3.getClass();
            Class[] classArray = new Class[objectArray2.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                classArray[i] = this.getType((String)objectArray[i]);
            }
            Method method = this.getMethod(clazz, string, classArray);
            if (isLoggingOn) {
                JNBDispatcher.logCall("charVirtualCall", clazz, string, objectArray, objectArray2);
            }
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            Character c = bl ? (Character)this.threadTrueInvoker.invoke(method, object3, objectArray2, byArray) : (Character)method.invoke(object3, objectArray2);
            return c.charValue();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException;
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public byte byteVirtualCall(Long l, String string, Object object, Object object2, boolean bl, byte[] byArray) throws Exception {
        try {
            Object object3 = ObjectRegistry.getObjectFromID(l);
            Object[] objectArray = BinaryArgConverter.unwrapArrays(object);
            Object[] objectArray2 = BinaryArgConverter.unwrapArrays(object2);
            Class<?> clazz = object3.getClass();
            Class[] classArray = new Class[objectArray2.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                classArray[i] = this.getType((String)objectArray[i]);
            }
            Method method = this.getMethod(clazz, string, classArray);
            if (isLoggingOn) {
                JNBDispatcher.logCall("byteVirtualCall", clazz, string, objectArray, objectArray2);
            }
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            Byte by = bl ? (Byte)this.threadTrueInvoker.invoke(method, object3, objectArray2, byArray) : (Byte)method.invoke(object3, objectArray2);
            return by;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException;
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public boolean booleanVirtualCall(Long l, String string, Object object, Object object2, boolean bl, byte[] byArray) throws Exception {
        try {
            Object[] objectArray = BinaryArgConverter.unwrapArrays(object);
            Object[] objectArray2 = BinaryArgConverter.unwrapArrays(object2);
            Object object3 = ObjectRegistry.getObjectFromID(l);
            Class<?> clazz = object3.getClass();
            Class[] classArray = new Class[objectArray2.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                classArray[i] = this.getType((String)objectArray[i]);
            }
            Method method = this.getMethod(clazz, string, classArray);
            if (isLoggingOn) {
                JNBDispatcher.logCall("booleanVirtualCall", clazz, string, objectArray, objectArray2);
            }
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            Boolean bl2 = bl ? (Boolean)this.threadTrueInvoker.invoke(method, object3, objectArray2, byArray) : (Boolean)method.invoke(object3, objectArray2);
            return bl2;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException;
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public Object objectVirtualCall(Long l, String string, Object object, Object object2, boolean bl, byte[] byArray) throws Exception {
        try {
            Object object3 = ObjectRegistry.getObjectFromID(l);
            Object[] objectArray = BinaryArgConverter.unwrapArrays(object);
            Object[] objectArray2 = BinaryArgConverter.unwrapArrays(object2);
            Class<?> clazz = object3.getClass();
            Class[] classArray = new Class[objectArray2.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                classArray[i] = this.getType((String)objectArray[i]);
            }
            Method method = this.getMethod(clazz, string, classArray);
            if (isLoggingOn) {
                JNBDispatcher.logCall("objectVirtualCall", clazz, string, objectArray, objectArray2);
            }
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            if (bl) {
                return this.threadTrueInvoker.invoke(method, object3, objectArray2, byArray);
            }
            return method.invoke(object3, objectArray2);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException;
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public int getIntInstanceField(Long l, String string, boolean bl, byte[] byArray) throws Exception {
        try {
            Object object = ObjectRegistry.getObjectFromID(l);
            Class<?> clazz = object.getClass();
            Field field = this.getField(clazz, string);
            if (isLoggingOn) {
                JNBDispatcher.logCall("getIntInstanceField", clazz, string);
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (bl) {
                return this.threadTrueInvoker.getInt(field, object, byArray);
            }
            return field.getInt(object);
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public short getShortInstanceField(Long l, String string, boolean bl, byte[] byArray) throws Exception {
        try {
            Object object = ObjectRegistry.getObjectFromID(l);
            Class<?> clazz = object.getClass();
            Field field = this.getField(clazz, string);
            if (isLoggingOn) {
                JNBDispatcher.logCall("getShortInstanceField", clazz, string);
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (bl) {
                return this.threadTrueInvoker.getShort(field, object, byArray);
            }
            return field.getShort(object);
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public long getLongInstanceField(Long l, String string, boolean bl, byte[] byArray) throws Exception {
        try {
            Object object = ObjectRegistry.getObjectFromID(l);
            Class<?> clazz = object.getClass();
            Field field = this.getField(clazz, string);
            if (isLoggingOn) {
                JNBDispatcher.logCall("getLongInstanceField", clazz, string);
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (bl) {
                return this.threadTrueInvoker.getLong(field, object, byArray);
            }
            return field.getLong(object);
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public float getFloatInstanceField(Long l, String string, boolean bl, byte[] byArray) throws Exception {
        try {
            Object object = ObjectRegistry.getObjectFromID(l);
            Class<?> clazz = object.getClass();
            Field field = this.getField(clazz, string);
            if (isLoggingOn) {
                JNBDispatcher.logCall("getFloatInstanceField", clazz, string);
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (bl) {
                return this.threadTrueInvoker.getFloat(field, object, byArray);
            }
            return field.getFloat(object);
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public double getDoubleInstanceField(Long l, String string, boolean bl, byte[] byArray) throws Exception {
        try {
            Object object = ObjectRegistry.getObjectFromID(l);
            Class<?> clazz = object.getClass();
            Field field = this.getField(clazz, string);
            if (isLoggingOn) {
                JNBDispatcher.logCall("getDoubleInstanceField", clazz, string);
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (bl) {
                return this.threadTrueInvoker.getDouble(field, object, byArray);
            }
            return field.getDouble(object);
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public char getCharInstanceField(Long l, String string, boolean bl, byte[] byArray) throws Exception {
        try {
            Object object = ObjectRegistry.getObjectFromID(l);
            Class<?> clazz = object.getClass();
            Field field = this.getField(clazz, string);
            if (isLoggingOn) {
                JNBDispatcher.logCall("getCharInstanceField", clazz, string);
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (bl) {
                return this.threadTrueInvoker.getChar(field, object, byArray);
            }
            return field.getChar(object);
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public byte getByteInstanceField(Long l, String string, boolean bl, byte[] byArray) throws Exception {
        try {
            Object object = ObjectRegistry.getObjectFromID(l);
            Class<?> clazz = object.getClass();
            Field field = this.getField(clazz, string);
            if (isLoggingOn) {
                JNBDispatcher.logCall("getByteInstanceField", clazz, string);
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (bl) {
                return this.threadTrueInvoker.getByte(field, object, byArray);
            }
            return field.getByte(object);
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public boolean getBooleanInstanceField(Long l, String string, boolean bl, byte[] byArray) throws Exception {
        try {
            Object object = ObjectRegistry.getObjectFromID(l);
            Class<?> clazz = object.getClass();
            Field field = this.getField(clazz, string);
            if (isLoggingOn) {
                JNBDispatcher.logCall("getBooleanInstanceField", clazz, string);
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (bl) {
                return this.threadTrueInvoker.getBoolean(field, object, byArray);
            }
            return field.getBoolean(object);
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public Object getObjectInstanceField(Long l, String string, String string2, boolean bl, byte[] byArray) throws Exception {
        try {
            Object object = ObjectRegistry.getObjectFromID(l);
            Class<?> clazz = object.getClass();
            Field field = this.getField(clazz, string);
            if (isLoggingOn) {
                JNBDispatcher.logCall("getObjectInstanceField", clazz, string);
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (bl) {
                return this.threadTrueInvoker.get(field, object, byArray);
            }
            return field.get(object);
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public void setIntInstanceField(Long l, String string, Integer n, boolean bl, byte[] byArray) throws Exception {
        try {
            Object object = ObjectRegistry.getObjectFromID(l);
            int n2 = n;
            Class<?> clazz = object.getClass();
            Field field = this.getField(clazz, string);
            if (isLoggingOn) {
                JNBDispatcher.logCall("setIntInstanceField", clazz, string, n);
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (bl) {
                this.threadTrueInvoker.setInt(field, object, n2, byArray);
            } else {
                field.setInt(object, n2);
            }
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public void setShortInstanceField(Long l, String string, Short s, boolean bl, byte[] byArray) throws Exception {
        try {
            Object object = ObjectRegistry.getObjectFromID(l);
            short s2 = s;
            Class<?> clazz = object.getClass();
            Field field = this.getField(clazz, string);
            if (isLoggingOn) {
                JNBDispatcher.logCall("setShortInstanceField", clazz, string, s);
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (bl) {
                this.threadTrueInvoker.setShort(field, object, s2, byArray);
            } else {
                field.setShort(object, s2);
            }
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public void setLongInstanceField(Long l, String string, Long l2, boolean bl, byte[] byArray) throws Exception {
        try {
            Object object = ObjectRegistry.getObjectFromID(l);
            long l3 = l2;
            Class<?> clazz = object.getClass();
            Field field = this.getField(clazz, string);
            if (isLoggingOn) {
                JNBDispatcher.logCall("setLongInstanceField", clazz, string, l2);
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (bl) {
                this.threadTrueInvoker.setLong(field, object, l3, byArray);
            } else {
                field.setLong(object, l3);
            }
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public void setFloatInstanceField(Long l, String string, Float f, boolean bl, byte[] byArray) throws Exception {
        try {
            Object object = ObjectRegistry.getObjectFromID(l);
            float f2 = f.floatValue();
            Class<?> clazz = object.getClass();
            Field field = this.getField(clazz, string);
            if (isLoggingOn) {
                JNBDispatcher.logCall("setFloatInstanceField", clazz, string, f);
            }
            if (bl) {
                this.threadTrueInvoker.setFloat(field, object, f2, byArray);
            } else {
                field.setFloat(object, f2);
            }
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public void setDoubleInstanceField(Long l, String string, Double d, boolean bl, byte[] byArray) throws Exception {
        try {
            Object object = ObjectRegistry.getObjectFromID(l);
            double d2 = d;
            Class<?> clazz = object.getClass();
            Field field = this.getField(clazz, string);
            if (isLoggingOn) {
                JNBDispatcher.logCall("setDoubleInstanceField", clazz, string, d);
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (bl) {
                this.threadTrueInvoker.setDouble(field, object, d2, byArray);
            } else {
                field.setDouble(object, d2);
            }
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public void setCharInstanceField(Long l, String string, Character c, boolean bl, byte[] byArray) throws Exception {
        try {
            Object object = ObjectRegistry.getObjectFromID(l);
            char c2 = c.charValue();
            Class<?> clazz = object.getClass();
            Field field = this.getField(clazz, string);
            if (isLoggingOn) {
                JNBDispatcher.logCall("setCharInstanceField", clazz, string, c);
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (bl) {
                this.threadTrueInvoker.setChar(field, object, c2, byArray);
            } else {
                field.setChar(object, c2);
            }
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public void setByteInstanceField(Long l, String string, Byte by, boolean bl, byte[] byArray) throws Exception {
        try {
            Object object = ObjectRegistry.getObjectFromID(l);
            byte by2 = by;
            Class<?> clazz = object.getClass();
            Field field = this.getField(clazz, string);
            if (isLoggingOn) {
                JNBDispatcher.logCall("setByteInstanceField", clazz, string, by);
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (bl) {
                this.threadTrueInvoker.setByte(field, object, by2, byArray);
            } else {
                field.setByte(object, by2);
            }
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public void setBooleanInstanceField(Long l, String string, Boolean bl, boolean bl2, byte[] byArray) throws Exception {
        try {
            Object object = ObjectRegistry.getObjectFromID(l);
            boolean bl3 = bl;
            Class<?> clazz = object.getClass();
            Field field = this.getField(clazz, string);
            if (isLoggingOn) {
                JNBDispatcher.logCall("setBooleanInstanceField", clazz, string, bl);
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (bl2) {
                this.threadTrueInvoker.setBoolean(field, object, bl3, byArray);
            } else {
                field.setBoolean(object, bl3);
            }
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public void setObjectInstanceField(Long l, String string, Object object, boolean bl, byte[] byArray) throws Exception {
        try {
            Object object2 = ObjectRegistry.getObjectFromID(l);
            Class<?> clazz = object2.getClass();
            Field field = this.getField(clazz, string);
            if (isLoggingOn) {
                JNBDispatcher.logCall("setObjectInstanceField", clazz, string, object);
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (bl) {
                this.threadTrueInvoker.set(field, object2, object, byArray);
            } else {
                field.set(object2, object);
            }
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public int getIntStaticField(String string, String string2, boolean bl, byte[] byArray) throws Exception {
        try {
            Class clazz = ClassRegistry.getClass(string, this.getClass().getClassLoader());
            Field field = this.getField(clazz, string2);
            if (isLoggingOn) {
                JNBDispatcher.logCall("getIntStaticField", clazz, string2);
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (bl) {
                return this.threadTrueInvoker.getInt(field, null, byArray);
            }
            return field.getInt(null);
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public short getShortStaticField(String string, String string2, boolean bl, byte[] byArray) throws Exception {
        try {
            Class clazz = ClassRegistry.getClass(string, this.getClass().getClassLoader());
            Field field = this.getField(clazz, string2);
            if (isLoggingOn) {
                JNBDispatcher.logCall("getShortStaticField", clazz, string2);
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (bl) {
                return this.threadTrueInvoker.getShort(field, null, byArray);
            }
            return field.getShort(null);
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public long getLongStaticField(String string, String string2, boolean bl, byte[] byArray) throws Exception {
        try {
            Class clazz = ClassRegistry.getClass(string, this.getClass().getClassLoader());
            Field field = this.getField(clazz, string2);
            if (isLoggingOn) {
                JNBDispatcher.logCall("getLongStaticField", clazz, string2);
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (bl) {
                return this.threadTrueInvoker.getLong(field, null, byArray);
            }
            return field.getLong(null);
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public float getFloatStaticField(String string, String string2, boolean bl, byte[] byArray) throws Exception {
        try {
            Class clazz = ClassRegistry.getClass(string, this.getClass().getClassLoader());
            Field field = this.getField(clazz, string2);
            if (isLoggingOn) {
                JNBDispatcher.logCall("getFloatStaticField", clazz, string2);
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (bl) {
                return this.threadTrueInvoker.getFloat(field, null, byArray);
            }
            return field.getFloat(null);
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public double getDoubleStaticField(String string, String string2, boolean bl, byte[] byArray) throws Exception {
        try {
            Class clazz = ClassRegistry.getClass(string, this.getClass().getClassLoader());
            Field field = this.getField(clazz, string2);
            if (isLoggingOn) {
                JNBDispatcher.logCall("getDoubleStaticField", clazz, string2);
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (bl) {
                return this.threadTrueInvoker.getDouble(field, null, byArray);
            }
            return field.getDouble(null);
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public char getCharStaticField(String string, String string2, boolean bl, byte[] byArray) throws Exception {
        try {
            Class clazz = ClassRegistry.getClass(string, this.getClass().getClassLoader());
            Field field = this.getField(clazz, string2);
            if (isLoggingOn) {
                JNBDispatcher.logCall("getCharStaticField", clazz, string2);
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (bl) {
                return this.threadTrueInvoker.getChar(field, null, byArray);
            }
            return field.getChar(null);
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public byte getByteStaticField(String string, String string2, boolean bl, byte[] byArray) throws Exception {
        try {
            Class clazz = ClassRegistry.getClass(string, this.getClass().getClassLoader());
            Field field = this.getField(clazz, string2);
            if (isLoggingOn) {
                JNBDispatcher.logCall("getByteStaticField", clazz, string2);
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (bl) {
                return this.threadTrueInvoker.getByte(field, null, byArray);
            }
            return field.getByte(null);
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public boolean getBooleanStaticField(String string, String string2, boolean bl, byte[] byArray) throws Exception {
        try {
            Class clazz = ClassRegistry.getClass(string, this.getClass().getClassLoader());
            Field field = this.getField(clazz, string2);
            if (isLoggingOn) {
                JNBDispatcher.logCall("getBooleanStaticField", clazz, string2);
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (bl) {
                return this.threadTrueInvoker.getBoolean(field, null, byArray);
            }
            return field.getBoolean(null);
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public Object getObjectStaticField(String string, String string2, String string3, boolean bl, byte[] byArray) throws Exception {
        try {
            Class clazz = ClassRegistry.getClass(string, this.getClass().getClassLoader());
            Field field = this.getField(clazz, string2);
            if (isLoggingOn) {
                JNBDispatcher.logCall("getObjectStaticField", clazz, string2);
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (bl) {
                return this.threadTrueInvoker.get(field, null, byArray);
            }
            return field.get(null);
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public void setIntStaticField(String string, String string2, Integer n, boolean bl, byte[] byArray) throws Exception {
        try {
            int n2 = n;
            Class clazz = ClassRegistry.getClass(string, this.getClass().getClassLoader());
            Field field = this.getField(clazz, string2);
            if (isLoggingOn) {
                JNBDispatcher.logCall("setIntStaticField", clazz, string2, n);
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (bl) {
                this.threadTrueInvoker.setInt(field, null, n2, byArray);
            } else {
                field.setInt(null, n2);
            }
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public void setShortStaticField(String string, String string2, Short s, boolean bl, byte[] byArray) throws Exception {
        try {
            short s2 = s;
            Class clazz = ClassRegistry.getClass(string, this.getClass().getClassLoader());
            Field field = this.getField(clazz, string2);
            if (isLoggingOn) {
                JNBDispatcher.logCall("setShortStaticField", clazz, string2, s);
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (bl) {
                this.threadTrueInvoker.setShort(field, null, s2, byArray);
            } else {
                field.setShort(null, s2);
            }
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public void setLongStaticField(String string, String string2, Long l, boolean bl, byte[] byArray) throws Exception {
        try {
            long l2 = l;
            Class clazz = ClassRegistry.getClass(string, this.getClass().getClassLoader());
            Field field = this.getField(clazz, string2);
            if (isLoggingOn) {
                JNBDispatcher.logCall("setLongStaticField", clazz, string2, l);
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (bl) {
                this.threadTrueInvoker.setLong(field, null, l2, byArray);
            } else {
                field.setLong(null, l2);
            }
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public void setFloatStaticField(String string, String string2, Float f, boolean bl, byte[] byArray) throws Exception {
        try {
            float f2 = f.floatValue();
            Class clazz = ClassRegistry.getClass(string, this.getClass().getClassLoader());
            Field field = this.getField(clazz, string2);
            if (isLoggingOn) {
                JNBDispatcher.logCall("setFloatStaticField", clazz, string2, f);
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (bl) {
                this.threadTrueInvoker.setFloat(field, null, f2, byArray);
            } else {
                field.setFloat(null, f2);
            }
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public void setDoubleStaticField(String string, String string2, Double d, boolean bl, byte[] byArray) throws Exception {
        try {
            double d2 = d;
            Class clazz = ClassRegistry.getClass(string, this.getClass().getClassLoader());
            Field field = this.getField(clazz, string2);
            if (isLoggingOn) {
                JNBDispatcher.logCall("setDoubleStaticField", clazz, string2, d);
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (bl) {
                this.threadTrueInvoker.setDouble(field, null, d2, byArray);
            } else {
                field.setDouble(null, d2);
            }
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public void setCharStaticField(String string, String string2, Character c, boolean bl, byte[] byArray) throws Exception {
        try {
            char c2 = c.charValue();
            Class clazz = ClassRegistry.getClass(string, this.getClass().getClassLoader());
            Field field = this.getField(clazz, string2);
            if (isLoggingOn) {
                JNBDispatcher.logCall("setCharStaticField", clazz, string2, c);
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (bl) {
                this.threadTrueInvoker.setChar(field, null, c2, byArray);
            } else {
                field.setChar(null, c2);
            }
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public void setByteStaticField(String string, String string2, Byte by, boolean bl, byte[] byArray) throws Exception {
        try {
            byte by2 = by;
            Class clazz = ClassRegistry.getClass(string, this.getClass().getClassLoader());
            Field field = this.getField(clazz, string2);
            if (isLoggingOn) {
                JNBDispatcher.logCall("setByteStaticField", clazz, string2, by);
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (bl) {
                this.threadTrueInvoker.setByte(field, null, by2, byArray);
            } else {
                field.setByte(null, by2);
            }
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public void setBooleanStaticField(String string, String string2, Boolean bl, boolean bl2, byte[] byArray) throws Exception {
        try {
            boolean bl3 = bl;
            Class clazz = ClassRegistry.getClass(string, this.getClass().getClassLoader());
            Field field = this.getField(clazz, string2);
            if (isLoggingOn) {
                JNBDispatcher.logCall("setBooleanStaticField", clazz, string2, bl);
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (bl2) {
                this.threadTrueInvoker.setBoolean(field, null, bl3, byArray);
            } else {
                field.setBoolean(null, bl3);
            }
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public void setObjectStaticField(String string, String string2, Object object, boolean bl, byte[] byArray) throws Exception {
        try {
            Class clazz = ClassRegistry.getClass(string, this.getClass().getClassLoader());
            Field field = this.getField(clazz, string2);
            if (isLoggingOn) {
                JNBDispatcher.logCall("setObjectStaticField", clazz, string2, object);
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (bl) {
                this.threadTrueInvoker.set(field, null, object, byArray);
            } else {
                field.set(null, object);
            }
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public void release(Long l) throws Exception {
        if (isLoggingOn) {
            JNBDispatcher.logCall("release", l);
        }
        ObjectRegistry.unregisterObject(l);
    }

    public void addReference(Long l) throws Exception {
        if (isLoggingOn) {
            JNBDispatcher.logCall("addReference", l);
        }
        ObjectRegistry.addReferenceCount(l);
    }

    public JNBValueObject getValue(Long l, Boolean bl) throws Exception {
        if (isLoggingOn) {
            JNBDispatcher.logCall("getValue", l);
        }
        Object object = ObjectRegistry.getObjectFromID(l);
        ObjectRegistry.unregisterObject(l);
        boolean bl2 = bl;
        JNBValueObject jNBValueObject = new JNBValueObject(object, bl2);
        return jNBValueObject;
    }

    public JNBValueObject[] getValueArray(Long[] longArray, Boolean bl) throws Exception {
        JNBValueObject[] jNBValueObjectArray = new JNBValueObject[longArray.length];
        boolean bl2 = bl;
        boolean bl3 = false;
        for (int i = 0; i < longArray.length; ++i) {
            Object object = ObjectRegistry.getObjectFromID(longArray[i]);
            ObjectRegistry.unregisterObject(longArray[i]);
            if (!bl3) {
                ClassRegistry.addByValueClass(object.getClass(), bl2);
                bl3 = true;
            }
            jNBValueObjectArray[i] = new JNBValueObject(object, bl2);
        }
        return jNBValueObjectArray;
    }

    private Method getMethod(Class genericDeclaration, String string, Class[] classArray) throws NoSuchMethodException {
        if (genericDeclaration == null) {
            throw new NoSuchMethodException(string);
        }
        try {
            GenericDeclaration genericDeclaration2;
            if (!Modifier.isPublic(genericDeclaration.getModifiers()) && (genericDeclaration2 = this.getInterface((Class)genericDeclaration, string, classArray)) != null) {
                genericDeclaration = genericDeclaration2;
            }
            genericDeclaration2 = genericDeclaration.getDeclaredMethod(string, classArray);
            return genericDeclaration2;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (genericDeclaration.isInterface()) {
                Class<?>[] classArray2 = genericDeclaration.getInterfaces();
                for (int i = 0; i < classArray2.length; ++i) {
                    try {
                        return this.getMethod(classArray2[i], string, classArray);
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        continue;
                    }
                }
                throw new NoSuchMethodException(string);
            }
            try {
                return this.getMethod(genericDeclaration.getSuperclass(), string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException3) {
                if (JNBDispatcher.runningJava8()) {
                    Class clazz = this.getInterface((Class)genericDeclaration, string, classArray);
                    if (clazz != null) {
                        return clazz.getDeclaredMethod(string, classArray);
                    }
                    throw new NoSuchMethodException(string);
                }
                throw new NoSuchMethodException(string);
            }
        }
    }

    private Field getField(Class clazz, String string) throws NoSuchFieldException {
        if (clazz == null) {
            throw new NoSuchFieldException(string);
        }
        try {
            return clazz.getDeclaredField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            if (clazz.isInterface()) {
                Class<?>[] classArray = clazz.getInterfaces();
                for (int i = 0; i < classArray.length; ++i) {
                    try {
                        return this.getField(classArray[i], string);
                    }
                    catch (NoSuchFieldException noSuchFieldException2) {
                        continue;
                    }
                }
                throw new NoSuchFieldException(string);
            }
            return this.getField(clazz.getSuperclass(), string);
        }
    }

    private Class getInterface(Class clazz, String string, Class[] classArray) {
        if (clazz == null) {
            return null;
        }
        Class<?> clazz2 = null;
        Class<?>[] classArray2 = clazz.getInterfaces();
        for (int i = 0; i < classArray2.length; ++i) {
            try {
                Method method = classArray2[i].getMethod(string, classArray);
                clazz2 = classArray2[i];
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        if (clazz2 != null) {
            return clazz2;
        }
        return this.getInterface(clazz.getSuperclass(), string, classArray);
    }

    private static void logCall(String string, Class clazz, String string2, Object[] objectArray, Object[] objectArray2) {
        int n;
        Logging.logMessage(string + ": targetClass = " + clazz.getName() + ", methodNameName = " + string2);
        if (objectArray != null) {
            Logging.logMessage("\tsignature:");
            for (n = 0; n < objectArray.length; ++n) {
                Logging.logMessage("\t\ti = " + n + ": " + objectArray[n]);
            }
        }
        if (objectArray2 != null) {
            Logging.logMessage("\targs:");
            for (n = 0; n < objectArray2.length; ++n) {
                try {
                    Logging.logMessage("\t\ti = " + n + ": " + objectArray2[n]);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static void logCall(String string, Class clazz, String string2) {
        Logging.logMessage(string + ": targetClass = " + clazz.getName() + ", fieldName = " + string2);
    }

    private static void logCall(String string, Class clazz, String string2, Object object) {
        Logging.logMessage(string + ": targetClass = " + clazz.getName() + ", fieldName = " + string2);
        if (object == null) {
            Logging.logMessage("value = null");
        } else {
            try {
                Logging.logMessage("value = " + object.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void logCall(String string, Long l) {
        Logging.logMessage(string + ": objID = " + l);
    }

    static {
        try {
            m_isDefault = Method.class.getMethod("isDefault", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

