/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore;

import com.jnbridge.jnbcore.DotNetObjectBase;
import com.jnbridge.jnbcore.JavaSideProperties;
import com.jnbridge.jnbcore.JavaSidePropertiesException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class JNBDotNetValueObject {
    private static boolean throwSecurityException;
    private Object m_theObject;

    public JNBDotNetValueObject(Object object) {
        this.m_theObject = object;
    }

    public Object getObject() {
        return this.m_theObject;
    }

    public static Method[] getPublicAndProtectedInstanceMethods(Class clazz) {
        int n;
        Method[] methodArray;
        Method[] methodArray2 = clazz.getMethods();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HashSet<Signature> hashSet = new HashSet<Signature>();
        for (int i = 0; i < methodArray2.length; ++i) {
            methodArray = methodArray2[i];
            arrayList.add(methodArray);
            hashSet.add(new Signature((Method)methodArray));
        }
        for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            methodArray = clazz2.getDeclaredMethods();
            for (n = 0; n < methodArray.length; ++n) {
                Signature signature;
                Method method = methodArray[n];
                if (!Modifier.isProtected(method.getModifiers()) || hashSet.contains(signature = new Signature(method))) continue;
                hashSet.add(signature);
                arrayList.add(method);
            }
        }
        methodArray = new Method[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            methodArray[n] = (Method)arrayList.get(n);
        }
        return methodArray;
    }

    public HashMap getFields() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Method[] methodArray = JNBDotNetValueObject.getPublicAndProtectedInstanceMethods(this.m_theObject.getClass());
        for (int i = 0; i < methodArray.length; ++i) {
            String string = methodArray[i].getName();
            int n = methodArray[i].getModifiers();
            if (!Modifier.isPublic(n) && !Modifier.isProtected(n) || Modifier.isStatic(n) || !JNBDotNetValueObject.isGetter(string) || !JNBDotNetValueObject.hasNoParams(methodArray[i])) continue;
            try {
                Object object;
                if (!methodArray[i].isAccessible()) {
                    methodArray[i].setAccessible(true);
                }
                if ((object = methodArray[i].invoke(this.m_theObject, new Object[0])) != null) {
                    object = DotNetObjectBase.convertArgFromJava(object.getClass().getName(), object);
                }
                hashMap.put(string.substring(4), object);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                continue;
            }
            catch (SecurityException securityException) {
                if (!throwSecurityException) continue;
                throw new SecurityException("Please see http://www.jnbridge.com/jn/kb/?p=275 for information on handling this exception");
            }
        }
        return hashMap;
    }

    private static boolean isGetter(String string) {
        return string.startsWith("Get_") && string.length() > 4;
    }

    private static boolean hasNoParams(Method method) {
        return method.getParameterTypes().length == 0;
    }

    static {
        try {
            if (JavaSideProperties.isPropsFileSet()) {
                JavaSideProperties javaSideProperties = JavaSideProperties.getInstance();
                String string = javaSideProperties.getProperty("javaSide.throwSecurityException");
                if (string == null) {
                    string = System.getProperty("javaSide.throwSecurityException", "true");
                }
                throwSecurityException = string != null && string.equalsIgnoreCase("true");
            } else {
                String string = System.getProperty("javaSide.throwSecurityException", "true");
                throwSecurityException = string != null && string.equalsIgnoreCase("true");
            }
        }
        catch (JavaSidePropertiesException javaSidePropertiesException) {
            String string = System.getProperty("javaSide.throwSecurityException", "true");
            throwSecurityException = string != null && string.equalsIgnoreCase("true");
        }
    }

    public static class Signature {
        private String methodName;
        private int numParams;
        private String[] paramTypes;

        public Signature(String string, int n, String[] stringArray) {
            this.methodName = string;
            this.numParams = n;
            this.paramTypes = stringArray;
        }

        public Signature(Method method) {
            this.methodName = method.getName();
            Class<?>[] classArray = method.getParameterTypes();
            this.numParams = classArray.length;
            this.paramTypes = new String[this.numParams];
            for (int i = 0; i < this.numParams; ++i) {
                this.paramTypes[i] = classArray[i].getName();
            }
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof Signature)) {
                return false;
            }
            Signature signature = (Signature)object;
            if (this.methodName != null && !this.methodName.equals(signature.methodName)) {
                return false;
            }
            if (this.numParams != signature.numParams) {
                return false;
            }
            for (int i = 0; i < this.numParams; ++i) {
                if (this.paramTypes[i].equals(signature.paramTypes[i])) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            if (this.paramTypes == null) {
                return 0;
            }
            return this.paramTypes.hashCode();
        }
    }
}

