/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore;

import com.jnbridge.jnbcore.DebugConstants;
import com.jnbridge.jnbcore.JavaSideProperties;
import com.jnbridge.jnbcore.JavaSidePropertiesException;
import com.jnbridge.jnbcore.MessageKeys;
import com.jnbridge.jnbcore.Messages;
import com.jnbridge.jnbcore.ObjectRegistry;
import com.jnbridge.jnbcore.PropertiesConstants;
import com.jnbridge.jnbcore.licensing.LMConstants;
import com.jnbridge.jnbcore.licensing.LMFactory;
import com.jnbridge.jnbcore.licensing.LicenseManager;
import com.jnbridge.jnbcore.server.Server;
import com.jnbridge.jnbcore.server.ServerException;
import com.jnbridge.jnbcore.server.ServerFactory;
import com.jnbridge.jnbcore.server.ServerFactoryException;
import java.net.SocketPermission;
import java.security.AccessControlException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Properties;

public final class JNBMain
implements LMConstants,
PropertiesConstants,
DebugConstants,
MessageKeys {
    private static Server server;
    private static String propertyFileName;
    private static ArrayList propertyList;
    private static ServerException serverException;
    private static Object serverExceptionLock;

    private JNBMain() {
    }

    public static void main(String[] stringArray) {
        JavaSideProperties javaSideProperties;
        block4: {
            JNBMain.getOptions(stringArray);
            javaSideProperties = null;
            try {
                JavaSideProperties.setPropsFile(propertyFileName);
            }
            catch (JavaSidePropertiesException javaSidePropertiesException) {
                if (propertyList != null) break block4;
                System.out.println(Messages.getString("JNBMAIN_MAIN_1") + " " + javaSidePropertiesException.getMessage());
                return;
            }
        }
        JavaSideProperties.setPropsPairs(propertyList);
        try {
            javaSideProperties = JavaSideProperties.getInstance();
        }
        catch (JavaSidePropertiesException javaSidePropertiesException) {
            System.out.println(Messages.getString("JNBMAIN_MAIN_2") + " " + javaSidePropertiesException.getMessage());
            return;
        }
        JNBMain.runJNBMain(javaSideProperties);
    }

    static void runJNBMain(JavaSideProperties javaSideProperties) {
        LicenseManager licenseManager = LMFactory.getInstance("alpha_lm");
        System.out.println(licenseManager.getLicenseInfo());
        try {
            String string = javaSideProperties.getProperty("javaSide.serverType");
            if (string == null) {
                string = javaSideProperties.getProperty("serverType");
            }
            server = ServerFactory.createServer(string, javaSideProperties, true);
        }
        catch (ServerFactoryException serverFactoryException) {
            System.out.println(Messages.getString("JNBMAIN_RUNJNBMAIN_1") + " " + serverFactoryException.getMessage());
            return;
        }
        try {
            JNBMain.registerSingletons(javaSideProperties);
            server.start();
        }
        catch (AccessControlException accessControlException) {
            Permission permission = accessControlException.getPermission();
            if (permission instanceof SocketPermission) {
                System.out.println(Messages.getString("JNBMAIN_RUNJNBMAIN_2"));
            } else {
                System.out.println(Messages.getString("JNBMAIN_RUNJNBMAIN_3") + " " + accessControlException.getPermission());
            }
        }
        catch (ObjectRegistry.SingletonRegistrationException singletonRegistrationException) {
            System.out.println(Messages.getString("JNBMAIN_RUNJNBMAIN_4"));
        }
        catch (ServerException serverException) {
            System.out.println(Messages.getString("JNBMAIN_RUNJNBMAIN_5") + " " + serverException.getMessage());
        }
        System.out.println(Messages.getString("JNBMAIN_RUNJNBMAIN_6"));
    }

    private static void registerSingletons(JavaSideProperties javaSideProperties) throws ObjectRegistry.SingletonRegistrationException {
        int n = 0;
        String string = javaSideProperties.getProperty("javaSide.singleton" + n);
        String string2 = javaSideProperties.getProperty("javaSide.singletonFactoryMethod" + n, "getInstance");
        while (string != null) {
            ObjectRegistry.createAndRegisterSingleton(string, string2, n);
            string = javaSideProperties.getProperty("javaSide.singleton" + ++n);
            string2 = javaSideProperties.getProperty("javaSide.singletonFactoryMethod" + n, "getInstance");
        }
    }

    private static void getOptions(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            String string;
            if (stringArray[n].equals("/props")) {
                propertyFileName = stringArray[n + 1];
                n += 2;
                continue;
            }
            if (stringArray[n].equals("/p")) {
                string = stringArray[n + 1];
                propertyList.add(string);
                n += 2;
                continue;
            }
            if (!stringArray[n].startsWith("/p")) continue;
            string = stringArray[n].substring(2);
            propertyList.add(string);
            ++n;
        }
    }

    public static void start(Properties properties) throws ServerException {
        JavaSideProperties.setPropsObject(properties);
        JNBMain.start_common();
    }

    public static void start(String string) throws ServerException {
        propertyFileName = string;
        try {
            JavaSideProperties.setPropsFile(string);
            JNBMain.start_common();
        }
        catch (JavaSidePropertiesException javaSidePropertiesException) {
            throw new ServerException(Messages.getString("JNBMAIN_START") + " " + javaSidePropertiesException.getMessage());
        }
    }

    private static void start_common() throws ServerException {
        try {
            JavaSideProperties javaSideProperties = null;
            javaSideProperties = JavaSideProperties.getInstance();
            String string = javaSideProperties.getProperty("javaSide.serverType");
            if (string == null) {
                string = javaSideProperties.getProperty("serverType");
            }
            server = ServerFactory.createServer(string, javaSideProperties, false);
            ServerThread serverThread = new ServerThread();
            serverThread.start();
        }
        catch (JavaSidePropertiesException javaSidePropertiesException) {
            throw new ServerException(Messages.getString("JNBMAIN_START_COMMON_1") + " " + javaSidePropertiesException.getMessage());
        }
        catch (ServerFactoryException serverFactoryException) {
            throw new ServerException(Messages.getString("JNBMAIN_START_COMMON_2") + " " + serverFactoryException.getMessage());
        }
    }

    public static void stop() throws ServerException {
        if (server == null) {
            throw new ServerException(Messages.getString("JNBMAIN_STOP"));
        }
        server.stop();
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerException getServerException() {
        Object object = serverExceptionLock;
        synchronized (object) {
            return serverException;
        }
    }

    static {
        propertyFileName = null;
        propertyList = new ArrayList();
        serverException = null;
        serverExceptionLock = new Object();
    }

    private static class ServerThread
    extends Thread {
        public ServerThread() {
            super("ServerThread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                server.start();
            }
            catch (ServerException serverException) {
                Object object = serverExceptionLock;
                synchronized (object) {
                    JNBMain.serverException = serverException;
                }
            }
        }
    }
}

