/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore;

import com.jnbridge.jnbcore.JNBMainRunner;
import com.jnbridge.jnbcore.JavaSideProperties;
import com.jnbridge.jnbcore.JavaSidePropertiesException;
import com.jnbridge.jnbcore.MessageKeys;
import com.jnbridge.jnbcore.Messages;
import com.jnbridge.jnbcore.ThreadTrueWrapper;
import com.jnbridge.jnbcore.VersionReporter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class JNBServlet
extends HttpServlet
implements MessageKeys {
    Thread mainThread;
    JNBMainRunner mainRunner;

    public void init(ServletConfig servletConfig) throws ServletException {
        JavaSideProperties javaSideProperties = null;
        super.init(servletConfig);
        VersionReporter.needsEE = true;
        System.out.println(Messages.getString("JNBSERVLET_INIT_1"));
        String string = this.getInitParameter("props");
        if (string != null) {
            System.out.println(Messages.getString("JNBSERVLET_INIT_2") + " " + string);
        } else {
            System.out.println(Messages.getString("JNBSERVLET_INIT_3"));
            InputStream inputStream = this.getServletContext().getResourceAsStream("/WEB-INF/jnbcore.properties");
            if (inputStream == null) {
                System.out.println(Messages.getString("JNBSERVLET_INIT_4"));
                return;
            }
            try {
                JavaSideProperties.setResourceStream(inputStream);
                javaSideProperties = JavaSideProperties.getInstance();
            }
            catch (JavaSidePropertiesException javaSidePropertiesException) {
                throw new ServletException(Messages.getString("JNBSERVLET_INIT_5") + " " + javaSidePropertiesException.getMessage());
            }
        }
        this.mainRunner = string != null ? new JNBMainRunner(string) : new JNBMainRunner(javaSideProperties);
        this.mainThread = new Thread((Runnable)this.mainRunner, "JNBMain");
        this.mainThread.start();
    }

    public void destroy() {
        System.out.println(Messages.getString("JNBSERVLET_DESTROY"));
        ThreadTrueWrapper.dispose();
        this.mainRunner.stop();
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.respond(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.respond(httpServletRequest, httpServletResponse);
    }

    private void respond(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.setStatus(200);
        httpServletResponse.setContentType("text/html");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.println("<HTML>");
        printWriter.println("<HEAD><TITLE>JNBServlet</TITLE></HEAD>");
        printWriter.println("<BODY>");
        printWriter.println("<H1>JNBServlet</H1>");
        printWriter.println("<P>" + Messages.getString("JNBSERVLET_RESPOND") + "</P>");
        printWriter.println("</BODY>");
        printWriter.println("</HTML>");
        printWriter.close();
    }
}

