/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore;

import com.jnbridge.jnbcore.ClassRegistry;
import com.jnbridge.jnbcore.JavaSideProperties;
import com.jnbridge.jnbcore.JavaSidePropertiesException;
import com.jnbridge.jnbcore.ObjectRegistry;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class JNBValueObject {
    private Object m_theObject;
    private boolean m_isJavaBean;
    private static boolean throwSecurityException;

    public JNBValueObject(Object object, boolean bl) {
        this.m_theObject = object;
        this.m_isJavaBean = bl;
        ClassRegistry.addByValueClass(object.getClass(), bl);
    }

    public Object getObject() {
        return this.m_theObject;
    }

    public boolean isJavaBean() {
        return this.m_isJavaBean;
    }

    public static Method[] getPublicAndProtectedInstanceMethods(Class clazz) {
        int n;
        Method[] methodArray;
        Method[] methodArray2 = clazz.getMethods();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HashSet<Signature> hashSet = new HashSet<Signature>();
        for (int i = 0; i < methodArray2.length; ++i) {
            methodArray = methodArray2[i];
            arrayList.add(methodArray);
            hashSet.add(new Signature((Method)methodArray));
        }
        for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            methodArray = clazz2.getDeclaredMethods();
            for (n = 0; n < methodArray.length; ++n) {
                Signature signature;
                Method method = methodArray[n];
                if (!Modifier.isProtected(method.getModifiers()) || hashSet.contains(signature = new Signature(method))) continue;
                hashSet.add(signature);
                arrayList.add(method);
            }
        }
        methodArray = new Method[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            methodArray[n] = (Method)arrayList.get(n);
        }
        return methodArray;
    }

    public static Field[] getPublicAndProtectedFields(Class clazz) {
        int n;
        Field[] fieldArray;
        Field[] fieldArray2 = clazz.getFields();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < fieldArray2.length; ++i) {
            fieldArray = fieldArray2[i];
            arrayList.add(fieldArray);
            hashSet.add(fieldArray.getName());
        }
        for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            fieldArray = clazz2.getDeclaredFields();
            for (n = 0; n < fieldArray.length; ++n) {
                String string;
                Field field = fieldArray[n];
                if (!Modifier.isProtected(field.getModifiers()) || hashSet.contains(string = field.getName())) continue;
                hashSet.add(string);
                arrayList.add(field);
            }
        }
        fieldArray = new Field[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            fieldArray[n] = (Field)arrayList.get(n);
        }
        return fieldArray;
    }

    public HashMap getFields(boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (!this.m_isJavaBean) {
            Field[] fieldArray = JNBValueObject.getPublicAndProtectedFields(this.m_theObject.getClass());
            for (int i = 0; i < fieldArray.length; ++i) {
                int n = fieldArray[i].getModifiers();
                if (!Modifier.isPublic(n) && !Modifier.isProtected(n)) continue;
                String string = fieldArray[i].getName();
                try {
                    if (!fieldArray[i].isAccessible()) {
                        fieldArray[i].setAccessible(true);
                    }
                    Object object = fieldArray[i].get(this.m_theObject);
                    if (!fieldArray[i].getType().isPrimitive()) {
                        object = ObjectRegistry.registerObject(object, bl);
                    }
                    hashMap.put(string, object);
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    continue;
                }
                catch (SecurityException securityException) {
                    if (!throwSecurityException) continue;
                    throw new SecurityException("Please see http://www.jnbridge.com/jn/kb/?p=275 for information on handling this exception");
                }
            }
        } else {
            Method[] methodArray = JNBValueObject.getPublicAndProtectedInstanceMethods(this.m_theObject.getClass());
            for (int i = 0; i < methodArray.length; ++i) {
                String string = methodArray[i].getName();
                int n = methodArray[i].getModifiers();
                if (!Modifier.isPublic(n) && !Modifier.isProtected(n) || Modifier.isStatic(n) || !JNBValueObject.isGetter(string) || !JNBValueObject.hasNoParams(methodArray[i])) continue;
                try {
                    if (!methodArray[i].isAccessible()) {
                        methodArray[i].setAccessible(true);
                    }
                    Object object = methodArray[i].invoke(this.m_theObject, new Object[0]);
                    if (!methodArray[i].getReturnType().isPrimitive()) {
                        object = ObjectRegistry.registerObject(object, bl);
                    }
                    hashMap.put(string.substring(3), object);
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    continue;
                }
                catch (InvocationTargetException invocationTargetException) {
                    continue;
                }
                catch (SecurityException securityException) {
                    if (!throwSecurityException) continue;
                    throw new SecurityException("Please see http://www.jnbridge.com/jn/kb/?p=275 for information on handling this exception");
                }
            }
        }
        return hashMap;
    }

    private static boolean isGetter(String string) {
        return string.startsWith("get") && string.length() > 3;
    }

    private static boolean hasNoParams(Method method) {
        return method.getParameterTypes().length == 0;
    }

    static {
        try {
            if (JavaSideProperties.isPropsFileSet()) {
                JavaSideProperties javaSideProperties = JavaSideProperties.getInstance();
                String string = javaSideProperties.getProperty("javaSide.throwSecurityException");
                if (string == null) {
                    string = System.getProperty("javaSide.throwSecurityException", "true");
                }
                throwSecurityException = string != null && string.equalsIgnoreCase("true");
            } else {
                String string = System.getProperty("javaSide.throwSecurityException", "true");
                throwSecurityException = string != null && string.equalsIgnoreCase("true");
            }
        }
        catch (JavaSidePropertiesException javaSidePropertiesException) {
            String string = System.getProperty("javaSide.throwSecurityException", "true");
            throwSecurityException = string != null && string.equalsIgnoreCase("true");
        }
    }

    public static class Signature {
        private String methodName;
        private int numParams;
        private String[] paramTypes;

        public Signature(String string, int n, String[] stringArray) {
            this.methodName = string;
            this.numParams = n;
            this.paramTypes = stringArray;
        }

        public Signature(Method method) {
            this.methodName = method.getName();
            Class<?>[] classArray = method.getParameterTypes();
            this.numParams = classArray.length;
            this.paramTypes = new String[this.numParams];
            for (int i = 0; i < this.numParams; ++i) {
                this.paramTypes[i] = classArray[i].getName();
            }
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof Signature)) {
                return false;
            }
            Signature signature = (Signature)object;
            if (this.methodName != null && !this.methodName.equals(signature.methodName)) {
                return false;
            }
            if (this.numParams != signature.numParams) {
                return false;
            }
            for (int i = 0; i < this.numParams; ++i) {
                if (this.paramTypes[i].equals(signature.paramTypes[i])) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            if (this.paramTypes == null) {
                return 0;
            }
            return this.paramTypes.hashCode();
        }
    }
}

