/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore;

import com.jnbridge.jnbcore.AbstractJavaProxyClass;
import com.jnbridge.jnbcore.ByValueConstants;
import com.jnbridge.jnbcore.ClassNameConstants;
import com.jnbridge.jnbcore.DotNetArgTypeConverter;
import com.jnbridge.jnbcore.DotNetArgTypeConverterJ2N;
import com.jnbridge.jnbcore.DotNetClassRegistry;
import com.jnbridge.jnbcore.JavaProxyBridgeMethod;
import com.jnbridge.jnbcore.JavaProxyConstructor;
import com.jnbridge.jnbcore.JavaProxyEnum;
import com.jnbridge.jnbcore.JavaProxyEvent;
import com.jnbridge.jnbcore.JavaProxyField;
import com.jnbridge.jnbcore.JavaProxyMethod;
import com.jnbridge.jnbcore.JavaProxyMethodGetDotNetClass;
import com.jnbridge.jnbcore.JavaProxyMethodToString;
import com.jnbridge.jnbcore.JavaProxyProperty;
import com.jnbridge.jnbcore.JavaProxyStaticInitializer;
import com.jnbridge.org.apache.bcel.Constants;
import com.jnbridge.org.apache.bcel.generic.FieldGen;
import com.jnbridge.org.apache.bcel.generic.ObjectType;
import com.jnbridge.org.apache.bcel.generic.Type;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;

public class JavaProxyClass
extends AbstractJavaProxyClass
implements Constants,
ClassNameConstants,
ByValueConstants {
    private static final String CONVERTARGSFROMJAVA = "convertArgsFromJava";
    private static final String DOTNETTYPE = "dotNetType";
    private static final String DOTNETSIDEPROXY = "dotNetSideProxy";
    private static final String IDOTNETSIDEPROXY = "com.jnbridge.jnbcore.IDotNetSideProxy";
    private static final String REGISTER = "register";
    private static final String CONSTRUCT = "construct";
    private static final String OBJMAP = "objMap";
    private static final String THROWEXCEPTION = "throwException";
    private static final String EXCEPTIONFACTORY = "com.jnbridge.jnbcore.ExceptionFactory";
    private static final String CLASS0 = "class$0";
    private static final ObjectType IDOTNETSIDEPROXY_TYPE = new ObjectType("com.jnbridge.jnbcore.IDotNetSideProxy");
    private static final ObjectType JNBDOTNETOBJID_TYPE = new ObjectType("com.jnbridge.jnbcore.JNBDotNetObjID");
    private static final ObjectType JNBEXCEPTION_TYPE = new ObjectType("com.jnbridge.jnbcore.JNBException");
    private static final ObjectType HASHTABLE_TYPE = new ObjectType("java.util.Hashtable");
    private static final ObjectType RUNTIMEEXCEPTION_TYPE = new ObjectType("java.lang.RuntimeException");
    private static final ObjectType THROWABLE_TYPE = new ObjectType("java.lang.Throwable");
    private static final ObjectType CLASS_TYPE = new ObjectType("java.lang.Class");
    private static final String[] ENUM_PROXY_MARKER = new String[]{"com.jnbridge.jnbcore.EnumProxyMarker"};
    private int byValueCode = -1;
    private static final Object TRUE = new Object();
    private static final Object FALSE = new Object();
    private static Hashtable isInClasspath = new Hashtable();
    JavaProxyStaticInitializer jpsi = null;
    private static HashSet definedMethods = new HashSet();

    private static boolean alreadyInClasspath(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            Object v = isInClasspath.get(stringArray[i]);
            if (v == FALSE) {
                return false;
            }
            if (v != null) continue;
            try {
                Class<?> clazz = Class.forName(stringArray[i], false, Thread.currentThread().getContextClassLoader());
                isInClasspath.put(stringArray[i], TRUE);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                isInClasspath.put(stringArray[i], FALSE);
                return false;
            }
        }
        return true;
    }

    public JavaProxyClass(String string, String string2, String[] stringArray, String[] stringArray2, boolean[] blArray, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, String[] stringArray3, boolean bl6) {
        super(string, bl3 && bl5 ? "java.lang.Enum" : string2, bl3 && bl5 ? ENUM_PROXY_MARKER : stringArray, stringArray2, blArray, bl, false, bl2, bl3, bl4, bl5, bl6);
        if (bl3 && bl5) {
            this.createJavaProxyEnum(stringArray3);
        } else {
            if (this.byValueCode == -1) {
                this.byValueCode = DotNetClassRegistry.getByValueCode(string);
            }
            this.createDotNetTypeField(bl2);
            this.createClassField();
            this.createInternalConstructors();
            this.createGetDotNetClass();
            if (this.byValueCode == 0) {
                this.createToString();
            }
            if (this.byValueCode == 3) {
                FieldGen fieldGen = new FieldGen(1, DotNetArgTypeConverterJ2N.convertMappedCollection(string), "NativeImpl", this.cp);
                this.cg.addField(fieldGen.getField());
            }
        }
    }

    public JavaProxyClass(String string, String[] stringArray, String[] stringArray2, boolean[] blArray, boolean bl, boolean bl2, boolean bl3) {
        super(string, "java.lang.Object", stringArray, stringArray2, blArray, true, true, bl, bl2, bl3);
        if (this.byValueCode == -1) {
            this.byValueCode = DotNetClassRegistry.getByValueCode(string);
        }
    }

    private void createDotNetTypeField(boolean bl) {
        String string = bl ? this.name.substring(0, this.name.length() - HELPER_LEN) : this.name;
        FieldGen fieldGen = new FieldGen(26, (Type)Type.STRING, DOTNETTYPE, this.cp);
        fieldGen.setInitValue(DotNetArgTypeConverter.convertToDotNet(string));
        this.cg.addField(fieldGen.getField());
    }

    private void createClassField() {
        FieldGen fieldGen = new FieldGen(10, (Type)CLASS_TYPE, CLASS0, this.cp);
        this.cg.addField(fieldGen.getField());
    }

    private void createGetDotNetClass() {
        JavaProxyMethodGetDotNetClass javaProxyMethodGetDotNetClass = new JavaProxyMethodGetDotNetClass(this.cg, this.cp, this.factory);
    }

    private void createToString() {
        JavaProxyMethodToString javaProxyMethodToString = new JavaProxyMethodToString(this.cg, this.cp, this.factory);
    }

    private void createInternalConstructors() {
        JavaProxyConstructor.createInternalConstructors(this.cg, this.cp, this.factory, this.name, this.parent);
    }

    private void createJavaProxyEnum(String[] stringArray) {
        JavaProxyEnum.generateEnum(this.cg, this.cp, this.factory, DotNetArgTypeConverter.convertNested(this.name), stringArray);
    }

    public void addToStaticInitializer(FieldGen fieldGen, String string, String string2) {
        if (!DotNetClassRegistry.isPresent(string2)) {
            return;
        }
        if (this.jpsi == null) {
            this.jpsi = new JavaProxyStaticInitializer();
        }
        this.jpsi.addToStaticInitializer(fieldGen, string, string2);
    }

    public ByteArrayOutputStream bake() throws IOException {
        if (this.jpsi != null) {
            this.jpsi.close(this.cg, this.cp, this.factory);
        }
        return super.bake();
    }

    public boolean addConstructor(String[] stringArray, String[] stringArray2, boolean bl, boolean bl2, boolean bl3) {
        return this.addConstructor(stringArray, stringArray2, bl, bl3);
    }

    public boolean addConstructor(String[] stringArray, String[] stringArray2, boolean bl, boolean bl2) {
        String[] stringArray3 = DotNetArgTypeConverter.convertNested(stringArray);
        if (this.byValueCode == -1) {
            this.byValueCode = DotNetClassRegistry.getByValueCode(this.name);
        }
        JavaProxyConstructor javaProxyConstructor = new JavaProxyConstructor(this.cg, this.cp, this.factory, stringArray3, stringArray2, this.byValueCode, bl, bl2);
        return javaProxyConstructor.wasSuccessful;
    }

    public boolean addField(String string, String string2, String[] stringArray, String string3, int n) {
        if (this.byValueCode == -1) {
            this.byValueCode = DotNetClassRegistry.getByValueCode(this.name);
        }
        return JavaProxyField.generateField(this.cg, this.cp, this.factory, stringArray, string, DotNetArgTypeConverter.convertNested(string2), string3, this, this.byValueCode, n);
    }

    public boolean addMethod(String[] stringArray, String string, String[] stringArray2, String[] stringArray3, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean[] blArray) {
        return this.addMethod(stringArray, string, stringArray2, stringArray3, string2, bl, bl3, bl4, blArray);
    }

    public boolean addMethod(String[] stringArray, String string, String[] stringArray2, String[] stringArray3, String string2, boolean bl, boolean bl2, boolean bl3, boolean[] blArray) {
        if (this.byValueCode == -1) {
            this.byValueCode = DotNetClassRegistry.getByValueCode(this.name);
        }
        JavaProxyMethod javaProxyMethod = new JavaProxyMethod(this.cg, this.cp, this.factory, JavaProxyClass.isStatic(stringArray), JavaProxyClass.isAbstract(stringArray), string, DotNetArgTypeConverter.convertNested(stringArray2), stringArray3, DotNetArgTypeConverter.convertNested(string2), this.byValueCode, bl, bl2, bl3, blArray);
        return javaProxyMethod.wasSuccessful;
    }

    public boolean addBridgeMethod(String string, String[] stringArray, String[] stringArray2, String string2, String string3, boolean bl, boolean bl2, boolean[] blArray) {
        JavaProxyBridgeMethod javaProxyBridgeMethod = new JavaProxyBridgeMethod(this.cg, this.cp, this.factory, string, DotNetArgTypeConverter.convertNested(stringArray), stringArray2, DotNetArgTypeConverter.convertNested(string2), DotNetArgTypeConverter.convertNested(string3), bl, bl2, blArray);
        return javaProxyBridgeMethod.wasSuccessful;
    }

    public boolean addProperty(String[] stringArray, String string, String string2, boolean bl, boolean bl2, String[] stringArray2, String[] stringArray3, int n, boolean bl3, boolean bl4) {
        return this.addProperty(stringArray, string, string2, bl, bl2, stringArray2, stringArray3, n, bl3);
    }

    public boolean addProperty(String[] stringArray, String string, String string2, boolean bl, boolean bl2, String[] stringArray2, String[] stringArray3, int n, boolean bl3) {
        if (this.byValueCode == -1) {
            this.byValueCode = DotNetClassRegistry.getByValueCode(this.name);
        }
        return JavaProxyProperty.generateProperty(this.cg, this.cp, this.factory, stringArray, string, DotNetArgTypeConverter.convertNested(string2), bl, bl2, DotNetArgTypeConverter.convertNested(stringArray2), stringArray3, this.byValueCode, bl3, n);
    }

    public boolean addEvent(String[] stringArray, String string, String string2, boolean bl, boolean bl2, int n) {
        if (this.byValueCode == -1) {
            this.byValueCode = DotNetClassRegistry.getByValueCode(this.name);
        }
        return JavaProxyEvent.generateEvent(this.cg, this.cp, this.factory, stringArray, string, DotNetArgTypeConverter.convertNested(string2), this, bl, bl2, this.byValueCode, n);
    }

    private static boolean isStatic(String[] stringArray) {
        return JavaProxyClass.contains(stringArray, "static");
    }

    private static boolean isAbstract(String[] stringArray) {
        return JavaProxyClass.contains(stringArray, "abstract");
    }

    private static boolean contains(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetDefinedMethods() {
        HashSet hashSet = definedMethods;
        synchronized (hashSet) {
            definedMethods.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAlreadyDefined(String string, String string2, String[] stringArray, ClassLoader classLoader) {
        HashSet hashSet = definedMethods;
        synchronized (hashSet) {
            return definedMethods.contains(new Signature(string, string2, stringArray, classLoader));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void definedMethod(String string, String string2, String[] stringArray, ClassLoader classLoader) {
        Signature signature = new Signature(string, string2, stringArray, classLoader);
        HashSet hashSet = definedMethods;
        synchronized (hashSet) {
            definedMethods.add(signature);
        }
    }

    public int getByValueCode() {
        return DotNetClassRegistry.getByValueCode(this.name);
    }

    private static class Signature {
        private String m_className;
        private String m_methodName;
        private String[] m_paramClasses;
        private ClassLoader m_classLoader;

        public Signature(String string, String string2, String[] stringArray, ClassLoader classLoader) {
            this.m_className = string;
            this.m_methodName = string2;
            this.m_paramClasses = DotNetArgTypeConverter.convertToJavaType(stringArray);
            this.m_classLoader = classLoader;
        }

        public String toString() {
            String string = this.m_className + "." + this.m_methodName + "(";
            for (int i = 0; i < this.m_paramClasses.length; ++i) {
                string = string + this.m_paramClasses[i];
                if (i >= this.m_paramClasses.length - 1) continue;
                string = string + ", ";
            }
            string = string + ")";
            return string;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof Signature)) {
                return false;
            }
            Signature signature = (Signature)object;
            if (!this.m_className.equals(signature.m_className)) {
                return false;
            }
            if (!this.m_methodName.equals(signature.m_methodName)) {
                return false;
            }
            if (this.m_paramClasses.length != signature.m_paramClasses.length) {
                return false;
            }
            for (int i = 0; i < this.m_paramClasses.length; ++i) {
                if (this.m_paramClasses[i].equals(signature.m_paramClasses[i])) continue;
                return false;
            }
            return this.m_classLoader == signature.m_classLoader;
        }

        public int hashCode() {
            return this.m_className.hashCode();
        }
    }
}

