/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore;

import com.jnbridge.jnbcore.DotNetArgTypeConverterJ2N;
import com.jnbridge.org.apache.bcel.generic.FieldGen;
import com.jnbridge.org.apache.bcel.generic.Type;

abstract class JavaProxyFieldHelpers {
    JavaProxyFieldHelpers() {
    }

    static boolean isStatic(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("static")) continue;
            return true;
        }
        return false;
    }

    static boolean isFinal(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("final") && !stringArray[i].equals("initOnly") && !stringArray[i].equals("literal")) continue;
            return true;
        }
        return false;
    }

    static boolean isInitOnly(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("initOnly")) continue;
            return true;
        }
        return false;
    }

    static boolean isLiteral(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("literal")) continue;
            return true;
        }
        return false;
    }

    static boolean isProtected(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("protected")) continue;
            return true;
        }
        return false;
    }

    static boolean isPublic(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("public")) continue;
            return true;
        }
        return false;
    }

    static void setFieldInitValue(FieldGen fieldGen, String string, String string2) {
        block30: {
            Type type = DotNetArgTypeConverterJ2N.convertOneArgType(string);
            if (type == Type.STRING && string2 == null) {
                fieldGen.setInitValue(null);
                return;
            }
            if (type == Type.BOOLEAN) {
                boolean bl = Boolean.valueOf(string2);
                fieldGen.setInitValue(bl);
            } else if (type == Type.BYTE) {
                byte by = Byte.valueOf(string2);
                fieldGen.setInitValue(by);
            } else if (type == Type.CHAR) {
                try {
                    int n = Integer.parseInt(string2);
                    fieldGen.setInitValue((char)n);
                }
                catch (NullPointerException nullPointerException) {
                    System.out.println(nullPointerException);
                }
            } else if (type == Type.DOUBLE) {
                try {
                    double d = Double.valueOf(string2);
                    fieldGen.setInitValue(d);
                }
                catch (NumberFormatException numberFormatException) {
                    if ("Infinity".equals(string2)) {
                        fieldGen.setInitValue(Double.POSITIVE_INFINITY);
                        break block30;
                    }
                    if ("-Infinity".equals(string2)) {
                        fieldGen.setInitValue(Double.NEGATIVE_INFINITY);
                        break block30;
                    }
                    if ("NaN".equals(string2)) {
                        fieldGen.setInitValue(Double.NaN);
                        break block30;
                    }
                    double d = Double.valueOf(JavaProxyFieldHelpers.reverseCommasPeriods(string2));
                    fieldGen.setInitValue(d);
                }
            } else if (type == Type.FLOAT) {
                try {
                    float f = Float.valueOf(string2).floatValue();
                    fieldGen.setInitValue(f);
                }
                catch (NumberFormatException numberFormatException) {
                    if ("Infinity".equals(string2)) {
                        fieldGen.setInitValue(Float.POSITIVE_INFINITY);
                        break block30;
                    }
                    if ("-Infinity".equals(string2)) {
                        fieldGen.setInitValue(Float.NEGATIVE_INFINITY);
                        break block30;
                    }
                    if ("NaN".equals(string2)) {
                        fieldGen.setInitValue(Float.NaN);
                        break block30;
                    }
                    float f = Float.valueOf(JavaProxyFieldHelpers.reverseCommasPeriods(string2)).floatValue();
                    fieldGen.setInitValue(f);
                }
            } else if (type == Type.INT) {
                int n = Integer.valueOf(string2);
                fieldGen.setInitValue(n);
            } else if (type == Type.LONG) {
                long l = Long.valueOf(string2);
                fieldGen.setInitValue(l);
            } else if (type == Type.SHORT) {
                short s = Short.valueOf(string2);
                fieldGen.setInitValue(s);
            } else if (type == Type.STRING) {
                fieldGen.setInitValue(string2);
            }
        }
    }

    private static String reverseCommasPeriods(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ',') {
                stringBuffer.setCharAt(i, '.');
                continue;
            }
            if (c != '.') continue;
            stringBuffer.setCharAt(i, ',');
        }
        return stringBuffer.toString();
    }
}

