/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore;

import com.jnbridge.jnbcore.JavaSidePropertiesException;
import com.jnbridge.jnbcore.MessageKeys;
import com.jnbridge.jnbcore.Messages;
import com.jnbridge.jnbcore.PropertiesConstants;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;

public class JavaSideProperties
implements PropertiesConstants,
MessageKeys {
    private static JavaSideProperties theInstance = null;
    private Properties props;

    public static JavaSideProperties getInstance() throws JavaSidePropertiesException {
        if (theInstance == null) {
            throw new JavaSidePropertiesException(Messages.getString("JAVASIDEPROPERTIES_GETINSTANCE"));
        }
        return theInstance;
    }

    public static boolean isPropsFileSet() {
        return theInstance != null;
    }

    public static void setPropsFile(String string) throws JavaSidePropertiesException {
        try {
            theInstance = new JavaSideProperties(string);
        }
        catch (IOException iOException) {
            throw new JavaSidePropertiesException(iOException.getMessage());
        }
    }

    public static void setPropsObject(Properties properties) {
        theInstance = new JavaSideProperties(properties);
    }

    public static void setResourceStream(InputStream inputStream) throws JavaSidePropertiesException {
        try {
            theInstance = new JavaSideProperties(inputStream);
        }
        catch (IOException iOException) {
            throw new JavaSidePropertiesException(iOException.getMessage());
        }
    }

    public static void setPropsPairs(ArrayList arrayList) {
        if (theInstance == null) {
            theInstance = new JavaSideProperties();
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            theInstance.addPropsPair(string);
        }
    }

    private JavaSideProperties() {
        this.props = new Properties();
    }

    private JavaSideProperties(Properties properties) {
        this.props = properties;
    }

    private JavaSideProperties(String string) throws IOException {
        this.props = new Properties();
        File file = null;
        file = string != null ? new File(string) : new File(System.getProperty("user.dir") + File.separator + "jnbcore.properties");
        file = file.getCanonicalFile();
        if (!file.exists()) {
            throw new FileNotFoundException(Messages.getString("DOTNETSIDE_GETPROPERTIES_2") + " " + string);
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        this.props.load(bufferedInputStream);
        ((InputStream)bufferedInputStream).close();
    }

    private JavaSideProperties(InputStream inputStream) throws IOException {
        this.props = new Properties();
        this.props.load(inputStream);
    }

    private void addPropsPair(String string) {
        int n = string.indexOf("=");
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 1).trim();
        this.props.put(string2, string3);
    }

    public String getProperty(String string) {
        return this.props.getProperty(string);
    }

    public String getProperty(String string, String string2) {
        return this.props.getProperty(string, string2);
    }

    public String[] getAssemblyList() throws JavaSidePropertiesException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.props.keys();
        while (stringArray.hasMoreElements()) {
            String string = (String)stringArray.nextElement();
            if (!string.startsWith("dotNetSide.assemblyList")) continue;
            arrayList.add(this.props.getProperty(string));
        }
        stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    public static String[] getAppServerPropertyList() throws JavaSidePropertiesException {
        Properties properties = null;
        try {
            JavaSideProperties javaSideProperties = JavaSideProperties.getInstance();
            properties = javaSideProperties.props;
        }
        catch (JavaSidePropertiesException javaSidePropertiesException) {
            properties = System.getProperties();
        }
        return JavaSideProperties.getAppServerPropertyList(properties);
    }

    private static String[] getAppServerPropertyList(Properties properties) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = properties.keys();
        while (stringArray.hasMoreElements()) {
            String string = (String)stringArray.nextElement();
            if (!string.startsWith("javaSide.appServerJNDIProperty")) continue;
            arrayList.add(properties.getProperty(string));
        }
        stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    public static String getFromPropertiesOrSystem(String string) throws JavaSidePropertiesException {
        try {
            JavaSideProperties javaSideProperties = JavaSideProperties.getInstance();
            String string2 = javaSideProperties.getProperty(string);
            if (string2 == null) {
                string2 = System.getProperty(string);
            }
            return string2;
        }
        catch (JavaSidePropertiesException javaSidePropertiesException) {
            String string3 = System.getProperty(string);
            if (string3 == null) {
                throw javaSidePropertiesException;
            }
            return string3;
        }
    }

    public static String getFromPropertiesOrSystem(String string, String string2) {
        try {
            JavaSideProperties javaSideProperties = JavaSideProperties.getInstance();
            String string3 = javaSideProperties.getProperty(string);
            if (string3 == null) {
                string3 = System.getProperty(string, string2);
            }
            return string3;
        }
        catch (JavaSidePropertiesException javaSidePropertiesException) {
            return System.getProperty(string, string2);
        }
    }
}

