/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore;

import com.jnbridge.jnbcore.ClassHelper;
import com.jnbridge.jnbcore.ClassRegistry;
import com.jnbridge.jnbcore.ComponentInfo;
import com.jnbridge.jnbcore.DebugConstants;
import com.jnbridge.jnbcore.DotNetWrapper;
import com.jnbridge.jnbcore.EqWrapper;
import com.jnbridge.jnbcore.JNBArrayWrapper;
import com.jnbridge.jnbcore.JNBObjID;
import com.jnbridge.jnbcore.JNBValueObject;
import com.jnbridge.jnbcore.JavaSideProperties;
import com.jnbridge.jnbcore.JavaSidePropertiesException;
import com.jnbridge.jnbcore.java50.EnumInfo;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.dgc.VMID;
import java.util.Hashtable;
import java.util.Vector;

public final class ObjectRegistry
implements DebugConstants {
    static long vmid = new VMID().hashCode();
    private static long objIDCounter;
    private static Object objIDCounterLock;
    private static Hashtable objIDMap;
    private static Hashtable revObjIDMap;
    private static Vector doNow;
    private static Vector doSoon;
    private static Vector doLater;
    private static Object vectorLock;
    private static Hashtable addNow;
    private static Object addNowLock;
    static long releaserDelay;
    private static ReleaserThread releaser;
    private static Class[] emptyClasses;
    private static Object[] emptyObjects;

    static void createAndRegisterSingleton(String string, String string2, int n) throws SingletonRegistrationException {
        try {
            Class clazz = ClassHelper.forName(string);
            Method method = clazz.getMethod(string2, emptyClasses);
            Object object = method.invoke(null, emptyObjects);
            ObjectRegistry.registerSingletonObject(object, n);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SingletonRegistrationException();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new SingletonRegistrationException();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SingletonRegistrationException();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SingletonRegistrationException();
        }
    }

    private static void registerSingletonObject(Object object, long l) throws SingletonRegistrationException {
        if (object == null || object instanceof String || object.getClass().isArray()) {
            throw new SingletonRegistrationException();
        }
        Class<?> clazz = object.getClass();
        String string = clazz.getName();
        JNBObjID jNBObjID = new JNBObjID(l, string);
        ClassRegistry.registerClass(string, clazz);
        objIDMap.put(jNBObjID, new ReferenceCountWrapper(object));
        revObjIDMap.put(new EqWrapper(object), jNBObjID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object registerObject(Object object, boolean bl) {
        if (object == null) {
            return object;
        }
        if (object instanceof String) {
            return object;
        }
        if (bl && EnumInfo.isEnum(object.getClass())) {
            return object;
        }
        if (object instanceof DotNetWrapper) {
            Object object2 = ((DotNetWrapper)object).getWrappedValue();
            return ObjectRegistry.registerObject(object2, bl);
        }
        if (object.getClass().isArray()) {
            int n;
            String string;
            String string2 = null;
            ComponentInfo componentInfo = ObjectRegistry.getComponentInfo(object);
            if (componentInfo.baseType.isPrimitive() || componentInfo.baseType == String.class || bl && EnumInfo.isEnum(componentInfo.baseType)) {
                return object;
            }
            string2 = string = object.getClass().getName();
            if ((string = string.substring(1)).charAt(0) != '[') {
                string = "java.lang.Object";
            } else {
                n = string.indexOf(76);
                string = string.substring(0, n + 1) + "java.lang.Object;";
            }
            n = Array.getLength(object);
            Class clazz = null;
            try {
                clazz = ClassRegistry.getClass(string, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            Object object3 = Array.newInstance(clazz, n);
            for (int i = 0; i < n; ++i) {
                Object object4 = ObjectRegistry.registerObject(Array.get(object, i), bl);
                if (object4 instanceof JNBArrayWrapper) {
                    object4 = ((JNBArrayWrapper)object4).getArray();
                }
                Array.set(object3, i, object4);
            }
            if (string2 == null) {
                return object3;
            }
            return new JNBArrayWrapper(string2, object3);
        }
        if (ClassRegistry.isByValueClass(object.getClass())) {
            boolean bl2 = ClassRegistry.isJavaBeanClass(object.getClass());
            return new JNBValueObject(object, bl2);
        }
        Object object5 = objIDCounterLock;
        synchronized (object5) {
            JNBObjID jNBObjID;
            Class<?> clazz = vectorLock;
            synchronized (clazz) {
                jNBObjID = (JNBObjID)revObjIDMap.get(new EqWrapper(object));
                if (jNBObjID != null) {
                    ObjectRegistry.removeFromReleaseQueue(jNBObjID);
                    return jNBObjID;
                }
            }
            long l = objIDCounter++;
            clazz = object.getClass();
            String string = clazz.getName();
            jNBObjID = new JNBObjID(l, string);
            ClassRegistry.registerClass(string, clazz);
            objIDMap.put(jNBObjID, new ReferenceCountWrapper(object));
            revObjIDMap.put(new EqWrapper(object), jNBObjID);
            ObjectRegistry.addReferenceCount(new Long(l));
            return new JNBObjID(l, "*" + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getObjectFromID(String string) {
        Object object;
        JNBObjID jNBObjID = new JNBObjID(string, null);
        if (jNBObjID.isNull()) {
            return null;
        }
        Object object2 = vectorLock;
        synchronized (object2) {
            object = objIDMap.get(jNBObjID);
            if (object == null) {
                ReferenceCountWrapper referenceCountWrapper = ObjectRegistry.retrieveFromReleaseQueue(jNBObjID);
                if (referenceCountWrapper == null) {
                    return null;
                }
                object = referenceCountWrapper.getObject();
            } else {
                object = ((ReferenceCountWrapper)object).getObject();
                ObjectRegistry.removeFromReleaseQueue(jNBObjID);
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getObjectFromID(Long l) {
        Object object;
        JNBObjID jNBObjID = new JNBObjID(l, null);
        if (jNBObjID.isNull()) {
            return null;
        }
        Object object2 = vectorLock;
        synchronized (object2) {
            object = objIDMap.get(jNBObjID);
            if (object == null) {
                ReferenceCountWrapper referenceCountWrapper = ObjectRegistry.retrieveFromReleaseQueue(jNBObjID);
                if (referenceCountWrapper == null) {
                    return null;
                }
                object = referenceCountWrapper.getObject();
            } else {
                object = ((ReferenceCountWrapper)object).getObject();
                ObjectRegistry.removeFromReleaseQueue(jNBObjID);
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getObjectFromID(JNBObjID jNBObjID) {
        Object object;
        if (jNBObjID.isNull()) {
            return null;
        }
        Object object2 = vectorLock;
        synchronized (object2) {
            object = objIDMap.get(jNBObjID);
            if (object == null) {
                ReferenceCountWrapper referenceCountWrapper = ObjectRegistry.retrieveFromReleaseQueue(jNBObjID);
                if (referenceCountWrapper == null) {
                    return null;
                }
                object = referenceCountWrapper.getObject();
            } else {
                object = ((ReferenceCountWrapper)object).getObject();
                ObjectRegistry.removeFromReleaseQueue(jNBObjID);
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addReferenceCount(String string) {
        ReferenceCountWrapper referenceCountWrapper;
        JNBObjID jNBObjID = new JNBObjID(string, null);
        ReferenceCountWrapper referenceCountWrapper2 = referenceCountWrapper = (ReferenceCountWrapper)objIDMap.get(jNBObjID);
        synchronized (referenceCountWrapper2) {
            if (referenceCountWrapper == null) {
                referenceCountWrapper = ObjectRegistry.retrieveFromReleaseQueue(jNBObjID);
            }
            referenceCountWrapper.incrementRefCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addReferenceCount(Long l) {
        ReferenceCountWrapper referenceCountWrapper;
        JNBObjID jNBObjID = new JNBObjID(l, null);
        ReferenceCountWrapper referenceCountWrapper2 = referenceCountWrapper = (ReferenceCountWrapper)objIDMap.get(jNBObjID);
        synchronized (referenceCountWrapper2) {
            if (referenceCountWrapper == null) {
                referenceCountWrapper = ObjectRegistry.retrieveFromReleaseQueue(jNBObjID);
            }
            referenceCountWrapper.incrementRefCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterObject(String string) throws Exception {
        JNBObjID jNBObjID = new JNBObjID(string, null);
        ReferenceCountWrapper referenceCountWrapper = (ReferenceCountWrapper)objIDMap.get(jNBObjID);
        if (referenceCountWrapper == null) {
            return;
        }
        ReferenceCountWrapper referenceCountWrapper2 = referenceCountWrapper;
        synchronized (referenceCountWrapper2) {
            referenceCountWrapper.decrementRefCount();
            if (referenceCountWrapper.noMoreReferences()) {
                ObjectRegistry.queueForRelease(jNBObjID);
            }
        }
        Thread.yield();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterObject(Long l) throws Exception {
        JNBObjID jNBObjID = new JNBObjID(l, null);
        ReferenceCountWrapper referenceCountWrapper = (ReferenceCountWrapper)objIDMap.get(jNBObjID);
        if (referenceCountWrapper == null) {
            return;
        }
        ReferenceCountWrapper referenceCountWrapper2 = referenceCountWrapper;
        synchronized (referenceCountWrapper2) {
            referenceCountWrapper.decrementRefCount();
            if (referenceCountWrapper.noMoreReferences()) {
                ObjectRegistry.queueForRelease(jNBObjID);
            }
        }
        Thread.yield();
    }

    public static JNBObjID getObjectID(Object object) {
        return (JNBObjID)ObjectRegistry.registerObject(object, true);
    }

    private static ComponentInfo getComponentInfo(Object object) {
        Class<?> clazz = object.getClass();
        byte by = 0;
        while (clazz.isArray()) {
            by = (byte)(by + 1);
            clazz = clazz.getComponentType();
        }
        Class<?> clazz2 = clazz;
        return new ComponentInfo(by, clazz2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void queueForRelease(JNBObjID jNBObjID) {
        Object object = vectorLock;
        synchronized (object) {
            doLater.add(jNBObjID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ReferenceCountWrapper retrieveFromReleaseQueue(JNBObjID jNBObjID) {
        ReferenceCountWrapper referenceCountWrapper = null;
        Object object = vectorLock;
        synchronized (object) {
            int n = doNow.indexOf(jNBObjID);
            if (n != -1) {
                referenceCountWrapper = (ReferenceCountWrapper)doNow.remove(n);
            } else {
                n = doSoon.indexOf(jNBObjID);
                if (n != -1) {
                    referenceCountWrapper = (ReferenceCountWrapper)doSoon.remove(n);
                } else {
                    n = doLater.indexOf(jNBObjID);
                    if (n != -1) {
                        referenceCountWrapper = (ReferenceCountWrapper)doLater.remove(n);
                    }
                }
            }
        }
        if (referenceCountWrapper != null) {
            object = referenceCountWrapper.getObject();
            if (jNBObjID.getClassName() == null) {
                long l = jNBObjID.getObjID();
                String string = object.getClass().getName();
                jNBObjID = new JNBObjID(l, string);
            }
            objIDMap.put(jNBObjID, new ReferenceCountWrapper(object));
            revObjIDMap.put(new EqWrapper(object), jNBObjID);
        }
        return referenceCountWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean removeFromReleaseQueue(JNBObjID jNBObjID) {
        Object object = vectorLock;
        synchronized (object) {
            boolean bl = doNow.remove(jNBObjID);
            bl |= doSoon.remove(jNBObjID);
            return bl |= doLater.remove(jNBObjID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void queueForReinstall(JNBObjID jNBObjID, Object object) {
        Object object2 = vectorLock;
        synchronized (object2) {
            while (doSoon.remove(jNBObjID)) {
            }
            while (doLater.remove(jNBObjID)) {
            }
        }
        object2 = addNowLock;
        synchronized (object2) {
            addNow.put(jNBObjID, object);
        }
    }

    static {
        while (vmid == 0L) {
            vmid = new VMID().hashCode();
        }
        objIDCounter = vmid << 31;
        objIDCounterLock = new Object();
        objIDMap = new Hashtable();
        revObjIDMap = new Hashtable();
        doNow = new Vector();
        doSoon = new Vector();
        doLater = new Vector();
        vectorLock = new Object();
        addNow = new Hashtable();
        addNowLock = new Object();
        try {
            if (JavaSideProperties.isPropsFileSet()) {
                JavaSideProperties javaSideProperties = JavaSideProperties.getInstance();
                String string = javaSideProperties.getProperty("javaSide.releaseDelay");
                if (string == null) {
                    string = System.getProperty("javaSide.releaseDelay", "2000");
                }
                try {
                    releaserDelay = Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {
                    releaserDelay = 30000L;
                }
            } else {
                String string = System.getProperty("javaSide.releaseDelay", "2000");
                try {
                    releaserDelay = Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {
                    releaserDelay = 30000L;
                }
            }
        }
        catch (JavaSidePropertiesException javaSidePropertiesException) {
            String string = System.getProperty("javaSide.releaseDelay", "2000");
            try {
                releaserDelay = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                releaserDelay = 30000L;
            }
        }
        releaser = new ReleaserThread(releaserDelay);
        releaser.start();
        emptyClasses = new Class[0];
        emptyObjects = new Object[0];
    }

    public static class SingletonRegistrationException
    extends Exception {
    }

    private static class ReleaserThread
    extends Thread {
        private long delay;

        public ReleaserThread(long l) {
            super("releaser");
            this.delay = l;
            this.setDaemon(true);
            this.setPriority(10);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (true) {
                    Object object;
                    Object object2;
                    ReleaserThread.sleep(this.delay);
                    Vector vector = doNow;
                    Object object3 = vectorLock;
                    synchronized (object3) {
                        doNow = doSoon;
                        doSoon = doLater;
                        doLater = vector;
                        while (!doNow.isEmpty()) {
                            object2 = (JNBObjID)doNow.remove(0);
                            Object v = objIDMap.remove(object2);
                            if (v == null) continue;
                            object = ((ReferenceCountWrapper)v).getObject();
                            revObjIDMap.remove(new EqWrapper(object));
                        }
                    }
                    object3 = addNowLock;
                    synchronized (object3) {
                        object2 = addNow.keys();
                        while (object2.hasMoreElements()) {
                            void var4_9;
                            JNBObjID jNBObjID = (JNBObjID)object2.nextElement();
                            object = addNow.remove(jNBObjID);
                            if (object == null) continue;
                            if (jNBObjID.getClassName() == null) {
                                long l = jNBObjID.getObjID();
                                String string = object.getClass().getName();
                                JNBObjID jNBObjID2 = new JNBObjID(l, string);
                            }
                            objIDMap.put(var4_9, new ReferenceCountWrapper(object));
                            revObjIDMap.put(new EqWrapper(object), var4_9);
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    static class ReferenceCountWrapper {
        private int refCount = 0;
        private Object theObject;

        public ReferenceCountWrapper(Object object) {
            this.theObject = object;
        }

        public Object getObject() {
            return this.theObject;
        }

        public int getRefCount() {
            return this.refCount;
        }

        public void incrementRefCount() {
            ++this.refCount;
        }

        public void decrementRefCount() {
            --this.refCount;
        }

        public boolean noMoreReferences() {
            return this.refCount <= 0;
        }
    }
}

