/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore;

import com.jnbridge.jnbcore.BoxedValueProxyClass;
import com.jnbridge.jnbcore.ByValueConstants;
import com.jnbridge.jnbcore.DotNetArgTypeConverter;
import com.jnbridge.jnbcore.DotNetArrayProxyClass;
import com.jnbridge.jnbcore.DotNetClassRegistry;
import com.jnbridge.jnbcore.DotNetEnumProxyClass;
import com.jnbridge.jnbcore.DotNetSideException;
import com.jnbridge.jnbcore.DotNetStringProxyClass;
import com.jnbridge.jnbcore.EvalLicenseIndicatorGenerator;
import com.jnbridge.jnbcore.IJavaProxyClass;
import com.jnbridge.jnbcore.IOException;
import com.jnbridge.jnbcore.JavaProxyClass;
import com.jnbridge.jnbcore.MessageKeys;
import com.jnbridge.jnbcore.Messages;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class ProxyJarFile
implements ByValueConstants,
MessageKeys {
    JarOutputStream jos;
    private Hashtable classMap = new Hashtable();
    protected static Hashtable staticClassMap = null;
    private boolean m_is50Targeted;
    private boolean m_isEvalLicense;
    private static final String[] delegateInterfaceList = new String[]{"com.jnbridge.jnbcore.DelegateMarker"};

    public ProxyJarFile(String string, boolean bl, boolean bl2) throws IOException {
        this.m_is50Targeted = bl;
        this.m_isEvalLicense = bl2;
        staticClassMap = this.classMap;
        JavaProxyClass.resetDefinedMethods();
        try {
            Manifest manifest = new Manifest();
            manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
            this.jos = new JarOutputStream((OutputStream)new FileOutputStream(string), manifest);
        }
        catch (java.io.IOException iOException) {
            throw new IOException(iOException);
        }
    }

    public void close() throws IOException {
        this.addDotNetWrappers(this.m_is50Targeted);
        this.addBoxedValueProxies(this.m_is50Targeted);
        if (this.m_isEvalLicense) {
            this.addEvalLicenseIndicator(this.m_is50Targeted);
        }
        try {
            Enumeration enumeration = this.classMap.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                IJavaProxyClass iJavaProxyClass = (IJavaProxyClass)this.classMap.get(string);
                ByteArrayOutputStream byteArrayOutputStream = iJavaProxyClass.bake();
                this.jos.putNextEntry(new JarEntry(ProxyJarFile.entryName(string)));
                byte[] byArray = byteArrayOutputStream.toByteArray();
                this.jos.write(byArray, 0, byArray.length);
            }
            this.jos.close();
        }
        catch (java.io.IOException iOException) {
            throw new IOException(iOException);
        }
    }

    public JavaProxyClass addClass(String string, String string2, String[] stringArray, String[] stringArray2, String[] stringArray3, boolean[] blArray, boolean bl, boolean bl2, int n, boolean bl3, boolean bl4, boolean bl5, String[] stringArray4, boolean bl6) {
        if (bl2) {
            return this.addInterface(string, delegateInterfaceList, stringArray2, blArray, n, bl3, bl4, bl6);
        }
        DotNetClassRegistry.setSuperclassChain(DotNetArgTypeConverter.convertNested(string), DotNetArgTypeConverter.convertNested(stringArray3));
        String string3 = DotNetArgTypeConverter.convertNested(string);
        String string4 = DotNetArgTypeConverter.convertNested(string2);
        String[] stringArray5 = ProxyJarFile.addMarkerInterface(n, stringArray);
        DotNetClassRegistry.setByValueCode(string, n);
        JavaProxyClass javaProxyClass = new JavaProxyClass(string3, string4, DotNetArgTypeConverter.convertNested(stringArray5), DotNetArgTypeConverter.convertNested(stringArray2, blArray), DotNetArgTypeConverter.convertNestedInterfaces(blArray), bl, false, bl3, bl4, bl5, stringArray4, bl6);
        this.classMap.put(string3, javaProxyClass);
        DotNetClassRegistry.setPresent(string3);
        return javaProxyClass;
    }

    public JavaProxyClass addInterface(String string, String[] stringArray, String[] stringArray2, boolean[] blArray, int n, boolean bl, boolean bl2, boolean bl3) {
        DotNetClassRegistry.setSuperclassChain(DotNetArgTypeConverter.convertNested(string), new String[0]);
        String string2 = DotNetArgTypeConverter.convertNested(string);
        String[] stringArray3 = ProxyJarFile.addMarkerInterface(n, stringArray);
        DotNetClassRegistry.setByValueCode(string, n);
        JavaProxyClass javaProxyClass = new JavaProxyClass(string2, DotNetArgTypeConverter.convertNested(stringArray3), DotNetArgTypeConverter.convertNested(stringArray2, blArray), DotNetArgTypeConverter.convertNestedInterfaces(blArray), bl, bl2, bl3);
        this.classMap.put(string2, javaProxyClass);
        DotNetClassRegistry.setPresent(string2);
        this.createInterfaceHelperClass(string2, bl);
        return javaProxyClass;
    }

    private void createInterfaceHelperClass(String string, boolean bl) {
        String string2 = string + "Helper";
        JavaProxyClass javaProxyClass = new JavaProxyClass(string2, "System.Object", new String[0], new String[0], new boolean[0], true, true, bl, true, false, null, false);
        this.classMap.put(string2, javaProxyClass);
    }

    private void addEvalLicenseIndicator(boolean bl) {
        EvalLicenseIndicatorGenerator evalLicenseIndicatorGenerator = new EvalLicenseIndicatorGenerator(bl);
        this.classMap.put("com.jnbridge.jnbcore.EvalLicenseIndicator", evalLicenseIndicatorGenerator);
    }

    private void addDotNetWrappers(boolean bl) {
        DotNetStringProxyClass dotNetStringProxyClass = new DotNetStringProxyClass(bl);
        this.classMap.put("System.DotNetString", dotNetStringProxyClass);
        DotNetArrayProxyClass dotNetArrayProxyClass = new DotNetArrayProxyClass(bl);
        this.classMap.put("System.DotNetArray", dotNetArrayProxyClass);
        if (bl) {
            DotNetEnumProxyClass dotNetEnumProxyClass = new DotNetEnumProxyClass();
            this.classMap.put("System.DotNetEnum", dotNetEnumProxyClass);
        }
    }

    private void addBoxedValueProxies(boolean bl) {
        BoxedValueProxyClass boxedValueProxyClass = new BoxedValueProxyClass(bl);
        this.classMap.put("System.BoxedValue", boxedValueProxyClass);
        boxedValueProxyClass = new BoxedValueProxyClass("System.BoxedInt", "System.Int32", "intValue", bl);
        this.classMap.put("System.BoxedInt", boxedValueProxyClass);
        boxedValueProxyClass = new BoxedValueProxyClass("System.BoxedShort", "System.Int16", "shortValue", bl);
        this.classMap.put("System.BoxedShort", boxedValueProxyClass);
        boxedValueProxyClass = new BoxedValueProxyClass("System.BoxedLong", "System.Int64", "longValue", bl);
        this.classMap.put("System.BoxedLong", boxedValueProxyClass);
        boxedValueProxyClass = new BoxedValueProxyClass("System.BoxedFloat", "System.Single", "floatValue", bl);
        this.classMap.put("System.BoxedFloat", boxedValueProxyClass);
        boxedValueProxyClass = new BoxedValueProxyClass("System.BoxedDouble", "System.Double", "doubleValue", bl);
        this.classMap.put("System.BoxedDouble", boxedValueProxyClass);
        boxedValueProxyClass = new BoxedValueProxyClass("System.BoxedBoolean", "System.Boolean", "booleanValue", bl);
        this.classMap.put("System.BoxedBoolean", boxedValueProxyClass);
        boxedValueProxyClass = new BoxedValueProxyClass("System.BoxedSByte", "System.SByte", "sbyteValue", bl);
        this.classMap.put("System.BoxedSByte", boxedValueProxyClass);
        boxedValueProxyClass = new BoxedValueProxyClass("System.BoxedChar", "System.Char", "charValue", bl);
        this.classMap.put("System.BoxedChar", boxedValueProxyClass);
        boxedValueProxyClass = new BoxedValueProxyClass("System.BoxedUInt", "System.UInt32", "longValue", bl);
        this.classMap.put("System.BoxedUInt", boxedValueProxyClass);
        boxedValueProxyClass = new BoxedValueProxyClass("System.BoxedUShort", "System.UInt16", "intValue", bl);
        this.classMap.put("System.BoxedUShort", boxedValueProxyClass);
        boxedValueProxyClass = new BoxedValueProxyClass("System.BoxedULong", "System.UInt64", "floatValue", bl);
        this.classMap.put("System.BoxedULong", boxedValueProxyClass);
        boxedValueProxyClass = new BoxedValueProxyClass("System.BoxedByte", "System.Byte", "shortValue", bl);
        this.classMap.put("System.BoxedByte", boxedValueProxyClass);
    }

    private static String entryName(String string) {
        return string.replace('.', '/') + ".class";
    }

    private static String[] makeHelper(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i] + "Helper";
        }
        return stringArray2;
    }

    private static String[] addMarkerInterface(int n, String[] stringArray) {
        switch (n) {
            case 0: {
                return stringArray;
            }
            case 1: {
                return ProxyJarFile.addMarkerInterface(stringArray, "com.jnbridge.jnbcore.ByValuePubFieldsMarker");
            }
            case 2: {
                return ProxyJarFile.addMarkerInterface(stringArray, "com.jnbridge.jnbcore.ByValueJavaBeansMarker");
            }
            case 3: {
                return ProxyJarFile.addMarkerInterface(stringArray, "com.jnbridge.jnbcore.ByValueMappedCollectionMarker");
            }
        }
        throw new DotNetSideException(Messages.getString("PROXYJARFILE_ADDMARKERINTERFACE") + " " + n);
    }

    static String[] addMarkerInterface(String[] stringArray, String string) {
        int n = stringArray.length;
        String[] stringArray2 = new String[n + 1];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = stringArray[i];
        }
        stringArray2[n] = string;
        return stringArray2;
    }
}

