/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore.clientTransports;

import com.jnbridge.jnbcore.JNBDispatchMap;
import com.jnbridge.jnbcore.JavaSideProperties;
import com.jnbridge.jnbcore.JavaSidePropertiesException;
import com.jnbridge.jnbcore.MessageKeys;
import com.jnbridge.jnbcore.Messages;
import com.jnbridge.jnbcore.clientTransports.ClientTransport;
import com.jnbridge.jnbcore.clientTransports.ClientTransportException;
import com.jnbridge.jnbcore.clientTransports.HttpClientTransport;
import com.jnbridge.jnbcore.clientTransports.SSLSocketPool;
import com.jnbridge.jnbcore.clientTransports.SocketPool;
import com.jnbridge.jnbcore.formatters.binary.BinaryRequestConstants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Hashtable;

public abstract class AbstractClientTransport
implements ClientTransport,
BinaryRequestConstants,
MessageKeys {
    String host;
    int port;
    String path;
    int pathID;
    boolean isOpened = false;
    boolean isHttp = false;
    InetAddress address;
    Socket theSocket;
    String localHost;
    int localPort;
    boolean useSSL = false;
    private static Hashtable inetHostsAndPorts = new Hashtable();
    private static Hashtable dnsCache = new Hashtable();

    protected AbstractClientTransport() {
        if (this instanceof HttpClientTransport) {
            this.isHttp = true;
        }
    }

    public void open(String string, int n) throws ClientTransportException {
        try {
            Object object;
            Object object2;
            this.host = string;
            this.port = n;
            if (this.isOpened) {
                throw new ClientTransportException(Messages.getString("ABSTRACTCLIENTTRANSPORT_OPEN_1"));
            }
            this.isOpened = true;
            this.pathID = 1;
            this.path = "/JNBDotNetDispatcher";
            try {
                object2 = JavaSideProperties.getInstance();
                object = ((JavaSideProperties)object2).getProperty("dotNetSide.useSSL");
                this.useSSL = object != null && ((String)object).equalsIgnoreCase("true");
            }
            catch (JavaSidePropertiesException javaSidePropertiesException) {
                throw new ClientTransportException(Messages.getString("ABSTRACTCLIENTTRANSPORT_OPEN_2") + " " + javaSidePropertiesException.getMessage());
            }
            this.address = (InetAddress)dnsCache.get(string);
            if (this.address == null) {
                this.address = InetAddress.getByName(string);
                dnsCache.put(string, this.address);
            }
            this.theSocket = this.useSSL ? SSLSocketPool.getSocket(this.address, n) : SocketPool.getSocket(this.address, n);
            if (this.isHttp) {
                object2 = this.theSocket.getLocalAddress();
                object = (HostAndPort)inetHostsAndPorts.get(object2);
                if (object != null) {
                    this.localHost = ((HostAndPort)object).host;
                    this.localPort = ((HostAndPort)object).port;
                } else {
                    this.localHost = ((InetAddress)object2).getHostName();
                    this.localPort = this.theSocket.getLocalPort();
                    inetHostsAndPorts.put(object2, new HostAndPort(this.localHost, this.localPort));
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            throw new ClientTransportException(Messages.getString("ABSTRACTCLIENTTRANSPORT_OPEN_3"), unknownHostException);
        }
        catch (IOException iOException) {
            throw new ClientTransportException(Messages.getString("ABSTRACTCLIENTTRANSPORT_OPEN_4"), iOException);
        }
    }

    public void open(String string, int n, String string2) throws ClientTransportException {
        try {
            this.host = string;
            this.port = n;
            this.path = string2;
            if (this.isOpened) {
                throw new ClientTransportException(Messages.getString("ABSTRACTCLIENTTRANSPORT_OPEN_1"));
            }
            this.isOpened = true;
            Integer n2 = JNBDispatchMap.getTargetID(string2);
            if (n2 == null) {
                throw new ClientTransportException(Messages.getString("ABSTRACTCLIENTTRANSPORT_OPEN_5"));
            }
            try {
                JavaSideProperties javaSideProperties = JavaSideProperties.getInstance();
                String string3 = javaSideProperties.getProperty("dotNetSide.useSSL");
                this.useSSL = string3 != null && string3.equalsIgnoreCase("true");
            }
            catch (JavaSidePropertiesException javaSidePropertiesException) {
                throw new ClientTransportException(Messages.getString("ABSTRACTCLIENTTRANSPORT_OPEN_2") + " " + javaSidePropertiesException.getMessage());
            }
            this.address = (InetAddress)dnsCache.get(string);
            if (this.address == null) {
                this.address = InetAddress.getByName(string);
                dnsCache.put(string, this.address);
            }
            this.theSocket = this.useSSL ? SSLSocketPool.getSocket(this.address, n) : SocketPool.getSocket(this.address, n);
        }
        catch (UnknownHostException unknownHostException) {
            throw new ClientTransportException(Messages.getString("ABSTRACTCLIENTTRANSPORT_OPEN_3"), unknownHostException);
        }
        catch (IOException iOException) {
            throw new ClientTransportException(Messages.getString("ABSTRACTCLIENTTRANSPORT_OPEN_4"), iOException);
        }
    }

    public abstract void sendRequest(ByteArrayOutputStream var1, String var2) throws ClientTransportException;

    public abstract ByteArrayInputStream getResponse() throws ClientTransportException;

    public void close() throws ClientTransportException {
        if (!this.isOpened) {
            throw new ClientTransportException(Messages.getString("ABSTRACTCLIENTTRANSPORT_CLOSE"));
        }
        if (this.useSSL) {
            SSLSocketPool.release(this.theSocket);
        } else {
            SocketPool.release(this.theSocket);
        }
        this.isOpened = false;
    }

    public abstract void dontCompress();

    private static class HostAndPort {
        public String host;
        public int port;

        public HostAndPort(String string, int n) {
            this.host = string;
            this.port = n;
        }
    }
}

