/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore.clientTransports;

import com.jnbridge.jnbcore.JavaSideProperties;
import com.jnbridge.jnbcore.MessageKeys;
import com.jnbridge.jnbcore.Messages;
import com.jnbridge.jnbcore.NotImplementedException;
import com.jnbridge.jnbcore.PropertiesConstants;
import com.jnbridge.jnbcore.clientTransports.AbstractClientTransport;
import com.jnbridge.jnbcore.clientTransports.ClientTransportException;
import com.jnbridge.jnbcore.clientTransports.SocketPool;
import com.jnbridge.jnbcore.formatters.soap.SOAPNamespaceConstants;
import com.jnbridge.jnbcore.server.http.HttpConstants;
import com.jnbridge.jnbcore.server.http.HttpRequestHeader;
import com.jnbridge.jnbcore.server.http.HttpResponseHeader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class HttpClientTransport
extends AbstractClientTransport
implements SOAPNamespaceConstants,
HttpConstants,
MessageKeys,
PropertiesConstants {
    InputStream socketInput = null;
    OutputStream socketOutput = null;
    private static boolean usingMono = false;

    public boolean isSocketBased() {
        return true;
    }

    public void open(String string, int n) throws ClientTransportException {
        super.open(string, n);
        try {
            this.socketInput = this.theSocket.getInputStream();
            this.socketOutput = this.theSocket.getOutputStream();
        }
        catch (IOException iOException) {
            throw new ClientTransportException(Messages.getString("HTTPCLIENTTRANSPORT_OPEN"), iOException);
        }
    }

    public void open(String string, int n, String string2) throws ClientTransportException {
        super.open(string, n, string2);
        try {
            this.socketInput = this.theSocket.getInputStream();
            this.socketOutput = this.theSocket.getOutputStream();
        }
        catch (IOException iOException) {
            throw new ClientTransportException(Messages.getString("HTTPCLIENTTRANSPORT_OPEN"), iOException);
        }
    }

    public void sendRequest(ByteArrayOutputStream byteArrayOutputStream, String string) throws ClientTransportException {
        if (!this.isOpened) {
            throw new ClientTransportException(Messages.getString("HTTPCLIENTTRANSPORT_SENDREQUEST_1"));
        }
        byte[] byArray = null;
        int n = 0;
        try {
            byArray = byteArrayOutputStream.toByteArray();
            n = byArray.length;
            HttpRequestHeader httpRequestHeader = new HttpRequestHeader(n, string, "/JNBDotNetDispatcher", this.localHost, this.localPort);
            httpRequestHeader.printToStream(this.socketOutput);
            this.socketOutput.write(byArray);
        }
        catch (IOException iOException) {
            if (usingMono) {
                try {
                    this.theSocket = SocketPool.reset(this.theSocket);
                    this.socketInput = this.theSocket.getInputStream();
                    this.socketOutput = this.theSocket.getOutputStream();
                    HttpRequestHeader httpRequestHeader = new HttpRequestHeader(n, string, "/JNBDotNetDispatcher", this.localHost, this.localPort);
                    httpRequestHeader.printToStream(this.socketOutput);
                    this.socketOutput.write(byArray);
                }
                catch (IOException iOException2) {
                    throw new ClientTransportException(Messages.getString("HTTPCLIENTTRANSPORT_SENDREQUEST_2"), iOException2);
                }
            }
            throw new ClientTransportException(Messages.getString("HTTPCLIENTTRANSPORT_SENDREQUEST_2"), iOException);
        }
    }

    public ByteArrayInputStream getResponse() throws ClientTransportException {
        if (!this.isOpened) {
            throw new ClientTransportException(Messages.getString("HTTPCLIENTTRANSPORT_GETRESPONSE_1"));
        }
        try {
            HttpResponseHeader httpResponseHeader = null;
            while ((httpResponseHeader = new HttpResponseHeader(this.socketInput)).getStatus() == 100) {
            }
            String string = httpResponseHeader.getProperty("Content-Length");
            int n = 0;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ClientTransportException(Messages.getString("HTTPCLIENTTRANSPORT_GETRESPONSE_2") + " " + numberFormatException.getMessage(), numberFormatException);
            }
            byte[] byArray = new byte[n];
            for (int i = this.socketInput.read(byArray); i < n; i += this.socketInput.read(byArray, i, n - i)) {
            }
            return new ByteArrayInputStream(byArray);
        }
        catch (IOException iOException) {
            throw new ClientTransportException(Messages.getString("HTTPCLIENTTRANSPORT_GETRESPONSE_3") + " " + iOException.getMessage(), iOException);
        }
    }

    public void dontCompress() {
        throw new NotImplementedException();
    }

    static {
        String string = JavaSideProperties.getFromPropertiesOrSystem("dotNetSide.usingMono", "false");
        usingMono = "true".equalsIgnoreCase(string);
    }
}

