/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore.clientTransports;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

abstract class SSLSocketPool {
    private static ArrayList socketPoolTable = new ArrayList();
    private static Hashtable timerTable = new Hashtable();
    private static Object objectLock = new Object();
    private static final long SELF_DESTRUCT_TIMEOUT = 5000L;
    private static final SocketFactory sslSocketFactory = SSLSocketFactory.getDefault();
    private static final String[] enabledProtocols = new String[]{"SSLv2Hello", "TLSv1", "SSLv3"};

    private SSLSocketPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Socket getSocket(InetAddress inetAddress, int n) throws IOException {
        Object object = objectLock;
        synchronized (object) {
            SSLSocket sSLSocket = SSLSocketPool.lookup(inetAddress, n);
            if (sSLSocket != null) {
                SelfDestructTask selfDestructTask = (SelfDestructTask)timerTable.remove(sSLSocket);
                try {
                    SSLSocketPool.remove(sSLSocket);
                    selfDestructTask.cancel();
                    InputStream inputStream = sSLSocket.getInputStream();
                }
                catch (IOException iOException) {
                    try {
                        sSLSocket.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    sSLSocket = (SSLSocket)sslSocketFactory.createSocket(inetAddress, n);
                }
                return sSLSocket;
            }
            sSLSocket = (SSLSocket)sslSocketFactory.createSocket(inetAddress, n);
            return sSLSocket;
        }
    }

    private static SSLSocket lookup(InetAddress inetAddress, int n) {
        for (int i = 0; i < socketPoolTable.size(); ++i) {
            SSLSocket sSLSocket = (SSLSocket)socketPoolTable.get(i);
            if (sSLSocket.getInetAddress() != inetAddress || sSLSocket.getPort() != n) continue;
            return sSLSocket;
        }
        return null;
    }

    private static boolean remove(Socket socket) {
        for (int i = 0; i < socketPoolTable.size(); ++i) {
            Socket socket2 = (Socket)socketPoolTable.get(i);
            if (socket != socket2) continue;
            socketPoolTable.remove(i);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release(Socket socket) {
        Object object = objectLock;
        synchronized (object) {
            SelfDestructTask selfDestructTask = new SelfDestructTask(socket);
            socketPoolTable.add(socket);
            timerTable.put(socket, selfDestructTask);
        }
    }

    private static class SelfDestructTask
    extends TimerTask {
        private Socket theSocket;
        private Timer selfDestructTimer;

        public SelfDestructTask(Socket socket) {
            this.theSocket = socket;
            this.selfDestructTimer = new Timer(true);
            this.selfDestructTimer.schedule((TimerTask)this, 5000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = objectLock;
            synchronized (object) {
                boolean bl = SSLSocketPool.remove(this.theSocket);
                if (!bl) {
                    return;
                }
                try {
                    this.theSocket.close();
                    this.theSocket = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

