/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore.clientTransports;

import com.jnbridge.jnbcore.BitnessDetector;
import com.jnbridge.jnbcore.DotNetSideException;
import com.jnbridge.jnbcore.JavaSideProperties;
import com.jnbridge.jnbcore.JavaSidePropertiesException;
import com.jnbridge.jnbcore.MessageKeys;
import com.jnbridge.jnbcore.Messages;
import com.jnbridge.jnbcore.NotImplementedException;
import com.jnbridge.jnbcore.PropertiesConstants;
import com.jnbridge.jnbcore.Utilities;
import com.jnbridge.jnbcore.clientTransports.AbstractClientTransport;
import com.jnbridge.jnbcore.clientTransports.ClientTransportException;
import com.jnbridge.jnbcore.server.sharedmem.SharedMemRequestHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;

public class SharedMemClientTransport
extends AbstractClientTransport
implements PropertiesConstants,
MessageKeys {
    private JavaSideProperties props;
    private ByteArrayInputStream response = null;

    public static String resolveEntry(String string) {
        if (string == null) {
            return string;
        }
        File file = new File(string);
        if (file.exists() && file.isDirectory()) {
            File file2 = BitnessDetector.is32bit() ? new File(file, "JNBJavaEntry_x86.dll") : new File(file, "JNBJavaEntry_x64.dll");
            return file2.getPath();
        }
        return string;
    }

    private static native byte[] dotNetCall(byte[] var0);

    private static native int dotNetInit();

    private static native int dotNetInit(int var0);

    private static native int dotNetInit(String var0);

    private static native int dotNetInit(String var0, int var1);

    private static native int dotNetInitAppBase(String var0);

    private static native int dotNetInitAppBase(String var0, int var1);

    private static native int dotNetInitAppBase(String var0, String var1);

    private static native int dotNetInitAppBase(String var0, String var1, int var2);

    private static native void setAssemblies(String[] var0, int var1, int var2, String var3);

    public boolean isSocketBased() {
        return false;
    }

    public void sendRequest(ByteArrayOutputStream byteArrayOutputStream, String string) throws ClientTransportException {
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byte[] byArray2 = SharedMemClientTransport.dotNetCall(byArray);
        this.response = new ByteArrayInputStream(byArray2);
    }

    public ByteArrayInputStream getResponse() throws ClientTransportException {
        return this.response;
    }

    public void dontCompress() {
        throw new NotImplementedException();
    }

    static {
        int n;
        String string = null;
        String string2 = null;
        String string3 = null;
        String[] stringArray = null;
        String string4 = null;
        boolean bl = true;
        if (SharedMemRequestHandler.dotNetIsMaster) {
            string = SharedMemRequestHandler.javaEntry;
        } else {
            try {
                JavaSideProperties javaSideProperties = JavaSideProperties.getInstance();
                string = javaSideProperties.getProperty("dotNetSide.javaEntry");
                string = SharedMemClientTransport.resolveEntry(string);
                string2 = javaSideProperties.getProperty("dotNetSide.appConfig");
                string3 = javaSideProperties.getProperty("dotNetSide.appBase");
                stringArray = javaSideProperties.getAssemblyList();
                string4 = javaSideProperties.getProperty("dotNetSide.apartmentThreadingModel");
                if (string4 != null && string4.equalsIgnoreCase("STA")) {
                    bl = false;
                }
            }
            catch (JavaSidePropertiesException javaSidePropertiesException) {
                throw new DotNetSideException(Messages.getString("SHAREDMEMCLIENTTRANSPORT_STATIC_1"));
            }
        }
        System.load(string);
        if (string2 != null) {
            n = string3 != null ? SharedMemClientTransport.dotNetInitAppBase(string2, string3) : SharedMemClientTransport.dotNetInit(string2);
            if (n == -1) {
                throw new DotNetSideException(Messages.getString("SHAREDMEMCLIENTTRANSPORT_STATIC_2"));
            }
        } else {
            n = string3 != null ? (bl ? SharedMemClientTransport.dotNetInitAppBase(string3) : SharedMemClientTransport.dotNetInitAppBase(string3, 0)) : (bl ? SharedMemClientTransport.dotNetInit() : SharedMemClientTransport.dotNetInit(0));
            if (n == -1) {
                throw new DotNetSideException(Messages.getString("SHAREDMEMCLIENTTRANSPORT_STATIC_2"));
            }
        }
        n = Utilities.getData2();
        int n2 = Utilities.getData3();
        String string5 = Utilities.getData5();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        SharedMemClientTransport.setAssemblies(stringArray, n, n2, string5);
    }
}

