/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore.clientTransports;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;

abstract class SocketPool {
    private static ArrayList socketPoolTable = new ArrayList();
    private static Object objectLock = new Object();
    private static final long SELF_DESTRUCT_TIMEOUT = 5000L;

    private SocketPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Socket getSocket(InetAddress inetAddress, int n) throws IOException {
        Object object = objectLock;
        synchronized (object) {
            TimedSocket timedSocket = SocketPool.lookup(inetAddress, n);
            if (timedSocket != null) {
                try {
                    SocketPool.remove(timedSocket);
                    timedSocket.cancelTimer();
                    InputStream inputStream = timedSocket.getInputStream();
                }
                catch (IOException iOException) {
                    try {
                        timedSocket.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    timedSocket = new TimedSocket(inetAddress, n);
                }
                return timedSocket;
            }
            return new TimedSocket(inetAddress, n);
        }
    }

    private static TimedSocket lookup(InetAddress inetAddress, int n) {
        for (int i = 0; i < socketPoolTable.size(); ++i) {
            TimedSocket timedSocket = (TimedSocket)socketPoolTable.get(i);
            if (timedSocket.getInetAddress() != inetAddress || timedSocket.getPort() != n) continue;
            return timedSocket;
        }
        return null;
    }

    private static boolean remove(Socket socket) {
        for (int i = 0; i < socketPoolTable.size(); ++i) {
            Socket socket2 = (Socket)socketPoolTable.get(i);
            if (socket != socket2) continue;
            socketPoolTable.remove(i);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release(Socket socket) {
        Object object = objectLock;
        synchronized (object) {
            ((TimedSocket)socket).setTimer();
            socketPoolTable.add(socket);
        }
    }

    public static Socket reset(Socket socket) throws IOException {
        SocketAddress socketAddress = socket.getLocalSocketAddress();
        SocketAddress socketAddress2 = socket.getRemoteSocketAddress();
        socket.close();
        TimedSocket timedSocket = new TimedSocket(socketAddress, socketAddress2);
        return timedSocket;
    }

    private static class SelfDestructTask
    extends TimerTask {
        private Socket theSocket;

        public SelfDestructTask(TimedSocket timedSocket) {
            this.theSocket = timedSocket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = objectLock;
            synchronized (object) {
                boolean bl = SocketPool.remove(this.theSocket);
                if (!bl) {
                    return;
                }
                try {
                    this.theSocket.close();
                    this.theSocket = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private static class TimedSocket
    extends Socket {
        private Timer selfDestructTimer = new Timer(true);
        private TimerTask sdt = null;
        private static Method purgeMethod = null;
        static final Object[] emptyArgs;

        public TimedSocket(InetAddress inetAddress, int n) throws IOException {
            super(inetAddress, n);
            this.setTcpNoDelay(true);
        }

        public TimedSocket(SocketAddress socketAddress, SocketAddress socketAddress2) throws IOException {
            this.setReuseAddress(true);
            this.setTcpNoDelay(true);
            this.setSoLinger(false, 0);
            this.bind(socketAddress);
            this.connect(socketAddress2);
        }

        public void setTimer() {
            this.sdt = new SelfDestructTask(this);
            this.selfDestructTimer.schedule(this.sdt, 5000L);
        }

        public void cancelTimer() {
            if (this.sdt != null) {
                this.sdt.cancel();
                this.sdt = null;
            }
            if (purgeMethod != null) {
                try {
                    purgeMethod.invoke((Object)this.selfDestructTimer, emptyArgs);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }

        public void close() throws IOException {
            if (this.sdt != null) {
                this.sdt.cancel();
                this.sdt = null;
            }
            if (this.selfDestructTimer != null) {
                this.selfDestructTimer.cancel();
            }
            this.selfDestructTimer = null;
            super.close();
        }

        static {
            try {
                purgeMethod = Timer.class.getMethod("purge", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                purgeMethod = null;
            }
            emptyArgs = new Object[0];
        }
    }
}

