/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore.clientTransports;

import com.jnbridge.jnbcore.CompressionManager;
import com.jnbridge.jnbcore.MessageKeys;
import com.jnbridge.jnbcore.Messages;
import com.jnbridge.jnbcore.PropertiesConstants;
import com.jnbridge.jnbcore.clientTransports.AbstractClientTransport;
import com.jnbridge.jnbcore.clientTransports.ClientTransportException;
import com.jnbridge.jnbcore.streams.DotNetDataInputStream;
import com.jnbridge.jnbcore.streams.DotNetDataOutputStream;
import com.jnbridge.jnbcore.streams.TcpConstants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class TcpClientTransport
extends AbstractClientTransport
implements TcpConstants,
PropertiesConstants,
MessageKeys {
    private DotNetDataOutputStream socketOutput;
    private DotNetDataInputStream socketInput;
    private static final byte[] preamble = new byte[]{74, 78, 66, 55, 48};
    private static final byte[] preamble_compressed = new byte[]{74, 78, 66, 55, 49};
    private boolean is11 = false;
    private static boolean calledIs11 = false;
    byte[] fiveBytes = new byte[5];

    public boolean isSocketBased() {
        return true;
    }

    public void open(String string, int n) throws ClientTransportException {
        super.open(string, n);
        try {
            this.socketInput = new DotNetDataInputStream(new DataInputStream(this.theSocket.getInputStream()));
            this.socketOutput = new DotNetDataOutputStream(new DataOutputStream(this.theSocket.getOutputStream()));
        }
        catch (IOException iOException) {
            throw new ClientTransportException(Messages.getString("TCPCLIENTTRANSPORT_OPEN"), iOException);
        }
    }

    public void open(String string, int n, String string2) throws ClientTransportException {
        super.open(string, n, string2);
        try {
            this.socketInput = new DotNetDataInputStream(new DataInputStream(this.theSocket.getInputStream()));
            this.socketOutput = new DotNetDataOutputStream(new DataOutputStream(this.theSocket.getOutputStream()));
        }
        catch (IOException iOException) {
            throw new ClientTransportException(Messages.getString("TCPCLIENTTRANSPORT_OPEN"), iOException);
        }
    }

    public void dontCompress() {
        this.is11 = true;
    }

    public void sendRequest(ByteArrayOutputStream byteArrayOutputStream, String string) throws ClientTransportException {
        if (!this.isOpened) {
            throw new ClientTransportException(Messages.getString("TCPCLIENTTRANSPORT_SENDREQUEST_1"));
        }
        try {
            int n = byteArrayOutputStream.size();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            boolean bl = !this.is11 && !CompressionManager.getInstance().NoCompression() && n >= 100000;
            if (bl) {
                this.socketOutput.write(preamble_compressed);
            } else {
                this.socketOutput.write(preamble);
            }
            this.socketOutput.flush();
            if (bl) {
                Deflater deflater = new Deflater(5, true);
                deflater.setInput(byArray);
                deflater.finish();
                byte[] byArray2 = new byte[n + 50];
                int n2 = deflater.deflate(byArray2);
                this.socketOutput.writeInt(n2);
                this.socketOutput.flush();
                this.socketOutput.writeInt(n);
                this.socketOutput.flush();
                this.socketOutput.write(byArray2, 0, n2);
                this.socketOutput.flush();
            } else {
                this.socketOutput.writeInt(n);
                this.socketOutput.flush();
                this.socketOutput.write(byArray);
                this.socketOutput.flush();
            }
        }
        catch (IOException iOException) {
            throw new ClientTransportException(Messages.getString("TCPCLIENTTRANSPORT_SENDREQUEST_2"), iOException);
        }
    }

    public ByteArrayInputStream getResponse() throws ClientTransportException {
        if (!this.isOpened) {
            throw new ClientTransportException(Messages.getString("TCPCLIENTTRANSPORT_GETRESPONSE_1"));
        }
        try {
            byte[] byArray;
            boolean bl;
            this.socketInput.read(this.fiveBytes);
            if (this.fiveBytes[0] != 74 || this.fiveBytes[1] != 78 || this.fiveBytes[2] != 66 || this.fiveBytes[3] != 55) {
                throw new ClientTransportException(Messages.getString("TCPCLIENTTRANSPORT_GETRESPONSE_2"));
            }
            switch (this.fiveBytes[4]) {
                case 48: {
                    bl = false;
                    break;
                }
                case 49: {
                    bl = true;
                    break;
                }
                default: {
                    throw new ClientTransportException(Messages.getString("TCPCLIENTTRANSPORT_GETRESPONSE_2"));
                }
            }
            int n = this.socketInput.readInt();
            int n2 = 0;
            if (bl) {
                n2 = this.socketInput.readInt();
            }
            byte[] byArray2 = new byte[n];
            this.socketInput.read(byArray2);
            if (bl) {
                Inflater inflater = new Inflater(true);
                inflater.setInput(byArray2);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
                byte[] byArray3 = new byte[1024];
                while (!inflater.finished()) {
                    int n3 = inflater.inflate(byArray3);
                    byteArrayOutputStream.write(byArray3, 0, n3);
                }
                byteArrayOutputStream.close();
                byArray = byteArrayOutputStream.toByteArray();
                inflater.end();
            } else {
                byArray = byArray2;
            }
            return new ByteArrayInputStream(byArray);
        }
        catch (IOException iOException) {
            throw new ClientTransportException(Messages.getString("TCPCLIENTTRANSPORT_GETRESPONSE_3"), iOException);
        }
        catch (DataFormatException dataFormatException) {
            throw new ClientTransportException(Messages.getString("TCPCLIENTTRANSPORT_GETRESPONSE_3"), dataFormatException);
        }
    }
}

