/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore.formatters.binary;

import com.jnbridge.jnbcore.CallbackException;
import com.jnbridge.jnbcore.CallbackFactory;
import com.jnbridge.jnbcore.ClassRegistry;
import com.jnbridge.jnbcore.DebugConstants;
import com.jnbridge.jnbcore.DotNetArgTypeConverter;
import com.jnbridge.jnbcore.InternalException;
import com.jnbridge.jnbcore.JNBArrayWrapper;
import com.jnbridge.jnbcore.JNBCallback;
import com.jnbridge.jnbcore.JNBObjID;
import com.jnbridge.jnbcore.JNBValueObject;
import com.jnbridge.jnbcore.MessageKeys;
import com.jnbridge.jnbcore.Messages;
import com.jnbridge.jnbcore.ObjectRegistry;
import com.jnbridge.jnbcore.java50.EnumInfo;
import java.lang.reflect.Array;

public final class BinaryArgConverter
implements DebugConstants,
MessageKeys {
    public static Object[] unwrapArrays(Object object) {
        Object[] objectArray;
        if (object instanceof JNBArrayWrapper) {
            JNBArrayWrapper jNBArrayWrapper = (JNBArrayWrapper)object;
            objectArray = (Object[])jNBArrayWrapper.getArray();
            String string = jNBArrayWrapper.getArrayTypeStr();
            String string2 = string.substring(0, string.length() - 2);
            boolean bl = string2.endsWith("[]");
            for (int i = 0; i < objectArray.length; ++i) {
                if (!bl || objectArray[i] instanceof JNBArrayWrapper) continue;
                objectArray[i] = new JNBArrayWrapper(string2, objectArray[i]);
            }
        } else {
            objectArray = (Object[])object;
        }
        return objectArray;
    }

    public static Object[] convertArgs(Object object, Object object2) throws InternalException, CallbackException {
        Object[] objectArray;
        Object[] objectArray2 = BinaryArgConverter.unwrapArrays(object);
        if (objectArray2.length != (objectArray = BinaryArgConverter.unwrapArrays(object2)).length) {
            throw new InternalException(Messages.getString("BINARYARGCONVERTER_CONVERTARGS_1"));
        }
        Object[] objectArray3 = new Object[objectArray2.length];
        for (int i = 0; i < objectArray2.length; ++i) {
            objectArray3[i] = BinaryArgConverter.convertOneArg((String)objectArray2[i], objectArray[i]);
        }
        return objectArray3;
    }

    public static Object convertOneArg(String string, Object object) throws InternalException, CallbackException {
        try {
            String string2 = null;
            if (object instanceof JNBArrayWrapper) {
                JNBArrayWrapper jNBArrayWrapper = (JNBArrayWrapper)object;
                object = jNBArrayWrapper.getArray();
                string2 = jNBArrayWrapper.getArrayTypeStr();
            }
            switch (string.charAt(0)) {
                case 'I': {
                    return object;
                }
                case 'Z': {
                    return object;
                }
                case 'B': {
                    return object;
                }
                case 'C': {
                    if (object instanceof Character) {
                        return object;
                    }
                    short s = (Short)object;
                    char c = (char)s;
                    return new Character(c);
                }
                case 'S': {
                    return object;
                }
                case 'J': {
                    return object;
                }
                case 'F': {
                    return object;
                }
                case 'D': {
                    return object;
                }
                case '[': {
                    return BinaryArgConverter.convertArray(string, object, string2);
                }
                case 'L': {
                    if (object == null) {
                        return null;
                    }
                    if (string.substring(1).equals("java.lang.String;")) {
                        return object;
                    }
                    if (object instanceof String) {
                        return object;
                    }
                    if (EnumInfo.isEnum(object.getClass())) {
                        return object;
                    }
                    if (object.getClass().isArray()) {
                        return BinaryArgConverter.convertArray(string, object, string2);
                    }
                    if (object instanceof JNBCallback) {
                        return CallbackFactory.createProxy((JNBCallback)object);
                    }
                    if (object instanceof JNBValueObject) {
                        return ((JNBValueObject)object).getObject();
                    }
                    return ObjectRegistry.getObjectFromID((JNBObjID)object);
                }
            }
            throw new InternalException(Messages.getString("BINARYARGCONVERTER_CONVERTONEARG") + " " + string);
        }
        catch (InternalException internalException) {
            throw internalException;
        }
        catch (CallbackException callbackException) {
            throw callbackException;
        }
        catch (Exception exception) {
            throw new InternalException(exception.toString());
        }
    }

    private static Object convertArray(String string, Object object, String string2) throws InternalException, CallbackException {
        if (object == null) {
            return object;
        }
        switch (string.charAt(1)) {
            case 'I': {
                return object;
            }
            case 'Z': {
                return object;
            }
            case 'B': {
                return object;
            }
            case 'C': {
                Class<?> clazz = object.getClass().getComponentType();
                if (clazz == Integer.TYPE) {
                    return BinaryArgConverter.convertIntArrayToCharArray((int[])object);
                }
                return object;
            }
            case 'S': {
                return object;
            }
            case 'J': {
                return object;
            }
            case 'F': {
                return object;
            }
            case 'D': {
                return object;
            }
            case '[': {
                Object object2;
                String string3;
                int n = Array.getLength(object);
                if (string2 != null) {
                    string2 = string2.substring(0, string2.length() - 2);
                    string3 = DotNetArgTypeConverter.convertToJavaType(string2, true);
                } else {
                    string3 = string.substring(1);
                }
                try {
                    string3 = BinaryArgConverter.filterObjID(string3);
                    object2 = Array.newInstance(ClassRegistry.getClass(string3, Thread.currentThread().getContextClassLoader()), n);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new InternalException(Messages.getString("BINARYARGCONVERTER_CONVERTARRAY_1") + " " + classNotFoundException.getMessage());
                }
                for (int i = 0; i < n; ++i) {
                    Array.set(object2, i, BinaryArgConverter.convertArray(string.substring(1), Array.get(object, i), string2));
                }
                return object2;
            }
            case 'L': {
                Object object3;
                String string4;
                int n = Array.getLength(object);
                if (string2 != null) {
                    string2 = string2.substring(0, string2.length() - 2);
                    string4 = DotNetArgTypeConverter.convertToJavaType(string2, true);
                } else {
                    string4 = string.substring(1);
                }
                if (string4.equals("Ljava.lang.String;")) {
                    return object;
                }
                try {
                    string4 = string4.substring(1, string4.length() - 1);
                    string4 = BinaryArgConverter.filterObjID(string4);
                    object3 = Array.newInstance(ClassRegistry.getClass(string4, Thread.currentThread().getContextClassLoader()), n);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new InternalException(Messages.getString("BINARYARGCONVERTER_CONVERTARRAY_2") + " " + classNotFoundException.getMessage());
                }
                for (int i = 0; i < n; ++i) {
                    Object object4 = BinaryArgConverter.convertOneArg(string.substring(1), Array.get(object, i));
                    Array.set(object3, i, object4);
                }
                return object3;
            }
        }
        return BinaryArgConverter.convertArray(object.getClass().getName(), object, string2);
    }

    private static char[] convertIntArrayToCharArray(int[] nArray) {
        int n = nArray.length;
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)nArray[i];
        }
        return cArray;
    }

    private static String filterObjID(String string) {
        int n = string.indexOf("com.jnbridge.jnbcore.JNBObjID");
        if (n == -1) {
            n = string.indexOf("System.Object");
            if (n != -1) {
                String string2 = string.substring(0, n) + "java.lang.Object" + string.substring(n + 13);
                return string2;
            }
            return string;
        }
        String string3 = string.substring(0, n) + "java.lang.Object" + string.substring(n + 29);
        return string3;
    }
}

