/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore.formatters.binary;

import com.jnbridge.jnbcore.BoxedValueFactory;
import com.jnbridge.jnbcore.ByValueMarker;
import com.jnbridge.jnbcore.CallArgs;
import com.jnbridge.jnbcore.CallbackException;
import com.jnbridge.jnbcore.ClassRegistry;
import com.jnbridge.jnbcore.DebugConstants;
import com.jnbridge.jnbcore.DotNetArgTypeConverter;
import com.jnbridge.jnbcore.DotNetMappedClass;
import com.jnbridge.jnbcore.DotNetObjectBase;
import com.jnbridge.jnbcore.DotNetSideException;
import com.jnbridge.jnbcore.DotNetWrapper;
import com.jnbridge.jnbcore.IDotNetSideProxy;
import com.jnbridge.jnbcore.InternalException;
import com.jnbridge.jnbcore.JNBArrayWrapper;
import com.jnbridge.jnbcore.JNBCallback;
import com.jnbridge.jnbcore.JNBDispatchMap;
import com.jnbridge.jnbcore.JNBDispatcherConstants;
import com.jnbridge.jnbcore.JNBDotNetCallback;
import com.jnbridge.jnbcore.JNBDotNetObjID;
import com.jnbridge.jnbcore.JNBDotNetValueObject;
import com.jnbridge.jnbcore.JNBException;
import com.jnbridge.jnbcore.JNBInternalException;
import com.jnbridge.jnbcore.JNBObjID;
import com.jnbridge.jnbcore.JNBValueObject;
import com.jnbridge.jnbcore.JNBVoidResult;
import com.jnbridge.jnbcore.JavaSideProperties;
import com.jnbridge.jnbcore.JavaSidePropertiesException;
import com.jnbridge.jnbcore.MappedClass;
import com.jnbridge.jnbcore.MappedClassConstants;
import com.jnbridge.jnbcore.MessageKeys;
import com.jnbridge.jnbcore.Messages;
import com.jnbridge.jnbcore.NullValue;
import com.jnbridge.jnbcore.ObjectRegistry;
import com.jnbridge.jnbcore.ThreadID;
import com.jnbridge.jnbcore.formatters.Formatter;
import com.jnbridge.jnbcore.formatters.SerializationException;
import com.jnbridge.jnbcore.formatters.binary.BinaryArgConverter;
import com.jnbridge.jnbcore.formatters.binary.BinaryCallArgs;
import com.jnbridge.jnbcore.formatters.binary.BinaryRequestConstants;
import com.jnbridge.jnbcore.java50.BigDecimalHelper;
import com.jnbridge.jnbcore.java50.EnumInfo;
import com.jnbridge.jnbcore.server.binary.BinaryException;
import com.jnbridge.jnbcore.streams.DotNetDataInputStream;
import com.jnbridge.jnbcore.streams.DotNetDataOutputStream;
import com.jnbridge.transaction.JavaTM;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class BinaryFormatter
implements Formatter,
BinaryRequestConstants,
MappedClassConstants,
JNBDispatcherConstants,
DebugConstants,
MessageKeys {
    boolean useThreadTrue;
    byte[] ttThreadDesignator = new byte[2];
    private static Class[] longParams = new Class[]{Long.TYPE};
    private static Class dotNetObjectClass;
    private static boolean throwSecurityException;

    public BinaryFormatter(boolean bl) {
        this.useThreadTrue = bl;
        this.ttThreadDesignator[0] = -1;
        this.ttThreadDesignator[1] = 1;
    }

    public BinaryFormatter() {
        this.useThreadTrue = true;
        this.ttThreadDesignator[0] = -1;
        this.ttThreadDesignator[1] = 1;
    }

    private static IDotNetSideProxy getMyDotNetSideProxy(Object object) {
        if (object instanceof DotNetObjectBase) {
            return ((DotNetObjectBase)object).getMyDotNetSideProxy();
        }
        return null;
    }

    public void serializeCall(OutputStream outputStream, HashMap hashMap) throws SerializationException {
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[2];
        try {
            int n;
            DotNetDataOutputStream dotNetDataOutputStream = new DotNetDataOutputStream(new DataOutputStream(outputStream));
            byArray[0] = -1;
            byArray[1] = -1;
            Integer n2 = (Integer)hashMap.get("targetObjectID");
            byArray[2] = (byte)n2.intValue();
            n2 = (Integer)hashMap.get("targetMethodID");
            int n3 = n2;
            byArray[3] = (byte)n3;
            dotNetDataOutputStream.write(byArray);
            String[] stringArray = JNBDispatchMap.getJ2NArgName(n3);
            for (n = 0; n < stringArray.length; ++n) {
                this.serializeValue(dotNetDataOutputStream, hashMap.get(stringArray[n]), true);
            }
            n = 0;
            Object v = hashMap.get("objID");
            if (v == null) {
                v = hashMap.get("className");
            }
            if (n3 != 1 && v != null) {
                Object object;
                if (v instanceof String) {
                    object = (String)v;
                    n = DotNetObjectBase.isThreadTrue((String)object) ? 1 : 0;
                } else {
                    object = (Long)v;
                    n = DotNetObjectBase.isThreadTrue((Long)object) ? 1 : 0;
                }
                if (n != 0) {
                    object = ThreadID.getThreadID();
                    dotNetDataOutputStream.write(this.ttThreadDesignator);
                    dotNetDataOutputStream.write((byte[])object);
                } else if (JavaTM.areTransactionsEnabled() && JavaTM.isWithinTransactionScope(ThreadID.getThreadID())) {
                    Object object2 = object = v instanceof String ? (String)v : DotNetObjectBase.classNameForID((Long)v);
                    if (!((String)object).equals("") && !((String)object).startsWith("com.jnbridge.")) {
                        throw new SerializationException(Messages.getString("TRANSACTION_NOT_TT") + (String)object);
                    }
                }
            }
            byArray2[0] = 0;
            byArray2[1] = 0;
            dotNetDataOutputStream.write(byArray2);
        }
        catch (IOException iOException) {
            throw new SerializationException(Messages.getString("BINARYFORMATTER_SERIALIZECALL") + " " + iOException.getMessage(), iOException);
        }
    }

    public void serializeResult(OutputStream outputStream, int n, int n2, Object object, boolean bl) throws SerializationException {
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[2];
        try {
            byArray[0] = -1;
            byArray[1] = -2;
            byArray[2] = (byte)n;
            byArray[3] = (byte)n2;
            DotNetDataOutputStream dotNetDataOutputStream = new DotNetDataOutputStream(new DataOutputStream(outputStream));
            outputStream.write(byArray);
            this.serializeValue(dotNetDataOutputStream, object, bl);
            byArray2[0] = -128;
            byArray2[1] = 0;
            outputStream.write(byArray2);
        }
        catch (IOException iOException) {
            throw new SerializationException("IOException: " + iOException.getMessage(), iOException);
        }
    }

    public void serializeException(OutputStream outputStream, Throwable throwable) throws SerializationException {
        try {
            String string;
            String string2;
            Object object;
            byte by;
            byte by2 = 0;
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            long l = 0L;
            String string3 = null;
            String string4 = DEFAULT_REMOTE_STACK_TRACE;
            int n = 0;
            String string5 = DEFAULT_EXCEPTION_METHOD;
            int n2 = -2146232832;
            String string6 = "JNBShare";
            if (throwable instanceof InvocationTargetException) {
                by = 2;
                object = ((InvocationTargetException)throwable).getTargetException();
                string2 = ((Throwable)object).getMessage();
                ((Throwable)object).printStackTrace(printWriter);
                string = stringWriter.toString();
                JNBObjID jNBObjID = ObjectRegistry.getObjectID(object);
                l = jNBObjID.getObjID();
                string3 = object.getClass().getName();
            } else if (throwable instanceof CallbackException) {
                by = 2;
                string2 = throwable.getMessage();
                throwable.printStackTrace(printWriter);
                string = stringWriter.toString();
                object = ObjectRegistry.getObjectID(throwable);
                l = ((JNBObjID)object).getObjID();
                string3 = throwable.getClass().getName();
            } else if (throwable instanceof InternalException) {
                by = 0;
                string2 = Messages.getString("BINARYFORMATTER_SERIALIZEEXCEPTION_1") + " " + throwable.getMessage();
                throwable.printStackTrace(printWriter);
                string = stringWriter.toString();
            } else if (throwable instanceof BinaryException) {
                by = 1;
                string2 = Messages.getString("BINARYFORMATTER_SERIALIZEEXCEPTION_2") + " " + throwable.getMessage();
                throwable.printStackTrace(printWriter);
                string = stringWriter.toString();
            } else {
                by = 0;
                string2 = Messages.getString("BINARYFORMATTER_SERIALIZEEXCEPTION_1") + " " + throwable.getClass() + ":" + throwable.getMessage();
                throwable.printStackTrace(printWriter);
                string = stringWriter.toString();
            }
            object = new DotNetDataOutputStream(new DataOutputStream(outputStream));
            ((DotNetDataOutputStream)object).write(255);
            ((DotNetDataOutputStream)object).write(240);
            ((DotNetDataOutputStream)object).writeByte(by2);
            ((DotNetDataOutputStream)object).writeByte(by);
            this.serializeValue((DotNetDataOutputStream)object, string2, true);
            this.serializeValue((DotNetDataOutputStream)object, string, true);
            if (by == 2) {
                ((DotNetDataOutputStream)object).writeLong(l);
                this.serializeValue((DotNetDataOutputStream)object, string3, true);
                this.serializeValue((DotNetDataOutputStream)object, string4, true);
                ((DotNetDataOutputStream)object).writeInt(n);
                this.serializeValue((DotNetDataOutputStream)object, string5, true);
                ((DotNetDataOutputStream)object).writeInt(n2);
                this.serializeValue((DotNetDataOutputStream)object, string6, true);
            }
            ((DotNetDataOutputStream)object).write(192);
            ((DotNetDataOutputStream)object).write(0);
        }
        catch (IOException iOException) {
            throw new SerializationException("IOException: " + iOException.getMessage(), iOException);
        }
    }

    public CallArgs deserializeCall(InputStream inputStream) throws SerializationException, InterruptedIOException, CallbackException {
        byte[] byArray = new byte[4];
        boolean bl = false;
        try {
            Object object;
            Object object2;
            DotNetDataInputStream dotNetDataInputStream = new DotNetDataInputStream(new DataInputStream(inputStream));
            dotNetDataInputStream.read(byArray);
            bl = true;
            Object object3 = byArray[0];
            Object object4 = byArray[1];
            if ((byte)object3 != -1 || (byte)object4 != -1) {
                throw new SerializationException(Messages.getString("BINARYFORMATTER_DESERIALIZECALL_1"));
            }
            byte by = byArray[2];
            if ((byte)by != 0) {
                throw new SerializationException(Messages.getString("BINARYFORMATTER_DESERIALIZECALL_2"));
            }
            byte by2 = byArray[3];
            if (by2 < 0 || by2 > 105) {
                throw new SerializationException(Messages.getString("BINARYFORMATTER_DESERIALIZECALL_3"));
            }
            String[] stringArray = JNBDispatchMap.getN2JArgName(by2);
            BinaryCallArgs binaryCallArgs = new BinaryCallArgs();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("genericParams")) continue;
                binaryCallArgs.setArg(stringArray[i], this.getValue(dotNetDataInputStream));
            }
            Object[] objectArray = binaryCallArgs.getArg("args");
            if (objectArray != null) {
                object2 = binaryCallArgs.getArg("signature");
                objectArray = BinaryArgConverter.convertArgs(object2, objectArray);
                binaryCallArgs.setArg("args", objectArray);
            } else {
                object2 = binaryCallArgs.getArg("val");
                if (object2 != null) {
                    String string = (String)binaryCallArgs.getArg("signature");
                    object = BinaryArgConverter.convertOneArg(string, object2);
                    binaryCallArgs.setArg("val", object);
                }
            }
            object2 = new byte[2];
            dotNetDataInputStream.read((byte[])object2);
            object3 = object2[0];
            object4 = object2[1];
            boolean bl2 = false;
            object = null;
            if ((byte)object3 == -1 && (byte)object4 == 1) {
                bl2 = this.useThreadTrue;
                object = new byte[16];
                dotNetDataInputStream.read((byte[])object);
                dotNetDataInputStream.read((byte[])object2);
                object3 = object2[0];
                object4 = object2[1];
                if ((byte)object3 != 0 || (byte)object4 != 0) {
                    throw new SerializationException(Messages.getString("BINARYFORMATTER_DESERIALIZECALL_4"));
                }
            } else if ((byte)object3 != 0 || (byte)object4 != 0) {
                throw new SerializationException(Messages.getString("BINARYFORMATTER_DESERIALIZECALL_4"));
            }
            binaryCallArgs.setArg("isThreadTrue", new Boolean(bl2));
            binaryCallArgs.setArg("threadID", object);
            binaryCallArgs.setArg("targetObjectID", new Integer(by));
            binaryCallArgs.setArg("targetMethodID", new Integer(by2));
            return binaryCallArgs;
        }
        catch (InterruptedIOException interruptedIOException) {
            throw interruptedIOException;
        }
        catch (EOFException eOFException) {
            if (!bl) {
                throw new InterruptedIOException();
            }
            throw new SerializationException(Messages.getString("BINARYFORMATTER_DESERIALIZECALL_5"), eOFException);
        }
        catch (IOException iOException) {
            throw new SerializationException("IOException: " + iOException.getMessage(), iOException);
        }
        catch (InternalException internalException) {
            throw new SerializationException("InternalException: " + internalException.getMessage(), internalException);
        }
        catch (BinaryException binaryException) {
            throw new SerializationException("BinaryException: " + binaryException.getMessage(), binaryException);
        }
    }

    public Object deserializeResponse(InputStream inputStream) throws SerializationException {
        byte[] byArray = new byte[2];
        try {
            inputStream.read(byArray);
            if (byArray[0] == -1 && byArray[1] == -2) {
                return this.deserializeResult(inputStream);
            }
            if (byArray[0] == -1 && byArray[1] == -16) {
                return this.deserializeException(inputStream);
            }
            throw new SerializationException(Messages.getString("BINARYFORMATTER_DESERIALIZERESPONSE_1"));
        }
        catch (IOException iOException) {
            throw new SerializationException(Messages.getString("BINARYFORMATTER_DESERIALIZERESPONSE_2") + " " + iOException.getMessage(), iOException);
        }
    }

    private Object deserializeResult(InputStream inputStream) throws SerializationException {
        byte[] byArray = new byte[2];
        try {
            inputStream.read(byArray);
            if (byArray[0] != 1) {
                throw new SerializationException(Messages.getString("BINARYFORMATTER_DESERIALIZERESULT_1"));
            }
            DotNetDataInputStream dotNetDataInputStream = new DotNetDataInputStream(new DataInputStream(inputStream));
            Object object = this.getValue(dotNetDataInputStream);
            inputStream.read(byArray);
            if (byArray[0] != -128 && byArray[0] != 0 || byArray[1] != 0) {
                throw new SerializationException(Messages.getString("BINARYFORMATTER_DESERIALIZERESULT_2"));
            }
            return object;
        }
        catch (IOException iOException) {
            throw new SerializationException(Messages.getString("BINARYFORMATTER_DESERIALIZERESULT_3") + " " + iOException.getMessage(), iOException);
        }
        catch (BinaryException binaryException) {
            throw new SerializationException(Messages.getString("BINARYFORMATTER_DESERIALIZERESULT_4") + " " + binaryException.getMessage(), binaryException);
        }
    }

    private Throwable deserializeException(InputStream inputStream) throws SerializationException {
        byte[] byArray = new byte[2];
        try {
            inputStream.read(byArray);
            if (byArray[0] != 1) {
                throw new SerializationException(Messages.getString("BINARYFORMATTER_DESERIALIZEEXCEPTION_1"));
            }
            DotNetDataInputStream dotNetDataInputStream = new DotNetDataInputStream(new DataInputStream(inputStream));
            byte by = byArray[1];
            String string = (String)this.getValue(dotNetDataInputStream);
            String string2 = (String)this.getValue(dotNetDataInputStream);
            long l = 0L;
            String string3 = null;
            String string4 = null;
            int n = 0;
            String string5 = null;
            int n2 = 0;
            String string6 = null;
            if (by == 2) {
                l = dotNetDataInputStream.readLong();
                string3 = (String)this.getValue(dotNetDataInputStream);
                string4 = (String)this.getValue(dotNetDataInputStream);
                n = dotNetDataInputStream.readInt();
                string5 = (String)this.getValue(dotNetDataInputStream);
                n2 = dotNetDataInputStream.readInt();
                string6 = (String)this.getValue(dotNetDataInputStream);
            }
            inputStream.read(byArray);
            if (byArray[0] != -64 && byArray[0] != 0 || byArray[1] != 0) {
                System.out.println("twoBytes[0] = " + byArray[0] + ", twoBytes[1] = " + byArray[1]);
                throw new SerializationException(Messages.getString("BINARYFORMATTER_DESERIALIZEEXCEPTION_2"));
            }
            if (by == 2) {
                return new JNBException(string, string2, l, string3);
            }
            if (string.indexOf("Object '/JNBDotNetDispatcher' has been disconnected or does not exist at the server") != -1) {
                string = Messages.getString("BINARYFORMATTER_DESERIALIZEEXCEPTION_5");
            }
            return new JNBInternalException(string, string2);
        }
        catch (IOException iOException) {
            throw new SerializationException(Messages.getString("BINARYFORMATTER_DESERIALIZEEXCEPTION_3") + " " + iOException.getMessage(), iOException);
        }
        catch (BinaryException binaryException) {
            throw new SerializationException(Messages.getString("BINARYFORMATTER_DESERIALIZEEXCEPTION_4") + " " + binaryException.getMessage(), binaryException);
        }
    }

    private void serializeValue(DotNetDataOutputStream dotNetDataOutputStream, Object object, boolean bl) throws IOException {
        if (object == null) {
            dotNetDataOutputStream.write(0);
        } else if (object instanceof JNBVoidResult) {
            dotNetDataOutputStream.write(-1);
        } else if (object instanceof Integer) {
            int n = (Integer)object;
            byte[] byArray = new byte[]{1, (byte)(0xFF & n), (byte)(0xFF & n >> 8), (byte)(0xFF & n >> 16), (byte)(0xFF & n >> 24)};
            dotNetDataOutputStream.write(byArray);
        } else if (object instanceof Short) {
            short s = (Short)object;
            byte[] byArray = new byte[]{2, (byte)(0xFF & s), (byte)(0xFF & s >> 8)};
            dotNetDataOutputStream.write(byArray);
        } else if (object instanceof Long) {
            long l = (Long)object;
            byte[] byArray = new byte[]{3, (byte)(0xFFL & l), (byte)(0xFFL & l >> 8), (byte)(0xFFL & l >> 16), (byte)(0xFFL & l >> 24), (byte)(0xFFL & l >> 32), (byte)(0xFFL & l >> 40), (byte)(0xFFL & l >> 48), (byte)(0xFFL & l >> 56)};
            dotNetDataOutputStream.write(byArray);
        } else if (object instanceof Float) {
            float f = ((Float)object).floatValue();
            int n = Float.floatToIntBits(f);
            byte[] byArray = new byte[]{4, (byte)(0xFF & n), (byte)(0xFF & n >> 8), (byte)(0xFF & n >> 16), (byte)(0xFF & n >> 24)};
            dotNetDataOutputStream.write(byArray);
        } else if (object instanceof Double) {
            double d = (Double)object;
            long l = Double.doubleToLongBits(d);
            byte[] byArray = new byte[]{5, (byte)(0xFFL & l), (byte)(0xFFL & l >> 8), (byte)(0xFFL & l >> 16), (byte)(0xFFL & l >> 24), (byte)(0xFFL & l >> 32), (byte)(0xFFL & l >> 40), (byte)(0xFFL & l >> 48), (byte)(0xFFL & l >> 56)};
            dotNetDataOutputStream.write(byArray);
        } else if (object instanceof Character) {
            char c = ((Character)object).charValue();
            byte[] byArray = new byte[]{6, 0, (byte)(c >> 8 & 0xFF), (byte)(c & 0xFF)};
            dotNetDataOutputStream.write(byArray);
        } else if (object instanceof Byte) {
            byte by = (Byte)object;
            byte[] byArray = new byte[]{7, by};
            dotNetDataOutputStream.write(byArray);
        } else if (object instanceof Boolean) {
            boolean bl2 = (Boolean)object;
            byte[] byArray = new byte[]{8, bl2 ? (byte)1 : 0};
            dotNetDataOutputStream.write(byArray);
        } else if (object instanceof String) {
            dotNetDataOutputStream.write(10);
            this.writeString(dotNetDataOutputStream, (String)object);
        } else if ("System.BoxedUInt".equals(object.getClass().getName())) {
            Long l = (Long)BoxedValueFactory.unbox(object);
            long l2 = l;
            byte[] byArray = new byte[]{21, (byte)(0xFFL & l2), (byte)(0xFFL & l2 >> 8), (byte)(0xFFL & l2 >> 16), (byte)(0xFFL & l2 >> 24), (byte)(0xFFL & l2 >> 32), (byte)(0xFFL & l2 >> 40), (byte)(0xFFL & l2 >> 48), (byte)(0xFFL & l2 >> 56)};
            dotNetDataOutputStream.write(byArray);
        } else if ("System.BoxedUShort".equals(object.getClass().getName())) {
            Integer n = (Integer)BoxedValueFactory.unbox(object);
            int n2 = n;
            byte[] byArray = new byte[]{22, (byte)(0xFF & n2), (byte)(0xFF & n2 >> 8), (byte)(0xFF & n2 >> 16), (byte)(0xFF & n2 >> 24)};
            dotNetDataOutputStream.write(byArray);
        } else if ("System.BoxedULong".equals(object.getClass().getName())) {
            Float f = (Float)BoxedValueFactory.unbox(object);
            float f2 = f.floatValue();
            int n = Float.floatToIntBits(f2);
            byte[] byArray = new byte[]{23, (byte)(0xFF & n), (byte)(0xFF & n >> 8), (byte)(0xFF & n >> 16), (byte)(0xFF & n >> 24)};
            dotNetDataOutputStream.write(byArray);
        } else if ("System.BoxedByte".equals(object.getClass().getName())) {
            Short s = (Short)BoxedValueFactory.unbox(object);
            short s2 = s;
            byte[] byArray = new byte[]{24, (byte)(0xFF & s2), (byte)(0xFF & s2 >> 8)};
            dotNetDataOutputStream.write(byArray);
        } else if (bl && EnumInfo.isEnum(object.getClass())) {
            dotNetDataOutputStream.write(20);
            this.writeString(dotNetDataOutputStream, object.getClass().getName());
            this.writeString(dotNetDataOutputStream, EnumInfo.name(object));
        } else if (object instanceof DotNetWrapper) {
            Object object2 = ((DotNetWrapper)object).getWrappedValue();
            this.serializeValue(dotNetDataOutputStream, object2, bl);
        } else if (object instanceof JNBObjID) {
            JNBObjID jNBObjID = (JNBObjID)object;
            long l = jNBObjID.getObjID();
            byte[] byArray = new byte[]{9, (byte)(0xFFL & l), (byte)(0xFFL & l >> 8), (byte)(0xFFL & l >> 16), (byte)(0xFFL & l >> 24), (byte)(0xFFL & l >> 32), (byte)(0xFFL & l >> 40), (byte)(0xFFL & l >> 48), (byte)(0xFFL & l >> 56)};
            dotNetDataOutputStream.write(byArray);
            this.writeString(dotNetDataOutputStream, jNBObjID.getClassName());
        } else if (object instanceof JNBDotNetObjID) {
            JNBDotNetObjID jNBDotNetObjID = (JNBDotNetObjID)object;
            long l = jNBDotNetObjID.getObjID();
            byte[] byArray = new byte[]{16, (byte)(0xFFL & l), (byte)(0xFFL & l >> 8), (byte)(0xFFL & l >> 16), (byte)(0xFFL & l >> 24), (byte)(0xFFL & l >> 32), (byte)(0xFFL & l >> 40), (byte)(0xFFL & l >> 48), (byte)(0xFFL & l >> 56)};
            dotNetDataOutputStream.write(byArray);
            this.writeString(dotNetDataOutputStream, jNBDotNetObjID.getClassName());
        } else if (object instanceof JNBDotNetCallback) {
            JNBDotNetCallback jNBDotNetCallback = (JNBDotNetCallback)object;
            long l = jNBDotNetCallback.callbackID;
            String string = jNBDotNetCallback.theInterface;
            int n = string.length();
            String string2 = jNBDotNetCallback.theClassName;
            int n3 = string2.length();
            byte[] byArray = new byte[]{17, jNBDotNetCallback.isSync ? (byte)1 : 0, (byte)(0xFFL & l), (byte)(0xFFL & l >> 8), (byte)(0xFFL & l >> 16), (byte)(0xFFL & l >> 24), (byte)(0xFFL & l >> 32), (byte)(0xFFL & l >> 40), (byte)(0xFFL & l >> 48), (byte)(0xFFL & l >> 56)};
            dotNetDataOutputStream.write(byArray);
            this.writeString(dotNetDataOutputStream, string);
            this.writeString(dotNetDataOutputStream, string2);
        } else if (object instanceof JNBValueObject) {
            JNBValueObject jNBValueObject = (JNBValueObject)object;
            Object object3 = jNBValueObject.getObject();
            Class<?> clazz = object3.getClass();
            String string = clazz.getName();
            if (MappedClass.isMapped(clazz)) {
                int n = MappedClass.getSize(object3);
                byte[] byArray = new byte[7];
                byArray[0] = 15;
                short s = MappedClass.getMappingScheme(string);
                byArray[1] = (byte)(0xFF & s);
                byArray[2] = (byte)(0xFF & s >> 8);
                byArray[3] = (byte)(0xFF & n);
                byArray[4] = (byte)(0xFF & n >> 8);
                byArray[5] = (byte)(0xFF & n >> 16);
                byArray[6] = (byte)(0xFF & n >> 24);
                dotNetDataOutputStream.write(byArray);
                this.writeString(dotNetDataOutputStream, string);
                if (s == 3) {
                    Date date = (Date)object3;
                    long l = date.getTime();
                    long l3 = 10000L * l + 621355968000000000L;
                    dotNetDataOutputStream.writeLong(l3);
                } else if (s == 4) {
                    String string3 = object3 instanceof BigDecimal ? BigDecimalHelper.toString(object3) : object3.toString();
                    this.serializeValue(dotNetDataOutputStream, string3, bl);
                } else {
                    Iterator iterator = MappedClass.getSetIterator(object3);
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        switch (s) {
                            case 2: {
                                Map.Entry entry = (Map.Entry)e;
                                this.serializeValue(dotNetDataOutputStream, entry.getKey(), bl);
                                this.serializeValue(dotNetDataOutputStream, entry.getValue(), bl);
                                break;
                            }
                            case 1: {
                                this.serializeValue(dotNetDataOutputStream, e, bl);
                            }
                        }
                    }
                }
            } else {
                HashMap hashMap = jNBValueObject.getFields(bl);
                byte[] byArray = new byte[4];
                byArray[0] = 14;
                byArray[1] = jNBValueObject.isJavaBean() ? (byte)1 : 0;
                short s = (short)hashMap.size();
                byArray[2] = (byte)(0xFF & s);
                byArray[3] = (byte)(0xFF & s >> 8);
                dotNetDataOutputStream.write(byArray);
                this.writeString(dotNetDataOutputStream, string);
                Set set = hashMap.entrySet();
                for (Map.Entry entry : set) {
                    String string4 = (String)entry.getKey();
                    Object v = entry.getValue();
                    this.writeString(dotNetDataOutputStream, string4);
                    this.serializeValue(dotNetDataOutputStream, v, bl);
                }
            }
        } else if (object instanceof JNBDotNetValueObject || BinaryFormatter.isByValue(object)) {
            JNBDotNetValueObject jNBDotNetValueObject = BinaryFormatter.isByValue(object) ? new JNBDotNetValueObject(object) : (JNBDotNetValueObject)object;
            Object object4 = jNBDotNetValueObject.getObject();
            Class<?> clazz = object4.getClass();
            String string = clazz.getName();
            if (DotNetMappedClass.isMapped(string)) {
                int n = DotNetMappedClass.getSize(object4);
                byte[] byArray = new byte[7];
                byArray[0] = 19;
                short s = DotNetMappedClass.getMappingScheme(string);
                byArray[1] = (byte)(0xFF & s);
                byArray[2] = (byte)(0xFF & s >> 8);
                byArray[3] = (byte)(0xFF & n);
                byArray[4] = (byte)(0xFF & n >> 8);
                byArray[5] = (byte)(0xFF & n >> 16);
                byArray[6] = (byte)(0xFF & n >> 24);
                dotNetDataOutputStream.write(byArray);
                this.writeString(dotNetDataOutputStream, string);
                if (s == 3) {
                    try {
                        Field field = clazz.getField("NativeImpl");
                        Date date = (Date)field.get(object4);
                        long l = date.getTime();
                        long l4 = 10000L * l + 621355968000000000L;
                        dotNetDataOutputStream.writeLong(l4);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        throw new DotNetSideException(Messages.getString("BINARYFORMATTER_SERIALIZEVALUE_1"));
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new DotNetSideException(Messages.getString("BINARYFORMATTER_SERIALIZEVALUE_2"));
                    }
                } else if (s == 4) {
                    try {
                        Field field = clazz.getField("NativeImpl");
                        Object object5 = field.get(object4);
                        String string5 = object4 instanceof BigDecimal ? BigDecimalHelper.toString(object5) : object5.toString();
                        this.serializeValue(dotNetDataOutputStream, string5, bl);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        throw new DotNetSideException(Messages.getString("BINARYFORMATTER_SERIALIZEVALUE_3"));
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new DotNetSideException(Messages.getString("BINARYFORMATTER_SERIALIZEVALUE_4"));
                    }
                } else {
                    Iterator iterator = DotNetMappedClass.getSetIterator(object4);
                    while (iterator.hasNext()) {
                        Object object6 = iterator.next();
                        switch (s) {
                            case 2: {
                                Map.Entry entry = (Map.Entry)object6;
                                Object object7 = entry.getKey();
                                String string6 = object7 == null ? "System.Object" : object7.getClass().getName();
                                object7 = DotNetObjectBase.convertArgFromJava(string6, object7);
                                this.serializeValue(dotNetDataOutputStream, object7, bl);
                                Object object8 = entry.getValue();
                                if (object8 instanceof NullValue) {
                                    object8 = null;
                                }
                                String string7 = object8 == null ? "System.Object" : object8.getClass().getName();
                                object8 = DotNetObjectBase.convertArgFromJava(string7, object8);
                                this.serializeValue(dotNetDataOutputStream, object8, bl);
                                break;
                            }
                            case 1: {
                                String string8 = object6 == null ? "System.Object" : object6.getClass().getName();
                                object6 = DotNetObjectBase.convertArgFromJava(string8, object6);
                                this.serializeValue(dotNetDataOutputStream, object6, bl);
                            }
                        }
                    }
                }
            } else {
                HashMap hashMap = jNBDotNetValueObject.getFields();
                byte[] byArray = new byte[3];
                byArray[0] = 18;
                short s = (short)hashMap.size();
                byArray[1] = (byte)(0xFF & s);
                byArray[2] = (byte)(0xFF & s >> 8);
                dotNetDataOutputStream.write(byArray);
                this.writeString(dotNetDataOutputStream, string);
                Set set = hashMap.entrySet();
                for (Map.Entry entry : set) {
                    String string9 = (String)entry.getKey();
                    Object v = entry.getValue();
                    this.writeString(dotNetDataOutputStream, string9);
                    this.serializeValue(dotNetDataOutputStream, v, bl);
                }
            }
        } else if (object.getClass().isArray() || object instanceof JNBArrayWrapper) {
            Object object9;
            String string = null;
            if (object instanceof JNBArrayWrapper) {
                object9 = (JNBArrayWrapper)object;
                string = DotNetArgTypeConverter.convertToDotNetEquivType(((JNBArrayWrapper)object9).getArrayTypeStr());
                object = ((JNBArrayWrapper)object9).getArray();
            } else {
                string = DotNetArgTypeConverter.convertToDotNetEquivType(object.getClass().getName());
            }
            object9 = this.getComponentInfo(object);
            int n = Array.getLength(object);
            if (((ComponentInfo)object9).rank == 1) {
                switch (((ComponentInfo)object9).baseType) {
                    case 1: {
                        dotNetDataOutputStream.writeIntArray((int[])object, n);
                        break;
                    }
                    case 5: {
                        dotNetDataOutputStream.writeDoubleArray((double[])object, n);
                        break;
                    }
                    case 2: {
                        dotNetDataOutputStream.writeShortArray((short[])object, n);
                        break;
                    }
                    case 3: {
                        dotNetDataOutputStream.writeLongArray((long[])object, n);
                        break;
                    }
                    case 4: {
                        dotNetDataOutputStream.writeFloatArray((float[])object, n);
                        break;
                    }
                    case 7: {
                        dotNetDataOutputStream.writeByteArray((byte[])object, n);
                        break;
                    }
                    case 6: {
                        dotNetDataOutputStream.writeCharArray((char[])object, n);
                        break;
                    }
                    case 8: {
                        dotNetDataOutputStream.writeBooleanArray((boolean[])object, n);
                        break;
                    }
                    default: {
                        byte[] byArray = new byte[]{11, ((ComponentInfo)object9).rank, (byte)(0xFF & n), (byte)(0xFF & n >> 8), (byte)(0xFF & n >> 16), (byte)(0xFF & n >> 24), ((ComponentInfo)object9).baseType};
                        dotNetDataOutputStream.write(byArray);
                        this.writeString(dotNetDataOutputStream, string);
                        for (int i = 0; i < n; ++i) {
                            this.serializeValue(dotNetDataOutputStream, Array.get(object, i), bl);
                        }
                    }
                }
            } else {
                byte[] byArray = new byte[]{11, ((ComponentInfo)object9).rank, (byte)(0xFF & n), (byte)(0xFF & n >> 8), (byte)(0xFF & n >> 16), (byte)(0xFF & n >> 24), ((ComponentInfo)object9).baseType};
                dotNetDataOutputStream.write(byArray);
                this.writeString(dotNetDataOutputStream, string);
                for (int i = 0; i < n; ++i) {
                    this.serializeValue(dotNetDataOutputStream, Array.get(object, i), bl);
                }
            }
        } else {
            Object object10 = ObjectRegistry.registerObject(object, true);
            this.serializeValue(dotNetDataOutputStream, object10, bl);
        }
    }

    private void writeString(DotNetDataOutputStream dotNetDataOutputStream, String string) throws IOException {
        dotNetDataOutputStream.write(0);
        int n = string.length();
        dotNetDataOutputStream.writeInt(n);
        char[] cArray = string.toCharArray();
        dotNetDataOutputStream.write(cArray);
    }

    private ComponentInfo getComponentInfo(Object object) {
        Class<?> clazz = object.getClass();
        byte by = 0;
        int n = 0;
        while (clazz.isArray()) {
            by = (byte)(by + 1);
            clazz = clazz.getComponentType();
        }
        n = clazz == Integer.TYPE ? 1 : (clazz == Short.TYPE ? 2 : (clazz == Long.TYPE ? 3 : (clazz == Float.TYPE ? 4 : (clazz == Double.TYPE ? 5 : (clazz == Character.TYPE ? 6 : (clazz == Byte.TYPE ? 7 : (clazz == Boolean.TYPE ? 8 : (clazz == String.class ? 10 : (clazz == JNBObjID.class ? 9 : 9)))))))));
        return new ComponentInfo(by, (byte)n);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Object getValue(DotNetDataInputStream var1_1) throws IOException, BinaryException {
        var2_2 = var1_1.read();
        var15_3 = null;
        switch (var2_2) {
            case 255: {
                return new JNBVoidResult();
            }
            case 0: {
                return null;
            }
            case 1: {
                var3_4 = var1_1.readInt();
                return new Integer(var3_4);
            }
            case 2: {
                var4_7 = var1_1.readShort();
                return new Short(var4_7);
            }
            case 3: {
                var5_13 = var1_1.readLong();
                return new Long(var5_13);
            }
            case 4: {
                var7_17 = var1_1.readFloat();
                return new Float(var7_17);
            }
            case 5: {
                var8_18 = var1_1.readDouble();
                return new Double(var8_18);
            }
            case 6: {
                var17_19 = new byte[3];
                var1_1.read(var17_19);
                var11_20 = var17_19[0];
                var4_8 = (short)(var17_19[1] << 8 | var17_19[2]);
                return new Character((char)var4_8);
            }
            case 7: {
                var11_21 = var1_1.readByte();
                return new Byte(var11_21);
            }
            case 8: {
                var12_22 = var1_1.readBoolean();
                return new Boolean(var12_22);
            }
            case 20: {
                var18_25 = this.getString(var1_1);
                var19_26 = this.getString(var1_1);
                return EnumInfo.getEnum(var18_25, var19_26);
            }
            case 9: {
                var5_14 = var1_1.readLong();
                var13_27 = this.getString(var1_1);
                return new JNBObjID(var5_14, var13_27);
            }
            case 16: {
                var5_15 = var1_1.readLong();
                var13_28 = this.getString(var1_1);
                return new JNBDotNetObjID(var5_15, var13_28);
            }
            case 15: {
                var4_9 = var1_1.readShort();
                var3_5 = var1_1.readInt();
                var13_29 = this.getString(var1_1);
                var16_34 = Thread.currentThread().getContextClassLoader();
                try {
                    switch (var4_9) {
                        case 1: {
                            try {
                                var14_36 = Class.forName(var13_29, false, var16_34);
                            }
                            catch (ClassNotFoundException var20_43) {
                                var16_34 = this.getClass().getClassLoader();
                                var14_36 = Class.forName(var13_29, false, var16_34);
                            }
                            var20_44 = (Collection)var14_36.newInstance();
                            for (var21_65 = 0; var21_65 < var3_5; ++var21_65) {
                                var22_72 = this.getValue(var1_1);
                                if (var22_72 != null && var22_72 instanceof JNBObjID) {
                                    var22_72 = ObjectRegistry.getObjectFromID((JNBObjID)var22_72);
                                } else if (var22_72 != null && var22_72 instanceof JNBValueObject) {
                                    var22_72 = ((JNBValueObject)var22_72).getObject();
                                } else if (var22_72 != null && (var22_72 instanceof JNBArrayWrapper || var22_72.getClass().isArray())) {
                                    if (var22_72 instanceof JNBArrayWrapper) {
                                        var23_81 = (JNBArrayWrapper)var22_72;
                                        var22_72 = var23_81.getArray();
                                    }
                                    var22_72 = BinaryFormatter.unwrapArray(var22_72, var22_72.getClass().getComponentType(), BinaryFormatter.getMyDotNetSideProxy(var20_44));
                                }
                                var20_44.add(var22_72);
                            }
                            var15_3 = var20_44;
                            break;
                        }
                        case 2: {
                            var14_37 = Class.forName(var13_29, false, var16_34);
                            var21_66 = (Map)var14_37.newInstance();
                            for (var22_73 = 0; var22_73 < var3_5; ++var22_73) {
                                var23_82 = this.getValue(var1_1);
                                if (var23_82 != null && var23_82 instanceof JNBObjID) {
                                    var23_82 = ObjectRegistry.getObjectFromID((JNBObjID)var23_82);
                                } else if (var23_82 != null && var23_82 instanceof JNBValueObject) {
                                    var23_82 = ((JNBValueObject)var23_82).getObject();
                                } else if (var23_82 != null && (var23_82 instanceof JNBArrayWrapper || var23_82.getClass().isArray())) {
                                    if (var23_82 instanceof JNBArrayWrapper) {
                                        var24_86 = (JNBArrayWrapper)var23_82;
                                        var23_82 = var24_86.getArray();
                                    }
                                    var23_82 = BinaryFormatter.unwrapArray(var23_82, var23_82.getClass().getComponentType(), BinaryFormatter.getMyDotNetSideProxy(var21_66));
                                }
                                var24_86 = this.getValue(var1_1);
                                if (var24_86 != null && var24_86 instanceof JNBObjID) {
                                    var24_86 = ObjectRegistry.getObjectFromID((JNBObjID)var24_86);
                                } else if (var24_86 != null && var24_86 instanceof JNBValueObject) {
                                    var24_86 = ((JNBValueObject)var24_86).getObject();
                                } else if (var24_86 != null && (var24_86 instanceof JNBArrayWrapper || var24_86.getClass().isArray())) {
                                    if (var24_86 instanceof JNBArrayWrapper) {
                                        var25_92 = (JNBArrayWrapper)var24_86;
                                        var24_86 = var25_92.getArray();
                                    }
                                    var24_86 = BinaryFormatter.unwrapArray(var24_86, var24_86.getClass().getComponentType(), BinaryFormatter.getMyDotNetSideProxy(var21_66));
                                }
                                var21_66.put(var23_82, var24_86);
                            }
                            var15_3 = var21_66;
                            break;
                        }
                        case 3: {
                            var22_74 = var1_1.readLong();
                            var24_87 = (var22_74 - 621355968000000000L) / 10000L;
                            try {
                                var14_38 = Class.forName(var13_29, false, var16_34);
                            }
                            catch (ClassNotFoundException var26_101) {
                                var16_34 = this.getClass().getClassLoader();
                                var14_38 = Class.forName(var13_29, false, var16_34);
                            }
                            try {
                                var26_102 = var14_38.getConstructor(BinaryFormatter.longParams);
                                var27_110 = (Date)var26_102.newInstance(new Object[]{new Long(var24_87)});
                                var15_3 = var27_110;
                                break;
                            }
                            catch (NoSuchMethodException var26_103) {
                                throw new BinaryException(Messages.getString("BINARYFORMATTER_GETVALUE_1") + " " + var13_29);
                            }
                            catch (InvocationTargetException var26_104) {
                                throw new BinaryException(Messages.getString("BINARYFORMATTER_GETVALUE_2") + " " + var13_29 + ": " + var26_104.getTargetException().getMessage());
                            }
                        }
                        case 4: {
                            var26_105 = (String)this.getValue(var1_1);
                            if (var13_29.equals("java.math.BigDecimal")) {
                                var27_111 = new BigDecimal(var26_105);
                                var15_3 = var27_111;
                                break;
                            }
                            if (var13_29.equals("java.math.BigInteger")) {
                                var27_112 = new BigInteger(var26_105);
                                var15_3 = var27_112;
                                break;
                            }
                            throw new BinaryException(Messages.getString("BINARYFORMATTER_GETVALUE_3") + " " + var13_29);
                        }
                        default: {
                            throw new BinaryException(Messages.getString("BINARYFORMATTER_GETVALUE_4") + " " + var4_9);
                        }
                    }
                    return new JNBValueObject(var15_3, false);
                }
                catch (ClassNotFoundException var20_45) {
                    throw new BinaryException("ClassNotFoundException: " + var20_45.getMessage());
                }
                catch (IllegalAccessException var20_46) {
                    throw new BinaryException("IllegalAccessException: " + var20_46.getMessage());
                }
                catch (InstantiationException var20_47) {
                    throw new BinaryException("InstantiationException: " + var20_47.getMessage());
                }
            }
            case 19: {
                var4_10 = var1_1.readShort();
                var3_6 = var1_1.readInt();
                var13_30 = this.getString(var1_1);
                var16_35 = Thread.currentThread().getContextClassLoader();
                try {
                    switch (var4_10) {
                        case 3: {
                            var20_48 = var1_1.readLong();
                            var22_75 = (var20_48 - 621355968000000000L) / 10000L;
                            var24_88 = new Date(var22_75);
                            try {
                                var14_39 = Class.forName(var13_30, false, var16_35);
                            }
                            catch (ClassNotFoundException var25_93) {
                                var16_35 = this.getClass().getClassLoader();
                                var14_39 = Class.forName(var13_30, false, var16_35);
                            }
                            if (!DotNetObjectBase.isByValueClass(var14_39)) {
                                throw new BinaryException(Messages.getString("BINARYFORMATTER_GETVALUE_5") + var14_39.getName() + "  " + Messages.getString("BINARYFORMATTER_GETVALUE_6") + "  " + Messages.getString("BINARYFORMATTER_GETVALUE_7"));
                            }
                            var15_3 = var14_39.newInstance();
                            var25_94 = var14_39.getField("NativeImpl");
                            var25_94.set(var15_3, var24_88);
                            break;
                        }
                        case 4: {
                            var26_106 = (String)this.getValue(var1_1);
                            var27_113 = new BigDecimal(var26_106);
                            try {
                                var14_40 = Class.forName(var13_30, false, var16_35);
                            }
                            catch (ClassNotFoundException var28_117) {
                                var16_35 = this.getClass().getClassLoader();
                                var14_40 = Class.forName(var13_30, false, var16_35);
                            }
                            if (!DotNetObjectBase.isByValueClass(var14_40)) {
                                throw new BinaryException(Messages.getString("BINARYFORMATTER_GETVALUE_5") + var14_40.getName() + "  " + Messages.getString("BINARYFORMATTER_GETVALUE_6") + "  " + Messages.getString("BINARYFORMATTER_GETVALUE_7"));
                            }
                            var15_3 = var14_40.newInstance();
                            var25_95 = var14_40.getField("NativeImpl");
                            var25_95.set(var15_3, var27_113);
                            break;
                        }
                        case 1: {
                            try {
                                var14_41 = Class.forName(var13_30, false, var16_35);
                            }
                            catch (ClassNotFoundException var28_118) {
                                var16_35 = this.getClass().getClassLoader();
                                var14_41 = Class.forName(var13_30, false, var16_35);
                            }
                            if (!DotNetObjectBase.isByValueClass(var14_41)) {
                                throw new BinaryException(Messages.getString("BINARYFORMATTER_GETVALUE_5") + var14_41.getName() + "  " + Messages.getString("BINARYFORMATTER_GETVALUE_6") + "  " + Messages.getString("BINARYFORMATTER_GETVALUE_7"));
                            }
                            var15_3 = var14_41.newInstance();
                            var28_119 = new ArrayList<Object>();
                            for (var29_127 = 0; var29_127 < var3_6; ++var29_127) {
                                var30_136 = this.getValue(var1_1);
                                if (var30_136 != null && var30_136 instanceof JNBObjID) {
                                    var30_136 = ObjectRegistry.getObjectFromID((JNBObjID)var30_136);
                                } else if (var30_136 != null && var30_136 instanceof JNBValueObject) {
                                    var30_136 = ((JNBValueObject)var30_136).getObject();
                                } else if (var30_136 != null && var30_136 instanceof JNBDotNetValueObject) {
                                    var30_136 = ((JNBDotNetValueObject)var30_136).getObject();
                                } else if (var30_136 != null && var30_136 instanceof JNBDotNetObjID) {
                                    var31_142 = (JNBDotNetObjID)var30_136;
                                    var30_136 = DotNetObjectBase.convertObjToJava(var30_136, var31_142.getClassName(), BinaryFormatter.getMyDotNetSideProxy(var15_3));
                                } else if (var30_136 != null && (var30_136.getClass().isArray() || var30_136 instanceof JNBArrayWrapper)) {
                                    if (var30_136 instanceof JNBArrayWrapper) {
                                        var31_142 = (JNBArrayWrapper)var30_136;
                                        var30_136 = var31_142.getArray();
                                    }
                                    var31_142 = BinaryFormatter.adjustBaseType(var30_136.getClass().getComponentType());
                                    var30_136 = BinaryFormatter.unwrapArray(var30_136, (Class)var31_142, BinaryFormatter.getMyDotNetSideProxy(var15_3));
                                }
                                var28_119.add(var30_136);
                                var25_96 = var14_41.getField("NativeImpl");
                                var25_96.set(var15_3, var28_119);
                            }
                            break;
                        }
                        case 2: {
                            var14_42 = Class.forName(var13_30, false, var16_35);
                            if (!DotNetObjectBase.isByValueClass(var14_42)) {
                                throw new BinaryException(Messages.getString("BINARYFORMATTER_GETVALUE_5") + var14_42.getName() + "  " + Messages.getString("BINARYFORMATTER_GETVALUE_6") + "  " + Messages.getString("BINARYFORMATTER_GETVALUE_7"));
                            }
                            var15_3 = var14_42.newInstance();
                            var29_128 = new Hashtable<Object, Object>();
                            for (var30_137 = 0; var30_137 < var3_6; ++var30_137) {
                                var31_143 = this.getValue(var1_1);
                                if (var31_143 != null && var31_143 instanceof JNBObjID) {
                                    var31_143 = ObjectRegistry.getObjectFromID((JNBObjID)var31_143);
                                } else if (var31_143 != null && var31_143 instanceof JNBValueObject) {
                                    var31_143 = ((JNBValueObject)var31_143).getObject();
                                } else if (var31_143 != null && var31_143 instanceof JNBDotNetValueObject) {
                                    var31_143 = ((JNBDotNetValueObject)var31_143).getObject();
                                } else if (var31_143 != null && var31_143 instanceof JNBDotNetObjID) {
                                    var32_157 = (JNBDotNetObjID)var31_143;
                                    var31_143 = DotNetObjectBase.convertObjToJava(var31_143, var32_157.getClassName(), BinaryFormatter.getMyDotNetSideProxy(var15_3));
                                } else if (var31_143 != null && (var31_143.getClass().isArray() || var31_143 instanceof JNBArrayWrapper)) {
                                    if (var31_143 instanceof JNBArrayWrapper) {
                                        var32_157 = (JNBArrayWrapper)var31_143;
                                        var31_143 = var32_157.getArray();
                                    }
                                    var31_143 = BinaryFormatter.unwrapArray(var31_143, var31_143.getClass().getComponentType(), BinaryFormatter.getMyDotNetSideProxy(var15_3));
                                }
                                var32_157 = this.getValue(var1_1);
                                if (var32_157 != null && var32_157 instanceof JNBObjID) {
                                    var32_157 = ObjectRegistry.getObjectFromID((JNBObjID)var32_157);
                                } else if (var32_157 != null && var32_157 instanceof JNBValueObject) {
                                    var32_157 = ((JNBValueObject)var32_157).getObject();
                                } else if (var32_157 != null && var32_157 instanceof JNBDotNetValueObject) {
                                    var32_157 = ((JNBDotNetValueObject)var32_157).getObject();
                                } else if (var32_157 != null && var32_157 instanceof JNBDotNetObjID) {
                                    var33_166 = (JNBDotNetObjID)var32_157;
                                    var32_157 = DotNetObjectBase.convertObjToJava(var32_157, var33_166.getClassName(), BinaryFormatter.getMyDotNetSideProxy(var15_3));
                                } else if (var32_157 != null && (var32_157.getClass().isArray() || var32_157 instanceof JNBArrayWrapper)) {
                                    if (var32_157 instanceof JNBArrayWrapper) {
                                        var33_166 = (JNBArrayWrapper)var32_157;
                                        var32_157 = var33_166.getArray();
                                    }
                                    var33_166 = BinaryFormatter.adjustBaseType(var32_157.getClass().getComponentType());
                                    var32_157 = BinaryFormatter.unwrapArray(var32_157, (Class)var33_166, BinaryFormatter.getMyDotNetSideProxy(var15_3));
                                } else if (var32_157 == null) {
                                    var32_157 = NullValue.nullValue();
                                }
                                var29_128.put(var31_143, var32_157);
                                var25_97 = var14_42.getField("NativeImpl");
                                var25_97.set(var15_3, var29_128);
                            }
                            break;
                        }
                        default: {
                            throw new BinaryException(Messages.getString("BINARYFORMATTER_GETVALUE_4") + " " + var4_10);
                        }
                    }
                    return new JNBDotNetValueObject(var15_3);
                }
                catch (ClassNotFoundException var20_49) {
                    throw new BinaryException("ClassNotFoundException: " + var20_49.getMessage());
                }
                catch (IllegalAccessException var20_50) {
                    throw new BinaryException("IllegalAccessException: " + var20_50.getMessage());
                }
                catch (InstantiationException var20_51) {
                    throw new BinaryException("InstantiationException: " + var20_51.getMessage());
                }
                catch (NoSuchFieldException var20_52) {
                    throw new BinaryException("NoSuchFieldException: " + var20_52.getMessage());
                }
            }
            case 14: {
                var12_23 = var1_1.readBoolean();
                var4_11 = var1_1.readShort();
                var13_31 = this.getString(var1_1);
                try {
                    var20_53 = Thread.currentThread().getContextClassLoader();
                    var21_67 = null;
                    try {
                        var21_67 = Class.forName(var13_31, false, var20_53);
                    }
                    catch (ClassNotFoundException var22_76) {
                        var20_53 = this.getClass().getClassLoader();
                        var21_67 = Class.forName(var13_31, false, var20_53);
                    }
                    var22_77 = var21_67.getDeclaredConstructor(new Class[0]);
                    if (!var22_77.isAccessible()) {
                        var22_77.setAccessible(true);
                    }
                    var23_83 = var22_77.newInstance(new Object[0]);
                    for (var24_89 = 0; var24_89 < var4_11; ++var24_89) {
                        var25_98 = this.getString(var1_1);
                        var26_107 = this.getValue(var1_1);
                        var27_114 = null;
                        var28_120 = null;
                        try {
                            if (var12_23) {
                                var29_129 /* !! */  = null;
                                for (var30_138 = var21_67; var30_138 != null; var30_138 = var30_138.getSuperclass()) {
                                    try {
                                        var29_129 /* !! */  = var30_138.getDeclaredMethod("get" + var25_98, null);
                                        break;
                                    }
                                    catch (NoSuchMethodException var31_145) {
                                        continue;
                                    }
                                }
                                if (var29_129 /* !! */  == null) {
                                    throw new BinaryException(Messages.getString("BINARYFORMATTER_GETVALUE_10") + " " + var25_98);
                                }
                                var31_146 = var29_129 /* !! */ .getReturnType();
                                for (var30_138 = var21_67; var30_138 != null; var30_138 = var30_138.getSuperclass()) {
                                    try {
                                        var28_120 = var30_138.getDeclaredMethod("set" + var25_98, new Class[]{var31_146});
                                        break;
                                    }
                                    catch (NoSuchMethodException var32_159) {
                                        continue;
                                    }
                                }
                                if (var28_120 != null && !var28_120.isAccessible()) {
                                    var28_120.setAccessible(true);
                                }
                                if (var31_146 == Character.TYPE && var26_107.getClass() == Short.class) {
                                    var32_160 = (Short)var26_107;
                                    var33_167 = (char)var32_160;
                                    if (var28_120 == null) continue;
                                    var28_120.invoke(var23_83, new Object[]{new Character(var33_167)});
                                    continue;
                                }
                                if (var26_107 instanceof JNBObjID) {
                                    var32_161 = ObjectRegistry.getObjectFromID((JNBObjID)var26_107);
                                    if (var28_120 == null) continue;
                                    var28_120.invoke(var23_83, new Object[]{var32_161});
                                    continue;
                                }
                                if (var26_107 instanceof JNBValueObject) {
                                    var32_162 = ((JNBValueObject)var26_107).getObject();
                                    if (var28_120 == null) continue;
                                    var28_120.invoke(var23_83, new Object[]{var32_162});
                                    continue;
                                }
                                if (var31_146.isArray()) {
                                    var32_163 = BinaryFormatter.unwrapArray(var26_107, var31_146.getComponentType(), BinaryFormatter.getMyDotNetSideProxy(var23_83));
                                    if (var28_120 == null) continue;
                                    var28_120.invoke(var23_83, new Object[]{var32_163});
                                    continue;
                                }
                                if (var28_120 == null) continue;
                                var28_120.invoke(var23_83, new Object[]{var26_107});
                                continue;
                            }
                            for (var29_129 /* !! */  = var21_67; var29_129 /* !! */  != null; var29_129 /* !! */  = var29_129 /* !! */ .getSuperclass()) {
                                try {
                                    var27_114 = var29_129 /* !! */ .getDeclaredField(var25_98);
                                    break;
                                }
                                catch (NoSuchFieldException var30_139) {
                                    continue;
                                }
                            }
                            if (var29_129 /* !! */  == null) {
                                throw new NoSuchFieldException();
                            }
                            if (!var27_114.isAccessible()) {
                                var27_114.setAccessible(true);
                            }
                            if ((var30_138 = var27_114.getType()) == Character.TYPE && var26_107.getClass() == Short.class) {
                                var31_147 = (Short)var26_107;
                                var32_164 = (char)var31_147;
                                var27_114.setChar(var23_83, var32_164);
                                continue;
                            }
                            if (var26_107 instanceof JNBObjID) {
                                var31_148 = ObjectRegistry.getObjectFromID((JNBObjID)var26_107);
                                var27_114.set(var23_83, var31_148);
                                continue;
                            }
                            if (var26_107 instanceof JNBValueObject) {
                                var31_149 = ((JNBValueObject)var26_107).getObject();
                                var27_114.set(var23_83, var31_149);
                                continue;
                            }
                            if (var30_138.isArray()) {
                                var31_150 = BinaryFormatter.unwrapArray(var26_107, var30_138.getComponentType(), BinaryFormatter.getMyDotNetSideProxy(var23_83));
                                var27_114.set(var23_83, var31_150);
                                continue;
                            }
                            var27_114.set(var23_83, var26_107);
                            continue;
                        }
                        catch (NoSuchFieldException var29_130) {
                            continue;
                        }
                        catch (InvocationTargetException var29_131) {
                            continue;
                        }
                        catch (IllegalAccessException var29_132) {
                            continue;
                        }
                        catch (IllegalArgumentException var29_133) {
                            throw var29_133;
                        }
                        catch (SecurityException var29_134) {
                            if (!BinaryFormatter.throwSecurityException) continue;
                            throw new SecurityException("Please see http://www.jnbridge.com/jn/kb/?p=275 for information on handling this exception");
                        }
                    }
                    return new JNBValueObject(var23_83, var12_23);
                }
                catch (ClassNotFoundException var20_54) {
                    throw new BinaryException("ClassNotFoundException: " + var20_54.getMessage());
                }
                catch (IllegalAccessException var20_55) {
                    throw new BinaryException("IllegalAccessException: " + var20_55.getMessage());
                }
                catch (InstantiationException var20_56) {
                    throw new BinaryException("InstantiationException: " + var20_56.getMessage());
                }
                catch (NoSuchMethodException var20_57) {
                    throw new BinaryException("NoSuchMethodException: " + var20_57.getMessage());
                }
                catch (InvocationTargetException var20_58) {
                    var21_68 = var20_58.getCause();
                    if (var21_68 == null) {
                        var21_68 = var20_58.getTargetException();
                    }
                    throw new BinaryException(var21_68.getClass().getName() + ": " + var21_68.getMessage());
                }
                catch (SecurityException var20_59) {
                    if (!BinaryFormatter.throwSecurityException) ** GOTO lbl421
                    throw new SecurityException("Please see http://www.jnbridge.com/jn/kb/?p=275 for information on handling this exception");
                }
            }
lbl421:
            // 2 sources

            case 18: {
                var4_11 = var1_1.readShort();
                var13_31 = this.getString(var1_1);
                try {
                    var20_60 = Thread.currentThread().getContextClassLoader();
                    var21_69 = null;
                    try {
                        var21_69 = Class.forName(var13_31, false, var20_60);
                    }
                    catch (ClassNotFoundException var22_78) {
                        var20_60 = this.getClass().getClassLoader();
                        var21_69 = Class.forName(var13_31, false, var20_60);
                    }
                    if (!DotNetObjectBase.isByValueClass(var21_69)) {
                        throw new BinaryException(Messages.getString("BINARYFORMATTER_GETVALUE_5") + var21_69.getName() + "  " + Messages.getString("BINARYFORMATTER_GETVALUE_6") + "  " + Messages.getString("BINARYFORMATTER_GETVALUE_7"));
                    }
                    var22_79 = var21_69.newInstance();
                    for (var23_84 = 0; var23_84 < var4_11; ++var23_84) {
                        var24_90 = this.getString(var1_1);
                        var25_99 = this.getValue(var1_1);
                        var26_108 = null;
                        var27_115 = null;
                        try {
                            var29_135 = null;
                            for (var28_121 = var21_69; var28_121 != null; var28_121 = var28_121.getSuperclass()) {
                                try {
                                    var29_135 = var28_121.getDeclaredMethod("Get_" + var24_90, null);
                                    break;
                                }
                                catch (NoSuchMethodException var30_141) {
                                    continue;
                                }
                            }
                            if (var28_121 == null) {
                                throw new NoSuchMethodException();
                            }
                            var30_140 = var29_135.getReturnType();
                            var27_115 = var28_121.getDeclaredMethod("Set_" + var24_90, new Class[]{var30_140});
                            if (!var27_115.isAccessible()) {
                                var27_115.setAccessible(true);
                            }
                            if (var30_140 == Character.TYPE && var25_99.getClass() == Short.class) {
                                var31_151 = (Short)var25_99;
                                var32_165 = (char)var31_151;
                                var27_115.invoke(var22_79, new Object[]{new Character(var32_165)});
                                continue;
                            }
                            if (var25_99 instanceof JNBObjID) {
                                var31_152 = ObjectRegistry.getObjectFromID((JNBObjID)var25_99);
                                var27_115.invoke(var22_79, new Object[]{var31_152});
                                continue;
                            }
                            if (var25_99 instanceof JNBValueObject) {
                                var31_153 = ((JNBValueObject)var25_99).getObject();
                                var27_115.invoke(var22_79, new Object[]{var31_153});
                                continue;
                            }
                            if (var25_99 instanceof JNBDotNetValueObject) {
                                var31_154 = ((JNBDotNetValueObject)var25_99).getObject();
                                var27_115.invoke(var22_79, new Object[]{var31_154});
                                continue;
                            }
                            if (var25_99 instanceof JNBDotNetObjID) {
                                var31_155 = DotNetObjectBase.convertObjToJava(var25_99, var30_140, BinaryFormatter.getMyDotNetSideProxy(var22_79));
                                var27_115.invoke(var22_79, new Object[]{var31_155});
                                continue;
                            }
                            if (var30_140.isArray()) {
                                var31_156 = BinaryFormatter.unwrapArray(var25_99, var30_140.getComponentType(), BinaryFormatter.getMyDotNetSideProxy(var22_79));
                                var27_115.invoke(var22_79, new Object[]{var31_156});
                                continue;
                            }
                            var27_115.invoke(var22_79, new Object[]{var25_99});
                            continue;
                        }
                        catch (NoSuchMethodException var28_122) {
                            continue;
                        }
                        catch (InvocationTargetException var28_123) {
                            continue;
                        }
                        catch (IllegalAccessException var28_124) {
                            continue;
                        }
                        catch (IllegalArgumentException var28_125) {
                            throw var28_125;
                        }
                        catch (SecurityException var28_126) {
                            if (!BinaryFormatter.throwSecurityException) continue;
                            throw new SecurityException("Please see http://www.jnbridge.com/jn/kb/?p=275 for information on handling this exception");
                        }
                    }
                    return new JNBDotNetValueObject(var22_79);
                }
                catch (ClassNotFoundException var20_61) {
                    throw new BinaryException("ClassNotFoundException: " + var20_61.getMessage());
                }
                catch (IllegalAccessException var20_62) {
                    throw new BinaryException("IllegalAccessException: " + var20_62.getMessage());
                }
                catch (InstantiationException var20_63) {
                    throw new BinaryException("InstantiationException: " + var20_63.getMessage());
                }
            }
            case 13: {
                var12_24 = var1_1.readBoolean();
                var5_16 = var1_1.readLong();
                var4_12 = var1_1.readShort();
                var20_64 = new String[var4_12];
                for (var21_70 = 0; var21_70 < var4_12; ++var21_70) {
                    var20_64[var21_70] = this.getString(var1_1);
                }
                var13_32 = this.getString(var1_1);
                return new JNBCallback(var12_24, var5_16, var20_64, var13_32);
            }
            case 10: {
                var13_33 = this.getString(var1_1);
                return var13_33;
            }
            case 11: {
                return this.getArray(var1_1);
            }
            case 25: {
                var21_71 = new Hashtable<String, Object>();
                var22_80 = new byte[4];
                var1_1.read(var22_80);
                var23_85 = (var22_80[3] & 255) << 24 | (var22_80[2] & 255) << 16 | (var22_80[1] & 255) << 8 | var22_80[0] & 255;
                for (var24_91 = 0; var24_91 < var23_85; ++var24_91) {
                    var25_100 = this.getString(var1_1);
                    var26_109 = this.getValue(var1_1);
                    if (var26_109 != null) {
                        if (var26_109 instanceof JNBDotNetObjID) {
                            var27_116 = (JNBDotNetObjID)var26_109;
                            var26_109 = DotNetObjectBase.convertObjToJava(var26_109, var27_116.getClassName(), BinaryFormatter.getMyDotNetSideProxy(var26_109));
                        } else if (var26_109 instanceof JNBDotNetValueObject) {
                            var27_116 = (JNBDotNetValueObject)var26_109;
                            var26_109 = var27_116.getObject();
                        }
                        var21_71.put(var25_100, var26_109);
                        continue;
                    }
                    var21_71.put(var25_100, NullValue.nullValue());
                }
                return var21_71;
            }
            case 12: {
                throw new BinaryException(Messages.getString("BINARYFORMATTER_GETVALUE_8"));
            }
        }
        throw new BinaryException(Messages.getString("BINARYFORMATTER_GETVALUE_9") + " " + var2_2);
    }

    private String getString(DotNetDataInputStream dotNetDataInputStream) throws IOException, BinaryException {
        byte[] byArray = new byte[5];
        dotNetDataInputStream.read(byArray);
        byte by = byArray[0];
        if (by != 0) {
            throw new BinaryException(Messages.getString("BINARYFORMATTER_GETSTRING_1"));
        }
        int n = (byArray[4] & 0xFF) << 24 | (byArray[3] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[1] & 0xFF;
        char[] cArray = new char[n];
        dotNetDataInputStream.read(cArray);
        return new String(cArray);
    }

    private Object getArray(DotNetDataInputStream dotNetDataInputStream) throws IOException, BinaryException {
        String string;
        byte[] byArray = new byte[6];
        dotNetDataInputStream.read(byArray);
        byte by = byArray[0];
        int n = (byArray[4] & 0xFF) << 24 | (byArray[3] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[1] & 0xFF;
        byte by2 = byArray[5];
        String string2 = this.getString(dotNetDataInputStream);
        StringBuffer stringBuffer = new StringBuffer(by - 1);
        for (int i = 0; i < by - 1; ++i) {
            stringBuffer.append('[');
        }
        switch (by2) {
            case 1: {
                if (by == 1) {
                    return this.getIntArray(dotNetDataInputStream, n);
                }
                string = stringBuffer + "I";
                break;
            }
            case 2: {
                if (by == 1) {
                    return this.getShortArray(dotNetDataInputStream, n);
                }
                string = stringBuffer + "S";
                break;
            }
            case 3: {
                if (by == 1) {
                    return this.getLongArray(dotNetDataInputStream, n);
                }
                string = stringBuffer + "J";
                break;
            }
            case 4: {
                if (by == 1) {
                    return this.getFloatArray(dotNetDataInputStream, n);
                }
                string = stringBuffer + "F";
                break;
            }
            case 5: {
                if (by == 1) {
                    return this.getDoubleArray(dotNetDataInputStream, n);
                }
                string = stringBuffer + "D";
                break;
            }
            case 6: {
                if (by == 1) {
                    return this.getCharArray(dotNetDataInputStream, n);
                }
                string = stringBuffer + "C";
                break;
            }
            case 7: {
                if (by == 1) {
                    return this.getByteArray(dotNetDataInputStream, n);
                }
                string = stringBuffer + "B";
                break;
            }
            case 8: {
                if (by == 1) {
                    return this.getBoolArray(dotNetDataInputStream, n);
                }
                string = stringBuffer + "Z";
                break;
            }
            case 20: {
                if (by == 1) {
                    return this.getEnumArray(dotNetDataInputStream, n);
                }
                string = stringBuffer + "Ljava.lang.Enum;";
                break;
            }
            case 9: {
                if (by == 1) {
                    string = stringBuffer + "com.jnbridge.jnbcore.JNBObjID";
                    break;
                }
                string = stringBuffer + "Lcom.jnbridge.jnbcore.JNBObjID;";
                break;
            }
            case 16: {
                if (by == 1) {
                    string = stringBuffer + "com.jnbridge.jnbcore.JNBDotNetObjID";
                    break;
                }
                string = stringBuffer + "Lcom.jnbridge.jnbcore.JNBDotNetObjID;";
                break;
            }
            case 18: {
                if (by == 1) {
                    string = stringBuffer + "com.jnbridge.jnbcore.JNBDotNetValueObject";
                    break;
                }
                string = stringBuffer + "Lcom.jnbridge.jnbcore.JNBDotNetValueObject;";
                break;
            }
            case 10: {
                if (by == 1) {
                    string = stringBuffer + "java.lang.String";
                    break;
                }
                string = stringBuffer + "Ljava.lang.String;";
                break;
            }
            case 12: {
                if (by == 1) {
                    string = stringBuffer + "java.lang.Object";
                    break;
                }
                string = stringBuffer + "Ljava.lang.Object;";
                break;
            }
            case 11: {
                throw new BinaryException(Messages.getString("BINARYFORMATTER_GETARRAY_1"));
            }
            case -1: {
                throw new BinaryException(Messages.getString("BINARYFORMATTER_GETARRAY_2"));
            }
            case 0: {
                throw new BinaryException(Messages.getString("BINARYFORMATTER_GETARRAY_3"));
            }
            default: {
                throw new BinaryException(Messages.getString("BINARYFORMATTER_GETARRAY_4") + " " + by2);
            }
        }
        Class clazz = null;
        try {
            clazz = ClassRegistry.getClass(string, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new BinaryException(Messages.getString("BINARYFORMATTER_GETARRAY_5") + " " + string);
        }
        Object object = Array.newInstance(clazz, n);
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            Object object2 = this.getValue(dotNetDataInputStream);
            if (clazz.isArray() && clazz.getComponentType() == Character.TYPE && object2 != null && object2.getClass().isArray() && object2.getClass().getComponentType() == Integer.TYPE) {
                object2 = BinaryFormatter.convertIntArrayToCharArray((int[])object2);
            }
            if (!clazz.isAssignableFrom(JNBArrayWrapper.class) && object2 != null && object2 instanceof JNBArrayWrapper) {
                JNBArrayWrapper jNBArrayWrapper = (JNBArrayWrapper)object2;
                object2 = jNBArrayWrapper.getArray();
                bl = true;
            }
            Array.set(object, i, object2);
        }
        return new JNBArrayWrapper(string2, object);
    }

    private static char[] convertIntArrayToCharArray(int[] nArray) {
        int n = nArray.length;
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)nArray[i];
        }
        return cArray;
    }

    private int[] getIntArray(DotNetDataInputStream dotNetDataInputStream, int n) throws IOException, BinaryException {
        return dotNetDataInputStream.readIntArray(n);
    }

    private short[] getShortArray(DotNetDataInputStream dotNetDataInputStream, int n) throws IOException, BinaryException {
        return dotNetDataInputStream.readShortArray(n);
    }

    private long[] getLongArray(DotNetDataInputStream dotNetDataInputStream, int n) throws IOException, BinaryException {
        return dotNetDataInputStream.readLongArray(n);
    }

    private float[] getFloatArray(DotNetDataInputStream dotNetDataInputStream, int n) throws IOException, BinaryException {
        return dotNetDataInputStream.readFloatArray(n);
    }

    private double[] getDoubleArray(DotNetDataInputStream dotNetDataInputStream, int n) throws IOException, BinaryException {
        return dotNetDataInputStream.readDoubleArray(n);
    }

    private char[] getCharArray(DotNetDataInputStream dotNetDataInputStream, int n) throws IOException, BinaryException {
        return dotNetDataInputStream.readCharArray(n);
    }

    private byte[] getByteArray(DotNetDataInputStream dotNetDataInputStream, int n) throws IOException, BinaryException {
        return dotNetDataInputStream.readByteArray(n);
    }

    private boolean[] getBoolArray(DotNetDataInputStream dotNetDataInputStream, int n) throws IOException, BinaryException {
        return dotNetDataInputStream.readBooleanArray(n);
    }

    private Object[] getEnumArray(DotNetDataInputStream dotNetDataInputStream, int n) throws IOException, BinaryException {
        Object[] objectArray = (Object[])EnumInfo.getEnumArray(n);
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.getValue(dotNetDataInputStream);
        }
        return objectArray;
    }

    private static Object unwrapArray(Object object, Class clazz, IDotNetSideProxy iDotNetSideProxy) {
        if (object == null) {
            return object;
        }
        if (object instanceof JNBArrayWrapper) {
            JNBArrayWrapper jNBArrayWrapper = (JNBArrayWrapper)object;
            object = jNBArrayWrapper.getArray();
        }
        int n = Array.getLength(object);
        Object object2 = Array.newInstance(clazz, n);
        for (int i = 0; i < n; ++i) {
            Object object3;
            Object object4 = Array.get(object, i);
            if (object4 instanceof JNBObjID) {
                object3 = ObjectRegistry.getObjectFromID((JNBObjID)object4);
            } else if (object4 instanceof JNBValueObject) {
                object3 = ((JNBValueObject)object4).getObject();
            } else if (object4 instanceof JNBDotNetObjID) {
                object3 = DotNetObjectBase.convertObjToJava(object4, clazz, iDotNetSideProxy);
            } else if (object4 instanceof JNBDotNetValueObject) {
                object3 = DotNetObjectBase.convertObjToJava(object4, clazz, iDotNetSideProxy);
            } else if (clazz.isArray()) {
                object3 = BinaryFormatter.unwrapArray(object4, clazz.getComponentType(), iDotNetSideProxy);
            } else if (clazz.getName().equals("System.Object")) {
                object3 = DotNetObjectBase.convertObjToJava(object4, clazz, iDotNetSideProxy);
            } else if (clazz.equals(Character.TYPE) && object4 != null && object4 instanceof Integer) {
                int n2 = (Integer)object4;
                object3 = new Character((char)n2);
            } else {
                object3 = object4;
            }
            Array.set(object2, i, object3);
        }
        return object2;
    }

    private static boolean isByValue(Object object) {
        return object instanceof ByValueMarker;
    }

    private static Class adjustBaseType(Class clazz) {
        if (clazz.isArray()) {
            String string = clazz.getName();
            if (string.endsWith("Ljava.lang.Object;")) {
                int n = string.lastIndexOf("Ljava.lang.Object;");
                String string2 = string.substring(0, n) + "LSystem.Object;";
                try {
                    Class<?> clazz2 = Class.forName(string2, false, Thread.currentThread().getContextClassLoader());
                    return clazz2;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new DotNetSideException("ClassNotFoundException: System.Object", classNotFoundException);
                }
            }
            return clazz;
        }
        if (clazz == Object.class) {
            return dotNetObjectClass;
        }
        return clazz;
    }

    static {
        try {
            dotNetObjectClass = Class.forName("System.Object", false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            if (JavaSideProperties.isPropsFileSet()) {
                JavaSideProperties javaSideProperties = JavaSideProperties.getInstance();
                String string = javaSideProperties.getProperty("javaSide.throwSecurityException");
                if (string == null) {
                    string = System.getProperty("javaSide.throwSecurityException", "true");
                }
                throwSecurityException = string != null && string.equalsIgnoreCase("true");
            } else {
                String string = System.getProperty("javaSide.throwSecurityException", "true");
                throwSecurityException = string != null && string.equalsIgnoreCase("true");
            }
        }
        catch (JavaSidePropertiesException javaSidePropertiesException) {
            String string = System.getProperty("javaSide.throwSecurityException", "true");
            throwSecurityException = string != null && string.equalsIgnoreCase("true");
        }
    }

    private class ComponentInfo {
        public byte rank;
        public byte baseType;

        public ComponentInfo(byte by, byte by2) {
            this.rank = by;
            this.baseType = by2;
        }
    }
}

