/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore.formatters.soap;

import com.jnbridge.jnbcore.Debugging;
import java.io.PrintStream;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class DOMWriter {
    static final String outputEncoding = "UTF-8";
    private PrintStream out;
    private int indent = 0;
    private final String basicIndent = "  ";

    public DOMWriter() {
        this.out = Debugging.debugStream;
    }

    public DOMWriter(PrintStream printStream) {
        this.out = printStream;
    }

    private void printlnCommon(Node node) {
        this.out.print(" nodeName=\"" + node.getNodeName() + "\"");
        String string = node.getNamespaceURI();
        if (string != null) {
            this.out.print(" uri=\"" + string + "\"");
        }
        if ((string = node.getPrefix()) != null) {
            this.out.print(" pre=\"" + string + "\"");
        }
        if ((string = node.getLocalName()) != null) {
            this.out.print(" local=\"" + string + "\"");
        }
        if ((string = node.getNodeValue()) != null) {
            this.out.print(" nodeValue=");
            if (string.trim().equals("")) {
                this.out.print("[WS]");
            } else {
                this.out.print("\"" + node.getNodeValue() + "\"");
            }
        }
        this.out.println();
    }

    private void outputIndentation() {
        for (int i = 0; i < this.indent; ++i) {
            this.out.print("  ");
        }
    }

    private void echo(Node node) {
        Object object;
        this.outputIndentation();
        short s = node.getNodeType();
        switch (s) {
            case 2: {
                this.out.print("ATTR:");
                this.printlnCommon(node);
                break;
            }
            case 4: {
                this.out.print("CDATA:");
                this.printlnCommon(node);
                break;
            }
            case 8: {
                this.out.print("COMM:");
                this.printlnCommon(node);
                break;
            }
            case 11: {
                this.out.print("DOC_FRAG:");
                this.printlnCommon(node);
                break;
            }
            case 9: {
                this.out.print("DOC:");
                this.printlnCommon(node);
                break;
            }
            case 10: {
                this.out.print("DOC_TYPE:");
                this.printlnCommon(node);
                object = ((DocumentType)node).getEntities();
                this.indent += 2;
                for (int i = 0; i < object.getLength(); ++i) {
                    Entity entity = (Entity)object.item(i);
                    this.echo(entity);
                }
                this.indent -= 2;
                break;
            }
            case 1: {
                this.out.print("ELEM:");
                this.printlnCommon(node);
                NamedNodeMap namedNodeMap = node.getAttributes();
                this.indent += 2;
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    Node node2 = namedNodeMap.item(i);
                    this.echo(node2);
                }
                this.indent -= 2;
                break;
            }
            case 6: {
                this.out.print("ENT:");
                this.printlnCommon(node);
                break;
            }
            case 5: {
                this.out.print("ENT_REF:");
                this.printlnCommon(node);
                break;
            }
            case 12: {
                this.out.print("NOTATION:");
                this.printlnCommon(node);
                break;
            }
            case 7: {
                this.out.print("PROC_INST:");
                this.printlnCommon(node);
                break;
            }
            case 3: {
                this.out.print("TEXT:");
                this.printlnCommon(node);
                break;
            }
            default: {
                this.out.print("UNSUPPORTED NODE: " + s);
                this.printlnCommon(node);
            }
        }
        ++this.indent;
        for (object = node.getFirstChild(); object != null; object = object.getNextSibling()) {
            this.echo((Node)object);
        }
        --this.indent;
    }

    public void print(Document document) {
        this.echo(document);
    }
}

