/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore.formatters.soap;

import com.jnbridge.jnbcore.ArgConverter;
import com.jnbridge.jnbcore.CallArgs;
import com.jnbridge.jnbcore.CallbackException;
import com.jnbridge.jnbcore.DebugConstants;
import com.jnbridge.jnbcore.InternalException;
import com.jnbridge.jnbcore.MessageKeys;
import com.jnbridge.jnbcore.Messages;
import com.jnbridge.jnbcore.formatters.soap.SOAPBodyElement;
import com.jnbridge.jnbcore.formatters.soap.SOAPDeserializer;
import com.jnbridge.jnbcore.formatters.soap.SOAPException;
import com.jnbridge.jnbcore.formatters.soap.SOAPNamespaceConstants;
import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

final class SOAPCallElement
implements SOAPNamespaceConstants,
CallArgs,
DebugConstants,
MessageKeys {
    Element calledElement = null;
    Hashtable argTable = new Hashtable();
    SOAPDeserializer deserializer;

    SOAPCallElement(Document document, SOAPBodyElement sOAPBodyElement) throws SOAPException {
        Object object;
        this.deserializer = new SOAPDeserializer(document, sOAPBodyElement);
        for (object = sOAPBodyElement.getFirstChild(); object != null; object = object.getNextSibling()) {
            if (object.getNodeType() != 1) continue;
            this.calledElement = (Element)object;
            break;
        }
        if (this.calledElement == null) {
            throw new SOAPException(Messages.getString("SOAPCALLELEMENT_CONSTRUCTOR_2"));
        }
        object = this.calledElement.getNamespaceURI();
        if (!((String)object).equals("http://schemas.microsoft.com/clr/nsassem/com.jnbridge.jnbcore.IJNBDispatcher/JNBShare") && !((String)object).equals("http://schemas.microsoft.com/clr/nsassem/com.jnbridge.jnbcore.JNBDispatcher/JNBShare")) {
            throw new SOAPException(Messages.getString("SOAPCALLELEMENT_CONSTRUCTOR_1"));
        }
    }

    String getCalledMethod() {
        return this.calledElement.getLocalName();
    }

    void getArguments(Hashtable hashtable) throws SOAPException, InternalException, CallbackException {
        Object object;
        String string;
        Object object2;
        Object[] objectArray;
        for (objectArray = this.calledElement.getFirstChild(); objectArray != null; objectArray = objectArray.getNextSibling()) {
            if (objectArray.getNodeType() != 1) continue;
            object2 = this.deserializer.deserialize((Element)objectArray, hashtable);
            if (object2 == null) {
                this.argTable.remove(((Element)objectArray).getTagName());
                continue;
            }
            this.argTable.put(((Element)objectArray).getTagName(), object2);
        }
        objectArray = (Object[])this.getArg("args");
        if (objectArray != null) {
            object2 = (Object[])this.getArg("signature");
            objectArray = ArgConverter.convertArgs(object2, objectArray);
            this.argTable.put("args", objectArray);
        } else {
            object2 = this.getArg("val");
            if (object2 != null) {
                string = (String)this.getArg("signature");
                object = ArgConverter.convertOneArg(string, object2);
                this.argTable.put("val", object);
            }
        }
        object2 = this.getArg("objID");
        if (object2 != null && object2 instanceof String) {
            object2 = new Long((String)object2);
        }
        if (object2 != null) {
            this.argTable.put("objID", object2);
        }
        string = null;
        object = this.getArg("isJavaBean");
        if (object != null) {
            string = object.toString();
        }
        if (string != null) {
            if (string.equalsIgnoreCase("true")) {
                this.argTable.put("isJavaBean", new Boolean(true));
            } else {
                this.argTable.put("isJavaBean", new Boolean(false));
            }
        }
    }

    public Object getArg(String string) {
        return this.argTable.get(string);
    }

    public void setArg(String string, Object object) {
        if (object == null) {
            this.argTable.remove(string);
        } else {
            this.argTable.put(string, object);
        }
    }
}

