/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore.formatters.soap;

import com.jnbridge.jnbcore.BoxedValueFactory;
import com.jnbridge.jnbcore.ClassRegistry;
import com.jnbridge.jnbcore.DebugConstants;
import com.jnbridge.jnbcore.DotNetArgTypeConverter;
import com.jnbridge.jnbcore.DotNetMappedClass;
import com.jnbridge.jnbcore.DotNetObjectBase;
import com.jnbridge.jnbcore.DotNetSideException;
import com.jnbridge.jnbcore.DotNetWrapperFactory;
import com.jnbridge.jnbcore.IDotNetSideProxy;
import com.jnbridge.jnbcore.JNBArrayWrapper;
import com.jnbridge.jnbcore.JNBCallback;
import com.jnbridge.jnbcore.JNBDotNetObjID;
import com.jnbridge.jnbcore.JNBDotNetValueObject;
import com.jnbridge.jnbcore.JNBException;
import com.jnbridge.jnbcore.JNBObjID;
import com.jnbridge.jnbcore.JNBValueObject;
import com.jnbridge.jnbcore.JavaSideProperties;
import com.jnbridge.jnbcore.JavaSidePropertiesException;
import com.jnbridge.jnbcore.MappedClass;
import com.jnbridge.jnbcore.MessageKeys;
import com.jnbridge.jnbcore.Messages;
import com.jnbridge.jnbcore.NullValue;
import com.jnbridge.jnbcore.ObjectRegistry;
import com.jnbridge.jnbcore.formatters.soap.SOAPBodyElement;
import com.jnbridge.jnbcore.formatters.soap.SOAPException;
import com.jnbridge.jnbcore.formatters.soap.SOAPNamespaceConstants;
import com.jnbridge.jnbcore.formatters.soap.SOAPTypeNamespaceRegistry;
import com.jnbridge.jnbcore.java50.EnumInfo;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sun.misc.BASE64Decoder;

public class SOAPDeserializer
implements SOAPNamespaceConstants,
DebugConstants,
MessageKeys {
    private Element responseElement;
    private Document document;
    private static Class[] longParams = new Class[]{Long.TYPE};
    private static Class dotNetObjectClass;
    private static boolean throwSecurityException;
    private static final Class byteArrayType;
    private static Hashtable arrayComponentConversionTable;
    private static Hashtable scalarTypeConversionTable;

    public SOAPDeserializer(Document document, SOAPBodyElement sOAPBodyElement) throws SOAPException {
        this.document = document;
        this.responseElement = sOAPBodyElement.getFirstNonTextChild();
        if (this.responseElement == null) {
            throw new SOAPException(Messages.getString("SOAPDESERIALIZER_CONSTRUCTOR_1"));
        }
        String string = this.responseElement.getNamespaceURI();
        if (!(string.equals("http://schemas.microsoft.com/clr/nsassem/com.jnbridge.jnbcore.IJNBDotNetDispatcher/JNBShare") || string.equals("http://schemas.microsoft.com/clr/nsassem/com.jnbridge.jnbcore.IJNBDispatcher/JNBShare") || string.equals("http://schemas.microsoft.com/clr/nsassem/com.jnbridge.jnbcore.JNBDispatcher/JNBShare") || string.equals("http://schemas.xmlsoap.org/soap/envelope/"))) {
            throw new SOAPException(Messages.getString("SOAPDESERIALIZER_CONSTRUCTOR_2"));
        }
    }

    private static IDotNetSideProxy getMyDotNetSideProxy(Object object) {
        if (object instanceof DotNetObjectBase) {
            return ((DotNetObjectBase)object).getMyDotNetSideProxy();
        }
        return null;
    }

    public Object deserialize(Element element, Hashtable hashtable) throws SOAPException {
        return this.getSingleArgument(element, hashtable, null);
    }

    private Object getSingleArgument(Element element, Hashtable hashtable, String string) throws SOAPException {
        if (element.hasAttribute("href")) {
            Element element2;
            String string2 = element.getAttribute("href");
            if (string2.charAt(0) == '#') {
                string2 = string2.substring(1);
            }
            if ((element2 = (Element)hashtable.get(string2)) != null) {
                return this.getSingleArgument(element2, hashtable, string);
            }
            throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_1"));
        }
        if (element.getTagName().equals("SOAP-ENC:Array")) {
            if (element.getAttribute("xsi:type").equals("SOAP-ENC:base64")) {
                NodeList nodeList = element.getChildNodes();
                Node node = nodeList.item(0);
                String string3 = node.getNodeValue();
                try {
                    byte[] byArray = new BASE64Decoder().decodeBuffer(string3);
                    return byArray;
                }
                catch (IOException iOException) {
                    throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_2"));
                }
            }
            String string4 = element.getAttribute("SOAP-ENC:arrayType");
            string4 = SOAPDeserializer.addPackageName(string4, element);
            String string5 = string4.substring(0, string4.lastIndexOf(91));
            int n = this.getArrayLength(string4);
            Class<Integer> clazz = this.convertToJavaComponentType(string4);
            if (clazz == Character.TYPE && string5 != null && string != null && string.equals("xsd:anyType")) {
                clazz = Integer.TYPE;
            }
            Object object = Array.newInstance(clazz, n);
            boolean bl = clazz.isPrimitive();
            boolean bl2 = EnumInfo.isEnum(clazz);
            NodeList nodeList = element.getElementsByTagName("item");
            int n2 = nodeList.getLength();
            for (int i = 0; i < n2; ++i) {
                Object object2 = this.getSingleArgument((Element)nodeList.item(i), hashtable, string5);
                if (clazz == Character.TYPE && object2 instanceof Integer) {
                    int n3 = (Integer)object2;
                    char c = (char)n3;
                    object2 = new Character(c);
                }
                if (object2 instanceof Integer) {
                    if (bl) {
                        Array.setInt(object, i, (Integer)object2);
                        continue;
                    }
                    Array.set(object, i, object2);
                    continue;
                }
                if (object2 instanceof Boolean) {
                    if (bl) {
                        Array.setBoolean(object, i, (Boolean)object2);
                        continue;
                    }
                    Array.set(object, i, object2);
                    continue;
                }
                if (object2 instanceof Short) {
                    if (bl) {
                        Array.setShort(object, i, (Short)object2);
                        continue;
                    }
                    Array.set(object, i, object2);
                    continue;
                }
                if (object2 instanceof Long) {
                    if (bl) {
                        Array.setLong(object, i, (Long)object2);
                        continue;
                    }
                    Array.set(object, i, object2);
                    continue;
                }
                if (object2 instanceof Float) {
                    if (bl) {
                        Array.setFloat(object, i, ((Float)object2).floatValue());
                        continue;
                    }
                    Array.set(object, i, object2);
                    continue;
                }
                if (object2 instanceof Double) {
                    if (bl) {
                        Array.setDouble(object, i, (Double)object2);
                        continue;
                    }
                    Array.set(object, i, object2);
                    continue;
                }
                if (object2 instanceof Character) {
                    if (bl) {
                        Array.setChar(object, i, ((Character)object2).charValue());
                        continue;
                    }
                    Array.set(object, i, object2);
                    continue;
                }
                if (object2 instanceof Byte) {
                    if (bl) {
                        Array.setByte(object, i, (Byte)object2);
                        continue;
                    }
                    Array.set(object, i, object2);
                    continue;
                }
                if (bl2) {
                    Object object3 = EnumInfo.getEnum(clazz.getName(), (String)object2);
                    Array.set(object, i, object3);
                    continue;
                }
                Array.set(object, i, object2);
            }
            return object;
        }
        if (element.getLocalName().equals("JNBArrayWrapper")) {
            NodeList nodeList = element.getElementsByTagName("m_arrayName");
            Node node = nodeList.item(0);
            String string6 = (String)this.getTextValue((Element)node, hashtable, null);
            nodeList = element.getElementsByTagName("m_array");
            Node node2 = nodeList.item(0);
            Object object = this.getSingleArgument((Element)node2, hashtable, string6);
            return new JNBArrayWrapper(string6, object);
        }
        if (element.hasAttribute("xsi:null")) {
            if (element.getAttribute("xsi:null").equals("1")) {
                return null;
            }
            throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_3"));
        }
        if (element.getLocalName().equals("JNBObjID")) {
            NodeList nodeList = element.getElementsByTagName("javaObjID");
            if (nodeList.getLength() != 1) {
                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_4"));
            }
            Element element3 = (Element)nodeList.item(0);
            String string7 = (String)this.getTextValue(element3, hashtable, null);
            NodeList nodeList2 = element.getElementsByTagName("actualClassName");
            if (nodeList2.getLength() != 1) {
                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_5"));
            }
            Element element4 = (Element)nodeList2.item(0);
            String string8 = (String)this.getTextValue(element4, hashtable, null);
            JNBObjID jNBObjID = new JNBObjID(string7, string8);
            return jNBObjID;
        }
        if (element.getLocalName().equals("JNBDotNetObjID")) {
            NodeList nodeList = element.getElementsByTagName("dotNetObjID");
            if (nodeList.getLength() != 1) {
                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_4"));
            }
            Element element5 = (Element)nodeList.item(0);
            String string9 = (String)this.getTextValue(element5, hashtable, null);
            NodeList nodeList3 = element.getElementsByTagName("actualClassName");
            if (nodeList3.getLength() != 1) {
                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_5"));
            }
            Element element6 = (Element)nodeList3.item(0);
            String string10 = (String)this.getTextValue(element6, hashtable, null);
            JNBDotNetObjID jNBDotNetObjID = new JNBDotNetObjID(string9, string10);
            return jNBDotNetObjID;
        }
        if (element.getLocalName().equals("JNBDotNetMultiResult")) {
            Hashtable<Object, Object> hashtable2 = new Hashtable<Object, Object>();
            NodeList nodeList = element.getElementsByTagName("numEntries");
            if (nodeList.getLength() != 1) {
                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_13"));
            }
            Element element7 = (Element)nodeList.item(0);
            String string11 = (String)this.getTextValue(element7, hashtable, null);
            int n = Integer.parseInt(string11);
            for (int i = 1; i <= n; ++i) {
                Object object;
                Object object4;
                String string12;
                Object object5;
                NodeList nodeList4 = element.getElementsByTagName("key" + i);
                if (nodeList4.getLength() != 1) {
                    throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_23") + " " + i);
                }
                Element element8 = (Element)nodeList4.item(0);
                Object object6 = this.getSingleArgument(element8, hashtable, "System.Object");
                if (object6 != null && object6 instanceof JNBDotNetObjID) {
                    object6 = DotNetObjectBase.convertObjToJava(object6, object6.getClass());
                } else if (object6 != null && object6 instanceof JNBDotNetValueObject) {
                    object6 = ((JNBDotNetValueObject)object6).getObject();
                } else if (object6 != null && (object6 instanceof JNBArrayWrapper || object6.getClass().isArray())) {
                    if (object6 instanceof JNBArrayWrapper) {
                        object5 = (JNBArrayWrapper)object6;
                        object6 = ((JNBArrayWrapper)object5).getArray();
                    }
                    object6 = SOAPDeserializer.unwrapArray(object6, object6.getClass().getComponentType(), null);
                }
                object5 = element.getElementsByTagName("valueType" + i);
                if (object5.getLength() == 0) {
                    string12 = "System.Object";
                } else if (object5.getLength() == 1) {
                    object4 = (Element)object5.item(0);
                    string12 = (String)this.getTextValue((Element)object4, hashtable, null);
                } else {
                    throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_21") + " " + i);
                }
                object4 = element.getElementsByTagName("value" + i);
                if (object4.getLength() != 1) {
                    throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_22") + " " + i);
                }
                Element element9 = (Element)object4.item(0);
                Object object7 = this.getSingleArgument(element9, hashtable, string12);
                if (object7 != null && object7 instanceof JNBDotNetObjID) {
                    object = DotNetObjectBase.convertObjToJava(object7, object7.getClass());
                    hashtable2.put(object6, object);
                    continue;
                }
                if (object7 != null && object7 instanceof JNBDotNetValueObject) {
                    object = ((JNBDotNetValueObject)object7).getObject();
                    hashtable2.put(object6, object);
                    continue;
                }
                if (object7 != null && (object7.getClass().isArray() || object7 instanceof JNBArrayWrapper)) {
                    if (object7 instanceof JNBArrayWrapper) {
                        object7 = ((JNBArrayWrapper)object7).getArray();
                    }
                    object = SOAPDeserializer.adjustBaseType(object7.getClass().getComponentType());
                    Object object8 = SOAPDeserializer.unwrapArray(object7, (Class)object, null);
                    hashtable2.put(object6, object8);
                    continue;
                }
                if (object7 == null) {
                    object7 = NullValue.nullValue();
                }
                hashtable2.put(object6, object7);
            }
            return hashtable2;
        }
        if (element.getLocalName().equals("JNBException")) {
            long l;
            NodeList nodeList = element.getElementsByTagName("objID");
            if (nodeList.getLength() != 1) {
                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_6"));
            }
            Element element10 = (Element)nodeList.item(0);
            String string13 = (String)this.getTextValue(element10, hashtable, null);
            try {
                l = Long.parseLong(string13);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_7"));
            }
            NodeList nodeList5 = element.getElementsByTagName("innerClassName");
            if (nodeList5.getLength() != 1) {
                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_5"));
            }
            Element element11 = (Element)nodeList5.item(0);
            String string14 = (String)this.getTextValue(element11, hashtable, null);
            NodeList nodeList6 = element.getElementsByTagName("Message");
            if (nodeList6.getLength() != 1) {
                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_8"));
            }
            Element element12 = (Element)nodeList6.item(0);
            String string15 = (String)this.getTextValue(element12, hashtable, null);
            NodeList nodeList7 = element.getElementsByTagName("innerStackTrace");
            if (nodeList7.getLength() != 1) {
                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_9"));
            }
            Element element13 = (Element)nodeList7.item(0);
            String string16 = (String)this.getTextValue(element13, hashtable, null);
            JNBException jNBException = new JNBException(string15, string16, l, string14);
            return jNBException;
        }
        if (element.getLocalName().equals("JNBValueObject")) {
            NodeList nodeList = element.getElementsByTagName("coreObjectClassName");
            if (nodeList.getLength() != 1) {
                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_10"));
            }
            Element element14 = (Element)nodeList.item(0);
            String string17 = (String)this.getTextValue(element14, hashtable, null);
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string17, false, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_11") + " " + string17);
            }
            if (MappedClass.isMapped(clazz)) {
                NodeList nodeList8 = element.getElementsByTagName("scheme");
                if (nodeList8.getLength() != 1) {
                    throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_12"));
                }
                Element element15 = (Element)nodeList8.item(0);
                String string18 = (String)this.getTextValue(element15, hashtable, null);
                short s = Short.parseShort(string18);
                NodeList nodeList9 = element.getElementsByTagName("numEntries");
                if (nodeList9.getLength() != 1) {
                    throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_13"));
                }
                Element element16 = (Element)nodeList9.item(0);
                String string19 = (String)this.getTextValue(element16, hashtable, null);
                int n = Integer.parseInt(string19);
                try {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    Class<?> clazz2 = Class.forName(string17, false, classLoader);
                    Object object = null;
                    switch (s) {
                        case 3: {
                            NodeList nodeList10 = element.getElementsByTagName("dotNetTicks");
                            if (nodeList10.getLength() != 1) {
                                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_14"));
                            }
                            Element element17 = (Element)nodeList10.item(0);
                            NodeList nodeList11 = element17.getChildNodes();
                            Node node = nodeList11.item(0);
                            if (node == null) {
                                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_15"));
                            }
                            String string20 = node.getNodeValue();
                            long l = Long.parseLong(string20);
                            long l2 = (l - 621355968000000000L) / 10000L;
                            try {
                                Constructor<?> constructor = clazz.getConstructor(longParams);
                                Date date = (Date)constructor.newInstance(new Long(l2));
                                object = date;
                                break;
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_16") + " " + string17);
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_17") + " " + string17 + ": " + invocationTargetException.getTargetException().getMessage());
                            }
                        }
                        case 4: {
                            NodeList nodeList12 = element.getElementsByTagName("decimalString");
                            if (nodeList12.getLength() != 1) {
                                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_18"));
                            }
                            Element element18 = (Element)nodeList12.item(0);
                            NodeList nodeList13 = element18.getChildNodes();
                            Node node = nodeList13.item(0);
                            if (node == null) {
                                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_19"));
                            }
                            String string21 = node.getNodeValue();
                            if (string17.equals("java.math.BigDecimal")) {
                                BigDecimal bigDecimal = new BigDecimal(string21);
                                object = bigDecimal;
                                break;
                            }
                            if (string17.equals("java.math.BigInteger")) {
                                BigInteger bigInteger = new BigInteger(string21);
                                object = bigInteger;
                                break;
                            }
                            throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_20") + " " + string17);
                        }
                        case 1: {
                            Collection collection = (Collection)clazz2.newInstance();
                            for (int i = 1; i <= n; ++i) {
                                Object object9;
                                Object object10;
                                String string22;
                                NodeList nodeList14 = element.getElementsByTagName("valueType" + i);
                                if (nodeList14.getLength() == 0) {
                                    string22 = "java.lang.Object";
                                } else if (nodeList14.getLength() == 1) {
                                    object10 = (Element)nodeList14.item(0);
                                    string22 = (String)this.getTextValue((Element)object10, hashtable, null);
                                } else {
                                    throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_21") + " " + i);
                                }
                                object10 = element.getElementsByTagName("value" + i);
                                if (object10.getLength() != 1) {
                                    throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_22") + " " + i);
                                }
                                Element element19 = (Element)object10.item(0);
                                Object object11 = this.getSingleArgument(element19, hashtable, string22);
                                if (object11 != null && object11 instanceof JNBObjID) {
                                    object9 = ObjectRegistry.getObjectFromID((JNBObjID)object11);
                                    collection.add(object9);
                                    continue;
                                }
                                if (object11 != null && object11 instanceof JNBValueObject) {
                                    object9 = ((JNBValueObject)object11).getObject();
                                    collection.add(object9);
                                    continue;
                                }
                                if (object11 != null && (object11 instanceof JNBArrayWrapper || object11.getClass().isArray())) {
                                    if (object11 instanceof JNBArrayWrapper) {
                                        object9 = (JNBArrayWrapper)object11;
                                        object11 = ((JNBArrayWrapper)object9).getArray();
                                    }
                                    object9 = SOAPDeserializer.unwrapArray(object11, object11.getClass().getComponentType(), SOAPDeserializer.getMyDotNetSideProxy(collection));
                                    collection.add(object9);
                                    continue;
                                }
                                collection.add(object11);
                            }
                            object = collection;
                            break;
                        }
                        case 2: {
                            Map map = (Map)clazz2.newInstance();
                            for (int i = 1; i <= n; ++i) {
                                Object object12;
                                Object object13;
                                NodeList nodeList15 = element.getElementsByTagName("key" + i);
                                if (nodeList15.getLength() != 1) {
                                    throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_23") + " " + i);
                                }
                                Element element20 = (Element)nodeList15.item(0);
                                Object object14 = this.getSingleArgument(element20, hashtable, "java.lang.Object");
                                if (object14 != null && object14 instanceof JNBObjID) {
                                    object14 = ObjectRegistry.getObjectFromID((JNBObjID)object14);
                                } else if (object14 != null && object14 instanceof JNBValueObject) {
                                    object14 = ((JNBValueObject)object14).getObject();
                                } else if (object14 != null && (object14 instanceof JNBArrayWrapper || object14.getClass().isArray())) {
                                    if (object14 instanceof JNBArrayWrapper) {
                                        object13 = (JNBArrayWrapper)object14;
                                        object14 = ((JNBArrayWrapper)object13).getArray();
                                    }
                                    object14 = SOAPDeserializer.unwrapArray(object14, object14.getClass().getComponentType(), SOAPDeserializer.getMyDotNetSideProxy(map));
                                }
                                object13 = element.getElementsByTagName("value" + i);
                                if (object13.getLength() != 1) {
                                    throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_22") + " " + i);
                                }
                                Element element21 = (Element)object13.item(0);
                                Object object15 = this.getSingleArgument(element21, hashtable, "java.lang.Object");
                                if (object15 != null && object15 instanceof JNBObjID) {
                                    object12 = ObjectRegistry.getObjectFromID((JNBObjID)object15);
                                    map.put(object14, object12);
                                    continue;
                                }
                                if (object15 != null && object15 instanceof JNBValueObject) {
                                    object12 = ((JNBValueObject)object15).getObject();
                                    map.put(object14, object12);
                                    continue;
                                }
                                if (object15 != null && (object15 instanceof JNBArrayWrapper || object15.getClass().isArray())) {
                                    if (object15 instanceof JNBArrayWrapper) {
                                        object12 = (JNBArrayWrapper)object15;
                                        object15 = ((JNBArrayWrapper)object12).getArray();
                                    }
                                    object12 = SOAPDeserializer.unwrapArray(object15, object15.getClass().getComponentType(), SOAPDeserializer.getMyDotNetSideProxy(map));
                                    map.put(object14, object12);
                                    continue;
                                }
                                map.put(object14, object15);
                            }
                            object = map;
                        }
                    }
                    return new JNBValueObject(object, false);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_11") + " " + string17);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_24") + " " + string17);
                }
                catch (InstantiationException instantiationException) {
                    throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_25") + " " + string17);
                }
            }
            NodeList nodeList16 = element.getElementsByTagName("isJavaBean");
            if (nodeList16.getLength() != 1) {
                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_26"));
            }
            Element element22 = (Element)nodeList16.item(0);
            String string23 = (String)this.getTextValue(element22, hashtable, null);
            boolean bl = string23.equalsIgnoreCase("true");
            NodeList nodeList17 = element.getElementsByTagName("numFields");
            if (nodeList17.getLength() != 1) {
                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_27"));
            }
            Element element23 = (Element)nodeList17.item(0);
            String string24 = (String)this.getTextValue(element23, hashtable, null);
            int n = Short.parseShort(string24);
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Class<?> clazz3 = Class.forName(string17, false, classLoader);
                Constructor<?> constructor = clazz3.getDeclaredConstructor(new Class[0]);
                if (!constructor.isAccessible()) {
                    constructor.setAccessible(true);
                }
                Object obj = constructor.newInstance(new Object[0]);
                if (bl) {
                    for (int i = 1; i <= n; ++i) {
                        try {
                            NodeList nodeList18 = element.getElementsByTagName("name" + i);
                            if (nodeList18.getLength() != 1) {
                                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_28") + " " + i);
                            }
                            Element element24 = (Element)nodeList18.item(0);
                            String string25 = (String)this.getTextValue(element24, hashtable, null);
                            Method method = clazz3.getMethod("get" + string25, null);
                            if (method == null) {
                                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_30") + " " + string25);
                            }
                            Class<?> clazz4 = method.getReturnType();
                            Method method2 = clazz3.getMethod("set" + string25, clazz4);
                            NodeList nodeList19 = element.getElementsByTagName("value" + i);
                            if (nodeList19.getLength() != 1) {
                                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_29") + " " + i);
                            }
                            Element element25 = (Element)nodeList19.item(0);
                            Object object = this.getSingleArgument(element25, hashtable, clazz4.getName());
                            if (object instanceof JNBObjID) {
                                Object object16 = ObjectRegistry.getObjectFromID((JNBObjID)object);
                                method2.invoke(obj, object16);
                                continue;
                            }
                            if (object instanceof JNBValueObject) {
                                Object object17 = ((JNBValueObject)object).getObject();
                                method2.invoke(obj, object17);
                                continue;
                            }
                            if (clazz4.isArray()) {
                                Object object18 = SOAPDeserializer.unwrapArray(object, clazz4.getComponentType(), SOAPDeserializer.getMyDotNetSideProxy(obj));
                                method2.invoke(obj, object18);
                                continue;
                            }
                            if (clazz4 == Character.TYPE && object != null && object.getClass() == Integer.class) {
                                int n4 = (Integer)object;
                                char c = (char)n4;
                                object = new Character(c);
                            }
                            method2.invoke(obj, object);
                            continue;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            continue;
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            // empty catch block
                        }
                    }
                } else {
                    for (int i = 1; i <= n; ++i) {
                        try {
                            NodeList nodeList20 = element.getElementsByTagName("name" + i);
                            if (nodeList20.getLength() != 1) {
                                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_28") + i);
                            }
                            Element element26 = (Element)nodeList20.item(0);
                            String string26 = (String)this.getTextValue(element26, hashtable, null);
                            Field field = clazz3.getField(string26);
                            Class<?> clazz5 = field.getType();
                            NodeList nodeList21 = element.getElementsByTagName("value" + i);
                            if (nodeList21.getLength() != 1) {
                                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_29") + " " + i);
                            }
                            Element element27 = (Element)nodeList21.item(0);
                            Object object = this.getSingleArgument(element27, hashtable, clazz5.getName());
                            if (object instanceof JNBObjID) {
                                Object object19 = ObjectRegistry.getObjectFromID((JNBObjID)object);
                                field.set(obj, object19);
                                continue;
                            }
                            if (object instanceof JNBValueObject) {
                                Object object20 = ((JNBValueObject)object).getObject();
                                field.set(obj, object20);
                                continue;
                            }
                            if (clazz5.isArray()) {
                                Object object21 = SOAPDeserializer.unwrapArray(object, clazz5.getComponentType(), SOAPDeserializer.getMyDotNetSideProxy(obj));
                                field.set(obj, object21);
                                continue;
                            }
                            if (clazz5 == Character.TYPE && object != null && object.getClass() == Integer.class) {
                                int n5 = (Integer)object;
                                char c = (char)n5;
                                object = new Character(c);
                            }
                            field.set(obj, object);
                            continue;
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                            continue;
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            // empty catch block
                        }
                    }
                }
                return new JNBValueObject(obj, bl);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_11") + " " + string17);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_24") + " " + string17);
            }
            catch (InstantiationException instantiationException) {
                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_25") + " " + string17);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_16") + " " + string17);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_17") + " " + string17 + ": " + invocationTargetException.getTargetException().getMessage());
            }
            catch (SecurityException securityException) {
                throw new SOAPException("SecurityException: Please see http://www.jnbridge.com/jn/kb/?p=275 for information on handling this exception");
            }
        }
        if (element.getLocalName().equals("JNBDotNetValueObject")) {
            NodeList nodeList = element.getElementsByTagName("coreObjectClassName");
            if (nodeList.getLength() != 1) {
                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_10"));
            }
            Element element28 = (Element)nodeList.item(0);
            String string27 = (String)this.getTextValue(element28, hashtable, null);
            if (DotNetMappedClass.isMapped(string27)) {
                NodeList nodeList22 = element.getElementsByTagName("scheme");
                if (nodeList22.getLength() != 1) {
                    throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_12"));
                }
                Element element29 = (Element)nodeList22.item(0);
                String string28 = (String)this.getTextValue(element29, hashtable, null);
                short s = Short.parseShort(string28);
                NodeList nodeList23 = element.getElementsByTagName("numEntries");
                if (nodeList23.getLength() != 1) {
                    throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_13"));
                }
                Element element30 = (Element)nodeList23.item(0);
                String string29 = (String)this.getTextValue(element30, hashtable, null);
                int n = Integer.parseInt(string29);
                try {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    Class<?> clazz = Class.forName(string27, false, classLoader);
                    if (!DotNetObjectBase.isByValueClass(clazz)) {
                        throw new SOAPException(Messages.getString("BINARYFORMATTER_GETVALUE_5") + clazz.getName() + "  " + Messages.getString("BINARYFORMATTER_GETVALUE_6") + "  " + Messages.getString("BINARYFORMATTER_GETVALUE_7"));
                    }
                    Object var17_154 = null;
                    Field field = null;
                    switch (s) {
                        case 3: {
                            var17_154 = clazz.newInstance();
                            NodeList nodeList24 = element.getElementsByTagName("dotNetTicks");
                            if (nodeList24.getLength() != 1) {
                                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_14"));
                            }
                            Element element31 = (Element)nodeList24.item(0);
                            NodeList nodeList25 = element31.getChildNodes();
                            Node node = nodeList25.item(0);
                            if (node == null) {
                                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_15"));
                            }
                            String string30 = node.getNodeValue();
                            long l = Long.parseLong(string30);
                            long l3 = (l - 621355968000000000L) / 10000L;
                            Date date = new Date(l3);
                            try {
                                field = clazz.getField("NativeImpl");
                                field.set(var17_154, date);
                                break;
                            }
                            catch (NoSuchFieldException noSuchFieldException) {
                                throw new SOAPException("NoSuchFieldException: " + noSuchFieldException.getMessage());
                            }
                        }
                        case 4: {
                            var17_154 = clazz.newInstance();
                            NodeList nodeList26 = element.getElementsByTagName("decimalString");
                            if (nodeList26.getLength() != 1) {
                                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_18"));
                            }
                            Element element32 = (Element)nodeList26.item(0);
                            NodeList nodeList27 = element32.getChildNodes();
                            Node node = nodeList27.item(0);
                            if (node == null) {
                                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_19"));
                            }
                            String string31 = node.getNodeValue();
                            BigDecimal bigDecimal = new BigDecimal(string31);
                            try {
                                field = clazz.getField("NativeImpl");
                                field.set(var17_154, bigDecimal);
                                break;
                            }
                            catch (NoSuchFieldException noSuchFieldException) {
                                throw new SOAPException("NoSuchFieldException: " + noSuchFieldException.getMessage());
                            }
                        }
                        case 1: {
                            var17_154 = clazz.newInstance();
                            ArrayList<Object> arrayList = new ArrayList<Object>();
                            for (int i = 1; i <= n; ++i) {
                                Object object;
                                Object object22;
                                String string32;
                                NodeList nodeList28 = element.getElementsByTagName("valueType" + i);
                                if (nodeList28.getLength() == 0) {
                                    string32 = "System.Object";
                                } else if (nodeList28.getLength() == 1) {
                                    object22 = (Element)nodeList28.item(0);
                                    string32 = (String)this.getTextValue((Element)object22, hashtable, null);
                                } else {
                                    throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_21") + " " + i);
                                }
                                object22 = element.getElementsByTagName("value" + i);
                                if (object22.getLength() != 1) {
                                    throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_22") + " " + i);
                                }
                                Element element33 = (Element)object22.item(0);
                                Object object23 = this.getSingleArgument(element33, hashtable, string32);
                                if (object23 != null && object23 instanceof JNBDotNetObjID) {
                                    object = DotNetObjectBase.convertObjToJava(object23, object23.getClass(), SOAPDeserializer.getMyDotNetSideProxy(var17_154));
                                    arrayList.add(object);
                                    continue;
                                }
                                if (object23 != null && object23 instanceof JNBDotNetValueObject) {
                                    object = ((JNBDotNetValueObject)object23).getObject();
                                    arrayList.add(object);
                                    continue;
                                }
                                if (object23 != null && (object23.getClass().isArray() || object23 instanceof JNBArrayWrapper)) {
                                    if (object23 instanceof JNBArrayWrapper) {
                                        object23 = ((JNBArrayWrapper)object23).getArray();
                                    }
                                    object = SOAPDeserializer.adjustBaseType(object23.getClass().getComponentType());
                                    Object object24 = SOAPDeserializer.unwrapArray(object23, (Class)object, SOAPDeserializer.getMyDotNetSideProxy(var17_154));
                                    arrayList.add(object24);
                                    continue;
                                }
                                arrayList.add(object23);
                            }
                            try {
                                field = clazz.getField("NativeImpl");
                                field.set(var17_154, arrayList);
                                break;
                            }
                            catch (NoSuchFieldException noSuchFieldException) {
                                throw new SOAPException("NoSuchFieldException: " + noSuchFieldException.getMessage());
                            }
                        }
                        case 2: {
                            var17_154 = clazz.newInstance();
                            Hashtable<Object, Object> hashtable3 = new Hashtable<Object, Object>();
                            for (int i = 1; i <= n; ++i) {
                                Object object;
                                Object object25;
                                String string33;
                                Object object26;
                                NodeList nodeList29 = element.getElementsByTagName("key" + i);
                                if (nodeList29.getLength() != 1) {
                                    throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_23") + " " + i);
                                }
                                Element element34 = (Element)nodeList29.item(0);
                                Object object27 = this.getSingleArgument(element34, hashtable, "System.Object");
                                if (object27 != null && object27 instanceof JNBDotNetObjID) {
                                    object27 = DotNetObjectBase.convertObjToJava(object27, object27.getClass(), SOAPDeserializer.getMyDotNetSideProxy(var17_154));
                                } else if (object27 != null && object27 instanceof JNBDotNetValueObject) {
                                    object27 = ((JNBDotNetValueObject)object27).getObject();
                                } else if (object27 != null && (object27 instanceof JNBArrayWrapper || object27.getClass().isArray())) {
                                    if (object27 instanceof JNBArrayWrapper) {
                                        object26 = (JNBArrayWrapper)object27;
                                        object27 = ((JNBArrayWrapper)object26).getArray();
                                    }
                                    object27 = SOAPDeserializer.unwrapArray(object27, object27.getClass().getComponentType(), SOAPDeserializer.getMyDotNetSideProxy(var17_154));
                                }
                                object26 = element.getElementsByTagName("valueType" + i);
                                if (object26.getLength() == 0) {
                                    string33 = "System.Object";
                                } else if (object26.getLength() == 1) {
                                    object25 = (Element)object26.item(0);
                                    string33 = (String)this.getTextValue((Element)object25, hashtable, null);
                                } else {
                                    throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_21") + " " + i);
                                }
                                object25 = element.getElementsByTagName("value" + i);
                                if (object25.getLength() != 1) {
                                    throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_22") + " " + i);
                                }
                                Element element35 = (Element)object25.item(0);
                                Object object28 = this.getSingleArgument(element35, hashtable, string33);
                                if (object28 != null && object28 instanceof JNBDotNetObjID) {
                                    object = DotNetObjectBase.convertObjToJava(object28, object28.getClass(), SOAPDeserializer.getMyDotNetSideProxy(var17_154));
                                    hashtable3.put(object27, object);
                                    continue;
                                }
                                if (object28 != null && object28 instanceof JNBDotNetValueObject) {
                                    object = ((JNBDotNetValueObject)object28).getObject();
                                    hashtable3.put(object27, object);
                                    continue;
                                }
                                if (object28 != null && (object28.getClass().isArray() || object28 instanceof JNBArrayWrapper)) {
                                    if (object28 instanceof JNBArrayWrapper) {
                                        object28 = ((JNBArrayWrapper)object28).getArray();
                                    }
                                    object = SOAPDeserializer.adjustBaseType(object28.getClass().getComponentType());
                                    Object object29 = SOAPDeserializer.unwrapArray(object28, (Class)object, SOAPDeserializer.getMyDotNetSideProxy(var17_154));
                                    hashtable3.put(object27, object29);
                                    continue;
                                }
                                if (object28 == null) {
                                    object28 = NullValue.nullValue();
                                }
                                hashtable3.put(object27, object28);
                            }
                            try {
                                field = clazz.getField("NativeImpl");
                                field.set(var17_154, hashtable3);
                                break;
                            }
                            catch (NoSuchFieldException noSuchFieldException) {
                                throw new SOAPException("NoSuchFieldException: " + noSuchFieldException.getMessage());
                            }
                        }
                    }
                    return new JNBDotNetValueObject(var17_154);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_11") + string27);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_24") + string27);
                }
                catch (InstantiationException instantiationException) {
                    throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_25") + string27);
                }
            }
            NodeList nodeList30 = element.getElementsByTagName("numFields");
            if (nodeList30.getLength() != 1) {
                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_27"));
            }
            Element element36 = (Element)nodeList30.item(0);
            String string34 = (String)this.getTextValue(element36, hashtable, null);
            int n = Short.parseShort(string34);
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Class<?> clazz = Class.forName(string27, false, classLoader);
                if (!DotNetObjectBase.isByValueClass(clazz)) {
                    throw new SOAPException(Messages.getString("BINARYFORMATTER_GETVALUE_5") + clazz.getName() + "  " + Messages.getString("BINARYFORMATTER_GETVALUE_6") + "  " + Messages.getString("BINARYFORMATTER_GETVALUE_7"));
                }
                Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                if (!constructor.isAccessible()) {
                    constructor.setAccessible(true);
                }
                Object obj = constructor.newInstance(new Object[0]);
                for (int i = 1; i <= n; ++i) {
                    try {
                        Object object;
                        NodeList nodeList31;
                        Class<?> clazz6;
                        NodeList nodeList32 = element.getElementsByTagName("name" + i);
                        if (nodeList32.getLength() != 1) {
                            throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_28") + " " + i);
                        }
                        Element element37 = (Element)nodeList32.item(0);
                        String string35 = (String)this.getTextValue(element37, hashtable, null);
                        Method method = null;
                        for (clazz6 = clazz; clazz6 != null; clazz6 = clazz6.getSuperclass()) {
                            try {
                                method = clazz6.getDeclaredMethod("Get_" + string35, null);
                                break;
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                continue;
                            }
                        }
                        if (clazz6 == null) {
                            throw new NoSuchMethodException();
                        }
                        Class<?> clazz7 = method.getReturnType();
                        Method method3 = clazz6.getDeclaredMethod("Set_" + string35, clazz7);
                        if (!method3.isAccessible()) {
                            method3.setAccessible(true);
                        }
                        if ((nodeList31 = element.getElementsByTagName("value" + i)).getLength() != 1) {
                            throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_29") + " " + i);
                        }
                        Element element38 = (Element)nodeList31.item(0);
                        Object object30 = this.getSingleArgument(element38, hashtable, clazz7.getName());
                        if (object30 instanceof JNBDotNetObjID) {
                            object = DotNetObjectBase.convertObjToJava(object30, clazz7, SOAPDeserializer.getMyDotNetSideProxy(obj));
                            method3.invoke(obj, object);
                            continue;
                        }
                        if (object30 instanceof JNBValueObject) {
                            object = ((JNBValueObject)object30).getObject();
                            method3.invoke(obj, object);
                            continue;
                        }
                        if (clazz7.isArray()) {
                            object = SOAPDeserializer.unwrapArray(object30, clazz7.getComponentType(), SOAPDeserializer.getMyDotNetSideProxy(obj));
                            method3.invoke(obj, object);
                            continue;
                        }
                        method3.invoke(obj, object30);
                        continue;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        continue;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        continue;
                    }
                    catch (SecurityException securityException) {
                        if (!throwSecurityException) continue;
                        throw new SOAPException("SecurityException: Please see http://www.jnbridge.com/jn/kb/?p=275 for information on handling this exception");
                    }
                }
                return new JNBDotNetValueObject(obj);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_11") + " " + string27);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_24") + " " + string27);
            }
            catch (InstantiationException instantiationException) {
                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_25") + " " + string27);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_16") + " " + string27);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_17") + " " + string27 + ": " + invocationTargetException.getTargetException().getMessage());
            }
            catch (SecurityException securityException) {
                throw new SOAPException("SecurityException: Please see http://www.jnbridge.com/jn/kb/?p=275 for information on handling this exception");
            }
        }
        if (element.getLocalName().equals("JNBCallback")) {
            NodeList nodeList = element.getElementsByTagName("isSync");
            if (nodeList.getLength() != 1) {
                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_4"));
            }
            Element element39 = (Element)nodeList.item(0);
            String string36 = (String)this.getTextValue(element39, hashtable, null);
            NodeList nodeList33 = element.getElementsByTagName("callbackID");
            if (nodeList33.getLength() != 1) {
                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_4"));
            }
            Element element40 = (Element)nodeList33.item(0);
            String string37 = (String)this.getTextValue(element40, hashtable, null);
            NodeList nodeList34 = element.getElementsByTagName("actualClassName");
            if (nodeList34.getLength() != 1) {
                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_5"));
            }
            Element element41 = (Element)nodeList34.item(0);
            String string38 = (String)this.getTextValue(element41, hashtable, null);
            NodeList nodeList35 = element.getElementsByTagName("interfaces");
            if (nodeList.getLength() != 1) {
                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETSINGLEARGUMENT_4"));
            }
            Element element42 = (Element)nodeList35.item(0);
            String[] stringArray = (String[])this.getSingleArgument(element42, hashtable, null);
            JNBCallback jNBCallback = new JNBCallback(Boolean.valueOf(string36), Long.parseLong(string37), stringArray, string38);
            return jNBCallback;
        }
        return this.getTextValue(element, hashtable, string);
    }

    private Class getEnumType(Element element) {
        if (element.hasAttribute("xsi:type")) {
            String string = element.getAttribute("xsi:type");
            if (string == null) {
                return null;
            }
            int n = string.indexOf(58);
            if (n != -1) {
                string = string.substring(n + 1, string.length() - 1);
            }
            try {
                Class<?> clazz = Class.forName(string, false, Thread.currentThread().getContextClassLoader());
                if (EnumInfo.isEnum(clazz)) {
                    return clazz;
                }
                return null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
        return null;
    }

    private int getArrayLength(String string) throws SOAPException {
        int n = string.lastIndexOf(91);
        int n2 = string.lastIndexOf(93);
        if (n == -1 || n2 == -1 || n > n2) {
            throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETARRAYLENGTH_1"));
        }
        try {
            String string2 = string.substring(string.lastIndexOf(91) + 1, string.lastIndexOf(93));
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETARRAYLENGTH_1"));
        }
    }

    private Class convertToJavaComponentType(String string) throws SOAPException {
        Class clazz;
        int n = 0;
        int n2 = string.length();
        int n3 = -1;
        for (int i = n2 - 1; i >= 0; --i) {
            if (string.charAt(i) != '[') continue;
            ++n;
            n3 = i;
        }
        String string2 = --n == -1 ? string : string.substring(0, n3);
        if (n > 0) {
            String string3 = this.convertSoapTypeToJavaStr(string2);
            if (string3 == null) {
                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_CONVERTTOJAVACOMPONENT_1") + " " + string);
            }
            String string4 = "";
            for (int i = 0; i < n; ++i) {
                string4 = string4 + '[';
            }
            string4 = string4 + string3;
            try {
                clazz = ClassRegistry.getClass(string4, this.getClass().getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SOAPException(Messages.getString("SOAPDESERIALIZER_CONVERTTOJAVACOMPONENT_2") + " " + string);
            }
        } else {
            clazz = this.convertSoapTypeToJavaClass(string2);
        }
        return clazz;
    }

    private Object getTextValue(Element element, Hashtable hashtable, String string) throws SOAPException {
        if (element.hasAttribute("href")) {
            String string2 = element.getAttribute("href");
            if (string2.charAt(0) == '#') {
                string2 = string2.substring(1);
            }
            Element element2 = (Element)hashtable.get(string2);
            return this.getTextValue(element2, hashtable, string);
        }
        NodeList nodeList = element.getChildNodes();
        Node node = nodeList.item(0);
        if (nodeList.getLength() == 1 && node.getNodeType() == 3) {
            String string3 = element.getAttribute("xsi:type");
            Class clazz = null;
            if (string3 != null && (clazz = this.convertSoapTypeToJavaClass(string3 = SOAPDeserializer.addPackageName(string3, element))) != null) {
                int n = string3.indexOf(58);
                if (n != -1) {
                    String string4 = string3.substring(0, n);
                    String string5 = element.getAttribute("xmlns:" + string4);
                    if (string5 != null) {
                        SOAPTypeNamespaceRegistry.register(clazz, string5);
                    }
                }
                string = clazz.getName();
            }
            if (string == null) {
                return node.getNodeValue();
            }
            String string6 = node.getNodeValue();
            return SOAPDeserializer.convertToJavaObject(string, string6, clazz);
        }
        if (nodeList.getLength() == 0) {
            return "";
        }
        throw new SOAPException(Messages.getString("SOAPDESERIALIZER_GETTEXTVALUE_1") + ". Please contact support@jnbridge.com");
    }

    private static Object unwrapArray(Object object, Class clazz, IDotNetSideProxy iDotNetSideProxy) {
        if (object == null) {
            return object;
        }
        boolean bl = clazz.getName().equals("System.Object");
        if (object instanceof JNBArrayWrapper) {
            object = ((JNBArrayWrapper)object).getArray();
        }
        int n = Array.getLength(object);
        Object object2 = Array.newInstance(clazz, n);
        for (int i = 0; i < n; ++i) {
            Object object3;
            Object object4 = Array.get(object, i);
            if (object4 instanceof JNBObjID) {
                object3 = ObjectRegistry.getObjectFromID((JNBObjID)object4);
            } else if (object4 instanceof JNBDotNetObjID) {
                object3 = DotNetObjectBase.convertObjToJava(object4, clazz, iDotNetSideProxy);
            } else if (object4 instanceof JNBValueObject) {
                object3 = ((JNBValueObject)object4).getObject();
            } else if (object4 instanceof JNBDotNetValueObject) {
                object3 = ((JNBDotNetValueObject)object4).getObject();
            } else if (object4 instanceof String && bl) {
                object3 = DotNetWrapperFactory.makeDotNetString((String)object4);
            } else if (object4 != null && EnumInfo.isEnum(object4.getClass()) && bl) {
                object3 = DotNetWrapperFactory.makeDotNetEnum(object4);
            } else if (clazz.isArray()) {
                object3 = SOAPDeserializer.unwrapArray(object4, clazz.getComponentType(), iDotNetSideProxy);
                if (bl) {
                    object3 = DotNetWrapperFactory.makeDotNetArray(object3);
                }
            } else {
                object3 = BoxedValueFactory.isBoxable(object4) && DotNetObjectBase.class.isAssignableFrom(clazz) ? BoxedValueFactory.box(object4) : object4;
            }
            Array.set(object2, i, object3);
        }
        return object2;
    }

    private static Class adjustBaseType(Class clazz) {
        if (clazz.isArray()) {
            String string = clazz.getName();
            if (string.endsWith("Ljava.lang.Object;")) {
                int n = string.lastIndexOf("Ljava.lang.Object;");
                String string2 = string.substring(0, n) + "LSystem.Object;";
                try {
                    Class<?> clazz2 = Class.forName(string2, false, Thread.currentThread().getContextClassLoader());
                    return clazz2;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new DotNetSideException("ClassNotFoundException: System.Object", classNotFoundException);
                }
            }
            return clazz;
        }
        if (clazz == Object.class) {
            return dotNetObjectClass;
        }
        return clazz;
    }

    private String convertSoapTypeToJavaStr(String string) {
        String string2;
        int n = string.indexOf(58);
        if (n != -1) {
            string = string.substring(n + 1);
        }
        if ((string2 = (String)arrayComponentConversionTable.get(string)) != null) {
            return string2;
        }
        return "L" + DotNetArgTypeConverter.convertNested(string) + ";";
    }

    private Class convertSoapTypeToJavaClass(String string) {
        Class clazz;
        int n = string.indexOf(58);
        if (n != -1) {
            string = string.substring(n + 1);
        }
        if ((clazz = (Class)scalarTypeConversionTable.get(string)) != null) {
            return clazz;
        }
        if (string.equals("base64")) {
            return byteArrayType;
        }
        try {
            return Class.forName(DotNetArgTypeConverter.convertNested(string), false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static String addPackageName(String string, Element element) {
        int n = string.indexOf(":");
        if (n == -1) {
            return string;
        }
        String string2 = string.substring(0, n);
        String string3 = element.getAttribute("xmlns:" + string2);
        if (string3 == null || string3.equals("")) {
            return string;
        }
        String string4 = string3.startsWith("\"http://schemas.microsoft.com/clr/nsassem/") ? string3.substring("\"http://schemas.microsoft.com/clr/nsassem/".length() - 1) : (string3.startsWith("http://schemas.microsoft.com/clr/nsassem/") ? string3.substring("http://schemas.microsoft.com/clr/nsassem/".length()) : (string3.startsWith("\"http://schemas.microsoft.com/clr/ns/") ? string3.substring("\"http://schemas.microsoft.com/clr/ns/".length() - 1) : string3.substring("http://schemas.microsoft.com/clr/ns/".length())));
        int n2 = string4.lastIndexOf("/");
        if (n2 != -1) {
            string4 = string4.substring(0, n2);
        }
        string4 = string4.replace('/', '.');
        return string4 + "." + string.substring(n + 1);
    }

    private static Object convertToJavaObject(String string, String string2, Class clazz) {
        if (string.endsWith("Boolean") || string.endsWith("boolean")) {
            return Boolean.valueOf(string2);
        }
        if (string.endsWith("Byte") || string.endsWith("byte")) {
            return Byte.valueOf(string2);
        }
        if (string.endsWith("Char") || string.endsWith("char") || string.endsWith("unsignedShort") || string.endsWith("UInt16")) {
            try {
                int n = Integer.parseInt(string2);
                return new Integer(n);
            }
            catch (NumberFormatException numberFormatException) {
                char c = string2.charAt(0);
                return new Character(c);
            }
        }
        if (string.endsWith("short") || string.endsWith("Short")) {
            return Short.valueOf(string2);
        }
        if (string.endsWith("int") || string.endsWith("Int")) {
            return Integer.valueOf(string2);
        }
        if (string.endsWith("long") || string.endsWith("Long")) {
            return Long.valueOf(string2);
        }
        if (string.endsWith("float") || string.endsWith("Float")) {
            return Float.valueOf(string2);
        }
        if (string.endsWith("double") || string.endsWith("Double")) {
            return Double.valueOf(string2);
        }
        if (clazz != null && EnumInfo.isEnum(clazz)) {
            return EnumInfo.getEnum(string, string2);
        }
        return string2;
    }

    static {
        try {
            dotNetObjectClass = Class.forName("System.Object", false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            Object object;
            if (JavaSideProperties.isPropsFileSet()) {
                object = JavaSideProperties.getInstance();
                String string = ((JavaSideProperties)object).getProperty("javaSide.throwSecurityException");
                if (string == null) {
                    string = System.getProperty("javaSide.throwSecurityException", "true");
                }
                throwSecurityException = string != null && string.equalsIgnoreCase("true");
            } else {
                object = System.getProperty("javaSide.throwSecurityException", "true");
                throwSecurityException = object != null && ((String)object).equalsIgnoreCase("true");
            }
        }
        catch (JavaSidePropertiesException javaSidePropertiesException) {
            String string = System.getProperty("javaSide.throwSecurityException", "true");
            throwSecurityException = string != null && string.equalsIgnoreCase("true");
        }
        byteArrayType = new byte[0].getClass();
        arrayComponentConversionTable = new Hashtable();
        scalarTypeConversionTable = new Hashtable();
        arrayComponentConversionTable.put("anyType", "Ljava.lang.Object;");
        arrayComponentConversionTable.put("ur-type", "Ljava.lang.Object;");
        arrayComponentConversionTable.put("System.Object", "Ljava.lang.Object;");
        arrayComponentConversionTable.put("JNBObjID", "Lcom.jnbridge.jnbcore.JNBObjID;");
        arrayComponentConversionTable.put("JNBDotNetObjID", "Lcom.jnbridge.jnbcore.JNBDotNetObjID;");
        arrayComponentConversionTable.put("string", "Ljava.lang.String;");
        arrayComponentConversionTable.put("String", "Ljava.lang.String;");
        arrayComponentConversionTable.put("System.String", "Ljava.lang.String;");
        arrayComponentConversionTable.put("Int", "I");
        arrayComponentConversionTable.put("int", "I");
        arrayComponentConversionTable.put("Int32", "I");
        arrayComponentConversionTable.put("System.Int32", "I");
        arrayComponentConversionTable.put("int32", "I");
        arrayComponentConversionTable.put("short", "S");
        arrayComponentConversionTable.put("Short", "S");
        arrayComponentConversionTable.put("Int16", "S");
        arrayComponentConversionTable.put("System.Int16", "S");
        arrayComponentConversionTable.put("int16", "S");
        arrayComponentConversionTable.put("long", "J");
        arrayComponentConversionTable.put("Long", "J");
        arrayComponentConversionTable.put("Int64", "J");
        arrayComponentConversionTable.put("System.Int64", "J");
        arrayComponentConversionTable.put("int64", "J");
        arrayComponentConversionTable.put("float", "F");
        arrayComponentConversionTable.put("Float", "F");
        arrayComponentConversionTable.put("single", "F");
        arrayComponentConversionTable.put("Single", "F");
        arrayComponentConversionTable.put("System.Single", "F");
        arrayComponentConversionTable.put("double", "D");
        arrayComponentConversionTable.put("Double", "D");
        arrayComponentConversionTable.put("System.Double", "D");
        arrayComponentConversionTable.put("uInt16", "C");
        arrayComponentConversionTable.put("UInt16", "C");
        arrayComponentConversionTable.put("System.UInt16", "C");
        arrayComponentConversionTable.put("unsignedShort", "C");
        arrayComponentConversionTable.put("UnsignedShort", "C");
        arrayComponentConversionTable.put("char", "C");
        arrayComponentConversionTable.put("Char", "C");
        arrayComponentConversionTable.put("System.Char", "C");
        arrayComponentConversionTable.put("byte", "B");
        arrayComponentConversionTable.put("Byte", "B");
        arrayComponentConversionTable.put("System.Byte", "B");
        arrayComponentConversionTable.put("UnsignedByte", "B");
        arrayComponentConversionTable.put("unsignedByte", "B");
        arrayComponentConversionTable.put("sbyte", "B");
        arrayComponentConversionTable.put("Sbyte", "B");
        arrayComponentConversionTable.put("System.Sbyte", "B");
        arrayComponentConversionTable.put("System.SByte", "B");
        arrayComponentConversionTable.put("bool", "Z");
        arrayComponentConversionTable.put("Bool", "Z");
        arrayComponentConversionTable.put("Boolean", "Z");
        arrayComponentConversionTable.put("System.Boolean", "Z");
        arrayComponentConversionTable.put("boolean", "Z");
        arrayComponentConversionTable.put("UnsignedInt", "J");
        arrayComponentConversionTable.put("unsignedInt", "J");
        arrayComponentConversionTable.put("uInt32", "J");
        arrayComponentConversionTable.put("UInt32", "J");
        arrayComponentConversionTable.put("System.UInt32", "J");
        arrayComponentConversionTable.put("UnsignedLong", "F");
        arrayComponentConversionTable.put("unsignedLong", "F");
        arrayComponentConversionTable.put("uInt64", "F");
        arrayComponentConversionTable.put("UInt64", "F");
        arrayComponentConversionTable.put("System.UInt64", "F");
        try {
            scalarTypeConversionTable.put("anyType", Class.forName("java.lang.Object"));
            scalarTypeConversionTable.put("ur-type", Class.forName("java.lang.Object"));
            scalarTypeConversionTable.put("JNBObjID", Class.forName("com.jnbridge.jnbcore.JNBObjID"));
            scalarTypeConversionTable.put("JNBDotNetObjID", Class.forName("com.jnbridge.jnbcore.JNBDotNetObjID"));
            scalarTypeConversionTable.put("string", Class.forName("java.lang.String"));
            scalarTypeConversionTable.put("String", Class.forName("java.lang.String"));
            scalarTypeConversionTable.put("int", Integer.TYPE);
            scalarTypeConversionTable.put("Int", Integer.TYPE);
            scalarTypeConversionTable.put("int32", Integer.TYPE);
            scalarTypeConversionTable.put("Int32", Integer.TYPE);
            scalarTypeConversionTable.put("System.Int32", Integer.TYPE);
            scalarTypeConversionTable.put("short", Short.TYPE);
            scalarTypeConversionTable.put("Short", Short.TYPE);
            scalarTypeConversionTable.put("int16", Short.TYPE);
            scalarTypeConversionTable.put("Int16", Short.TYPE);
            scalarTypeConversionTable.put("System.Int16", Short.TYPE);
            scalarTypeConversionTable.put("long", Long.TYPE);
            scalarTypeConversionTable.put("Long", Long.TYPE);
            scalarTypeConversionTable.put("int64", Long.TYPE);
            scalarTypeConversionTable.put("Int64", Long.TYPE);
            scalarTypeConversionTable.put("System.Int64", Long.TYPE);
            scalarTypeConversionTable.put("float", Float.TYPE);
            scalarTypeConversionTable.put("Float", Float.TYPE);
            scalarTypeConversionTable.put("single", Float.TYPE);
            scalarTypeConversionTable.put("Single", Float.TYPE);
            scalarTypeConversionTable.put("System.Single", Float.TYPE);
            scalarTypeConversionTable.put("double", Double.TYPE);
            scalarTypeConversionTable.put("Double", Double.TYPE);
            scalarTypeConversionTable.put("System.Double", Double.TYPE);
            scalarTypeConversionTable.put("uInt16", Character.TYPE);
            scalarTypeConversionTable.put("UInt16", Character.TYPE);
            scalarTypeConversionTable.put("System.UInt16", Character.TYPE);
            scalarTypeConversionTable.put("unsignedShort", Character.TYPE);
            scalarTypeConversionTable.put("UnsignedShort", Character.TYPE);
            scalarTypeConversionTable.put("char", Character.TYPE);
            scalarTypeConversionTable.put("Char", Character.TYPE);
            scalarTypeConversionTable.put("System.Char", Character.TYPE);
            scalarTypeConversionTable.put("Byte", Byte.TYPE);
            scalarTypeConversionTable.put("System.Byte", Byte.TYPE);
            scalarTypeConversionTable.put("byte", Byte.TYPE);
            scalarTypeConversionTable.put("UnsignedByte", Byte.TYPE);
            scalarTypeConversionTable.put("unsignedByte", Byte.TYPE);
            scalarTypeConversionTable.put("sbyte", Byte.TYPE);
            scalarTypeConversionTable.put("Sbyte", Byte.TYPE);
            scalarTypeConversionTable.put("System.Sbyte", Byte.TYPE);
            scalarTypeConversionTable.put("Bool", Boolean.TYPE);
            scalarTypeConversionTable.put("bool", Boolean.TYPE);
            scalarTypeConversionTable.put("Boolean", Boolean.TYPE);
            scalarTypeConversionTable.put("System.Boolean", Boolean.TYPE);
            scalarTypeConversionTable.put("boolean", Boolean.TYPE);
            scalarTypeConversionTable.put("UnsignedInt", Long.TYPE);
            scalarTypeConversionTable.put("unsignedInt", Long.TYPE);
            scalarTypeConversionTable.put("uInt32", Long.TYPE);
            scalarTypeConversionTable.put("UInt32", Long.TYPE);
            scalarTypeConversionTable.put("System.UInt32", Long.TYPE);
            scalarTypeConversionTable.put("UnsignedLong", Float.TYPE);
            scalarTypeConversionTable.put("unsignedLong", Float.TYPE);
            scalarTypeConversionTable.put("uInt64", Float.TYPE);
            scalarTypeConversionTable.put("UInt64", Float.TYPE);
            scalarTypeConversionTable.put("System.UInt64", Float.TYPE);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println(Messages.getString("SOAPDESERIALIZER_STATIC_1"));
            System.out.println(Messages.getString("SOAPDESERIALIZER_STATIC_2"));
            classNotFoundException.printStackTrace();
            Runtime.getRuntime().exit(1);
        }
    }
}

