/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore.formatters.soap;

import com.jnbridge.jnbcore.CallArgs;
import com.jnbridge.jnbcore.CallbackException;
import com.jnbridge.jnbcore.DebugConstants;
import com.jnbridge.jnbcore.InternalException;
import com.jnbridge.jnbcore.JNBDispatchMap;
import com.jnbridge.jnbcore.JNBObjID;
import com.jnbridge.jnbcore.JNBVoidResult;
import com.jnbridge.jnbcore.MessageKeys;
import com.jnbridge.jnbcore.Messages;
import com.jnbridge.jnbcore.ObjectRegistry;
import com.jnbridge.jnbcore.formatters.Formatter;
import com.jnbridge.jnbcore.formatters.SerializationException;
import com.jnbridge.jnbcore.formatters.soap.MutableInteger;
import com.jnbridge.jnbcore.formatters.soap.SOAPBodyElement;
import com.jnbridge.jnbcore.formatters.soap.SOAPCallElement;
import com.jnbridge.jnbcore.formatters.soap.SOAPDeserializer;
import com.jnbridge.jnbcore.formatters.soap.SOAPEnvelopeElement;
import com.jnbridge.jnbcore.formatters.soap.SOAPException;
import com.jnbridge.jnbcore.formatters.soap.SOAPNamespaceConstants;
import com.jnbridge.jnbcore.formatters.soap.SOAPSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class SOAPFormatter
implements Formatter,
DebugConstants,
SOAPNamespaceConstants,
MessageKeys {
    private DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    private DocumentBuilderPool dbPool;
    private String calledMethod = null;
    private static Templates templates = null;
    private static TransformerConfigurationException templateError = null;

    private static synchronized void setupTemplates() throws TransformerConfigurationException {
        if (templates != null) {
            return;
        }
        InputStream inputStream = SOAPFormatter.class.getClassLoader().getResourceAsStream("output.xslt");
        StreamSource streamSource = new StreamSource(inputStream);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        templates = transformerFactory.newTemplates(streamSource);
    }

    public SOAPFormatter() {
        this.dbf.setValidating(false);
        this.dbf.setIgnoringComments(true);
        this.dbf.setIgnoringElementContentWhitespace(true);
        this.dbf.setCoalescing(true);
        this.dbf.setExpandEntityReferences(true);
        this.dbf.setNamespaceAware(true);
        this.dbPool = new DocumentBuilderPool();
    }

    public void serializeCall(OutputStream outputStream, HashMap hashMap) throws SerializationException {
        try {
            DocumentBuilder documentBuilder = this.dbf.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = SOAPFormatter.newSoapEnvelope(document, false, true);
            Element element2 = document.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "SOAP-ENV:Body");
            document.appendChild(element);
            element.appendChild(element2);
            Element element3 = this.newSoapCallElement(document, element2, hashMap);
            try {
                if (templateError != null) {
                    throw templateError;
                }
                Transformer transformer = templates.newTransformer();
                transformer.transform(new DOMSource(document), new StreamResult(outputStream));
            }
            catch (TransformerException transformerException) {
                throw new SerializationException(Messages.getString("SOAPFORMATTER_SERIALIZECALL_1") + " " + transformerException, transformerException);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SerializationException("ParserConfigurationException: " + parserConfigurationException.getMessage(), parserConfigurationException);
        }
    }

    public Element newSoapCallElement(Document document, Element element, HashMap hashMap) throws SOAPException {
        String string = (String)hashMap.get("targetMethodName");
        Element element2 = document.createElementNS("http://schemas.microsoft.com/clr/nsassem/com.jnbridge.jnbcore.IJNBDotNetDispatcher/JNBShare", "i2:" + string);
        element.appendChild(element2);
        Integer n = (Integer)hashMap.get("targetMethodID");
        int n2 = n;
        String[] stringArray = JNBDispatchMap.getJ2NArgName(n2);
        SOAPSerializer sOAPSerializer = new SOAPSerializer(document, element);
        MutableInteger mutableInteger = new MutableInteger(3);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            Object v = hashMap.get(string2);
            Element element3 = document.createElement(string2);
            element2.appendChild(element3);
            sOAPSerializer.serialize(v, element3, mutableInteger, string2.equals("signature") || string2.equals("indexSignature"));
        }
        return element2;
    }

    public void serializeResult(OutputStream outputStream, int n, int n2, Object object, boolean bl) throws SerializationException {
        Document document = this.generateSOAPResponse(object);
        try {
            if (templateError != null) {
                throw templateError;
            }
            Transformer transformer = templates.newTransformer();
            transformer.transform(new DOMSource(document), new StreamResult(outputStream));
        }
        catch (TransformerException transformerException) {
            throw new SerializationException(Messages.getString("SOAPFORMATTER_SERIALIZECALL_1") + " " + transformerException, transformerException);
        }
    }

    public void serializeException(OutputStream outputStream, Throwable throwable) throws SerializationException {
        Document document = this.generateSOAPFault(throwable);
        try {
            if (templateError != null) {
                throw templateError;
            }
            Transformer transformer = templates.newTransformer();
            transformer.transform(new DOMSource(document), new StreamResult(outputStream));
        }
        catch (TransformerException transformerException) {
            throw new SerializationException(Messages.getString("SOAPFORMATTER_SERIALIZEEXCEPTION_1") + " " + transformerException, transformerException);
        }
    }

    public CallArgs deserializeCall(InputStream inputStream) throws SerializationException, InterruptedIOException, CallbackException {
        DocumentBuilder documentBuilder = null;
        try {
            CallArgs callArgs;
            documentBuilder = this.dbPool.getDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            CallArgs callArgs2 = callArgs = this.getCallArgs(document);
            return callArgs2;
        }
        catch (InterruptedIOException interruptedIOException) {
            throw interruptedIOException;
        }
        catch (IOException iOException) {
            throw new SerializationException("IOException: " + iOException.getMessage(), iOException);
        }
        catch (SAXException sAXException) {
            throw new SerializationException("SAXException: " + sAXException.getMessage(), sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SerializationException("ParserConfigurationException: " + parserConfigurationException.getMessage(), parserConfigurationException);
        }
        finally {
            if (documentBuilder != null) {
                this.dbPool.releaseDocumentBuilder(documentBuilder);
            }
        }
    }

    private CallArgs getCallArgs(Document document) throws SerializationException, CallbackException {
        Hashtable hashtable = new Hashtable();
        this.getIdMap(document.getDocumentElement(), hashtable);
        SOAPEnvelopeElement sOAPEnvelopeElement = new SOAPEnvelopeElement(document);
        SOAPBodyElement sOAPBodyElement = new SOAPBodyElement(sOAPEnvelopeElement);
        SOAPCallElement sOAPCallElement = new SOAPCallElement(document, sOAPBodyElement);
        try {
            sOAPCallElement.getArguments(hashtable);
        }
        catch (InternalException internalException) {
            throw new SerializationException("InternalException: " + internalException.getMessage(), internalException);
        }
        this.calledMethod = sOAPCallElement.getCalledMethod();
        sOAPCallElement.setArg("targetMethodID", JNBDispatchMap.getMethodIDasInteger(this.calledMethod));
        sOAPCallElement.setArg("isThreadTrue", new Boolean(false));
        return sOAPCallElement;
    }

    private void getIdMap(Element element, Hashtable hashtable) {
        String string = element.getAttribute("id");
        if (string != null && string.length() != 0) {
            hashtable.put(string, element);
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            this.getIdMap((Element)node, hashtable);
        }
    }

    public Object deserializeResponse(InputStream inputStream) throws SerializationException, InterruptedIOException {
        Document document = null;
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = this.dbPool.getDocumentBuilder();
            document = documentBuilder.parse(inputStream);
            SOAPEnvelopeElement sOAPEnvelopeElement = new SOAPEnvelopeElement(document);
            SOAPBodyElement sOAPBodyElement = new SOAPBodyElement(sOAPEnvelopeElement);
            Element element = sOAPBodyElement.getFirstNonTextChild();
            if (this.isResult(element)) {
                Object object = this.deserializeResult(element, document, sOAPBodyElement);
                return object;
            }
            Object object = this.deserializeException(element, document, sOAPBodyElement);
            return object;
        }
        catch (InterruptedIOException interruptedIOException) {
            throw interruptedIOException;
        }
        catch (IOException iOException) {
            throw new SerializationException("IOException: " + iOException.getMessage(), iOException);
        }
        catch (SAXException sAXException) {
            throw new SerializationException("SAXException: " + sAXException.getMessage(), sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SerializationException("ParserConfigurationException: " + parserConfigurationException.getMessage(), parserConfigurationException);
        }
        finally {
            if (documentBuilder != null) {
                this.dbPool.releaseDocumentBuilder(documentBuilder);
            }
        }
    }

    private boolean isResult(Element element) {
        String string = element.getNodeName();
        return string.endsWith("Response");
    }

    private Object deserializeResult(Element element, Document document, SOAPBodyElement sOAPBodyElement) throws SerializationException {
        Object object;
        Hashtable hashtable = new Hashtable();
        this.getIdMap(document.getDocumentElement(), hashtable);
        Element element2 = null;
        for (object = element.getFirstChild(); object != null; object = object.getNextSibling()) {
            if (object.getNodeType() != 1) continue;
            element2 = (Element)object;
            break;
        }
        if (element2 == null) {
            return new JNBVoidResult();
        }
        object = new SOAPDeserializer(document, sOAPBodyElement);
        return ((SOAPDeserializer)object).deserialize(element2, hashtable);
    }

    private Object deserializeException(Node node, Document document, SOAPBodyElement sOAPBodyElement) throws SerializationException {
        Object object;
        Hashtable hashtable = new Hashtable();
        this.getIdMap(document.getDocumentElement(), hashtable);
        Element element = null;
        Element element2 = null;
        for (object = node.getFirstChild(); object != null; object = object.getNextSibling()) {
            Object object2;
            if (object.getNodeType() != 1 || !object.getLocalName().equals("detail")) continue;
            element = (Element)object;
            if (element.hasAttribute("href")) {
                object2 = element.getAttribute("href");
                if (((String)object2).charAt(0) == '#') {
                    object2 = ((String)object2).substring(1);
                }
                element = (Element)hashtable.get(object2);
            }
            for (object2 = element.getFirstChild(); object2 != null; object2 = object2.getNextSibling()) {
                if (object2.getNodeType() != 1 || !object2.getLocalName().equals("exception")) continue;
                element2 = (Element)object2;
                break;
            }
            if (element2 != null) break;
            throw new SOAPException(Messages.getString("SOAPFORMATTER_DESERIALIZEEXCEPTION_1"));
        }
        if (element == null) {
            throw new SOAPException(Messages.getString("SOAPFORMATTER_DESERIALIZEEXCEPTION_2"));
        }
        object = new SOAPDeserializer(document, sOAPBodyElement);
        return ((SOAPDeserializer)object).deserialize(element2, hashtable);
    }

    private static Element newSoapEnvelope(Document document, boolean bl, boolean bl2) {
        Element element = document.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "SOAP-ENV:Envelope");
        element.setAttribute("xmlns:SOAP-ENV", "http://schemas.xmlsoap.org/soap/envelope/");
        element.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        element.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        element.setAttribute("xmlns:SOAP-ENC", "http://schemas.xmlsoap.org/soap/encoding/");
        element.setAttribute("xmlns:clr", "http://schemas.microsoft.com/soap/encoding/clr/1.0");
        if (bl2) {
            element.setAttribute("xmlns:i2", "http://schemas.microsoft.com/clr/nsassem/com.jnbridge.jnbcore.IJNBDotNetDispatcher/JNBShare");
        } else {
            element.setAttribute("xmlns:i2", "http://schemas.microsoft.com/clr/nsassem/com.jnbridge.jnbcore.IJNBDispatcher/JNBShare");
        }
        element.setAttribute("xmlns:a3", "http://schemas.microsoft.com/clr/nsassem/com.jnbridge.jnbcore/JNBShare");
        element.setAttribute("xmlns:a2", "http://schemas.microsoft.com/clr/ns/System");
        if (bl) {
            element.setAttribute("xmlns:a1", "http://schemas.microsoft.com/clr/ns/System.Runtime.Serialization.Formatters");
        } else {
            element.setAttribute("xmlns:a1", "http://schemas.microsoft.com/clr/nsassem/com.jnbridge.jnbcore/JNBShare");
        }
        return element;
    }

    private Document generateSOAPResponse(Object object) throws SerializationException {
        try {
            DocumentBuilder documentBuilder = this.dbf.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = SOAPFormatter.newSoapEnvelope(document, false, false);
            Element element2 = document.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "SOAP-ENV:Body");
            document.appendChild(element);
            element.appendChild(element2);
            Element element3 = document.createElementNS("http://schemas.microsoft.com/clr/nsassem/com.jnbridge.jnbcore.IJNBDispatcher/JNBShare", "i2:" + this.calledMethod + "Response");
            element2.appendChild(element3);
            if (!(object instanceof JNBVoidResult)) {
                Element element4 = document.createElement("return");
                element3.appendChild(element4);
                SOAPSerializer sOAPSerializer = new SOAPSerializer(document, element2);
                try {
                    sOAPSerializer.serialize(object, element4, new MutableInteger(4));
                }
                catch (SOAPException sOAPException) {
                    throw new SerializationException("SOAPException: " + sOAPException.getMessage(), sOAPException);
                }
            }
            return document;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SerializationException("ParserConfigurationException: " + parserConfigurationException.getMessage(), parserConfigurationException);
        }
    }

    public Document generateSOAPFault(Throwable throwable) throws SerializationException {
        try {
            Node node;
            Node node2;
            boolean bl;
            Throwable throwable2;
            String string = null;
            JNBObjID jNBObjID = null;
            String string2 = "";
            String string3 = null;
            if (throwable instanceof InvocationTargetException) {
                throwable2 = ((InvocationTargetException)throwable).getTargetException();
                string2 = Messages.getString("SOAPFORMATTER_GENERATESOAPFAULT_1");
                bl = true;
            } else if (throwable instanceof InternalException) {
                throwable2 = throwable;
                string3 = Messages.getString("SOAPFORMATTER_GENERATESOAPFAULT_2");
                string2 = string3 + ": " + throwable2.getMessage();
                bl = false;
            } else if (throwable instanceof SOAPException) {
                throwable2 = throwable;
                string3 = Messages.getString("SOAPFORMATTER_GENERATESOAPFAULT_3");
                string2 = string3 + ": " + throwable2.getMessage();
                bl = false;
            } else {
                throwable2 = throwable;
                string3 = Messages.getString("SOAPFORMATTER_GENERATESOAPFAULT_2");
                string2 = string3 + ": " + throwable2.toString();
                bl = false;
            }
            string = throwable2.getClass().getName();
            jNBObjID = ObjectRegistry.getObjectID(throwable2);
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable2.printStackTrace(printWriter);
            DocumentBuilder documentBuilder = this.dbf.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = SOAPFormatter.newSoapEnvelope(document, true, false);
            Element element2 = document.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "SOAP-ENV:Body");
            document.appendChild(element);
            element.appendChild(element2);
            Element element3 = document.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "SOAP-ENV:Fault");
            element3.setAttribute("id", "ref-1");
            element2.appendChild(element3);
            Element element4 = document.createElement("faultcode");
            element4.setAttribute("id", "ref-2");
            Text text = document.createTextNode("SOAP-ENV:Server");
            element4.appendChild(text);
            element3.appendChild(element4);
            Element element5 = document.createElement("faultstring");
            element5.setAttribute("id", "ref-3");
            Text text2 = document.createTextNode(string2);
            element5.appendChild(text2);
            element3.appendChild(element5);
            Element element6 = document.createElement("detail");
            element6.setAttribute("xsi:type", "a1:ServerFault");
            element3.appendChild(element6);
            Element element7 = document.createElement("exceptionType");
            if (bl || string3 == null) {
                element7.setAttribute("xsi:null", "1");
            } else {
                node2 = document.createTextNode(string3);
                element7.appendChild(node2);
            }
            element6.appendChild(element7);
            node2 = document.createElement("message");
            if (bl) {
                node2.setAttribute("xsi:null", "1");
            } else {
                node = document.createTextNode(string2);
                node2.appendChild(node);
            }
            element6.appendChild(node2);
            node = document.createElement("stackTrace");
            node.setAttribute("xsi:null", "1");
            element6.appendChild(node);
            Element element8 = document.createElement("exception");
            if (bl) {
                Text text3;
                Element element9;
                element8.setAttribute("href", "#ref-5");
                element6.appendChild(element8);
                Element element10 = document.createElementNS("http://schemas.microsoft.com/clr/nsassem/com.jnbridge.jnbcore/JNBShare", "a3:JNBException");
                element10.setAttribute("id", "ref-5");
                element2.appendChild(element10);
                Element element11 = document.createElement("objID");
                Text text4 = document.createTextNode(jNBObjID.toString());
                element11.appendChild(text4);
                element10.appendChild(element11);
                if (string != null) {
                    element9 = document.createElement("innerClassName");
                    element9.setAttribute("id", "ref-6");
                    text3 = document.createTextNode(string);
                    element9.appendChild(text3);
                    element10.appendChild(element9);
                }
                element9 = document.createElement("ClassName");
                element9.setAttribute("id", "ref-7");
                text3 = document.createTextNode("com.jnbridge.jnbcore.JNBException");
                element9.appendChild(text3);
                element10.appendChild(element9);
                Element element12 = document.createElement("Message");
                element12.setAttribute("id", "ref-8");
                Text text5 = document.createTextNode("Error in the application.");
                element12.appendChild(text5);
                element10.appendChild(element12);
                Element element13 = document.createElement("InnerException");
                element13.setAttribute("xsi:null", "1");
                element10.appendChild(element13);
                Element element14 = document.createElement("HelpURL");
                element14.setAttribute("xsi:null", "1");
                element10.appendChild(element14);
                Element element15 = document.createElement("StackTraceString");
                element15.setAttribute("id", "ref-9");
                Text text6 = document.createTextNode(stringWriter.toString());
                element15.appendChild(text6);
                element10.appendChild(element15);
                Element element16 = document.createElement("innerStackTrace");
                element16.setAttribute("id", "ref-12");
                Text text7 = document.createTextNode(stringWriter.toString());
                element16.appendChild(text7);
                element10.appendChild(element16);
                Element element17 = document.createElement("RemoteStackTraceString");
                element17.setAttribute("xsi:null", "1");
                element10.appendChild(element17);
                Element element18 = document.createElement("RemoteStackIndex");
                Text text8 = document.createTextNode("0");
                element18.appendChild(text8);
                element10.appendChild(element18);
                Element element19 = document.createElement("ExceptionMethod");
                element19.setAttribute("xsi:null", "1");
                element10.appendChild(element19);
                Element element20 = document.createElement("HResult");
                Text text9 = document.createTextNode("-2146232832");
                element20.appendChild(text9);
                element10.appendChild(element20);
                Element element21 = document.createElement("Source");
                element21.setAttribute("id", "ref-11");
                Text text10 = document.createTextNode("JNBShare");
                element21.appendChild(text10);
                element10.appendChild(element21);
            } else {
                element8.setAttribute("xsi:null", "1");
                element6.appendChild(element8);
            }
            return document;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SerializationException("ParserConfigurationException: " + parserConfigurationException.getMessage(), parserConfigurationException);
        }
    }

    static {
        try {
            SOAPFormatter.setupTemplates();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            templateError = transformerConfigurationException;
        }
    }

    private class DocumentBuilderPool {
        private static final int MAX_POOL = 5;
        private Vector thePool = new Vector();

        private DocumentBuilderPool() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
            Vector vector = this.thePool;
            synchronized (vector) {
                if (this.thePool.size() != 0) {
                    DocumentBuilder documentBuilder = (DocumentBuilder)this.thePool.remove(0);
                    return documentBuilder;
                }
            }
            return SOAPFormatter.this.dbf.newDocumentBuilder();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseDocumentBuilder(DocumentBuilder documentBuilder) {
            Vector vector = this.thePool;
            synchronized (vector) {
                if (this.thePool.size() < 5) {
                    this.thePool.add(documentBuilder);
                    return;
                }
            }
        }
    }
}

