/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore.formatters.soap;

import com.jnbridge.jnbcore.BoxedValueFactory;
import com.jnbridge.jnbcore.ClassRegistry;
import com.jnbridge.jnbcore.DotNetArgTypeConverter;
import com.jnbridge.jnbcore.DotNetMappedClass;
import com.jnbridge.jnbcore.DotNetObjectBase;
import com.jnbridge.jnbcore.DotNetWrapper;
import com.jnbridge.jnbcore.JNBArrayWrapper;
import com.jnbridge.jnbcore.JNBDotNetCallback;
import com.jnbridge.jnbcore.JNBDotNetObjID;
import com.jnbridge.jnbcore.JNBDotNetValueObject;
import com.jnbridge.jnbcore.JNBObjID;
import com.jnbridge.jnbcore.JNBValueObject;
import com.jnbridge.jnbcore.JNBVoidResult;
import com.jnbridge.jnbcore.MappedClass;
import com.jnbridge.jnbcore.MessageKeys;
import com.jnbridge.jnbcore.Messages;
import com.jnbridge.jnbcore.NullValue;
import com.jnbridge.jnbcore.ObjectRegistry;
import com.jnbridge.jnbcore.formatters.soap.MutableInteger;
import com.jnbridge.jnbcore.formatters.soap.SOAPException;
import com.jnbridge.jnbcore.formatters.soap.SOAPNamespaceConstants;
import com.jnbridge.jnbcore.formatters.soap.SOAPTypeNamespaceRegistry;
import com.jnbridge.jnbcore.java50.BigDecimalHelper;
import com.jnbridge.jnbcore.java50.EnumInfo;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public final class SOAPSerializer
implements SOAPNamespaceConstants,
MessageKeys {
    Document doc;
    Element body;
    private static Hashtable classIDMap = new Hashtable();
    private static final int NULL_ID = -1;
    private static final int ARRAY_ID = -2;
    private static final int OTHER_ID = -3;
    private static final Class JNBVOIDRESULT_CLASS = JNBVoidResult.class;
    private static final int JNBVOIDRESULT_ID = 0;
    private static final Class JNBOBJID_CLASS = JNBObjID.class;
    private static final int JNBOBJID_ID = 1;
    private static final Class INTEGER_CLASS = Integer.class;
    private static final int INTEGER_ID = 2;
    private static final Class SHORT_CLASS = Short.class;
    private static final int SHORT_ID = 3;
    private static final Class LONG_CLASS = Long.class;
    private static final int LONG_ID = 4;
    private static final Class FLOAT_CLASS = Float.class;
    private static final int FLOAT_ID = 5;
    private static final Class DOUBLE_CLASS = Double.class;
    private static final int DOUBLE_ID = 6;
    private static final Class CHAR_CLASS = Character.class;
    private static final int CHAR_ID = 7;
    private static final Class BYTE_CLASS = Byte.class;
    private static final int BYTE_ID = 8;
    private static final Class BOOL_CLASS = Boolean.class;
    private static final int BOOL_ID = 9;
    private static final Class STRING_CLASS = String.class;
    private static final int STRING_ID = 10;
    private static final Class JNBVALUEOBJ_CLASS = JNBValueObject.class;
    private static final int JNBVALUEOBJ_ID = 11;
    private static final Class JNBDOTNETOBJID_CLASS = JNBDotNetObjID.class;
    private static final int JNBDOTNETOBJID_ID = 12;
    private static final Class JNBDOTNETCALLBACK_CLASS = JNBDotNetCallback.class;
    private static final int JNBDOTNETCALLBACK_ID = 13;
    private static final Class JNBDOTNETVALUEOBJ_CLASS = JNBDotNetValueObject.class;
    private static final int JNBDOTNETVALUEOBJ_ID = 14;
    private static final int BOXEDUINT_ID = 15;
    private static final int BOXEDUSHORT_ID = 16;
    private static final int BOXEDULONG_ID = 17;
    private static final int BOXEDUBYTE_ID = 18;

    public SOAPSerializer(Document document, Element element) {
        this.doc = document;
        this.body = element;
    }

    public void serialize(int n, Element element, MutableInteger mutableInteger) {
        Text text = this.doc.createTextNode(String.valueOf(n));
        element.appendChild(text);
    }

    public void serialize(short s, Element element, MutableInteger mutableInteger) {
        Text text = this.doc.createTextNode(String.valueOf(s));
        element.appendChild(text);
    }

    public void serialize(long l, Element element, MutableInteger mutableInteger) {
        Text text = this.doc.createTextNode(String.valueOf(l));
        element.appendChild(text);
    }

    public void serialize(float f, Element element, MutableInteger mutableInteger) {
        Text text = this.doc.createTextNode(String.valueOf(f));
        element.appendChild(text);
    }

    public void serialize(double d, Element element, MutableInteger mutableInteger) {
        Text text = this.doc.createTextNode(String.valueOf(d));
        element.appendChild(text);
    }

    public void serialize(char c, Element element, MutableInteger mutableInteger) {
        int n = c & 0xFFFF;
        Text text = this.doc.createTextNode(String.valueOf(n));
        element.appendChild(text);
    }

    public void serialize(byte by, Element element, MutableInteger mutableInteger) {
        Text text = this.doc.createTextNode(String.valueOf(by));
        element.appendChild(text);
    }

    public void serialize(boolean bl, Element element, MutableInteger mutableInteger) {
        Text text = this.doc.createTextNode(String.valueOf(bl));
        element.appendChild(text);
    }

    public void serialize(Object object, Element element, MutableInteger mutableInteger) throws SOAPException {
        this.serialize(object, element, mutableInteger, false);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void serialize(Object object, Element element, MutableInteger mutableInteger, boolean bl) throws SOAPException {
        boolean bl2 = false;
        String string = null;
        if (object != null && object instanceof JNBArrayWrapper) {
            JNBArrayWrapper jNBArrayWrapper = (JNBArrayWrapper)object;
            object = jNBArrayWrapper.getArray();
            bl2 = true;
            string = jNBArrayWrapper.getArrayTypeStr();
        }
        switch (this.getClassID(object)) {
            case 7: {
                int n = ((Character)object).charValue() & 0xFFFF;
                Text text = this.doc.createTextNode(String.valueOf(n));
                element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "xsd:unsignedShort");
                element.appendChild(text);
                return;
            }
            case 2: {
                element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "xsd:int");
                Text text = this.doc.createTextNode(object.toString());
                element.appendChild(text);
                return;
            }
            case 15: {
                element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "xsd:unsignedInt");
                Text text = this.doc.createTextNode(BoxedValueFactory.unbox(object).toString());
                element.appendChild(text);
                return;
            }
            case 3: {
                element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "xsd:short");
                Text text = this.doc.createTextNode(object.toString());
                element.appendChild(text);
                return;
            }
            case 16: {
                element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "xsd:unsignedShort");
                Text text = this.doc.createTextNode(BoxedValueFactory.unbox(object).toString());
                element.appendChild(text);
                return;
            }
            case 4: {
                element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "xsd:long");
                Text text = this.doc.createTextNode(object.toString());
                element.appendChild(text);
                return;
            }
            case 17: {
                element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "xsd:unsignedLong");
                String string2 = BoxedValueFactory.unbox(object).toString();
                int n = string2.indexOf(".");
                string2 = string2.substring(0, n);
                Text text = this.doc.createTextNode(string2);
                element.appendChild(text);
                return;
            }
            case 5: {
                element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "xsd:float");
                Text text = this.doc.createTextNode(object.toString());
                element.appendChild(text);
                return;
            }
            case 6: {
                element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "xsd:double");
                Text text = this.doc.createTextNode(object.toString());
                element.appendChild(text);
                return;
            }
            case 8: {
                element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "xsd:byte");
                Text text = this.doc.createTextNode(object.toString());
                element.appendChild(text);
                return;
            }
            case 18: {
                element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "xsd:unsignedByte");
                Text text = this.doc.createTextNode(BoxedValueFactory.unbox(object).toString());
                element.appendChild(text);
                return;
            }
            case 9: {
                element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "xsd:boolean");
                Text text = this.doc.createTextNode(object.toString());
                element.appendChild(text);
                return;
            }
            case 0: {
                return;
            }
            case 13: {
                int n = mutableInteger.getAndIncrement();
                element.setAttribute("href", "#ref-" + n);
                Element element2 = this.doc.createElementNS("http://schemas.microsoft.com/clr/nsassem/com.jnbridge.jnbcore/JNBShare", "a1:JNBDotNetCallback");
                element2.setAttribute("id", "ref-" + n);
                this.body.appendChild(element2);
                Element element3 = this.doc.createElement("callbackID");
                element2.appendChild(element3);
                Text text = this.doc.createTextNode(String.valueOf(((JNBDotNetCallback)object).callbackID));
                element3.appendChild(text);
                Element element4 = this.doc.createElement("theInterface");
                element2.appendChild(element4);
                Text text2 = this.doc.createTextNode(String.valueOf(((JNBDotNetCallback)object).theInterface));
                element4.appendChild(text2);
                Element element5 = this.doc.createElement("theClassName");
                element2.appendChild(element5);
                Text text3 = this.doc.createTextNode(String.valueOf(((JNBDotNetCallback)object).theClassName));
                element5.appendChild(text3);
                Element element6 = this.doc.createElement("isSync");
                element2.appendChild(element6);
                Text text4 = this.doc.createTextNode(String.valueOf(((JNBDotNetCallback)object).isSync));
                element6.appendChild(text4);
                return;
            }
            case -3: {
                Object object2 = ObjectRegistry.registerObject(object, true);
                if (object2 != null && EnumInfo.isEnum(object2.getClass())) {
                    String string3 = SOAPTypeNamespaceRegistry.lookup(object2.getClass());
                    if (string3 != null && !string3.equals("")) {
                        element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "a4:" + DotNetArgTypeConverter.convertToDotNet(object2.getClass().getName()));
                        element.setAttribute("xmlns:a4", string3);
                        Text text = this.doc.createTextNode(EnumInfo.name(object2));
                        element.appendChild(text);
                        return;
                    }
                    int n = mutableInteger.getAndIncrement();
                    element.setAttribute("href", "#ref-" + n);
                    Element element7 = this.doc.createElementNS("http://schemas.microsoft.com/clr/nsassem/com.jnbridge.jnbcore/JNBShare", "a1:JNBDotNetEnum");
                    element7.setAttribute("id", "ref-" + n);
                    this.body.appendChild(element7);
                    Element element8 = this.doc.createElement("enumClassName");
                    element7.appendChild(element8);
                    Text text = this.doc.createTextNode(object2.getClass().getName());
                    element8.appendChild(text);
                    Element element9 = this.doc.createElement("enumValue");
                    element7.appendChild(element9);
                    Text text5 = this.doc.createTextNode(object2.toString());
                    element9.appendChild(text5);
                    return;
                }
                this.serialize(object2, element, mutableInteger);
                return;
            }
            case 12: {
                int n = mutableInteger.getAndIncrement();
                element.setAttribute("href", "#ref-" + n);
                Element element10 = this.doc.createElementNS("http://schemas.microsoft.com/clr/nsassem/com.jnbridge.jnbcore/JNBShare", "a1:JNBDotNetObjID");
                element10.setAttribute("id", "ref-" + n);
                this.body.appendChild(element10);
                Element element11 = this.doc.createElement("dotNetObjID");
                element10.appendChild(element11);
                Text text = this.doc.createTextNode(String.valueOf(((JNBDotNetObjID)object).getObjID()));
                element11.appendChild(text);
                Element element12 = this.doc.createElement("actualClassName");
                element10.appendChild(element12);
                String string4 = ((JNBDotNetObjID)object).getClassName();
                if (string4 == null) {
                    string4 = "null";
                }
                Text text6 = this.doc.createTextNode(string4);
                element12.appendChild(text6);
                return;
            }
            case 1: {
                int n = mutableInteger.getAndIncrement();
                element.setAttribute("href", "#ref-" + n);
                Element element13 = this.doc.createElementNS("http://schemas.microsoft.com/clr/nsassem/com.jnbridge.jnbcore/JNBShare", "a1:JNBObjID");
                element13.setAttribute("id", "ref-" + n);
                this.body.appendChild(element13);
                Element element14 = this.doc.createElement("javaObjID");
                element13.appendChild(element14);
                Text text = this.doc.createTextNode(String.valueOf(((JNBObjID)object).getObjID()));
                element14.appendChild(text);
                Element element15 = this.doc.createElement("actualClassName");
                element13.appendChild(element15);
                String string5 = ((JNBObjID)object).getClassName();
                if (string5 == null) {
                    string5 = "null";
                }
                Text text7 = this.doc.createTextNode(string5);
                element15.appendChild(text7);
                return;
            }
            case 11: {
                JNBValueObject jNBValueObject = (JNBValueObject)object;
                int n = mutableInteger.getAndIncrement();
                element.setAttribute("href", "#ref-" + n);
                Element element16 = this.doc.createElementNS("http://schemas.microsoft.com/clr/nsassem/com.jnbridge.jnbcore/JNBShare", "a1:JNBValueObject");
                element16.setAttribute("id", "ref-" + n);
                this.body.appendChild(element16);
                Element element17 = this.doc.createElement("coreObjectClassName");
                element16.appendChild(element17);
                String string6 = jNBValueObject.getObject().getClass().getName();
                Text text = this.doc.createTextNode(string6);
                element17.appendChild(text);
                Class<?> clazz = jNBValueObject.getObject().getClass();
                if (MappedClass.isMapped(clazz)) {
                    short s = MappedClass.getMappingScheme(string6);
                    Element element18 = this.doc.createElement("scheme");
                    element16.appendChild(element18);
                    Text text8 = this.doc.createTextNode(String.valueOf(s));
                    element18.appendChild(text8);
                    switch (s) {
                        case 3: {
                            Date date = (Date)jNBValueObject.getObject();
                            int n2 = 1;
                            long l = date.getTime();
                            long l2 = 10000L * l + 621355968000000000L;
                            Element element19 = this.doc.createElement("numEntries");
                            element16.appendChild(element19);
                            Text text9 = this.doc.createTextNode(String.valueOf(n2));
                            element19.appendChild(text9);
                            Element element20 = this.doc.createElement("dotNetTicks");
                            element16.appendChild(element20);
                            Text text10 = this.doc.createTextNode(String.valueOf(l2));
                            element20.appendChild(text10);
                            return;
                        }
                        case 4: {
                            Object object3 = jNBValueObject.getObject();
                            int n3 = 1;
                            String string7 = object3.toString();
                            Element element21 = this.doc.createElement("numEntries");
                            element16.appendChild(element21);
                            Text text11 = this.doc.createTextNode(String.valueOf(n3));
                            element21.appendChild(text11);
                            Element element22 = this.doc.createElement("decimalString");
                            element16.appendChild(element22);
                            Text text12 = this.doc.createTextNode(string7);
                            element22.appendChild(text12);
                            return;
                        }
                        case 1: {
                            Collection collection = (Collection)jNBValueObject.getObject();
                            int n4 = collection.size();
                            Element element23 = this.doc.createElement("numEntries");
                            element16.appendChild(element23);
                            Text text13 = this.doc.createTextNode(String.valueOf(n4));
                            element23.appendChild(text13);
                            int n5 = 1;
                            for (Object e : collection) {
                                void var71_168;
                                Element element24 = this.doc.createElement("value" + n5);
                                element16.appendChild(element24);
                                if (e != null && !e.getClass().isPrimitive()) {
                                    Object object4 = ObjectRegistry.registerObject(e, true);
                                } else if (e != null) {
                                    Element element25 = this.doc.createElement("valueType" + n5);
                                    element16.appendChild(element25);
                                    Text text14 = this.doc.createTextNode(object.getClass().getName());
                                    element25.appendChild(text14);
                                }
                                this.serialize(var71_168, element24, mutableInteger);
                                ++n5;
                            }
                            return;
                        }
                        case 2: {
                            Map map = (Map)jNBValueObject.getObject();
                            int n6 = map.size();
                            Element element26 = this.doc.createElement("numEntries");
                            element16.appendChild(element26);
                            Text text15 = this.doc.createTextNode(String.valueOf(n6));
                            element26.appendChild(text15);
                            int n7 = 1;
                            Set set = map.entrySet();
                            for (Map.Entry entry : set) {
                                void var74_180;
                                Object object5;
                                Object k = entry.getKey();
                                Element element27 = this.doc.createElement("key" + n7);
                                element16.appendChild(element27);
                                if (k != null && !k.getClass().isPrimitive()) {
                                    Object object6 = ObjectRegistry.registerObject(k, true);
                                } else if (k != null) {
                                    object5 = this.doc.createElement("keyType" + n7);
                                    element16.appendChild((Node)object5);
                                    Text text16 = this.doc.createTextNode(object.getClass().getName());
                                    object5.appendChild(text16);
                                }
                                this.serialize(var74_180, element27, mutableInteger);
                                object5 = entry.getValue();
                                Element element28 = this.doc.createElement("value" + n7);
                                element16.appendChild(element28);
                                if (object5 != null && !object5.getClass().isPrimitive()) {
                                    object5 = ObjectRegistry.registerObject(object5, true);
                                } else if (object5 != null) {
                                    Element element29 = this.doc.createElement("valueType" + n7);
                                    element16.appendChild(element29);
                                    Text text17 = this.doc.createTextNode(object.getClass().getName());
                                    element29.appendChild(text17);
                                }
                                this.serialize(object5, element28, mutableInteger);
                                ++n7;
                            }
                            return;
                        }
                        default: {
                            throw new SOAPException("invalid mapped collection type");
                        }
                    }
                }
                Element element30 = this.doc.createElement("isJavaBean");
                element16.appendChild(element30);
                Text text18 = jNBValueObject.isJavaBean() ? this.doc.createTextNode("true") : this.doc.createTextNode("false");
                element30.appendChild(text18);
                HashMap hashMap = jNBValueObject.getFields(true);
                Element element31 = this.doc.createElement("numFields");
                element16.appendChild(element31);
                Text text19 = this.doc.createTextNode(String.valueOf(hashMap.size()));
                element31.appendChild(text19);
                Set set = hashMap.entrySet();
                int n8 = 1;
                for (Map.Entry entry : set) {
                    String string8 = (String)entry.getKey();
                    Object v = entry.getValue();
                    Element element32 = this.doc.createElement("name" + n8);
                    element16.appendChild(element32);
                    Text text20 = this.doc.createTextNode(string8);
                    element32.appendChild(text20);
                    Element element33 = this.doc.createElement("value" + n8);
                    element16.appendChild(element33);
                    this.serialize(v, element33, mutableInteger);
                    ++n8;
                }
                return;
            }
            case 14: {
                JNBDotNetValueObject jNBDotNetValueObject = (JNBDotNetValueObject)object;
                int n = mutableInteger.getAndIncrement();
                element.setAttribute("href", "#ref-" + n);
                Element element34 = this.doc.createElementNS("http://schemas.microsoft.com/clr/nsassem/com.jnbridge.jnbcore/JNBShare", "a1:JNBDotNetValueObject");
                element34.setAttribute("id", "ref-" + n);
                this.body.appendChild(element34);
                Element element35 = this.doc.createElement("coreObjectClassName");
                element34.appendChild(element35);
                String string9 = jNBDotNetValueObject.getObject().getClass().getName();
                Text text = this.doc.createTextNode(string9);
                element35.appendChild(text);
                if (DotNetMappedClass.isMapped(string9)) {
                    short s = DotNetMappedClass.getMappingScheme(string9);
                    Element element36 = this.doc.createElement("scheme");
                    element34.appendChild(element36);
                    Text text21 = this.doc.createTextNode(String.valueOf(s));
                    element36.appendChild(text21);
                    try {
                        switch (s) {
                            case 3: {
                                Object object7 = jNBDotNetValueObject.getObject();
                                Class<?> clazz = object7.getClass();
                                Field field = clazz.getField("NativeImpl");
                                Date date = (Date)field.get(object7);
                                long l = date.getTime();
                                long l3 = 10000L * l + 621355968000000000L;
                                int n9 = 1;
                                Element element37 = this.doc.createElement("numEntries");
                                element34.appendChild(element37);
                                Text text22 = this.doc.createTextNode(String.valueOf(n9));
                                element37.appendChild(text22);
                                Element element38 = this.doc.createElement("dotNetTicks");
                                element34.appendChild(element38);
                                Text text23 = this.doc.createTextNode(String.valueOf(l3));
                                element38.appendChild(text23);
                                return;
                            }
                            case 4: {
                                Object object8 = jNBDotNetValueObject.getObject();
                                Class<?> clazz = object8.getClass();
                                Field field = clazz.getField("NativeImpl");
                                Object object9 = field.get(object8);
                                String string10 = object9 instanceof BigDecimal ? BigDecimalHelper.toString(object9) : object9.toString();
                                int n10 = 1;
                                Element element39 = this.doc.createElement("numEntries");
                                element34.appendChild(element39);
                                Text text24 = this.doc.createTextNode(String.valueOf(n10));
                                element39.appendChild(text24);
                                Element element40 = this.doc.createElement("decimalString");
                                element34.appendChild(element40);
                                Text text25 = this.doc.createTextNode(string10);
                                element40.appendChild(text25);
                                return;
                            }
                            case 1: {
                                Object object10 = jNBDotNetValueObject.getObject();
                                Class<?> clazz = object10.getClass();
                                Field field = clazz.getField("NativeImpl");
                                Collection collection = (Collection)field.get(object10);
                                int n11 = collection.size();
                                Element element41 = this.doc.createElement("numEntries");
                                element34.appendChild(element41);
                                Text text26 = this.doc.createTextNode(String.valueOf(n11));
                                element41.appendChild(text26);
                                int n12 = 1;
                                for (Object e : collection) {
                                    void var75_186;
                                    void var77_196;
                                    Element element42 = this.doc.createElement("value" + n12);
                                    element34.appendChild(element42);
                                    Object var77_197 = null;
                                    if (e != null) {
                                        Class<?> clazz2 = e.getClass();
                                    }
                                    if (e != null && !var77_196.isPrimitive() && var77_196 != Character.class) {
                                        Object object11 = DotNetObjectBase.convertArgFromJava(e.getClass().getName(), e);
                                    } else if (e != null) {
                                        Element element43 = this.doc.createElement("valueType" + n12);
                                        element34.appendChild(element43);
                                        String string11 = null;
                                        string11 = var77_196 == Character.class ? "char" : var77_196.getName();
                                        Text text27 = this.doc.createTextNode(string11);
                                        element43.appendChild(text27);
                                    }
                                    this.serialize(var75_186, element42, mutableInteger);
                                    ++n12;
                                }
                                return;
                            }
                            case 2: {
                                Object object12 = jNBDotNetValueObject.getObject();
                                Class<?> clazz = object12.getClass();
                                Field field = clazz.getField("NativeImpl");
                                Map map = (Map)field.get(object12);
                                int n13 = map.size();
                                Element element44 = this.doc.createElement("numEntries");
                                element34.appendChild(element44);
                                Text text28 = this.doc.createTextNode(String.valueOf(n13));
                                element44.appendChild(text28);
                                int n14 = 1;
                                Set set = map.entrySet();
                                for (Map.Entry entry : set) {
                                    void var78_202;
                                    Object object13;
                                    Object object14;
                                    Object k = entry.getKey();
                                    Element element45 = this.doc.createElement("key" + n14);
                                    element34.appendChild(element45);
                                    if (k != null && !k.getClass().isPrimitive()) {
                                        Object object15 = DotNetObjectBase.convertArgFromJava(k.getClass().getName(), k);
                                    } else if (k != null) {
                                        object14 = this.doc.createElement("keyType" + n14);
                                        element34.appendChild((Node)object14);
                                        object13 = this.doc.createTextNode(object.getClass().getName());
                                        object14.appendChild((Node)object13);
                                    }
                                    this.serialize(var78_202, element45, mutableInteger);
                                    object14 = entry.getValue();
                                    object13 = object14.getClass();
                                    if (object14 instanceof NullValue) {
                                        object14 = null;
                                    }
                                    Element element46 = this.doc.createElement("value" + n14);
                                    element34.appendChild(element46);
                                    if (object14 != null && !((Class)object13).isPrimitive() && object13 != Character.class) {
                                        object14 = DotNetObjectBase.convertArgFromJava(object14.getClass().getName(), object14);
                                    } else if (object14 != null) {
                                        Element element47 = this.doc.createElement("valueType" + n14);
                                        element34.appendChild(element47);
                                        String string12 = null;
                                        string12 = object13 == Character.class ? "char" : ((Class)object13).getName();
                                        Text text29 = this.doc.createTextNode(string12);
                                        element47.appendChild(text29);
                                    }
                                    this.serialize(object14, element46, mutableInteger);
                                    ++n14;
                                }
                                return;
                            }
                            default: {
                                throw new SOAPException(Messages.getString("SOAPSERIALIZER_SERIALIZE_1"));
                            }
                        }
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        throw new SOAPException("NoSuchFieldException: " + noSuchFieldException.getMessage());
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new SOAPException("IllegalAccessException: " + illegalAccessException.getMessage());
                    }
                }
                HashMap hashMap = jNBDotNetValueObject.getFields();
                Element element48 = this.doc.createElement("numFields");
                element34.appendChild(element48);
                Text text30 = this.doc.createTextNode(String.valueOf(hashMap.size()));
                element48.appendChild(text30);
                Set set = hashMap.entrySet();
                int n15 = 1;
                for (Map.Entry entry : set) {
                    String string13 = (String)entry.getKey();
                    Object v = entry.getValue();
                    Element element49 = this.doc.createElement("name" + n15);
                    element34.appendChild(element49);
                    Text text31 = this.doc.createTextNode(string13);
                    element49.appendChild(text31);
                    Element element50 = this.doc.createElement("value" + n15);
                    element34.appendChild(element50);
                    this.serialize(v, element50, mutableInteger);
                    ++n15;
                }
                return;
            }
            case -1: {
                element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:null", "1");
                return;
            }
            case 10: {
                element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "SOAP-ENC:string");
                Text text = this.doc.createTextNode((String)object);
                element.appendChild(text);
                return;
            }
            case -2: {
                Object object16;
                Element element51;
                int n;
                Element element52 = null;
                if (!bl) {
                    n = mutableInteger.getAndIncrement();
                    element.setAttribute("href", "#ref-" + n);
                    element51 = this.doc.createElementNS("http://schemas.microsoft.com/clr/nsassem/com.jnbridge.jnbcore/JNBShare", "a1:JNBArrayWrapper");
                    element51.setAttribute("id", "ref-" + n);
                    this.body.appendChild(element51);
                    Element element53 = this.doc.createElement("m_arrayName");
                    element51.appendChild(element53);
                    object16 = null;
                    object16 = bl2 ? this.doc.createTextNode(DotNetArgTypeConverter.convertToDotNetEquivType(string)) : this.doc.createTextNode(DotNetArgTypeConverter.convertToDotNetEquivType(object.getClass().getName()));
                    element53.appendChild((Node)object16);
                    element52 = this.doc.createElement("m_array");
                    element51.appendChild(element52);
                }
                element51 = this.doc.createElementNS("http://schemas.xmlsoap.org/soap/encoding/", "SOAP-ENC:Array");
                int n16 = Array.getLength(object);
                object16 = this.getArrayComponentType(object);
                if (((String)object16).startsWith("a4:")) {
                    String string14 = SOAPTypeNamespaceRegistry.lookup(object.getClass().getComponentType());
                    if (string14 != null && !string14.equals("")) {
                        element51.setAttribute("xmlns:a4", string14);
                    } else {
                        int n17 = ((String)object16).indexOf("a4:");
                        int n18 = ((String)object16).indexOf("[");
                        String string15 = n17 > 0 ? ((String)object16).substring(0, n17 - 1) : "";
                        String string16 = n18 > 0 ? ((String)object16).substring(n18) : "";
                        object16 = string15 + "a1:JNBDotNetEnum" + string16;
                    }
                }
                n = mutableInteger.getAndIncrement();
                if (!bl) {
                    element52.setAttribute("href", "#ref-" + n);
                } else {
                    element.setAttribute("href", "#ref-" + n);
                }
                this.body.appendChild(element51);
                element51.setAttribute("id", "ref-" + n);
                for (int i = 0; i < n16; ++i) {
                    Element element54 = this.doc.createElement("item");
                    element51.appendChild(element54);
                    Object object17 = Array.get(object, i);
                    this.serialize(object17, element54, mutableInteger);
                }
                if (((String)object16).endsWith("[]")) {
                    object16 = "xsd:anyType";
                }
                element51.setAttributeNS("http://schemas.xmlsoap.org/soap/encoding/", "SOAP-ENC:arrayType", (String)object16 + '[' + n16 + ']');
                return;
            }
            default: {
                if (!(object instanceof DotNetWrapper)) throw new SOAPException(Messages.getString("SOAPSERIALIZER_SERIALIZE_2"));
                Object object18 = ((DotNetWrapper)object).getWrappedValue();
                this.serialize(object18, element, mutableInteger);
                return;
            }
        }
    }

    private String getArrayComponentType(Object object) throws SOAPException {
        String string;
        String string2 = object.getClass().getName().substring(1);
        Class<?> clazz = object.getClass();
        Class<?> clazz2 = clazz.getComponentType();
        while (clazz2.isArray()) {
            clazz2 = clazz2.getComponentType();
        }
        int n = string2.lastIndexOf(91) + 1;
        String string3 = string2.substring(n);
        String string4 = string = this.convertToSoapClass(string3, ClassRegistry.isByValueClass(clazz), EnumInfo.isEnum(clazz2));
        for (int i = 0; i < n; ++i) {
            string4 = string4 + "[]";
        }
        return string4;
    }

    private String convertToSoapClass(String string, boolean bl, boolean bl2) throws SOAPException {
        switch (string.charAt(0)) {
            case 'Z': {
                return "xsd:boolean";
            }
            case 'B': {
                return "xsd:byte";
            }
            case 'C': {
                return "xsd:unsignedShort";
            }
            case 'S': {
                return "xsd:short";
            }
            case 'I': {
                return "xsd:int";
            }
            case 'J': {
                return "xsd:long";
            }
            case 'F': {
                return "xsd:float";
            }
            case 'D': {
                return "xsd:double";
            }
            case 'L': {
                if (string.equals("Ljava.lang.String;")) {
                    return "xsd:string";
                }
                if (string.equals("Ljava.lang.Integer;")) {
                    return "xsd:int";
                }
                if (string.equals("Ljava.lang.Short;")) {
                    return "xsd:short";
                }
                if (string.equals("Ljava.lang.Long;")) {
                    return "xsd:long";
                }
                if (string.equals("Ljava.lang.Float;")) {
                    return "xsd:float";
                }
                if (string.equals("Ljava.lang.Double;")) {
                    return "xsd:double";
                }
                if (string.equals("Ljava.lang.Character;")) {
                    return "a2:Char";
                }
                if (string.equals("Ljava.lang.Byte;")) {
                    return "xsd:byte";
                }
                if (string.equals("Ljava.lang.Boolean;")) {
                    return "xsd:boolean";
                }
                if (string.equals("Ljava.lang.Object;")) {
                    return "xsd:anyType";
                }
                if (bl) {
                    return "a2:com.jnbridge.jnbcore.JNBValueObject";
                }
                if (bl2) {
                    String string2 = string.substring(1, string.length() - 1);
                    return "a4:" + DotNetArgTypeConverter.convertToDotNet(string2);
                }
                if (string.equals("Lcom.jnbridge.jnbcore.JNBDotNetObjID;")) {
                    return "a1:JNBDotNetObjID";
                }
                return "a1:JNBObjID";
            }
        }
        throw new SOAPException(Messages.getString("SOAPSERIALIZER_CONVERTTOSOAPCLASS_1"));
    }

    private int getClassID(Object object) {
        if (object == null) {
            return -1;
        }
        if (object.getClass().isArray()) {
            return -2;
        }
        Integer n = (Integer)classIDMap.get(object.getClass());
        if (n == null && (n = (Integer)classIDMap.get(object.getClass().getName())) == null) {
            return -3;
        }
        return n;
    }

    static {
        classIDMap.put(JNBVOIDRESULT_CLASS, new Integer(0));
        classIDMap.put(JNBOBJID_CLASS, new Integer(1));
        classIDMap.put(INTEGER_CLASS, new Integer(2));
        classIDMap.put(SHORT_CLASS, new Integer(3));
        classIDMap.put(LONG_CLASS, new Integer(4));
        classIDMap.put(FLOAT_CLASS, new Integer(5));
        classIDMap.put(DOUBLE_CLASS, new Integer(6));
        classIDMap.put(CHAR_CLASS, new Integer(7));
        classIDMap.put(BYTE_CLASS, new Integer(8));
        classIDMap.put(BOOL_CLASS, new Integer(9));
        classIDMap.put(STRING_CLASS, new Integer(10));
        classIDMap.put(JNBVALUEOBJ_CLASS, new Integer(11));
        classIDMap.put(JNBDOTNETOBJID_CLASS, new Integer(12));
        classIDMap.put(JNBDOTNETCALLBACK_CLASS, new Integer(13));
        classIDMap.put(JNBDOTNETVALUEOBJ_CLASS, new Integer(14));
        classIDMap.put("System.BoxedUInt", new Integer(15));
        classIDMap.put("System.BoxedUShort", new Integer(16));
        classIDMap.put("System.BoxedULong", new Integer(17));
        classIDMap.put("System.BoxedByte", new Integer(18));
    }
}

