/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore.java50;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class EnumInfo {
    private static Method m_isEnum = null;
    private static Method m_getEnumConstants = null;
    private static Method m_valueOf = null;
    private static Method m_name = null;
    private static final Object[] emptyParams = new Object[0];
    private static final Class[] emptyClassParams = new Class[0];
    private static final Class[] valueOfParams = new Class[]{Class.class, String.class};
    private static Class enumClass = null;
    private static final String[] emptyStrings;

    private EnumInfo() {
    }

    public static boolean isEnum(Class clazz) {
        try {
            if (m_isEnum == null) {
                return false;
            }
            Boolean bl = (Boolean)m_isEnum.invoke((Object)clazz, emptyParams);
            return bl;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
    }

    public static Class getEnumClass() {
        return enumClass;
    }

    public static String[] getEnumNames(Class clazz) {
        if (!EnumInfo.isEnum(clazz)) {
            return emptyStrings;
        }
        try {
            if (m_getEnumConstants == null) {
                return emptyStrings;
            }
            Object[] objectArray = (Object[])m_getEnumConstants.invoke((Object)clazz, emptyParams);
            if (objectArray == null) {
                return emptyStrings;
            }
            int n = objectArray.length;
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = (String)m_name.invoke(objectArray[i], emptyParams);
            }
            return stringArray;
        }
        catch (IllegalAccessException illegalAccessException) {
            return emptyStrings;
        }
        catch (InvocationTargetException invocationTargetException) {
            return emptyStrings;
        }
    }

    public static String name(Object object) {
        if (object == null || !EnumInfo.isEnum(object.getClass())) {
            return null;
        }
        try {
            String string = (String)m_name.invoke(object, emptyParams);
            return string;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
    }

    public static Object getEnum(String string, String string2) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string, false, Thread.currentThread().getContextClassLoader());
            if (!EnumInfo.isEnum(clazz)) {
                return null;
            }
            return EnumInfo.getEnum(clazz, string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                clazz = Class.forName(string, false, EnumInfo.class.getClassLoader());
                if (!EnumInfo.isEnum(clazz)) {
                    return null;
                }
                return EnumInfo.getEnum(clazz, string2);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                return null;
            }
        }
    }

    public static Object getEnum(Class clazz, String string) {
        try {
            Object object = m_valueOf.invoke(null, clazz, string);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
    }

    public static Object getEnumArray(int n) {
        if (enumClass != null) {
            return Array.newInstance(enumClass, n);
        }
        return null;
    }

    public static void main(String[] stringArray) {
        if (EnumInfo.isEnum(Object.class)) {
            System.out.println("failed test 1");
        } else {
            System.out.println("passed test 1");
        }
        String[] stringArray2 = EnumInfo.getEnumNames(Object.class);
        if (stringArray2 == null) {
            System.out.println("passed test 3");
        } else {
            System.out.println("failed test 3");
        }
    }

    static {
        try {
            m_isEnum = Class.class.getMethod("isEnum", emptyClassParams);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            m_getEnumConstants = Class.class.getMethod("getEnumConstants", emptyClassParams);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            enumClass = Class.forName("java.lang.Enum");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            if (enumClass != null) {
                m_valueOf = enumClass.getMethod("valueOf", valueOfParams);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            if (enumClass != null) {
                m_name = enumClass.getMethod("name", emptyClassParams);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        emptyStrings = new String[0];
    }
}

