/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore.licensing;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;

public class CloudDetector {
    private static CloudDetector instance = null;
    private boolean onAzure = this.isOnAzure();
    private boolean onEC2 = this.isOnEC2();
    private boolean inCloud = false;

    private CloudDetector() {
    }

    public static CloudDetector getInstance() {
        if (instance == null) {
            instance = new CloudDetector();
        }
        return instance;
    }

    public boolean OnAzure() {
        return this.onAzure;
    }

    public boolean OnEC2() {
        return this.onEC2;
    }

    public boolean InCloud() {
        return this.OnAzure() || this.OnEC2();
    }

    private boolean isOnAzure() {
        boolean bl = false;
        try {
            if (InetAddress.getLocalHost().getCanonicalHostName().startsWith("RD")) {
                Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                block6: while (enumeration.hasMoreElements()) {
                    try {
                        NetworkInterface networkInterface = enumeration.nextElement();
                        Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                        while (enumeration2.hasMoreElements()) {
                            try {
                                InetAddress inetAddress = enumeration2.nextElement();
                                String string = inetAddress.getCanonicalHostName();
                                if (!string.toLowerCase().endsWith("reddog.microsoft.com")) continue;
                                bl = true;
                                continue block6;
                            }
                            catch (Exception exception) {
                            }
                        }
                    }
                    catch (Exception exception) {
                    }
                }
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    private boolean isOnEC2() {
        boolean bl = false;
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            block6: while (enumeration.hasMoreElements()) {
                try {
                    NetworkInterface networkInterface = enumeration.nextElement();
                    Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                    while (enumeration2.hasMoreElements()) {
                        try {
                            InetAddress inetAddress = enumeration2.nextElement();
                            String string = inetAddress.getLocalHost().getCanonicalHostName();
                            if (!string.toLowerCase().endsWith("ec2.internal")) continue;
                            bl = true;
                            continue block6;
                        }
                        catch (Exception exception) {
                        }
                    }
                }
                catch (Exception exception) {
                }
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        CloudDetector cloudDetector = CloudDetector.getInstance();
        System.out.println("isOnAzure = " + cloudDetector.isOnAzure());
        System.out.println("isOnEC2 = " + cloudDetector.isOnEC2());
    }
}

