/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore.server.binary;

import com.jnbridge.jnbcore.CallArgs;
import com.jnbridge.jnbcore.DebugConstants;
import com.jnbridge.jnbcore.InternalException;
import com.jnbridge.jnbcore.JNBDispatcher;
import com.jnbridge.jnbcore.JNBDispatcherConstants;
import com.jnbridge.jnbcore.JNBVoidResult;
import com.jnbridge.jnbcore.MessageKeys;
import com.jnbridge.jnbcore.Messages;
import com.jnbridge.jnbcore.formatters.Formatter;
import com.jnbridge.jnbcore.formatters.SerializationException;
import com.jnbridge.jnbcore.formatters.binary.BinaryFormatter;
import com.jnbridge.jnbcore.server.binary.BinaryServer;
import com.jnbridge.jnbcore.streams.DotNetDataInputStream;
import com.jnbridge.jnbcore.streams.DotNetDataOutputStream;
import com.jnbridge.jnbcore.streams.TcpConstants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.zip.Inflater;

final class BinaryRequestHandler
implements JNBDispatcherConstants,
DebugConstants,
TcpConstants,
MessageKeys {
    int targetObjectID;
    int targetMethodID;
    private BinaryServer theServer;
    private Formatter theFormatter;
    static final char[] hexval = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public BinaryRequestHandler(BinaryServer binaryServer) {
        this.theServer = binaryServer;
        this.theFormatter = new BinaryFormatter();
    }

    public void handleRequest(InputStream inputStream, OutputStream outputStream) throws SerializationException, IOException {
        boolean bl = false;
        DotNetDataInputStream dotNetDataInputStream = new DotNetDataInputStream(new DataInputStream(inputStream));
        DotNetDataOutputStream dotNetDataOutputStream = new DotNetDataOutputStream(new DataOutputStream(outputStream));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl2 = false;
        boolean bl3 = true;
        try {
            byte[] byArray;
            Object object;
            Object object2;
            Object object3;
            boolean bl4 = dotNetDataInputStream.readPreamble();
            bl2 = dotNetDataInputStream.DontCompressResponse();
            bl3 = dotNetDataInputStream.MapEnums();
            int n = dotNetDataInputStream.readInt();
            int n2 = 0;
            if (bl4) {
                n2 = dotNetDataInputStream.readInt();
            }
            byte[] byArray2 = new byte[n];
            dotNetDataInputStream.read(byArray2);
            if (bl4) {
                object3 = new Inflater(true);
                ((Inflater)object3).setInput(byArray2);
                object2 = new ByteArrayOutputStream(n2);
                object = new byte[1024];
                while (!((Inflater)object3).finished()) {
                    int n3 = ((Inflater)object3).inflate((byte[])object);
                    ((ByteArrayOutputStream)object2).write((byte[])object, 0, n3);
                }
                ((ByteArrayOutputStream)object2).close();
                byArray = ((ByteArrayOutputStream)object2).toByteArray();
                ((Inflater)object3).end();
            } else {
                byArray = byArray2;
            }
            object3 = new ByteArrayInputStream(byArray);
            object2 = this.theFormatter.deserializeCall((InputStream)object3);
            object = (Integer)object2.getArg("targetMethodID");
            this.targetMethodID = (Integer)object;
            object = (Integer)object2.getArg("targetObjectID");
            this.targetObjectID = (Integer)object;
            Boolean bl5 = (Boolean)object2.getArg("isThreadTrue");
            boolean bl6 = bl5;
            byte[] byArray3 = (byte[])object2.getArg("threadID");
            if (this.targetMethodID == 58) {
                this.theFormatter.serializeResult(byteArrayOutputStream, this.targetObjectID, this.targetMethodID, new JNBVoidResult(), bl3);
            } else if (this.targetMethodID == 59) {
                this.theFormatter.serializeResult(byteArrayOutputStream, this.targetObjectID, this.targetMethodID, new JNBVoidResult(), bl3);
                this.theServer.stop();
            } else {
                JNBDispatcher jNBDispatcher = JNBDispatcher.getInstance();
                Object object4 = jNBDispatcher.call(this.targetMethodID, (CallArgs)object2, bl6, byArray3, bl3);
                this.theFormatter.serializeResult(byteArrayOutputStream, this.targetObjectID, this.targetMethodID, object4, bl3);
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            throw interruptedIOException;
        }
        catch (EOFException eOFException) {
            if (!bl) {
                throw new InterruptedIOException();
            }
            this.theFormatter.serializeException(byteArrayOutputStream, new InternalException(Messages.getString("BINARYREQUESTHANDLER_HANDLEREQUEST")));
        }
        catch (Exception exception) {
            this.theFormatter.serializeException(byteArrayOutputStream, exception);
        }
        dotNetDataOutputStream.copyByteArrayStream(byteArrayOutputStream, bl2);
        dotNetDataOutputStream.flush();
    }

    private void hexDump(DotNetDataInputStream dotNetDataInputStream) throws Exception {
        char[] cArray = new char[24];
        int n = 0;
        try {
            while (true) {
                for (n = 0; n < 24; ++n) {
                    int n2 = dotNetDataInputStream.read();
                    int n3 = n2 / 16;
                    int n4 = n2 % 16;
                    System.out.print(hexval[n3]);
                    System.out.print(hexval[n4]);
                    System.out.print(' ');
                    int n5 = n2;
                    cArray[n] = 32 <= n5 && n5 <= 126 ? n5 : 63;
                }
                System.out.print('\t');
                System.out.println(cArray);
            }
        }
        catch (Throwable throwable) {
            int n6;
            for (n6 = n; n6 < 24; ++n6) {
                System.out.print("   ");
            }
            System.out.print('\t');
            for (n6 = 0; n6 < n; ++n6) {
                System.out.print(cArray[n6]);
            }
            System.out.println();
            throw throwable;
        }
    }
}

