/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore.server.binary;

import com.jnbridge.jnbcore.DebugConstants;
import com.jnbridge.jnbcore.MessageKeys;
import com.jnbridge.jnbcore.Messages;
import com.jnbridge.jnbcore.server.ServerException;
import com.jnbridge.jnbcore.server.binary.BinaryRequestHandler;
import com.jnbridge.jnbcore.server.binary.BinaryServer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.Vector;

final class BinaryWorker
implements Runnable,
DebugConstants,
MessageKeys {
    static final byte[] EOL = new byte[]{13, 10};
    BinaryServer binaryServer;
    private Socket s;
    private boolean isStopped = false;
    private static Class sslExceptionClass;

    BinaryWorker(BinaryServer binaryServer) {
        this.binaryServer = binaryServer;
        this.s = null;
    }

    synchronized void setSocket(Socket socket) throws ServerException {
        this.s = socket;
        try {
            socket.setTcpNoDelay(this.binaryServer.noDelay);
        }
        catch (SocketException socketException) {
            throw new ServerException("SocketException: " + socketException.getMessage());
        }
        this.notify();
    }

    synchronized void stopWorker() {
        this.isStopped = true;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        while (true) {
            Vector vector;
            if (this.s == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
            }
            if (this.isStopped) {
                return;
            }
            try {
                this.handleClient();
            }
            catch (Exception exception) {
                System.out.println(Messages.getString("BINARYWORKER_RUN_1"));
                System.out.println(Messages.getString("BINARYWORKER_RUN_2"));
                System.out.println();
                exception.printStackTrace();
            }
            this.s = null;
            Vector vector2 = vector = this.binaryServer.threads;
            synchronized (vector2) {
                if (vector.size() >= this.binaryServer.workers) {
                    return;
                }
                vector.addElement(this);
                vector.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleClient() throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(this.s.getInputStream(), 4096);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(this.s.getOutputStream(), 4096);
        boolean bl = false;
        try {
            try {
                this.s.setSoTimeout(this.binaryServer.timeout);
                this.s.setTcpNoDelay(this.binaryServer.noDelay);
                while (true) {
                    BinaryRequestHandler binaryRequestHandler = new BinaryRequestHandler(this.binaryServer);
                    binaryRequestHandler.handleRequest(bufferedInputStream, bufferedOutputStream);
                    ((OutputStream)bufferedOutputStream).flush();
                }
            }
            catch (SocketException socketException) {
                block36: {
                    Object var7_8 = null;
                    try {
                        ((OutputStream)bufferedOutputStream).flush();
                        this.s.close();
                    }
                    catch (SocketException socketException2) {
                        return;
                    }
                    catch (Exception exception) {
                        if (sslExceptionClass == null || !exception.getClass().equals(sslExceptionClass)) break block36;
                        Throwable throwable = exception.getCause();
                        if (throwable != null && throwable instanceof SocketException) {
                            return;
                        }
                        Throwable throwable2 = throwable.getCause();
                        if (throwable2 != null && throwable2 instanceof SocketException) {
                            return;
                        }
                        if (bl) break block36;
                        System.err.println(Messages.getString("BINARYWORKER_HANDLECLIENT_1"));
                        System.err.println(Messages.getString("BINARYWORKER_HANDLECLIENT_2") + " " + throwable.getClass().getName() + ": " + throwable.getMessage());
                        return;
                    }
                }
                return;
            }
            catch (InterruptedIOException interruptedIOException) {
                block37: {
                    Object var7_9 = null;
                    try {
                        ((OutputStream)bufferedOutputStream).flush();
                        this.s.close();
                    }
                    catch (SocketException socketException) {
                        return;
                    }
                    catch (Exception exception) {
                        if (sslExceptionClass == null || !exception.getClass().equals(sslExceptionClass)) break block37;
                        Throwable throwable = exception.getCause();
                        if (throwable != null && throwable instanceof SocketException) {
                            return;
                        }
                        Throwable throwable3 = throwable.getCause();
                        if (throwable3 != null && throwable3 instanceof SocketException) {
                            return;
                        }
                        if (bl) break block37;
                        System.err.println(Messages.getString("BINARYWORKER_HANDLECLIENT_1"));
                        System.err.println(Messages.getString("BINARYWORKER_HANDLECLIENT_2") + " " + throwable.getClass().getName() + ": " + throwable.getMessage());
                        return;
                    }
                }
                return;
            }
            catch (Exception exception) {
                if (sslExceptionClass != null && exception.getClass().equals(sslExceptionClass)) {
                    block39: {
                        Throwable throwable = exception.getCause();
                        if (throwable != null && throwable instanceof SocketException) {
                            block38: {
                                Object var7_10 = null;
                                try {
                                    ((OutputStream)bufferedOutputStream).flush();
                                    this.s.close();
                                }
                                catch (SocketException socketException) {
                                    return;
                                }
                                catch (Exception exception2) {
                                    if (sslExceptionClass == null || !exception2.getClass().equals(sslExceptionClass)) break block38;
                                    Throwable throwable4 = exception2.getCause();
                                    if (throwable4 != null && throwable4 instanceof SocketException) {
                                        return;
                                    }
                                    Throwable throwable5 = throwable4.getCause();
                                    if (throwable5 != null && throwable5 instanceof SocketException) {
                                        return;
                                    }
                                    if (bl) break block38;
                                    System.err.println(Messages.getString("BINARYWORKER_HANDLECLIENT_1"));
                                    System.err.println(Messages.getString("BINARYWORKER_HANDLECLIENT_2") + " " + throwable4.getClass().getName() + ": " + throwable4.getMessage());
                                    return;
                                }
                            }
                            return;
                        }
                        System.err.println(Messages.getString("BINARYWORKER_HANDLECLIENT_1"));
                        System.err.println(Messages.getString("BINARYWORKER_HANDLECLIENT_2") + " " + throwable.getClass().getName() + ": " + throwable.getMessage());
                        bl = true;
                        Object var7_11 = null;
                        try {
                            ((OutputStream)bufferedOutputStream).flush();
                            this.s.close();
                        }
                        catch (SocketException socketException) {
                            return;
                        }
                        catch (Exception exception3) {
                            if (sslExceptionClass == null || !exception3.getClass().equals(sslExceptionClass)) break block39;
                            Throwable throwable6 = exception3.getCause();
                            if (throwable6 != null && throwable6 instanceof SocketException) {
                                return;
                            }
                            Throwable throwable7 = throwable6.getCause();
                            if (throwable7 != null && throwable7 instanceof SocketException) {
                                return;
                            }
                            if (bl) break block39;
                            System.err.println(Messages.getString("BINARYWORKER_HANDLECLIENT_1"));
                            System.err.println(Messages.getString("BINARYWORKER_HANDLECLIENT_2") + " " + throwable6.getClass().getName() + ": " + throwable6.getMessage());
                            return;
                        }
                    }
                    return;
                }
                System.out.println(Messages.getString("BINARYWORKER_HANDLECLIENT_3"));
                exception.printStackTrace();
                Object var7_12 = null;
                try {
                    ((OutputStream)bufferedOutputStream).flush();
                    this.s.close();
                }
                catch (SocketException socketException) {
                    return;
                }
                catch (Exception exception4) {
                    if (sslExceptionClass != null && exception4.getClass().equals(sslExceptionClass)) {
                        Throwable throwable = exception4.getCause();
                        if (throwable != null && throwable instanceof SocketException) {
                            return;
                        }
                        Throwable throwable8 = throwable.getCause();
                        if (throwable8 != null && throwable8 instanceof SocketException) {
                            return;
                        }
                        if (!bl) {
                            System.err.println(Messages.getString("BINARYWORKER_HANDLECLIENT_1"));
                            System.err.println(Messages.getString("BINARYWORKER_HANDLECLIENT_2") + " " + throwable.getClass().getName() + ": " + throwable.getMessage());
                            return;
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
            block41: {
                Object var7_13 = null;
                try {
                    ((OutputStream)bufferedOutputStream).flush();
                    this.s.close();
                }
                catch (SocketException socketException) {
                    return;
                }
                catch (Exception exception) {
                    if (sslExceptionClass == null || !exception.getClass().equals(sslExceptionClass)) break block41;
                    Throwable throwable9 = exception.getCause();
                    if (throwable9 != null && throwable9 instanceof SocketException) {
                        return;
                    }
                    Throwable throwable10 = throwable9.getCause();
                    if (throwable10 != null && throwable10 instanceof SocketException) {
                        return;
                    }
                    if (bl) break block41;
                    System.err.println(Messages.getString("BINARYWORKER_HANDLECLIENT_1"));
                    System.err.println(Messages.getString("BINARYWORKER_HANDLECLIENT_2") + " " + throwable9.getClass().getName() + ": " + throwable9.getMessage());
                    return;
                }
            }
            throw throwable;
        }
    }

    static {
        try {
            sslExceptionClass = Class.forName("javax.net.ssl.SSLException");
        }
        catch (ClassNotFoundException classNotFoundException) {
            sslExceptionClass = null;
        }
    }
}

