/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore.server.http;

import java.util.Hashtable;

final class HeaderTokenizer {
    private static char[] wsChars = new char[]{' ', '\t', '\r', '\n'};
    private static char[] eolChars = new char[]{'\r', '\n'};
    private String headerString;
    private int curIndex = 0;
    private int endIndex;

    public HeaderTokenizer(String string) {
        this.headerString = string;
        this.endIndex = string.length();
    }

    public String getStringToWS() {
        this.skipWhiteSpace();
        int n = this.indexOfAny(this.curIndex, this.endIndex, wsChars);
        StringBuffer stringBuffer = new StringBuffer(n - this.curIndex);
        while (this.curIndex < n) {
            char c = this.headerString.charAt(this.curIndex);
            stringBuffer.append(c);
            ++this.curIndex;
        }
        return new String(stringBuffer);
    }

    public String getStringToEOL() {
        this.skipWhiteSpace();
        int n = this.indexOfAny(this.curIndex, this.endIndex, eolChars);
        StringBuffer stringBuffer = new StringBuffer(n - this.curIndex);
        while (this.curIndex < n) {
            char c = this.headerString.charAt(this.curIndex);
            stringBuffer.append(c);
            ++this.curIndex;
        }
        return new String(stringBuffer);
    }

    public String getStringToChar(char c) {
        this.skipWhiteSpace();
        int n = this.headerString.indexOf(c, this.curIndex);
        StringBuffer stringBuffer = new StringBuffer(n - this.curIndex);
        while (this.curIndex < n) {
            char c2 = this.headerString.charAt(this.curIndex);
            stringBuffer.append(c2);
            ++this.curIndex;
        }
        return new String(stringBuffer);
    }

    public boolean hasMorePairs() {
        this.skipWhiteSpace();
        return this.curIndex < this.endIndex;
    }

    public void getHeaderPair(Hashtable hashtable) {
        this.skipWhiteSpace();
        String string = this.getStringToChar(':');
        this.skipNChars(1);
        String string2 = this.getStringToEOL();
        hashtable.put(string, string2);
    }

    private boolean isWhiteSpace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    private boolean isEOL(byte by) {
        switch (by) {
            case 10: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    private void skipWhiteSpace() {
        char c;
        while (this.curIndex < this.endIndex && this.isWhiteSpace(c = this.headerString.charAt(this.curIndex))) {
            ++this.curIndex;
        }
    }

    private void skipNChars(int n) {
        this.curIndex += n;
    }

    private int indexOfAny(int n, int n2, char[] cArray) {
        int n3 = cArray.length;
        for (int i = n; i <= n2; ++i) {
            char c = this.headerString.charAt(i);
            for (int j = 0; j < n3; ++j) {
                if (c != cArray[j]) continue;
                return i;
            }
        }
        return -1;
    }
}

