/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore.server.http;

import com.jnbridge.jnbcore.MessageKeys;
import com.jnbridge.jnbcore.Messages;
import com.jnbridge.jnbcore.formatters.SerializationException;
import com.jnbridge.jnbcore.formatters.soap.SOAPNamespaceConstants;
import com.jnbridge.jnbcore.server.http.HeaderTokenizer;
import com.jnbridge.jnbcore.server.http.HttpRequestHeaderConstants;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;

public final class HttpRequestHeader
implements HttpRequestHeaderConstants,
SOAPNamespaceConstants,
MessageKeys {
    private int method;
    private String path;
    private String version;
    Hashtable headerPairs = new Hashtable();
    private static final byte[] EOL = new byte[]{13, 10};

    public HttpRequestHeader(InputStream inputStream) throws IOException {
        this.readHeader(inputStream);
    }

    public HttpRequestHeader(int n, String string, String string2, String string3, int n2) {
        this.path = string2;
        this.headerPairs.put("User-Agent", "Mozilla/4.0+(compatible; MSIE 6.0; Windows 5.1.2600.0; MS .NET Remoting; MS .NET CLR 1.1.4322.573 )");
        this.headerPairs.put("Content-Type", "text/xml; charset=\"utf-8\"");
        this.headerPairs.put("SOAPAction", "\"http://schemas.microsoft.com/clr/nsassem/com.jnbridge.jnbcore.IJNBDotNetDispatcher/JNBShare#" + string + "\"");
        this.headerPairs.put("Content-Length", String.valueOf(n));
        this.headerPairs.put("Host", string3 + ":" + n2);
    }

    public void printToStream(OutputStream outputStream) throws IOException {
        PrintStream printStream = new PrintStream(outputStream);
        printStream.print("POST " + this.path + " " + "HTTP/1.1");
        printStream.write(EOL);
        Enumeration enumeration = this.headerPairs.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.headerPairs.get(string);
            printStream.print(string + ": " + string2);
            printStream.write(EOL);
        }
        printStream.write(EOL);
    }

    public void readHeader(InputStream inputStream) throws IOException {
        int n = 0;
        int n2 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while (true) {
            byte by;
            if ((by = (byte)inputStream.read()) == -1) {
                throw new SocketException();
            }
            byteArrayOutputStream.write(by);
            ++n;
            if (by == 13 || by == 10) {
                if (n2 == 3) break;
                ++n2;
                continue;
            }
            n2 = 0;
        }
        n2 = 0;
        this.parseHeader(byteArrayOutputStream.toString());
    }

    void parseHeader(String string) {
        HeaderTokenizer headerTokenizer = new HeaderTokenizer(string);
        String string2 = headerTokenizer.getStringToWS();
        this.method = string2.equals("POST") ? 1 : 0;
        this.path = headerTokenizer.getStringToWS();
        this.version = headerTokenizer.getStringToEOL();
        while (headerTokenizer.hasMorePairs()) {
            headerTokenizer.getHeaderPair(this.headerPairs);
        }
    }

    public void verifyHeader() throws SerializationException {
        if (this.getMethod() != 1) {
            throw new SerializationException(Messages.getString("HTTPREQUESTHEADER_VERIFYHEADER_1"));
        }
        if (!this.getPath().equals("/JNBDispatcher")) {
            throw new SerializationException(Messages.getString("HTTPREQUESTHEADER_VERIFYHEADER_2") + " " + "/JNBDispatcher");
        }
        String string = this.getHeaderValue("SOAPAction");
        if (string == null) {
            throw new SerializationException(Messages.getString("HTTPREQUESTHEADER_VERIFYHEADER_3"));
        }
        if (!string.startsWith("\"http://schemas.microsoft.com/clr/nsassem/")) {
            throw new SerializationException(Messages.getString("HTTPREQUESTHEADER_VERIFYHEADER_4"));
        }
        String string2 = string.substring("\"http://schemas.microsoft.com/clr/nsassem/".length());
        if (!string2.startsWith("com.jnbridge.jnbcore.IJNBDispatcher/JNBShare") && !string2.startsWith("com.jnbridge.jnbcore.JNBDispatcher/JNBShare")) {
            throw new SerializationException(Messages.getString("HTTPREQUESTHEADER_VERIFYHEADER_5"));
        }
    }

    public int getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.path;
    }

    public String getHeaderValue(String string) {
        return (String)this.headerPairs.get(string);
    }

    public String toString() {
        String string = "";
        string = string + "Method: ";
        string = this.method == 1 ? string + "POST" : string + "Other";
        string = string + '\n';
        string = string + "Path: " + this.path + '\n';
        string = string + "Version: " + this.version + '\n';
        Enumeration enumeration = this.headerPairs.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)this.headerPairs.get(string2);
            string = string + string2 + ": " + string3 + '\n';
        }
        return string;
    }
}

