/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore.server.http;

import com.jnbridge.jnbcore.MessageKeys;
import com.jnbridge.jnbcore.Messages;
import com.jnbridge.jnbcore.server.http.HeaderTokenizer;
import com.jnbridge.jnbcore.server.http.HttpConstants;
import com.jnbridge.jnbcore.server.http.HttpRequestHeaderConstants;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;

public final class HttpResponseHeader
implements HttpConstants,
HttpRequestHeaderConstants,
MessageKeys {
    private int status;
    private String statusStr;
    private static final byte[] EOL = new byte[]{13, 10};
    private Hashtable headers;

    HttpResponseHeader(int n) {
        this.status = n;
        this.statusStr = this.getStatusString(n);
        this.headers = new Hashtable();
    }

    public HttpResponseHeader(InputStream inputStream) throws IOException {
        this.headers = new Hashtable();
        int n = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        do {
            byte by;
            if ((by = (byte)inputStream.read()) == 255) {
                throw new IOException(Messages.getString("HTTPRESPONSEHEADER_CONSTRUCTOR"));
            }
            byteArrayOutputStream.write(by);
            if (by == 13 || by == 10) {
                ++n;
                continue;
            }
            n = 0;
        } while (n != 4);
        String string = byteArrayOutputStream.toString();
        this.parseHeader(string);
    }

    private String getStatusString(int n) {
        switch (n) {
            case 100: {
                return "Continue";
            }
            case 200: {
                return "OK";
            }
            case 500: {
                return "Internal Server Error";
            }
        }
        return "OTHER";
    }

    public int getStatus() {
        return this.status;
    }

    public void setProperty(String string, String string2) {
        this.headers.put(string, string2);
    }

    public String getProperty(String string) {
        return (String)this.headers.get(string);
    }

    public void printToStream(PrintStream printStream) throws IOException {
        printStream.print("HTTP/1.1 " + this.status + ' ' + this.statusStr);
        printStream.write(EOL);
        Enumeration enumeration = this.headers.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.headers.get(string);
            printStream.print(string + ": " + string2);
            printStream.write(EOL);
        }
        printStream.write(EOL);
    }

    private void parseHeader(String string) throws IOException {
        HeaderTokenizer headerTokenizer = new HeaderTokenizer(string);
        String string2 = headerTokenizer.getStringToWS();
        String string3 = headerTokenizer.getStringToWS();
        this.statusStr = headerTokenizer.getStringToEOL();
        if (!string2.equals("HTTP/1.1")) {
            throw new IOException(Messages.getString("HTTPRESPONSEHEADER_PARSEHEADER_1") + " " + string2);
        }
        try {
            this.status = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException(Messages.getString("HTTPRESPONSEHEADER_PARSEHEADER_2") + " " + numberFormatException.getMessage());
        }
        if (this.status != 200 && this.status != 100 && this.status != 500) {
            throw new IOException(Messages.getString("HTTPRESPONSEHEADER_PARSEHEADER_3"));
        }
        while (headerTokenizer.hasMorePairs()) {
            headerTokenizer.getHeaderPair(this.headers);
        }
    }
}

