/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore.server.http;

import com.jnbridge.jnbcore.CallArgs;
import com.jnbridge.jnbcore.DebugConstants;
import com.jnbridge.jnbcore.JNBDispatchMap;
import com.jnbridge.jnbcore.JNBDispatcher;
import com.jnbridge.jnbcore.JNBDispatcherConstants;
import com.jnbridge.jnbcore.JNBVoidResult;
import com.jnbridge.jnbcore.MessageKeys;
import com.jnbridge.jnbcore.Messages;
import com.jnbridge.jnbcore.formatters.Formatter;
import com.jnbridge.jnbcore.formatters.SerializationException;
import com.jnbridge.jnbcore.formatters.soap.SOAPException;
import com.jnbridge.jnbcore.formatters.soap.SOAPFormatter;
import com.jnbridge.jnbcore.server.ServerException;
import com.jnbridge.jnbcore.server.http.HttpConstants;
import com.jnbridge.jnbcore.server.http.HttpRequestHeader;
import com.jnbridge.jnbcore.server.http.HttpResponseHeader;
import com.jnbridge.jnbcore.server.http.HttpServer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Vector;

final class HttpWorker
implements HttpConstants,
JNBDispatcherConstants,
DebugConstants,
Runnable,
MessageKeys {
    static final byte[] EOL = new byte[]{13, 10};
    HttpServer httpServer;
    private Socket s;
    private Formatter soapFormatter;
    private boolean isStopped = false;

    HttpWorker(HttpServer httpServer) throws SerializationException {
        this.httpServer = httpServer;
        this.soapFormatter = new SOAPFormatter();
        this.s = null;
    }

    synchronized void setSocket(Socket socket) throws ServerException {
        this.s = socket;
        try {
            socket.setTcpNoDelay(this.httpServer.noDelay);
        }
        catch (SocketException socketException) {
            throw new ServerException("SocketException: " + socketException.getMessage());
        }
        this.notify();
    }

    synchronized void stopWorker() {
        this.isStopped = true;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        while (true) {
            Vector vector;
            if (this.s == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
            }
            if (this.isStopped) {
                return;
            }
            try {
                this.handleClient();
            }
            catch (Exception exception) {
                System.out.println(Messages.getString("HTTPWORKER_RUN_1"));
                System.out.println(Messages.getString("HTTPWORKER_RUN_2"));
                System.out.println();
                exception.printStackTrace();
            }
            this.s = null;
            Vector vector2 = vector = this.httpServer.threads;
            synchronized (vector2) {
                if (vector.size() >= this.httpServer.workers) {
                    return;
                }
                vector.addElement(this);
                vector.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleClient() throws SerializationException, IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(this.s.getInputStream());
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(this.s.getOutputStream());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            try {
                this.s.setTcpNoDelay(this.httpServer.noDelay);
                while (true) {
                    byteArrayOutputStream.reset();
                    HttpRequestHeader httpRequestHeader = new HttpRequestHeader(bufferedInputStream);
                    httpRequestHeader.verifyHeader();
                    String string = httpRequestHeader.getHeaderValue("Expect");
                    if (string != null && string.equals("100-continue")) {
                        this.sendResponse(bufferedOutputStream, 100, null);
                        ((OutputStream)bufferedOutputStream).flush();
                    }
                    String string2 = httpRequestHeader.getHeaderValue("Content-Length");
                    int n = 0;
                    try {
                        n = Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        this.soapFormatter.serializeException(byteArrayOutputStream, new SOAPException(Messages.getString("HTTPWORKER_HANDLECLIENT")));
                        this.sendResponse(bufferedOutputStream, 500, byteArrayOutputStream);
                        ((OutputStream)bufferedOutputStream).flush();
                        Object var22_27 = null;
                        try {
                            ((OutputStream)bufferedOutputStream).flush();
                            this.s.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return;
                    }
                    int n2 = 200;
                    try {
                        int n3;
                        byte[] byArray = new byte[n];
                        for (int i = 0; i < n; i += ((InputStream)bufferedInputStream).read(byArray, i, n3)) {
                            n3 = n - i;
                        }
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                        CallArgs callArgs = this.soapFormatter.deserializeCall(byteArrayInputStream);
                        Integer n4 = (Integer)callArgs.getArg("targetMethodID");
                        int n5 = n4;
                        n4 = JNBDispatchMap.getTargetID(httpRequestHeader.getPath());
                        int n6 = n4;
                        callArgs.setArg("targetObjectID", n4);
                        Boolean bl = (Boolean)callArgs.getArg("isThreadTrue");
                        boolean bl2 = bl;
                        byte[] byArray2 = (byte[])callArgs.getArg("threadID");
                        if (n5 == 58) {
                            this.soapFormatter.serializeResult(byteArrayOutputStream, n6, n5, new JNBVoidResult(), true);
                        } else if (n5 == 59) {
                            this.soapFormatter.serializeResult(byteArrayOutputStream, n6, n5, new JNBVoidResult(), true);
                            this.httpServer.stop();
                        } else {
                            JNBDispatcher jNBDispatcher = JNBDispatcher.getInstance();
                            Object object = jNBDispatcher.call(n5, callArgs, bl2, byArray2, true);
                            this.soapFormatter.serializeResult(byteArrayOutputStream, n6, n5, object, true);
                            n2 = 200;
                        }
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        n2 = 500;
                        this.soapFormatter.serializeException(byteArrayOutputStream, invocationTargetException);
                    }
                    catch (SocketException socketException) {
                        throw socketException;
                    }
                    catch (Exception exception) {
                        n2 = 500;
                        this.soapFormatter.serializeException(byteArrayOutputStream, exception);
                    }
                    this.sendResponse(bufferedOutputStream, n2, byteArrayOutputStream);
                    ((OutputStream)bufferedOutputStream).flush();
                }
            }
            catch (SocketException socketException) {
                Object var22_28 = null;
                try {
                    ((OutputStream)bufferedOutputStream).flush();
                    this.s.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (Throwable throwable) {
            Object var22_29 = null;
            try {
                ((OutputStream)bufferedOutputStream).flush();
                this.s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    void sendResponse(OutputStream outputStream, int n, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        PrintStream printStream = new PrintStream(outputStream);
        HttpResponseHeader httpResponseHeader = new HttpResponseHeader(n);
        if (byteArrayOutputStream != null) {
            httpResponseHeader.setProperty("Content-Type", "text/xml; charset=\"utf-8\"");
            httpResponseHeader.setProperty("Content-Length", String.valueOf(byteArrayOutputStream.size()));
        }
        httpResponseHeader.printToStream(printStream);
        if (byteArrayOutputStream != null) {
            printStream.print(byteArrayOutputStream);
        }
    }
}

