/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore.streams;

import com.jnbridge.jnbcore.MessageKeys;
import com.jnbridge.jnbcore.Messages;
import com.jnbridge.jnbcore.server.binary.BinaryException;
import com.jnbridge.jnbcore.streams.TcpConstants;
import java.io.DataInputStream;
import java.io.IOException;

public final class DotNetDataInputStream
implements TcpConstants,
MessageKeys {
    DataInputStream is;
    private byte[] intBytes = null;
    private byte[] longBytes = null;
    private byte[] shortBytes = null;
    private byte[] floatBytes = null;
    private byte[] doubleBytes = null;
    private byte[] charBytes = null;
    private boolean dontCompressResponse = false;
    private boolean mapEnums = true;
    byte[] fiveBytes = new byte[5];

    public DotNetDataInputStream(DataInputStream dataInputStream) {
        this.is = dataInputStream;
    }

    public long skip(long l) throws IOException {
        return this.is.skip(l);
    }

    public int read() throws IOException {
        return this.is.read();
    }

    public int readInt() throws IOException {
        if (this.intBytes == null) {
            this.intBytes = new byte[4];
        }
        this.is.readFully(this.intBytes);
        return (this.intBytes[3] & 0xFF) << 24 | (this.intBytes[2] & 0xFF) << 16 | (this.intBytes[1] & 0xFF) << 8 | this.intBytes[0] & 0xFF;
    }

    public int[] readIntArray(int n) throws IOException {
        int n2 = n * 5;
        byte[] byArray = new byte[n2];
        this.is.readFully(byArray);
        int[] nArray = new int[n];
        int n3 = 0;
        for (int i = 0; i < n2; i += 5) {
            nArray[n3++] = (byArray[i + 4] & 0xFF) << 24 | (byArray[i + 3] & 0xFF) << 16 | (byArray[i + 2] & 0xFF) << 8 | byArray[i + 1] & 0xFF;
        }
        return nArray;
    }

    public long readLong() throws IOException {
        if (this.longBytes == null) {
            this.longBytes = new byte[8];
        }
        this.is.readFully(this.longBytes);
        return (long)(this.longBytes[7] & 0xFF) << 56 | (long)(this.longBytes[6] & 0xFF) << 48 | (long)(this.longBytes[5] & 0xFF) << 40 | (long)(this.longBytes[4] & 0xFF) << 32 | (long)(this.longBytes[3] & 0xFF) << 24 | (long)(this.longBytes[2] & 0xFF) << 16 | (long)(this.longBytes[1] & 0xFF) << 8 | (long)(this.longBytes[0] & 0xFF);
    }

    public long[] readLongArray(int n) throws IOException {
        int n2 = n * 9;
        byte[] byArray = new byte[n2];
        this.is.readFully(byArray);
        long[] lArray = new long[n];
        int n3 = 0;
        for (int i = 0; i < n2; i += 9) {
            lArray[n3++] = (long)(byArray[i + 8] & 0xFF) << 56 | (long)(byArray[i + 7] & 0xFF) << 48 | (long)(byArray[i + 6] & 0xFF) << 40 | (long)(byArray[i + 5] & 0xFF) << 32 | (long)(byArray[i + 4] & 0xFF) << 24 | (long)(byArray[i + 3] & 0xFF) << 16 | (long)(byArray[i + 2] & 0xFF) << 8 | (long)(byArray[i + 1] & 0xFF);
        }
        return lArray;
    }

    public short readShort() throws IOException {
        if (this.shortBytes == null) {
            this.shortBytes = new byte[2];
        }
        this.is.readFully(this.shortBytes);
        return (short)((0xFF & this.shortBytes[1]) << 8 | 0xFF & this.shortBytes[0]);
    }

    public short[] readShortArray(int n) throws IOException {
        int n2 = n * 3;
        byte[] byArray = new byte[n2];
        this.is.readFully(byArray);
        short[] sArray = new short[n];
        int n3 = 0;
        for (int i = 0; i < n2; i += 3) {
            sArray[n3++] = (short)((byArray[i + 2] & 0xFF) << 8 | byArray[i + 1] & 0xFF);
        }
        return sArray;
    }

    public float readFloat() throws IOException {
        if (this.floatBytes == null) {
            this.floatBytes = new byte[4];
        }
        this.is.readFully(this.floatBytes);
        int n = (this.floatBytes[3] & 0xFF) << 24 | (this.floatBytes[2] & 0xFF) << 16 | (this.floatBytes[1] & 0xFF) << 8 | this.floatBytes[0] & 0xFF;
        return Float.intBitsToFloat(n);
    }

    public float[] readFloatArray(int n) throws IOException {
        int n2 = n * 5;
        byte[] byArray = new byte[n2];
        this.is.readFully(byArray);
        float[] fArray = new float[n];
        int n3 = 0;
        for (int i = 0; i < n2; i += 5) {
            int n4 = (byArray[i + 4] & 0xFF) << 24 | (byArray[i + 3] & 0xFF) << 16 | (byArray[i + 2] & 0xFF) << 8 | byArray[i + 1] & 0xFF;
            fArray[n3++] = Float.intBitsToFloat(n4);
        }
        return fArray;
    }

    public double readDouble() throws IOException {
        if (this.doubleBytes == null) {
            this.doubleBytes = new byte[8];
        }
        this.is.readFully(this.doubleBytes);
        long l = (long)(this.doubleBytes[7] & 0xFF) << 56 | (long)(this.doubleBytes[6] & 0xFF) << 48 | (long)(this.doubleBytes[5] & 0xFF) << 40 | (long)(this.doubleBytes[4] & 0xFF) << 32 | (long)(this.doubleBytes[3] & 0xFF) << 24 | (long)(this.doubleBytes[2] & 0xFF) << 16 | (long)(this.doubleBytes[1] & 0xFF) << 8 | (long)(this.doubleBytes[0] & 0xFF);
        double d = Double.longBitsToDouble(l);
        return d;
    }

    public double[] readDoubleArray(int n) throws IOException {
        int n2 = n * 9;
        byte[] byArray = new byte[n2];
        this.is.readFully(byArray);
        double[] dArray = new double[n];
        int n3 = 0;
        for (int i = 0; i < n2; i += 9) {
            long l = (long)(byArray[i + 8] & 0xFF) << 56 | (long)(byArray[i + 7] & 0xFF) << 48 | (long)(byArray[i + 6] & 0xFF) << 40 | (long)(byArray[i + 5] & 0xFF) << 32 | (long)(byArray[i + 4] & 0xFF) << 24 | (long)(byArray[i + 3] & 0xFF) << 16 | (long)(byArray[i + 2] & 0xFF) << 8 | (long)(byArray[i + 1] & 0xFF);
            dArray[n3++] = Double.longBitsToDouble(l);
        }
        return dArray;
    }

    public short readChar() throws IOException {
        if (this.charBytes == null) {
            this.charBytes = new byte[2];
        }
        this.is.readFully(this.charBytes);
        short s = (short)((0xFF & this.charBytes[0]) << 8 | 0xFF & this.charBytes[1]);
        return s;
    }

    public char[] readCharArray(int n) throws IOException {
        int n2 = n * 4;
        byte[] byArray = new byte[n2];
        this.is.readFully(byArray);
        char[] cArray = new char[n];
        int n3 = 0;
        for (int i = 0; i < n2; i += 4) {
            short s = (short)((byArray[i + 2] & 0xFF) << 8 | byArray[i + 3] & 0xFF);
            cArray[n3++] = (char)s;
        }
        return cArray;
    }

    public byte readByte() throws IOException {
        return (byte)this.is.read();
    }

    public byte[] readByteArray(int n) throws IOException {
        int n2 = n * 2;
        byte[] byArray = new byte[n2];
        this.is.readFully(byArray);
        byte[] byArray2 = new byte[n];
        int n3 = 0;
        for (int i = 0; i < n2; i += 2) {
            byArray2[n3++] = byArray[i + 1];
        }
        return byArray2;
    }

    public boolean readBoolean() throws IOException {
        int n = this.is.read();
        return n != 0;
    }

    public boolean[] readBooleanArray(int n) throws IOException {
        int n2 = n * 2;
        byte[] byArray = new byte[n2];
        this.is.readFully(byArray);
        boolean[] blArray = new boolean[n];
        int n3 = 0;
        for (int i = 0; i < n2; i += 2) {
            blArray[n3++] = byArray[i + 1] != 0;
        }
        return blArray;
    }

    public void read(char[] cArray) throws IOException {
        byte[] byArray = new byte[cArray.length * 2];
        this.is.readFully(byArray);
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = (char)((0xFF & byArray[2 * i]) << 8 | 0xFF & byArray[2 * i + 1]);
        }
    }

    public void read(byte[] byArray) throws IOException {
        this.is.readFully(byArray);
    }

    public boolean DontCompressResponse() {
        return this.dontCompressResponse;
    }

    public boolean MapEnums() {
        return this.mapEnums;
    }

    public boolean readPreamble() throws IOException, BinaryException {
        this.read(this.fiveBytes);
        if (this.fiveBytes[0] != 74 || this.fiveBytes[1] != 78 || this.fiveBytes[2] != 66 || this.fiveBytes[3] != 55) {
            throw new BinaryException(Messages.getString("DOTNETDATAINPUTSTREAM_READPREAMBLE_1"));
        }
        switch (this.fiveBytes[4]) {
            case 48: {
                return false;
            }
            case 49: {
                return true;
            }
            case 50: {
                this.dontCompressResponse = true;
                return false;
            }
            case 51: {
                this.mapEnums = false;
                return false;
            }
            case 52: {
                this.mapEnums = false;
                return true;
            }
            case 53: {
                this.mapEnums = false;
                this.dontCompressResponse = true;
                return false;
            }
        }
        throw new BinaryException(Messages.getString("DOTNETDATAINPUTSTREAM_READPREAMBLE_1"));
    }
}

