/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbcore.streams;

import com.jnbridge.jnbcore.CompressionManager;
import com.jnbridge.jnbcore.PropertiesConstants;
import com.jnbridge.jnbcore.formatters.binary.BinaryRequestConstants;
import com.jnbridge.jnbcore.streams.TcpConstants;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;

public final class DotNetDataOutputStream
implements TcpConstants,
PropertiesConstants,
BinaryRequestConstants {
    OutputStream os;
    private byte[] intBytes = null;
    private byte[] shortBytes = null;
    private byte[] longBytes = null;
    private byte[] charBytes = null;
    private static byte[] fiveBytes = new byte[]{74, 78, 66, 55, 48};
    private static byte[] fiveBytesCompressed = new byte[]{74, 78, 66, 55, 49};

    public DotNetDataOutputStream(OutputStream outputStream) {
        this.os = outputStream;
    }

    public void write(int n) throws IOException {
        this.os.write(n);
    }

    public void write(String string) throws IOException {
        this.os.write(0);
        int n = string.length();
        this.writeInt(n);
        char[] cArray = string.toCharArray();
        this.write(cArray);
    }

    private int writeStringToArray(byte[] byArray, int n, String string) {
        int n2 = string.length();
        byArray[n] = 0;
        byArray[n + 1] = (byte)(n2 & 0xFF);
        byArray[n + 2] = (byte)(n2 >> 8 & 0xFF);
        byArray[n + 3] = (byte)(n2 >> 16 & 0xFF);
        byArray[n + 4] = (byte)(n2 >> 24 & 0xFF);
        char[] cArray = string.toCharArray();
        for (int i = 0; i < n2; ++i) {
            byArray[2 * i + n + 5] = (byte)(cArray[i] >> 8 & 0xFF);
            byArray[2 * i + n + 6] = (byte)(cArray[i] & 0xFF);
        }
        return n + 2 * n2 + 5;
    }

    public void writeInt(int n) throws IOException {
        if (this.intBytes == null) {
            this.intBytes = new byte[4];
        }
        this.intBytes[0] = (byte)(0xFF & n);
        this.intBytes[1] = (byte)(0xFF & n >> 8);
        this.intBytes[2] = (byte)(0xFF & n >> 16);
        this.intBytes[3] = (byte)(0xFF & n >> 24);
        this.os.write(this.intBytes);
    }

    public void writeIntArray(int[] nArray, int n) throws IOException {
        String string = nArray.getClass().getName();
        int n2 = string.length();
        int n3 = n * 5 + 7 + n2 * 2 + 5;
        byte[] byArray = new byte[n3];
        byArray[0] = 11;
        byArray[1] = 1;
        byArray[2] = (byte)(0xFF & n);
        byArray[3] = (byte)(0xFF & n >> 8);
        byArray[4] = (byte)(0xFF & n >> 16);
        byArray[5] = (byte)(0xFF & n >> 24);
        byArray[6] = 1;
        int n4 = 0;
        for (int i = this.writeStringToArray(byArray, 7, string); i < n3; i += 5) {
            int n5 = nArray[n4++];
            byArray[i] = 1;
            byArray[i + 1] = (byte)(0xFF & n5);
            byArray[i + 2] = (byte)(0xFF & n5 >> 8);
            byArray[i + 3] = (byte)(0xFF & n5 >> 16);
            byArray[i + 4] = (byte)(0xFF & n5 >> 24);
        }
        this.os.write(byArray);
    }

    public void writeShort(short s) throws IOException {
        if (this.shortBytes == null) {
            this.shortBytes = new byte[2];
        }
        this.shortBytes[0] = (byte)(0xFF & s);
        this.shortBytes[1] = (byte)(0xFF & s >> 8);
        this.os.write(this.shortBytes);
    }

    public void writeShortArray(short[] sArray, int n) throws IOException {
        String string = sArray.getClass().getName();
        int n2 = string.length();
        int n3 = n * 3 + 7 + n2 * 2 + 5;
        byte[] byArray = new byte[n3];
        byArray[0] = 11;
        byArray[1] = 1;
        byArray[2] = (byte)(0xFF & n);
        byArray[3] = (byte)(0xFF & n >> 8);
        byArray[4] = (byte)(0xFF & n >> 16);
        byArray[5] = (byte)(0xFF & n >> 24);
        byArray[6] = 2;
        int n4 = 0;
        for (int i = this.writeStringToArray(byArray, 7, string); i < n3; i += 3) {
            short s = sArray[n4++];
            byArray[i] = 2;
            byArray[i + 1] = (byte)(0xFF & s);
            byArray[i + 2] = (byte)(0xFF & s >> 8);
        }
        this.os.write(byArray);
    }

    public void writeLong(long l) throws IOException {
        if (this.longBytes == null) {
            this.longBytes = new byte[8];
        }
        this.longBytes[0] = (byte)(0xFFL & l);
        this.longBytes[1] = (byte)(0xFFL & l >> 8);
        this.longBytes[2] = (byte)(0xFFL & l >> 16);
        this.longBytes[3] = (byte)(0xFFL & l >> 24);
        this.longBytes[4] = (byte)(0xFFL & l >> 32);
        this.longBytes[5] = (byte)(0xFFL & l >> 40);
        this.longBytes[6] = (byte)(0xFFL & l >> 48);
        this.longBytes[7] = (byte)(0xFFL & l >> 56);
        this.os.write(this.longBytes);
    }

    public void writeLongArray(long[] lArray, int n) throws IOException {
        String string = lArray.getClass().getName();
        int n2 = string.length();
        int n3 = n * 9 + 7 + n2 * 2 + 5;
        byte[] byArray = new byte[n3];
        byArray[0] = 11;
        byArray[1] = 1;
        byArray[2] = (byte)(0xFF & n);
        byArray[3] = (byte)(0xFF & n >> 8);
        byArray[4] = (byte)(0xFF & n >> 16);
        byArray[5] = (byte)(0xFF & n >> 24);
        byArray[6] = 3;
        int n4 = 0;
        for (int i = this.writeStringToArray(byArray, 7, string); i < n3; i += 9) {
            long l = lArray[n4++];
            byArray[i] = 3;
            byArray[i + 1] = (byte)(0xFFL & l);
            byArray[i + 2] = (byte)(0xFFL & l >> 8);
            byArray[i + 3] = (byte)(0xFFL & l >> 16);
            byArray[i + 4] = (byte)(0xFFL & l >> 24);
            byArray[i + 5] = (byte)(0xFFL & l >> 32);
            byArray[i + 6] = (byte)(0xFFL & l >> 40);
            byArray[i + 7] = (byte)(0xFFL & l >> 48);
            byArray[i + 8] = (byte)(0xFFL & l >> 56);
        }
        this.os.write(byArray);
    }

    public void writeFloat(float f) throws IOException {
        int n = Float.floatToIntBits(f);
        this.writeInt(n);
    }

    public void writeFloatArray(float[] fArray, int n) throws IOException {
        String string = fArray.getClass().getName();
        int n2 = string.length();
        int n3 = n * 5 + 7 + n2 * 2 + 5;
        byte[] byArray = new byte[n3];
        byArray[0] = 11;
        byArray[1] = 1;
        byArray[2] = (byte)(0xFF & n);
        byArray[3] = (byte)(0xFF & n >> 8);
        byArray[4] = (byte)(0xFF & n >> 16);
        byArray[5] = (byte)(0xFF & n >> 24);
        byArray[6] = 4;
        int n4 = 0;
        for (int i = this.writeStringToArray(byArray, 7, string); i < n3; i += 5) {
            int n5 = Float.floatToIntBits(fArray[n4++]);
            byArray[i] = 4;
            byArray[i + 1] = (byte)(0xFF & n5);
            byArray[i + 2] = (byte)(0xFF & n5 >> 8);
            byArray[i + 3] = (byte)(0xFF & n5 >> 16);
            byArray[i + 4] = (byte)(0xFF & n5 >> 24);
        }
        this.os.write(byArray);
    }

    public void writeDouble(double d) throws IOException {
        long l = Double.doubleToLongBits(d);
        this.writeLong(l);
    }

    public void writeDoubleArray(double[] dArray, int n) throws IOException {
        String string = dArray.getClass().getName();
        int n2 = string.length();
        int n3 = n * 9 + 7 + n2 * 2 + 5;
        byte[] byArray = new byte[n3];
        byArray[0] = 11;
        byArray[1] = 1;
        byArray[2] = (byte)(0xFF & n);
        byArray[3] = (byte)(0xFF & n >> 8);
        byArray[4] = (byte)(0xFF & n >> 16);
        byArray[5] = (byte)(0xFF & n >> 24);
        byArray[6] = 5;
        int n4 = 0;
        for (int i = this.writeStringToArray(byArray, 7, string); i < n3; i += 9) {
            long l = Double.doubleToLongBits(dArray[n4]);
            byArray[i] = 5;
            byArray[i + 1] = (byte)(0xFFL & l);
            byArray[i + 2] = (byte)(0xFFL & l >> 8);
            byArray[i + 3] = (byte)(0xFFL & l >> 16);
            byArray[i + 4] = (byte)(0xFFL & l >> 24);
            byArray[i + 5] = (byte)(0xFFL & l >> 32);
            byArray[i + 6] = (byte)(0xFFL & l >> 40);
            byArray[i + 7] = (byte)(0xFFL & l >> 48);
            byArray[i + 8] = (byte)(0xFFL & l >> 56);
            ++n4;
        }
        this.os.write(byArray);
    }

    public void writeChar(char c) throws IOException {
        if (this.charBytes == null) {
            this.charBytes = new byte[2];
        }
        this.charBytes[0] = (byte)(c >> 8 & 0xFF);
        this.charBytes[1] = (byte)(c & 0xFF);
        this.os.write(this.charBytes);
    }

    public void writeCharArray(char[] cArray, int n) throws IOException {
        String string = cArray.getClass().getName();
        int n2 = string.length();
        int n3 = n * 4 + 7 + n2 * 2 + 5;
        byte[] byArray = new byte[n3];
        byArray[0] = 11;
        byArray[1] = 1;
        byArray[2] = (byte)(0xFF & n);
        byArray[3] = (byte)(0xFF & n >> 8);
        byArray[4] = (byte)(0xFF & n >> 16);
        byArray[5] = (byte)(0xFF & n >> 24);
        byArray[6] = 6;
        int n4 = 0;
        for (int i = this.writeStringToArray(byArray, 7, string); i < n3; i += 4) {
            char c = cArray[n4++];
            byArray[i] = 6;
            byArray[i + 1] = 0;
            byArray[i + 2] = (byte)(0xFF & c >> 8);
            byArray[i + 3] = (byte)(0xFF & c);
        }
        this.os.write(byArray);
    }

    public void writeByte(byte by) throws IOException {
        this.os.write(by);
    }

    public void writeByteArray(byte[] byArray, int n) throws IOException {
        String string = byArray.getClass().getName();
        int n2 = string.length();
        int n3 = n * 2 + 7 + n2 * 2 + 5;
        byte[] byArray2 = new byte[n3];
        byArray2[0] = 11;
        byArray2[1] = 1;
        byArray2[2] = (byte)(0xFF & n);
        byArray2[3] = (byte)(0xFF & n >> 8);
        byArray2[4] = (byte)(0xFF & n >> 16);
        byArray2[5] = (byte)(0xFF & n >> 24);
        byArray2[6] = 7;
        int n4 = 0;
        for (int i = this.writeStringToArray(byArray2, 7, string); i < n3; i += 2) {
            byte by = byArray[n4++];
            byArray2[i] = 7;
            byArray2[i + 1] = by;
        }
        this.os.write(byArray2);
    }

    public void writeBoolean(boolean bl) throws IOException {
        if (bl) {
            this.os.write(1);
        } else {
            this.os.write(0);
        }
    }

    public void writeBooleanArray(boolean[] blArray, int n) throws IOException {
        String string = blArray.getClass().getName();
        int n2 = string.length();
        int n3 = n * 2 + 7 + n2 * 2 + 5;
        byte[] byArray = new byte[n3];
        byArray[0] = 11;
        byArray[1] = 1;
        byArray[2] = (byte)(0xFF & n);
        byArray[3] = (byte)(0xFF & n >> 8);
        byArray[4] = (byte)(0xFF & n >> 16);
        byArray[5] = (byte)(0xFF & n >> 24);
        byArray[6] = 8;
        int n4 = 0;
        for (int i = this.writeStringToArray(byArray, 7, string); i < n3; i += 2) {
            boolean bl = blArray[n4++];
            byArray[i] = 8;
            byArray[i + 1] = bl ? (byte)1 : 0;
        }
        this.os.write(byArray);
    }

    public void write(byte[] byArray) throws IOException {
        this.os.write(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.os.write(byArray, n, n2);
    }

    public void write(char[] cArray) throws IOException {
        byte[] byArray = new byte[cArray.length * 2];
        for (int i = 0; i < cArray.length; ++i) {
            byArray[2 * i] = (byte)(cArray[i] >> 8 & 0xFF);
            byArray[2 * i + 1] = (byte)(cArray[i] & 0xFF);
        }
        this.os.write(byArray);
    }

    public void flush() throws IOException {
        this.os.flush();
    }

    public void copyByteArrayStream(ByteArrayOutputStream byteArrayOutputStream, boolean bl) throws IOException {
        byte[] byArray = byteArrayOutputStream.toByteArray();
        int n = byArray.length;
        boolean bl2 = !CompressionManager.getInstance().NoCompression() && !bl && n >= 100000;
        this.writePreamble(bl2);
        if (bl2) {
            Deflater deflater = new Deflater(5, true);
            deflater.setInput(byArray);
            deflater.finish();
            byte[] byArray2 = new byte[n + 50];
            int n2 = deflater.deflate(byArray2);
            this.writeInt(n2);
            this.writeInt(n);
            this.write(byArray2, 0, n2);
        } else {
            this.writeInt(n);
            this.write(byArray);
        }
    }

    public void writePreamble(boolean bl) throws IOException {
        if (bl) {
            this.write(fiveBytesCompressed);
        } else {
            this.write(fiveBytes);
        }
    }
}

