/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbproxy;

import com.jnbridge.jnbproxy.ClassDependencyCycleException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

class ClassDependencyGraph {
    private Hashtable dependencies = new Hashtable();
    private int maxDependencies = 0;
    private Hashtable invDependencies = new Hashtable();
    private HashSet classList = new HashSet();

    ClassDependencyGraph() {
    }

    public void add(Class clazz) {
        this.classList.add(clazz);
    }

    private void addClass(Class clazz) {
        if (this.dependencies.containsKey(clazz)) {
            return;
        }
        HashSet<Class> hashSet = new HashSet<Class>();
        Class clazz2 = this.findSubstitute(clazz.getSuperclass());
        if (clazz2 != null) {
            hashSet.add(clazz2);
            this.addToInvDependencies(clazz2, clazz);
        }
        Class[] classArray = this.findSubstitutes(clazz.getInterfaces());
        for (int i = 0; i < classArray.length; ++i) {
            if (hashSet.contains(classArray[i])) continue;
            hashSet.add(classArray[i]);
            this.addToInvDependencies(classArray[i], clazz);
        }
        Class clazz3 = this.findSubstitute(clazz.getDeclaringClass());
        if (clazz3 != null && !hashSet.contains(clazz3)) {
            hashSet.add(clazz3);
            this.addToInvDependencies(clazz3, clazz);
        }
        this.dependencies.put(clazz, hashSet);
        int n = hashSet.size();
        if (this.maxDependencies < n) {
            this.maxDependencies = n;
        }
    }

    private Class findSubstitute(Class clazz) {
        while (clazz != null) {
            if (this.classList.contains(clazz)) {
                return clazz;
            }
            clazz = clazz.getSuperclass();
        }
        return clazz;
    }

    private Class[] findSubstitutes(Class[] classArray) {
        HashSet<Class> hashSet = new HashSet<Class>();
        for (int i = 0; i < classArray.length; ++i) {
            if (this.classList.contains(classArray[i])) {
                hashSet.add(classArray[i]);
                continue;
            }
            Class[] classArray2 = this.findSubstitutes(classArray[i].getInterfaces());
            for (int j = 0; j < classArray2.length; ++j) {
                hashSet.add(classArray2[j]);
            }
        }
        Object[] objectArray = hashSet.toArray();
        int n = objectArray.length;
        Class[] classArray3 = new Class[n];
        for (int i = 0; i < n; ++i) {
            classArray3[i] = (Class)objectArray[i];
        }
        return classArray3;
    }

    private void addToInvDependencies(Class clazz, Class clazz2) {
        Vector<Class> vector = (Vector<Class>)this.invDependencies.get(clazz);
        if (vector == null) {
            vector = new Vector<Class>();
            this.invDependencies.put(clazz, vector);
            vector.add(clazz2);
        } else if (!vector.contains(clazz2)) {
            vector.add(clazz2);
        }
    }

    public String[] getClassList() throws ClassDependencyCycleException {
        String[] stringArray2;
        if (this.classList.isEmpty()) {
            return new String[]{"java.lang.Object", "java.lang.Class"};
        }
        for (String[] stringArray2 : this.classList) {
            this.addClass((Class)stringArray2);
        }
        Vector[] vectorArray = this.createSortedClassList();
        stringArray2 = null;
        ArrayList<Class> arrayList = new ArrayList<Class>();
        Class<Object> clazz = Object.class;
        arrayList.add(clazz);
        vectorArray[0].remove(clazz);
        this.adjustSortedList(vectorArray, clazz);
        while (vectorArray[0].size() != 0) {
            Class clazz2 = (Class)vectorArray[0].elementAt(0);
            arrayList.add(clazz2);
            vectorArray[0].removeElementAt(0);
            this.adjustSortedList(vectorArray, clazz2);
        }
        int n = arrayList.size();
        stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            Class clazz3 = (Class)arrayList.get(i);
            stringArray2[i] = clazz3.getName();
        }
        if (ClassDependencyGraph.isEmpty(vectorArray)) {
            return stringArray2;
        }
        throw new ClassDependencyCycleException();
    }

    private void adjustSortedList(Vector[] vectorArray, Class clazz) {
        Vector vector = (Vector)this.invDependencies.get(clazz);
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Class clazz2 = (Class)vector.elementAt(i);
            HashSet hashSet = (HashSet)this.dependencies.get(clazz2);
            int n = hashSet.size();
            hashSet.remove(clazz);
            Vector<Class> vector2 = vectorArray[n];
            vector2.remove(clazz2);
            vector2 = vectorArray[n - 1];
            if (vector2 == null) {
                vectorArray[n - 1] = vector2 = new Vector<Class>();
            }
            vector2.add(clazz2);
        }
    }

    private static boolean isEmpty(Vector[] vectorArray) {
        for (int i = 0; i < vectorArray.length; ++i) {
            if (vectorArray[i].size() == 0) continue;
            return false;
        }
        return true;
    }

    private Vector[] createSortedClassList() {
        Vector[] vectorArray = new Vector[this.maxDependencies + 1];
        for (int i = 0; i < vectorArray.length; ++i) {
            vectorArray[i] = null;
        }
        Enumeration enumeration = this.dependencies.keys();
        while (enumeration.hasMoreElements()) {
            Class clazz = (Class)enumeration.nextElement();
            HashSet hashSet = (HashSet)this.dependencies.get(clazz);
            int n = hashSet.size();
            if (vectorArray[n] == null) {
                vectorArray[n] = new Vector();
            }
            vectorArray[n].add(clazz);
        }
        return vectorArray;
    }
}

