/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbproxy;

import com.jnbridge.jnbcore.ClassRegistry;
import com.jnbridge.jnbcore.DotNetArgTypeConverter;
import com.jnbridge.jnbcore.JavaSideProperties;
import com.jnbridge.jnbcore.Logging;
import com.jnbridge.jnbcore.MessageKeys;
import com.jnbridge.jnbcore.Messages;
import com.jnbridge.jnbcore.NoClassDefFoundError;
import com.jnbridge.jnbcore.VerifyError;
import com.jnbridge.jnbcore.java50.EnumInfo;
import com.jnbridge.jnbproxy.ConstructorInfo;
import com.jnbridge.jnbproxy.FieldInfo;
import com.jnbridge.jnbproxy.MethodInfo;
import com.jnbridge.jnbproxy.ModifierInfo;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;

public final class ClassInfo
implements MessageKeys {
    public String className;
    public String superclassName;
    public String[] interfaces;
    public boolean isInterface;
    public String[] modifiers;
    public boolean isThrowable;
    public boolean isNested;
    public String enclosingClassName;
    public boolean isEnum;
    public boolean hasNestedEnums;
    public String[] nestedClasses;
    public FieldInfo[] fields;
    public MethodInfo[] methods;
    public ConstructorInfo[] constructors;
    public String[] enumNames;
    public Class classObject;
    private static boolean proxyBridgeMethods;

    private static boolean isDefaultModifier(int n) {
        return !Modifier.isPrivate(n) && !Modifier.isPublic(n) && !Modifier.isProtected(n);
    }

    public ClassInfo(String string) throws com.jnbridge.jnbcore.ClassNotFoundException, NoClassDefFoundError, com.jnbridge.jnbcore.UnsupportedClassVersionError, VerifyError {
        this.className = string;
        try {
            int n;
            int n2;
            int n3;
            Object object;
            int n4;
            int n5;
            int n6;
            Class clazz;
            string = DotNetArgTypeConverter.convertNested(string);
            this.classObject = clazz = ClassRegistry.getClass(string, this.getClass().getClassLoader());
            Class clazz2 = clazz.getSuperclass();
            this.superclassName = clazz2 != null ? clazz2.getName() : null;
            Class<?>[] classArray = clazz.getInterfaces();
            this.interfaces = new String[classArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                this.interfaces[i] = classArray[i].getName();
            }
            this.isInterface = clazz.isInterface();
            this.modifiers = ModifierInfo.translateModifiers(clazz.getModifiers());
            this.isThrowable = Throwable.class.isAssignableFrom(clazz);
            Class<?> clazz3 = clazz.getDeclaringClass();
            if (clazz3 != null) {
                this.isNested = true;
                this.enclosingClassName = clazz3.getName();
            } else {
                this.isNested = false;
                this.enclosingClassName = null;
            }
            this.isEnum = EnumInfo.isEnum(clazz);
            this.enumNames = EnumInfo.getEnumNames(clazz);
            Field[] fieldArray = clazz.getDeclaredFields();
            Vector<Field> vector = new Vector<Field>();
            for (n6 = 0; n6 < fieldArray.length; ++n6) {
                if (Modifier.isPrivate(fieldArray[n6].getModifiers()) || ClassInfo.isDefaultModifier(fieldArray[n6].getModifiers())) continue;
                vector.add(fieldArray[n6]);
            }
            this.fields = new FieldInfo[vector.size()];
            for (n6 = 0; n6 < this.fields.length; ++n6) {
                this.fields[n6] = new FieldInfo((Field)vector.elementAt(n6));
            }
            Method[] methodArray = clazz.getDeclaredMethods();
            Vector<Object> vector2 = new Vector<Object>();
            for (n5 = 0; n5 < methodArray.length; ++n5) {
                if (Modifier.isPrivate(methodArray[n5].getModifiers()) || ClassInfo.isDefaultModifier(methodArray[n5].getModifiers())) continue;
                n4 = 0;
                if (!proxyBridgeMethods) {
                    object = methodArray[n5];
                    for (n3 = 0; n3 < vector2.size(); ++n3) {
                        Method method = (Method)vector2.elementAt(n3);
                        if (!ClassInfo.signaturesMatch((Method)object, method)) continue;
                        n4 = 1;
                        if (ClassInfo.requiredByAnInterface(clazz, (Method)object)) {
                            vector2.setElementAt(object, n3);
                        }
                        if (!((Method)object).getReturnType().isAssignableFrom(method.getReturnType())) continue;
                        vector2.setElementAt(object, n3);
                        break;
                    }
                }
                if (n4 != 0) continue;
                vector2.add(methodArray[n5]);
            }
            if (clazz.isInterface()) {
                for (n5 = 0; n5 < classArray.length; ++n5) {
                    Vector vector3 = this.flattenAbstract(classArray[n5]);
                    ClassInfo.mergeMethods(vector2, vector3);
                }
            } else if (Modifier.isAbstract(clazz.getModifiers())) {
                Vector vector4 = this.flattenAbstract(clazz.getSuperclass());
                ClassInfo.mergeMethods(vector2, vector4);
                for (n4 = 0; n4 < classArray.length; ++n4) {
                    object = this.flattenAbstract(classArray[n4]);
                    ClassInfo.mergeMethods(vector2, (Vector)object);
                }
            } else {
                for (n5 = 0; n5 < classArray.length; ++n5) {
                    Vector vector5 = this.flattenAbstract(classArray[n5]);
                    ClassInfo.mergeMethods(vector2, vector5);
                }
            }
            this.methods = new MethodInfo[vector2.size()];
            for (int i = 0; i < this.methods.length; ++i) {
                this.methods[i] = new MethodInfo((Method)vector2.elementAt(i));
            }
            Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
            Vector vector6 = new Vector();
            for (n2 = 0; n2 < constructorArray.length; ++n2) {
                n3 = constructorArray[n2].getModifiers();
                if (Modifier.isPrivate(n3) || ClassInfo.isDefaultModifier(n3)) continue;
                vector6.add(constructorArray[n2]);
            }
            this.constructors = new ConstructorInfo[vector6.size()];
            for (n2 = 0; n2 < this.constructors.length; ++n2) {
                this.constructors[n2] = new ConstructorInfo((Constructor)vector6.elementAt(n2));
            }
            this.hasNestedEnums = false;
            Class<?>[] classArray2 = clazz.getDeclaredClasses();
            Vector<String> vector7 = new Vector<String>();
            for (n = 0; n < classArray2.length; ++n) {
                vector7.add(classArray2[n].getName());
                if (!EnumInfo.isEnum(classArray2[n])) continue;
                this.hasNestedEnums = true;
            }
            this.nestedClasses = new String[vector7.size()];
            for (n = 0; n < this.nestedClasses.length; ++n) {
                this.nestedClasses[n] = (String)vector7.elementAt(n);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new com.jnbridge.jnbcore.ClassNotFoundException(classNotFoundException.getMessage());
        }
        catch (java.lang.NoClassDefFoundError noClassDefFoundError) {
            throw new NoClassDefFoundError(noClassDefFoundError.getMessage());
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
            throw new com.jnbridge.jnbcore.UnsupportedClassVersionError(string);
        }
        catch (java.lang.VerifyError verifyError) {
            throw new VerifyError(string);
        }
    }

    private void logMethods(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Method method = (Method)vector.get(i);
            ClassInfo.logMethod(method);
        }
    }

    private static boolean requiredByAnInterface(Class clazz, Method method) {
        return false;
    }

    public String[][] classInfoDump() {
        int n;
        String[][] stringArray = new String[5 + 2 * this.fields.length + 4 * this.methods.length + 4 * this.constructors.length][];
        stringArray[0] = new String[10];
        stringArray[0][0] = this.className;
        stringArray[0][1] = this.superclassName;
        stringArray[0][2] = String.valueOf(this.fields.length);
        stringArray[0][3] = String.valueOf(this.methods.length);
        stringArray[0][4] = String.valueOf(this.constructors.length);
        stringArray[0][5] = String.valueOf(this.isThrowable);
        stringArray[0][6] = String.valueOf(this.isNested);
        stringArray[0][7] = String.valueOf(this.enclosingClassName);
        stringArray[0][8] = String.valueOf(this.isEnum);
        stringArray[0][9] = String.valueOf(this.hasNestedEnums);
        stringArray[1] = this.interfaces;
        stringArray[2] = this.modifiers;
        stringArray[3] = this.nestedClasses;
        int n2 = 4;
        for (n = 0; n < this.fields.length; ++n) {
            stringArray[2 * n + n2] = new String[4];
            stringArray[2 * n + n2][0] = "field";
            stringArray[2 * n + n2][1] = this.fields[n].fieldName;
            stringArray[2 * n + n2][2] = this.fields[n].className;
            stringArray[2 * n + n2][3] = this.fields[n].value;
            stringArray[2 * n + n2 + 1] = this.fields[n].modifiers;
        }
        n2 = 4 + 2 * this.fields.length;
        for (n = 0; n < this.methods.length; ++n) {
            stringArray[4 * n + n2] = new String[4];
            stringArray[4 * n + n2][0] = "method";
            stringArray[4 * n + n2][1] = this.methods[n].methodName;
            stringArray[4 * n + n2][2] = this.methods[n].returnClass;
            stringArray[4 * n + n2][3] = this.methods[n].isVarArgs ? "true" : "false";
            stringArray[4 * n + n2 + 1] = this.methods[n].paramClasses;
            stringArray[4 * n + n2 + 2] = this.methods[n].modifiers;
            stringArray[4 * n + n2 + 3] = this.methods[n].paramNames;
        }
        n2 = 4 + 2 * this.fields.length + 4 * this.methods.length;
        for (n = 0; n < this.constructors.length; ++n) {
            stringArray[4 * n + n2] = new String[2];
            stringArray[4 * n + n2][0] = "constructor";
            stringArray[4 * n + n2][1] = this.constructors[n].isVarArgs ? "true" : "false";
            stringArray[4 * n + n2 + 1] = this.constructors[n].paramClasses;
            stringArray[4 * n + n2 + 2] = this.constructors[n].modifiers;
            stringArray[4 * n + n2 + 3] = this.constructors[n].paramNames;
        }
        n2 = 4 + 2 * this.fields.length + 4 * this.methods.length + 4 * this.constructors.length;
        stringArray[n2] = this.enumNames;
        return stringArray;
    }

    private Vector flattenAbstract(Class clazz) {
        Object object;
        Vector<Method> vector = new Vector<Method>();
        if (clazz == null) {
            return vector;
        }
        if (!clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers())) {
            return vector;
        }
        Method[] methodArray = clazz.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!Modifier.isPublic(methodArray[i].getModifiers())) continue;
            if (clazz.isInterface() && !this.classObject.isInterface()) {
                try {
                    object = this.classObject.getMethod(methodArray[i].getName(), methodArray[i].getParameterTypes());
                    if (object != null && !((Method)object).getDeclaringClass().isInterface()) {
                        continue;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    throw new NoSuchMethodError(Messages.getString("CLASSINFO_FLATTENABSTRACT_1") + " " + this.classObject.getName() + "." + methodArray[i].getName() + ".  " + Messages.getString("CLASSINFO_FLATTENABSTRACT_2"));
                }
            }
            vector.add(methodArray[i]);
        }
        Vector vector2 = this.flattenAbstract(clazz.getSuperclass());
        ClassInfo.mergeMethods(vector, vector2);
        object = clazz.getInterfaces();
        for (int i = 0; i < ((Class<?>[])object).length; ++i) {
            Vector vector3 = this.flattenAbstract(object[i]);
            ClassInfo.mergeMethods(vector, vector3);
        }
        return vector;
    }

    private static void logMethod(Method method) {
        String string = "\t";
        string = string + method.getReturnType().getName();
        string = string + " ";
        string = string + method.getDeclaringClass().getName();
        string = string + ".";
        string = string + method.getName();
        string = string + "( ";
        Class<?>[] classArray = method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            if (i != 0) {
                string = string + ", ";
            }
            string = string + classArray[i].getName();
        }
        string = string + " )";
        Logging.logMessage(string);
    }

    private static void mergeMethods(Vector vector, Vector vector2) {
        Method method = null;
        Method method2 = null;
        for (int i = 0; i < vector2.size(); ++i) {
            boolean bl = false;
            method = (Method)vector2.elementAt(i);
            if (Modifier.isFinal(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers())) continue;
            for (int j = 0; j < vector.size(); ++j) {
                method2 = (Method)vector.elementAt(j);
                if (!ClassInfo.signaturesMatch(method, method2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            vector.add(method);
        }
    }

    private static boolean signaturesMatch(Method method, Method method2) {
        Class<?>[] classArray;
        if (!method.getName().equals(method2.getName())) {
            return false;
        }
        Class<?>[] classArray2 = method.getParameterTypes();
        if (classArray2.length != (classArray = method2.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < classArray2.length; ++i) {
            if (classArray2[i].getName().equals(classArray[i].getName())) continue;
            return false;
        }
        return !proxyBridgeMethods || method.getReturnType().getName().equals(method2.getReturnType().getName());
    }

    static {
        String string = JavaSideProperties.getFromPropertiesOrSystem("javaSide.proxyBridgeMethods", "true");
        proxyBridgeMethods = !"false".equalsIgnoreCase(string);
    }
}

