/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.jnbproxy;

import com.jnbridge.jnbcore.ClassRegistry;
import com.jnbridge.jnbcore.DebugConstants;
import com.jnbridge.jnbcore.InternalException;
import com.jnbridge.jnbcore.JarFileLoadException;
import com.jnbridge.jnbcore.MessageKeys;
import com.jnbridge.jnbcore.Messages;
import com.jnbridge.jnbcore.NoClassDefFoundError;
import com.jnbridge.jnbcore.VerifyError;
import com.jnbridge.jnbproxy.ClassDependencyCycleException;
import com.jnbridge.jnbproxy.ClassDependencyGraph;
import com.jnbridge.jnbproxy.UncheckedExceptions;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class ClassTree
implements DebugConstants,
MessageKeys {
    private ClassDependencyGraph cdg = new ClassDependencyGraph();
    private HashSet classesCovered;
    private boolean addedUncheckedExceptions = false;
    private Vector missingClasses = new Vector();

    public ClassTree() {
        this.classesCovered = new HashSet();
    }

    public ClassTree(String string, boolean bl) throws Exception {
        this.classesCovered = new HashSet();
        if (!ClassTree.isInClasspath(string)) {
            throw new NoClassDefFoundError(string + " " + Messages.getString("CLASSTREE_CONSTRUCTOR_1"));
        }
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new com.jnbridge.jnbcore.FileNotFoundException(fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            throw new com.jnbridge.jnbcore.IOException(iOException.getMessage());
        }
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            String string2 = jarEntry.getName();
            if (string2.startsWith("META-INF") || !string2.endsWith(".class") || string2.indexOf("$$") != -1) continue;
            string2 = string2.substring(0, string2.length() - 6);
            string2 = string2.replace('/', '.');
            try {
                this.addClass(string2, false);
            }
            catch (java.lang.NoClassDefFoundError noClassDefFoundError) {
                if (bl) {
                    this.addToMissingClasses(string2);
                    continue;
                }
                throw new NoClassDefFoundError(noClassDefFoundError.getMessage());
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (bl) {
                    this.addToMissingClasses(string2);
                    continue;
                }
                throw new com.jnbridge.jnbcore.ClassNotFoundException(classNotFoundException.getMessage());
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                if (bl) {
                    this.addToMissingClasses(string2);
                    continue;
                }
                throw noClassDefFoundError;
            }
            catch (com.jnbridge.jnbcore.ClassNotFoundException classNotFoundException) {
                if (bl) {
                    this.addToMissingClasses(string2);
                    continue;
                }
                throw classNotFoundException;
            }
            catch (IncompatibleClassChangeError incompatibleClassChangeError) {
            }
            catch (java.lang.VerifyError verifyError) {
                throw new VerifyError(string2);
            }
            catch (Throwable throwable) {
                throw new JarFileLoadException(throwable);
            }
        }
    }

    public void addClass(String string, boolean bl) throws Exception {
        this.addClass(string, bl, true);
    }

    public void addClass(String string, boolean bl, boolean bl2) throws Exception {
        Object object;
        if (!(bl || string.equals("java.lang.Object") || string.equals("java.lang.Class"))) {
            this.addClass("java.lang.Object", bl, bl2);
            this.addClass("java.lang.Class", bl, bl2);
        }
        if (bl && !this.addedUncheckedExceptions) {
            object = UncheckedExceptions.exceptionList;
            for (int i = 0; i < ((Object)object).length; ++i) {
                try {
                    Class clazz = ClassRegistry.getClass((String)object[i], this.getClass().getClassLoader());
                    this.addClass(clazz, bl, bl2);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            this.addedUncheckedExceptions = true;
        }
        try {
            object = ClassRegistry.getClass(string, this.getClass().getClassLoader());
            if (((Class)object).isInterface() && Modifier.isPrivate(((Class)object).getModifiers())) {
                return;
            }
            this.addClass((Class)object, bl, bl2);
        }
        catch (java.lang.NoClassDefFoundError noClassDefFoundError) {
            throw new NoClassDefFoundError(noClassDefFoundError.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new com.jnbridge.jnbcore.ClassNotFoundException(classNotFoundException.getMessage());
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
            throw new com.jnbridge.jnbcore.UnsupportedClassVersionError(string);
        }
        catch (java.lang.VerifyError verifyError) {
            throw new VerifyError(string);
        }
    }

    public void addClass(Class clazz, boolean bl) throws InternalException, NoClassDefFoundError, com.jnbridge.jnbcore.UnsupportedClassVersionError, com.jnbridge.jnbcore.IncompatibleClassChangeError {
        this.addClass(clazz, bl, true);
    }

    public void addClass(Class clazz, boolean bl, boolean bl2) throws InternalException, NoClassDefFoundError, com.jnbridge.jnbcore.UnsupportedClassVersionError, com.jnbridge.jnbcore.IncompatibleClassChangeError {
        try {
            Class<?>[] classArray;
            int n;
            if (this.classesCovered.contains(clazz)) {
                return;
            }
            Class<?> clazz2 = clazz.getDeclaringClass();
            if (clazz2 == null && (n = (classArray = clazz.getName()).lastIndexOf("$")) != -1) {
                String object = classArray.substring(0, n);
                try {
                    clazz2 = Class.forName(object, false, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException unsupportedClassVersionError) {
                    try {
                        clazz2 = Class.forName(object, false, this.getClass().getClassLoader());
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
                catch (java.lang.NoClassDefFoundError noClassDefFoundError) {
                }
                catch (UnsupportedClassVersionError unsupportedClassVersionError) {
                    throw new com.jnbridge.jnbcore.UnsupportedClassVersionError(object);
                }
            }
            if (clazz2 != null) {
                this.addClass(clazz2, bl, bl2);
            }
            if (bl) {
                classArray = this.getSupporting(clazz);
                for (Class clazz3 : classArray) {
                    this.addClass(clazz3, false, bl2);
                }
            } else {
                this.cdg.add(clazz);
                this.classesCovered.add(clazz);
            }
            if (bl2) {
                classArray = clazz.getDeclaredClasses();
                for (int i = 0; i < classArray.length; ++i) {
                    this.addClass(classArray[i], bl, bl2);
                }
            }
        }
        catch (IncompatibleClassChangeError incompatibleClassChangeError) {
            throw new com.jnbridge.jnbcore.IncompatibleClassChangeError(incompatibleClassChangeError.getMessage());
        }
    }

    public String[] printSupportingClasses() throws ClassDependencyCycleException {
        int n;
        String[] stringArray = this.cdg.getClassList();
        String[] stringArray2 = new String[stringArray.length + this.missingClasses.size()];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray2[n] = stringArray[n];
        }
        n = stringArray.length;
        for (int i = 0; i < this.missingClasses.size(); ++i) {
            stringArray2[n + i] = (String)this.missingClasses.elementAt(i);
        }
        return stringArray2;
    }

    private HashSet getSupporting(Class clazz) throws com.jnbridge.jnbcore.UnsupportedClassVersionError {
        HashSet hashSet = new HashSet();
        this.getSupporting(clazz, hashSet);
        return hashSet;
    }

    private void getSupporting(Class clazz, HashSet hashSet) throws com.jnbridge.jnbcore.UnsupportedClassVersionError {
        try {
            int n;
            if (clazz == null) {
                return;
            }
            if (clazz.isPrimitive() || clazz.isArray()) {
                return;
            }
            if (this.classesCovered.contains(clazz) || hashSet.contains(clazz)) {
                return;
            }
            hashSet.add(clazz);
            Field[] fieldArray = clazz.getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                Class<?> clazz2 = fieldArray[i].getType();
                n = clazz2.getModifiers();
                if (!Modifier.isPublic(n) || clazz2.isPrimitive() || clazz2.isArray() || this.classesCovered.contains(clazz2) || hashSet.contains(clazz2)) continue;
                this.getSupporting(clazz2, hashSet);
            }
            Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
            for (int i = 0; i < constructorArray.length; ++i) {
                n = constructorArray[i].getModifiers();
                if (!Modifier.isPublic(n)) continue;
                this.getSupporting(constructorArray[i].getParameterTypes(), hashSet);
                this.getSupporting(constructorArray[i].getExceptionTypes(), hashSet);
            }
            Method[] methodArray = clazz.getDeclaredMethods();
            for (n = 0; n < methodArray.length; ++n) {
                int n2 = methodArray[n].getModifiers();
                if (!Modifier.isPublic(n2)) continue;
                this.getSupporting(methodArray[n].getParameterTypes(), hashSet);
                this.getSupporting(methodArray[n].getExceptionTypes(), hashSet);
                this.getSupporting(methodArray[n].getReturnType(), hashSet);
            }
            this.getSupporting(clazz.getSuperclass(), hashSet);
            this.getSupporting(clazz.getInterfaces(), hashSet);
        }
        catch (java.lang.NoClassDefFoundError noClassDefFoundError) {
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
            throw new com.jnbridge.jnbcore.UnsupportedClassVersionError(Messages.getString("CLASSTREE_GETSUPPORTING_1") + " " + clazz.getName());
        }
    }

    private void getSupporting(Class[] classArray, HashSet hashSet) throws com.jnbridge.jnbcore.UnsupportedClassVersionError {
        for (int i = 0; i < classArray.length; ++i) {
            Class<?> clazz = classArray[i];
            while (clazz.isArray()) {
                clazz = clazz.getComponentType();
            }
            int n = clazz.getModifiers();
            if (!Modifier.isPublic(n) || clazz.isPrimitive() || this.classesCovered.contains(clazz) || hashSet.contains(clazz)) continue;
            this.getSupporting(clazz, hashSet);
        }
    }

    private static boolean isInClasspath(String string) {
        String string2 = System.getProperty("java.class.path", ".");
        if (string2 == null) {
            return false;
        }
        int n = string2.indexOf(string);
        if (n == -1) {
            return false;
        }
        if (n != 0 && string2.charAt(n - 1) != ';') {
            return false;
        }
        return n == string2.length() - 1 || n + string.length() == string2.length() || string2.charAt(n + string.length()) == ';';
    }

    public static void main(String[] stringArray) throws Exception {
        ClassTree classTree = new ClassTree("D:\\JNBridge\\Java Master Project\\jsse.jar", true);
    }

    private void addToMissingClasses(String string) {
        String string2 = string + "$";
        for (int i = this.missingClasses.size() - 1; i >= 0; --i) {
            String string3 = (String)this.missingClasses.elementAt(i);
            if (!string3.startsWith(string2)) continue;
            this.missingClasses.remove(i);
        }
        this.missingClasses.add(string);
    }
}

